/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.ServiceType;
import ch.ethz.iks.slp.impl.RequestMessage;
import ch.ethz.iks.slp.impl.SLPCore;
import ch.ethz.iks.slp.impl.SLPMessage;
import ch.ethz.iks.slp.impl.filter.Filter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

class ServiceRequest
extends RequestMessage {
    ServiceType serviceType;
    Filter predicate;
    String spi;

    ServiceRequest(ServiceType serviceType, List list, String string, Locale locale) throws IllegalArgumentException {
        this.funcID = 1;
        this.prevRespList = new ArrayList();
        this.serviceType = serviceType;
        this.predicate = string == null ? null : SLPCore.platform.createFilter(string);
        this.scopeList = list;
        if (this.scopeList == null) {
            this.scopeList = new ArrayList();
            this.scopeList.add("default");
        }
        this.locale = locale == null ? SLPCore.DEFAULT_LOCALE : locale;
        this.spi = SLPCore.CONFIG.getSecurityEnabled() ? SLPCore.CONFIG.getSPI() : "";
    }

    protected ServiceRequest(DataInputStream dataInputStream) throws IOException {
        block2: {
            this.prevRespList = SLPMessage.stringToList(dataInputStream.readUTF(), ",");
            this.serviceType = new ServiceType(dataInputStream.readUTF());
            this.scopeList = SLPMessage.stringToList(dataInputStream.readUTF(), ",");
            try {
                String string = dataInputStream.readUTF();
                this.predicate = "".equals(string) ? null : SLPCore.platform.createFilter(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!SLPCore.platform.isErrorEnabled()) break block2;
                SLPCore.platform.logError("Invalid filter in incoming message " + this.xid, illegalArgumentException);
            }
        }
        this.spi = dataInputStream.readUTF();
    }

    protected void writeTo(DataOutputStream dataOutputStream) throws IOException {
        super.writeHeader(dataOutputStream, this.getSize());
        dataOutputStream.writeUTF(SLPMessage.listToString(this.prevRespList, ","));
        dataOutputStream.writeUTF(this.serviceType.toString());
        dataOutputStream.writeUTF(SLPMessage.listToString(this.scopeList, ","));
        dataOutputStream.writeUTF(this.predicate == null ? "" : ((Object)this.predicate).toString());
        dataOutputStream.writeUTF(this.spi);
    }

    int getSize() {
        return this.getHeaderSize() + 2 + SLPMessage.listToString(this.prevRespList, ",").length() + 2 + this.serviceType.toString().length() + 2 + SLPMessage.listToString(this.scopeList, ",").length() + 2 + (this.predicate == null ? 0 : ((Object)this.predicate).toString().length()) + 2 + this.spi.length();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(", prevRespList: " + this.prevRespList);
        stringBuffer.append(", serviceType: " + this.serviceType);
        stringBuffer.append(", scopeList: " + this.scopeList);
        stringBuffer.append(", predicate: " + (this.predicate == null ? "" : ((Object)this.predicate).toString()));
        stringBuffer.append(", slpSpi: " + this.spi);
        return stringBuffer.toString();
    }
}

