/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.ServiceType;
import ch.ethz.iks.slp.ServiceURL;
import ch.ethz.iks.slp.impl.RequestMessage;
import ch.ethz.iks.slp.impl.SLPCore;
import ch.ethz.iks.slp.impl.SLPMessage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

class AttributeRequest
extends RequestMessage {
    String url;
    List tagList;
    String spi;

    AttributeRequest(ServiceURL serviceURL, List list, List list2, Locale locale) {
        this.funcID = (byte)6;
        this.url = serviceURL.toString();
        this.scopeList = list;
        if (this.scopeList == null) {
            this.scopeList = new ArrayList();
            this.scopeList.add("default");
        }
        this.tagList = list2;
        if (this.tagList == null) {
            this.tagList = new ArrayList();
        }
        this.locale = locale == null ? SLPCore.DEFAULT_LOCALE : locale;
        this.spi = SLPCore.CONFIG.getSecurityEnabled() ? SLPCore.CONFIG.getSPI() : "";
    }

    AttributeRequest(ServiceType serviceType, List list, List list2, Locale locale) {
        this.funcID = (byte)6;
        this.url = serviceType.toString();
        this.scopeList = list;
        if (this.scopeList == null) {
            this.scopeList = new ArrayList();
            this.scopeList.add("default");
        }
        this.tagList = list2;
        if (this.tagList == null) {
            this.tagList = new ArrayList();
        }
        this.locale = locale == null ? SLPCore.DEFAULT_LOCALE : locale;
        this.spi = SLPCore.CONFIG.getSecurityEnabled() ? SLPCore.CONFIG.getSPI() : "";
    }

    AttributeRequest(DataInputStream dataInputStream) throws IOException {
        this.prevRespList = SLPMessage.stringToList(dataInputStream.readUTF(), ",");
        this.url = dataInputStream.readUTF();
        this.scopeList = SLPMessage.stringToList(dataInputStream.readUTF(), ",");
        this.tagList = SLPMessage.stringToList(dataInputStream.readUTF(), ",");
        this.spi = dataInputStream.readUTF();
    }

    protected void writeTo(DataOutputStream dataOutputStream) throws IOException {
        super.writeHeader(dataOutputStream, this.getSize());
        dataOutputStream.writeUTF(SLPMessage.listToString(this.prevRespList, ","));
        dataOutputStream.writeUTF(this.url);
        dataOutputStream.writeUTF(SLPMessage.listToString(this.scopeList, ","));
        dataOutputStream.writeUTF(SLPMessage.listToString(this.tagList, ","));
        dataOutputStream.writeUTF(this.spi);
    }

    int getSize() {
        return this.getHeaderSize() + 2 + SLPMessage.listToString(this.prevRespList, ",").length() + 2 + this.url.length() + 2 + SLPMessage.listToString(this.scopeList, ",").length() + 2 + SLPMessage.listToString(this.tagList, ",").length() + 2 + this.spi.length();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(", prevRespList: " + this.prevRespList);
        stringBuffer.append(", URL: " + this.url);
        stringBuffer.append(", scopeList: " + this.scopeList);
        stringBuffer.append(", tag-list: " + this.tagList);
        stringBuffer.append(", slpSpi: " + this.spi);
        return stringBuffer.toString();
    }
}

