/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.jdt.internal.ui.text.correction.ICommandAccess;
import org.eclipse.jdt.internal.ui.text.correction.JavaCorrectionAssistant;
import org.eclipse.jdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedNamesAssistProposal;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.texteditor.ITextEditor;

public class CorrectionCommandHandler
extends AbstractHandler {
    private final JavaEditor fEditor;
    private final String fId;
    private final boolean fIsAssist;
    static /* synthetic */ Class class$0;

    public CorrectionCommandHandler(JavaEditor editor, String id, boolean isAssist) {
        this.fEditor = editor;
        this.fId = id;
        this.fIsAssist = isAssist;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = this.fEditor.getSelectionProvider().getSelection();
        ICompilationUnit cu = JavaUI.getWorkingCopyManager().getWorkingCopy(this.fEditor.getEditorInput());
        IAnnotationModel model = JavaUI.getDocumentProvider().getAnnotationModel((Object)this.fEditor.getEditorInput());
        if (selection instanceof ITextSelection && cu != null && model != null) {
            if (!ActionUtil.isEditable(this.fEditor)) {
                return null;
            }
            ICompletionProposal proposal = this.findCorrection(this.fId, this.fIsAssist, (ITextSelection)selection, cu, model);
            if (proposal != null) {
                this.invokeProposal(proposal, ((ITextSelection)selection).getOffset());
            }
        }
        return null;
    }

    private ICompletionProposal findCorrection(String id, boolean isAssist, ITextSelection selection, ICompilationUnit cu, IAnnotationModel model) {
        AssistContext context = new AssistContext(cu, selection.getOffset(), selection.getLength());
        ArrayList proposals = new ArrayList(10);
        if (isAssist) {
            if (id.equals("org.eclipse.jdt.ui.correction.renameInFile.assist")) {
                return this.getLocalRenameProposal(context);
            }
            JavaCorrectionProcessor.collectAssists(context, new ProblemLocation[0], proposals);
        } else {
            try {
                boolean goToClosest = selection.getLength() == 0;
                Annotation[] annotations = this.getAnnotations(selection.getOffset(), goToClosest);
                JavaCorrectionProcessor.collectProposals(context, model, annotations, true, false, proposals);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        Iterator iter = proposals.iterator();
        while (iter.hasNext()) {
            Object curr = iter.next();
            if (!(curr instanceof ICommandAccess) || !id.equals(((ICommandAccess)curr).getCommandId())) continue;
            return (ICompletionProposal)curr;
        }
        return null;
    }

    private Annotation[] getAnnotations(int offset, boolean goToClosest) throws BadLocationException {
        ArrayList resultingAnnotations = new ArrayList();
        JavaCorrectionAssistant.collectQuickFixableAnnotations((ITextEditor)this.fEditor, offset, goToClosest, resultingAnnotations);
        return resultingAnnotations.toArray(new Annotation[resultingAnnotations.size()]);
    }

    private ICompletionProposal getLocalRenameProposal(IInvocationContext context) {
        ASTNode node = context.getCoveringNode();
        if (node instanceof SimpleName) {
            return new LinkedNamesAssistProposal(context.getCompilationUnit(), (SimpleName)node);
        }
        return null;
    }

    private IDocument getDocument() {
        return JavaUI.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
    }

    private void invokeProposal(ICompletionProposal proposal, int offset) {
        IDocument document;
        if (proposal instanceof ICompletionProposalExtension2) {
            ISourceViewer viewer = this.fEditor.getViewer();
            if (viewer != null) {
                ((ICompletionProposalExtension2)proposal).apply((ITextViewer)viewer, '\u0000', 0, offset);
                return;
            }
        } else if (proposal instanceof ICompletionProposalExtension && (document = this.getDocument()) != null) {
            ((ICompletionProposalExtension)proposal).apply(document, '\u0000', offset);
            return;
        }
        if ((document = this.getDocument()) != null) {
            proposal.apply(document);
        }
    }

    public static String getShortCutString(String proposalId) {
        if (proposalId != null) {
            TriggerSequence[] activeBindingsFor;
            IBindingService bindingService;
            IWorkbench iWorkbench = PlatformUI.getWorkbench();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.keys.IBindingService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((bindingService = (IBindingService)iWorkbench.getAdapter((Class)clazz)) != null && (activeBindingsFor = bindingService.getActiveBindingsFor(proposalId)).length > 0) {
                return activeBindingsFor[0].format();
            }
        }
        return null;
    }
}

