/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.sef;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.Message;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.refactoring.descriptors.EncapsulateFieldDescriptor;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.sef.AccessAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class SelfEncapsulateFieldRefactoring
extends Refactoring {
    private static final String ATTRIBUTE_VISIBILITY = "visibility";
    private static final String ATTRIBUTE_GETTER = "getter";
    private static final String ATTRIBUTE_SETTER = "setter";
    private static final String ATTRIBUTE_INSERTION = "insertion";
    private static final String ATTRIBUTE_COMMENTS = "comments";
    private static final String ATTRIBUTE_DECLARING = "declaring";
    private IField fField;
    private TextChangeManager fChangeManager = new TextChangeManager();
    private CompilationUnit fRoot;
    private VariableDeclarationFragment fFieldDeclaration;
    private ASTRewrite fRewriter;
    private ImportRewrite fImportRewrite;
    private int fVisibility = -1;
    private String fGetterName;
    private String fSetterName;
    private String fArgName;
    private boolean fSetterMustReturnValue;
    private int fInsertionIndex;
    private boolean fEncapsulateDeclaringClass = true;
    private boolean fGenerateJavadoc;
    private List fUsedReadNames;
    private List fUsedModifyNames;
    private boolean fConsiderVisibility = true;
    private static final String NO_NAME = "";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public SelfEncapsulateFieldRefactoring(IField field) throws JavaModelException {
        this.fField = field;
        if (field != null) {
            this.initialize(field);
        }
    }

    private void initialize(IField field) throws JavaModelException {
        this.fGetterName = GetterSetterUtil.getGetterName(field, null);
        this.fSetterName = GetterSetterUtil.getSetterName(field, null);
        this.fArgName = NamingConventions.removePrefixAndSuffixForFieldName((IJavaProject)field.getJavaProject(), (String)field.getElementName(), (int)field.getFlags());
        this.checkArgName();
    }

    public void reinitialize() {
        try {
            this.initialize(this.fField);
        }
        catch (JavaModelException javaModelException) {}
    }

    public IField getField() {
        return this.fField;
    }

    public String getGetterName() {
        return this.fGetterName;
    }

    public void setGetterName(String name) {
        this.fGetterName = name;
        Assert.isNotNull((Object)this.fGetterName);
    }

    public String getSetterName() {
        return this.fSetterName;
    }

    public void setSetterName(String name) {
        this.fSetterName = name;
        Assert.isNotNull((Object)this.fSetterName);
    }

    public void setInsertionIndex(int index) {
        this.fInsertionIndex = index;
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public void setVisibility(int visibility) {
        this.fVisibility = visibility;
    }

    public void setEncapsulateDeclaringClass(boolean encapsulateDeclaringClass) {
        this.fEncapsulateDeclaringClass = encapsulateDeclaringClass;
    }

    public boolean getEncapsulateDeclaringClass() {
        return this.fEncapsulateDeclaringClass;
    }

    public boolean getGenerateJavadoc() {
        return this.fGenerateJavadoc;
    }

    public void setGenerateJavadoc(boolean value) {
        this.fGenerateJavadoc = value;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        if (this.fVisibility < 0) {
            this.fVisibility = this.fField.getFlags() & 7;
        }
        RefactoringStatus result = new RefactoringStatus();
        result.merge(Checks.checkAvailability((IJavaElement)this.fField));
        if (result.hasFatalError()) {
            return result;
        }
        this.fRoot = new RefactoringASTParser(3).parse((ITypeRoot)this.fField.getCompilationUnit(), true, pm);
        ISourceRange sourceRange = this.fField.getNameRange();
        ASTNode node = NodeFinder.perform((ASTNode)this.fRoot, sourceRange.getOffset(), sourceRange.getLength());
        if (node == null) {
            return this.mappingErrorFound(result, node);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.VariableDeclarationFragment");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fFieldDeclaration = (VariableDeclarationFragment)ASTNodes.getParent(node, clazz);
        if (this.fFieldDeclaration == null) {
            return this.mappingErrorFound(result, node);
        }
        if (this.fFieldDeclaration.resolveBinding() == null) {
            if (!this.processCompilerError(result, node)) {
                result.addFatalError(RefactoringCoreMessages.SelfEncapsulateField_type_not_resolveable);
            }
            return result;
        }
        this.computeUsedNames();
        this.fRewriter = ASTRewrite.create((AST)this.fRoot.getAST());
        return result;
    }

    private RefactoringStatus mappingErrorFound(RefactoringStatus result, ASTNode node) {
        if (node != null && (node.getFlags() & 1) != 0 && this.processCompilerError(result, node)) {
            return result;
        }
        result.addFatalError(this.getMappingErrorMessage());
        return result;
    }

    private boolean processCompilerError(RefactoringStatus result, ASTNode node) {
        Message[] messages = ASTNodes.getMessages(node, 2);
        if (messages.length == 0) {
            return false;
        }
        result.addFatalError(Messages.format(RefactoringCoreMessages.SelfEncapsulateField_compiler_errors_field, new String[]{BasicElementLabels.getJavaElementName(this.fField.getElementName()), messages[0].getMessage()}));
        return true;
    }

    private String getMappingErrorMessage() {
        return Messages.format(RefactoringCoreMessages.SelfEncapsulateField_cannot_analyze_selected_field, BasicElementLabels.getJavaElementName(this.fField.getElementName()));
    }

    public RefactoringStatus checkMethodNames() {
        return this.checkMethodNames(this.isUsingLocalGetter(), this.isUsingLocalSetter());
    }

    public RefactoringStatus checkMethodNames(boolean usingLocalGetter, boolean usingLocalSetter) {
        RefactoringStatus result = new RefactoringStatus();
        IType declaringType = this.fField.getDeclaringType();
        SelfEncapsulateFieldRefactoring.checkName(result, this.fGetterName, this.fUsedReadNames, declaringType, usingLocalGetter, this.fField);
        SelfEncapsulateFieldRefactoring.checkName(result, this.fSetterName, this.fUsedModifyNames, declaringType, usingLocalSetter, this.fField);
        return result;
    }

    private static void checkName(RefactoringStatus status, String name, List usedNames, IType type, boolean reUseExistingField, IField field) {
        if (NO_NAME.equals(name)) {
            status.addFatalError(RefactoringCoreMessages.Checks_Choose_name);
            return;
        }
        boolean isStatic = false;
        try {
            isStatic = Flags.isStatic((int)field.getFlags());
        }
        catch (JavaModelException javaModelException) {}
        status.merge(Checks.checkMethodName(name, (IJavaElement)field));
        Iterator iter = usedNames.iterator();
        while (iter.hasNext()) {
            IMethodBinding method = (IMethodBinding)iter.next();
            String selector = method.getName();
            if (!selector.equals(name)) continue;
            if (!reUseExistingField) {
                status.addFatalError(Messages.format(RefactoringCoreMessages.SelfEncapsulateField_method_exists, new String[]{BindingLabelProvider.getBindingLabel((IBinding)method, JavaElementLabels.ALL_FULLY_QUALIFIED), BasicElementLabels.getJavaElementName(type.getElementName())}));
                continue;
            }
            boolean methodIsStatic = Modifier.isStatic((int)method.getModifiers());
            if (methodIsStatic && !isStatic) {
                status.addWarning(Messages.format(RefactoringCoreMessages.SelfEncapsulateFieldRefactoring_static_method_but_nonstatic_field, new String[]{BasicElementLabels.getJavaElementName(method.getName()), BasicElementLabels.getJavaElementName(field.getElementName())}));
            }
            if (!methodIsStatic && isStatic) {
                status.addFatalError(Messages.format(RefactoringCoreMessages.SelfEncapsulateFieldRefactoring_nonstatic_method_but_static_field, new String[]{BasicElementLabels.getJavaElementName(method.getName()), BasicElementLabels.getJavaElementName(field.getElementName())}));
            }
            return;
        }
        if (reUseExistingField) {
            status.addFatalError(Messages.format(RefactoringCoreMessages.SelfEncapsulateFieldRefactoring_methoddoesnotexist_status_fatalError, new String[]{BasicElementLabels.getJavaElementName(name), BasicElementLabels.getJavaElementName(type.getElementName())}));
        }
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        this.fChangeManager.clear();
        pm.beginTask(NO_NAME, 12);
        pm.setTaskName(RefactoringCoreMessages.SelfEncapsulateField_checking_preconditions);
        boolean usingLocalGetter = this.isUsingLocalGetter();
        boolean usingLocalSetter = this.isUsingLocalSetter();
        result.merge(this.checkMethodNames(usingLocalGetter, usingLocalSetter));
        pm.worked(1);
        if (result.hasFatalError()) {
            return result;
        }
        pm.setTaskName(RefactoringCoreMessages.SelfEncapsulateField_searching_for_cunits);
        SubProgressMonitor subPm = new SubProgressMonitor(pm, 5);
        ICompilationUnit[] affectedCUs = RefactoringSearchEngine.findAffectedCompilationUnits(SearchPattern.createPattern((IJavaElement)this.fField, (int)2), RefactoringScopeFactory.create((IJavaElement)this.fField, this.fConsiderVisibility), (IProgressMonitor)subPm, result, true);
        this.checkInHierarchy(result, usingLocalGetter, usingLocalSetter);
        if (result.hasFatalError()) {
            return result;
        }
        pm.setTaskName(RefactoringCoreMessages.SelfEncapsulateField_analyzing);
        SubProgressMonitor sub = new SubProgressMonitor(pm, 5);
        sub.beginTask(NO_NAME, affectedCUs.length);
        IVariableBinding fieldIdentifier = this.fFieldDeclaration.resolveBinding();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITypeBinding declaringClass = ((AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)this.fFieldDeclaration, clazz)).resolveBinding();
        ArrayList ownerDescriptions = new ArrayList();
        ICompilationUnit owner = this.fField.getCompilationUnit();
        this.fImportRewrite = StubUtility.createImportRewrite(this.fRoot, true);
        int i = 0;
        while (i < affectedCUs.length) {
            ArrayList descriptions;
            ImportRewrite importRewrite;
            ICompilationUnit unit = affectedCUs[i];
            sub.subTask(BasicElementLabels.getFileName((ITypeRoot)unit));
            CompilationUnit root = null;
            ASTRewrite rewriter = null;
            if (owner.equals(unit)) {
                root = this.fRoot;
                rewriter = this.fRewriter;
                importRewrite = this.fImportRewrite;
                descriptions = ownerDescriptions;
            } else {
                root = new RefactoringASTParser(3).parse((ITypeRoot)unit, true);
                rewriter = ASTRewrite.create((AST)root.getAST());
                descriptions = new ArrayList();
                importRewrite = StubUtility.createImportRewrite(root, true);
            }
            this.checkCompileErrors(result, root, unit);
            AccessAnalyzer analyzer = new AccessAnalyzer(this, unit, fieldIdentifier, declaringClass, rewriter, importRewrite);
            root.accept((ASTVisitor)analyzer);
            result.merge(analyzer.getStatus());
            if (!this.fSetterMustReturnValue) {
                this.fSetterMustReturnValue = analyzer.getSetterMustReturnValue();
            }
            if (result.hasFatalError()) {
                this.fChangeManager.clear();
                return result;
            }
            descriptions.addAll(analyzer.getGroupDescriptions());
            if (!owner.equals(unit)) {
                this.createEdits(unit, rewriter, descriptions, importRewrite);
            }
            sub.worked(1);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            ++i;
        }
        ownerDescriptions.addAll(this.addGetterSetterChanges(this.fRoot, this.fRewriter, owner.findRecommendedLineSeparator(), usingLocalSetter, usingLocalGetter));
        this.createEdits(owner, this.fRewriter, ownerDescriptions, this.fImportRewrite);
        sub.done();
        IFile[] filesToBeModified = ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
        result.merge(Checks.validateModifiesFiles(filesToBeModified, this.getValidationContext()));
        if (result.hasFatalError()) {
            return result;
        }
        ResourceChangeChecker.checkFilesToBeChanged((IFile[])filesToBeModified, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        return result;
    }

    private void createEdits(ICompilationUnit unit, ASTRewrite rewriter, List groups, ImportRewrite importRewrite) throws CoreException {
        TextChange change = this.fChangeManager.get(unit);
        MultiTextEdit root = new MultiTextEdit();
        change.setEdit((TextEdit)root);
        root.addChild(importRewrite.rewriteImports(null));
        root.addChild(rewriter.rewriteAST());
        Iterator iter = groups.iterator();
        while (iter.hasNext()) {
            change.addTextEditGroup((TextEditGroup)iter.next());
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        HashMap<String, String> arguments = new HashMap<String, String>();
        String project = null;
        IJavaProject javaProject = this.fField.getJavaProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        int flags = 589830;
        IType declaring = this.fField.getDeclaringType();
        try {
            if (declaring.isAnonymous() || declaring.isLocal()) {
                flags |= 0x40000;
            }
        }
        catch (JavaModelException exception) {
            JavaPlugin.log(exception);
        }
        String description = Messages.format(RefactoringCoreMessages.SelfEncapsulateField_descriptor_description_short, BasicElementLabels.getJavaElementName(this.fField.getElementName()));
        String header = Messages.format(RefactoringCoreMessages.SelfEncapsulateFieldRefactoring_descriptor_description, new String[]{JavaElementLabels.getElementLabel((IJavaElement)this.fField, JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getElementLabel((IJavaElement)declaring, JavaElementLabels.ALL_FULLY_QUALIFIED)});
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, (Object)this, header);
        comment.addSetting(Messages.format(RefactoringCoreMessages.SelfEncapsulateField_original_pattern, JavaElementLabels.getElementLabel((IJavaElement)this.fField, JavaElementLabels.ALL_FULLY_QUALIFIED)));
        comment.addSetting(Messages.format(RefactoringCoreMessages.SelfEncapsulateField_getter_pattern, BasicElementLabels.getJavaElementName(this.fGetterName)));
        comment.addSetting(Messages.format(RefactoringCoreMessages.SelfEncapsulateField_setter_pattern, BasicElementLabels.getJavaElementName(this.fSetterName)));
        String visibility = JdtFlags.getVisibilityString(this.fVisibility);
        if (NO_NAME.equals(visibility)) {
            visibility = RefactoringCoreMessages.SelfEncapsulateField_default_visibility;
        }
        comment.addSetting(Messages.format(RefactoringCoreMessages.SelfEncapsulateField_visibility_pattern, visibility));
        if (this.fEncapsulateDeclaringClass) {
            comment.addSetting(RefactoringCoreMessages.SelfEncapsulateField_use_accessors);
        } else {
            comment.addSetting(RefactoringCoreMessages.SelfEncapsulateField_do_not_use_accessors);
        }
        if (this.fGenerateJavadoc) {
            comment.addSetting(RefactoringCoreMessages.SelfEncapsulateField_generate_comments);
        }
        EncapsulateFieldDescriptor descriptor = new EncapsulateFieldDescriptor(project, description, comment.asString(), arguments, flags);
        arguments.put("input", JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fField));
        arguments.put(ATTRIBUTE_VISIBILITY, new Integer(this.fVisibility).toString());
        arguments.put(ATTRIBUTE_INSERTION, new Integer(this.fInsertionIndex).toString());
        arguments.put(ATTRIBUTE_SETTER, this.fSetterName);
        arguments.put(ATTRIBUTE_GETTER, this.fGetterName);
        arguments.put(ATTRIBUTE_COMMENTS, Boolean.valueOf(this.fGenerateJavadoc).toString());
        arguments.put(ATTRIBUTE_DECLARING, Boolean.valueOf(this.fEncapsulateDeclaringClass).toString());
        DynamicValidationRefactoringChange result = new DynamicValidationRefactoringChange((JavaRefactoringDescriptor)descriptor, this.getName());
        TextChange[] changes = this.fChangeManager.getAllChanges();
        pm.beginTask(NO_NAME, changes.length);
        pm.setTaskName(RefactoringCoreMessages.SelfEncapsulateField_create_changes);
        int i = 0;
        while (i < changes.length) {
            result.add((Change)changes[i]);
            pm.worked(1);
            ++i;
        }
        pm.done();
        return result;
    }

    public String getName() {
        return RefactoringCoreMessages.SelfEncapsulateField_name;
    }

    private void checkCompileErrors(RefactoringStatus result, CompilationUnit root, ICompilationUnit element) {
        IProblem[] messages = root.getProblems();
        int i = 0;
        while (i < messages.length) {
            IProblem problem = messages[i];
            if (!this.isIgnorableProblem(problem)) {
                result.addWarning(Messages.format(RefactoringCoreMessages.SelfEncapsulateField_compiler_errors_update, BasicElementLabels.getFileName((ITypeRoot)element)), JavaStatusContext.create((ITypeRoot)element));
                return;
            }
            ++i;
        }
    }

    private void checkInHierarchy(RefactoringStatus status, boolean usingLocalGetter, boolean usingLocalSetter) {
        AbstractTypeDeclaration declaration;
        ITypeBinding type;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((type = (declaration = (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)this.fFieldDeclaration, clazz)).resolveBinding()) != null) {
            ITypeBinding fieldType = this.fFieldDeclaration.resolveBinding().getType();
            SelfEncapsulateFieldRefactoring.checkMethodInHierarchy(type, this.fGetterName, fieldType, new ITypeBinding[0], status, usingLocalGetter);
            SelfEncapsulateFieldRefactoring.checkMethodInHierarchy(type, this.fSetterName, this.fFieldDeclaration.getAST().resolveWellKnownType("void"), new ITypeBinding[]{fieldType}, status, usingLocalSetter);
        }
    }

    public static void checkMethodInHierarchy(ITypeBinding type, String methodName, ITypeBinding returnType, ITypeBinding[] parameters, RefactoringStatus result, boolean reUseMethod) {
        IMethodBinding method = Bindings.findMethodInHierarchy(type, methodName, parameters);
        if (method != null) {
            boolean returnTypeClash = false;
            ITypeBinding methodReturnType = method.getReturnType();
            if (returnType != null && methodReturnType != null) {
                String returnTypeKey = returnType.getKey();
                String methodReturnTypeKey = methodReturnType.getKey();
                if (returnTypeKey == null && methodReturnTypeKey == null) {
                    returnTypeClash = returnType != methodReturnType;
                } else if (returnTypeKey != null && methodReturnTypeKey != null) {
                    returnTypeClash = !returnTypeKey.equals(methodReturnTypeKey);
                }
            }
            ITypeBinding dc = method.getDeclaringClass();
            if (returnTypeClash) {
                result.addError(Messages.format(RefactoringCoreMessages.Checks_methodName_returnTypeClash, new Object[]{BasicElementLabels.getJavaElementName(methodName), BasicElementLabels.getJavaElementName(dc.getName())}), JavaStatusContext.create(method));
            } else if (!reUseMethod) {
                result.addError(Messages.format(RefactoringCoreMessages.Checks_methodName_overrides, new Object[]{BasicElementLabels.getJavaElementName(methodName), BasicElementLabels.getJavaElementName(dc.getName())}), JavaStatusContext.create(method));
            }
        } else if (reUseMethod) {
            result.addError(Messages.format(RefactoringCoreMessages.SelfEncapsulateFieldRefactoring_nosuchmethod_status_fatalError, BasicElementLabels.getJavaElementName(methodName)), JavaStatusContext.create(method));
        }
    }

    private void computeUsedNames() {
        this.fUsedReadNames = new ArrayList(0);
        this.fUsedModifyNames = new ArrayList(0);
        IVariableBinding binding = this.fFieldDeclaration.resolveBinding();
        ITypeBinding type = binding.getType();
        IMethodBinding[] methods = binding.getDeclaringClass().getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            IMethodBinding method = methods[i];
            ITypeBinding[] parameters = methods[i].getParameterTypes();
            if (parameters == null || parameters.length == 0) {
                this.fUsedReadNames.add(method);
            } else if (parameters.length == 1 && parameters[0] == type) {
                this.fUsedModifyNames.add(method);
            }
            ++i;
        }
    }

    private List addGetterSetterChanges(CompilationUnit root, ASTRewrite rewriter, String lineDelimiter, boolean usingLocalSetter, boolean usingLocalGetter) throws CoreException {
        TextEditGroup description;
        ArrayList<TextEditGroup> result = new ArrayList<TextEditGroup>(2);
        AST ast = root.getAST();
        FieldDeclaration decl = (FieldDeclaration)ASTNodes.getParent((ASTNode)this.fFieldDeclaration, 23);
        int position = 0;
        int numberOfMethods = 0;
        List members = ASTNodes.getBodyDeclarations(decl.getParent());
        Iterator iter = members.iterator();
        while (iter.hasNext()) {
            BodyDeclaration element = (BodyDeclaration)iter.next();
            if (element.getNodeType() == 31) {
                if (this.fInsertionIndex == -1) break;
                if (this.fInsertionIndex == numberOfMethods) {
                    ++position;
                    break;
                }
                ++numberOfMethods;
            }
            ++position;
        }
        ListRewrite rewrite = this.fRewriter.getListRewrite(decl.getParent(), this.getBodyDeclarationsProperty(decl.getParent()));
        if (!JdtFlags.isFinal((IMember)this.fField) && !usingLocalSetter) {
            description = new TextEditGroup(RefactoringCoreMessages.SelfEncapsulateField_add_setter);
            result.add(description);
            rewrite.insertAt((ASTNode)this.createSetterMethod(ast, rewriter, lineDelimiter), position++, description);
        }
        if (!usingLocalGetter) {
            description = new TextEditGroup(RefactoringCoreMessages.SelfEncapsulateField_add_getter);
            result.add(description);
            rewrite.insertAt((ASTNode)this.createGetterMethod(ast, rewriter, lineDelimiter), position, description);
        }
        if (!JdtFlags.isPrivate((IMember)this.fField)) {
            result.add(this.makeDeclarationPrivate(rewriter, decl));
        }
        return result;
    }

    private TextEditGroup makeDeclarationPrivate(ASTRewrite rewriter, FieldDeclaration decl) {
        AST ast = rewriter.getAST();
        TextEditGroup description = new TextEditGroup(RefactoringCoreMessages.SelfEncapsulateField_change_visibility);
        if (decl.fragments().size() > 1) {
            rewriter.remove((ASTNode)this.fFieldDeclaration, description);
            ChildListPropertyDescriptor descriptor = this.getBodyDeclarationsProperty(decl.getParent());
            VariableDeclarationFragment newField = (VariableDeclarationFragment)rewriter.createCopyTarget((ASTNode)this.fFieldDeclaration);
            FieldDeclaration fieldDecl = ast.newFieldDeclaration(newField);
            fieldDecl.setType((Type)rewriter.createCopyTarget((ASTNode)decl.getType()));
            fieldDecl.modifiers().addAll(ASTNodeFactory.newModifiers(ast, 2));
            rewriter.getListRewrite(decl.getParent(), descriptor).insertAfter((ASTNode)fieldDecl, (ASTNode)decl, description);
        } else {
            ModifierRewrite.create(rewriter, (ASTNode)decl).setVisibility(2, description);
        }
        return description;
    }

    private ChildListPropertyDescriptor getBodyDeclarationsProperty(ASTNode declaration) {
        if (declaration instanceof AnonymousClassDeclaration) {
            return AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY;
        }
        if (declaration instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)declaration).getBodyDeclarationsProperty();
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private MethodDeclaration createSetterMethod(AST ast, ASTRewrite rewriter, String lineDelimiter) throws CoreException {
        String string;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jdt.core.dom.FieldDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FieldDeclaration field = (FieldDeclaration)ASTNodes.getParent((ASTNode)this.fFieldDeclaration, clazz);
        Type type = field.getType();
        MethodDeclaration result = ast.newMethodDeclaration();
        result.setName(ast.newSimpleName(this.fSetterName));
        result.modifiers().addAll(ASTNodeFactory.newModifiers(ast, this.createModifiers()));
        if (this.fSetterMustReturnValue) {
            result.setReturnType2((Type)rewriter.createCopyTarget((ASTNode)type));
        }
        SingleVariableDeclaration param = ast.newSingleVariableDeclaration();
        result.parameters().add(param);
        param.setName(ast.newSimpleName(this.fArgName));
        param.setType((Type)rewriter.createCopyTarget((ASTNode)type));
        param.setExtraDimensions(this.fFieldDeclaration.getExtraDimensions());
        Block block = ast.newBlock();
        result.setBody(block);
        String fieldAccess = this.createFieldAccess();
        String body = CodeGeneration.getSetterMethodBodyContent(this.fField.getCompilationUnit(), this.getTypeName(field.getParent()), this.fSetterName, fieldAccess, this.fArgName, lineDelimiter);
        if (body != null) {
            ASTNode setterNode = rewriter.createStringPlaceholder(body, 8);
            block.statements().add(setterNode);
        } else {
            Assignment ass = ast.newAssignment();
            ass.setLeftHandSide((Expression)rewriter.createStringPlaceholder(fieldAccess, 40));
            ass.setRightHandSide((Expression)ast.newSimpleName(this.fArgName));
            block.statements().add(ass);
        }
        if (this.fSetterMustReturnValue) {
            ReturnStatement rs = ast.newReturnStatement();
            rs.setExpression((Expression)ast.newSimpleName(this.fArgName));
            block.statements().add(rs);
        }
        if (this.fGenerateJavadoc && (string = CodeGeneration.getSetterComment(this.fField.getCompilationUnit(), this.getTypeName(field.getParent()), this.fSetterName, this.fField.getElementName(), ASTNodes.asString((ASTNode)type), this.fArgName, NamingConventions.removePrefixAndSuffixForFieldName((IJavaProject)this.fField.getJavaProject(), (String)this.fField.getElementName(), (int)this.fField.getFlags()), lineDelimiter)) != null) {
            Javadoc javadoc = (Javadoc)this.fRewriter.createStringPlaceholder(string, 29);
            result.setJavadoc(javadoc);
        }
        return result;
    }

    private MethodDeclaration createGetterMethod(AST ast, ASTRewrite rewriter, String lineDelimiter) throws CoreException {
        String string;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jdt.core.dom.FieldDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FieldDeclaration field = (FieldDeclaration)ASTNodes.getParent((ASTNode)this.fFieldDeclaration, clazz);
        Type type = field.getType();
        MethodDeclaration result = ast.newMethodDeclaration();
        result.setName(ast.newSimpleName(this.fGetterName));
        result.modifiers().addAll(ASTNodeFactory.newModifiers(ast, this.createModifiers()));
        Type returnType = (Type)rewriter.createCopyTarget((ASTNode)type);
        if (this.fFieldDeclaration.getExtraDimensions() > 0) {
            returnType = ast.newArrayType(returnType, this.fFieldDeclaration.getExtraDimensions());
        }
        result.setReturnType2(returnType);
        Block block = ast.newBlock();
        result.setBody(block);
        String body = CodeGeneration.getGetterMethodBodyContent(this.fField.getCompilationUnit(), this.getTypeName(field.getParent()), this.fGetterName, this.fField.getElementName(), lineDelimiter);
        if (body != null) {
            ASTNode getterNode = rewriter.createStringPlaceholder(body, 8);
            block.statements().add(getterNode);
        } else {
            ReturnStatement rs = ast.newReturnStatement();
            rs.setExpression((Expression)ast.newSimpleName(this.fField.getElementName()));
            block.statements().add(rs);
        }
        if (this.fGenerateJavadoc && (string = CodeGeneration.getGetterComment(this.fField.getCompilationUnit(), this.getTypeName(field.getParent()), this.fGetterName, this.fField.getElementName(), ASTNodes.asString((ASTNode)type), NamingConventions.removePrefixAndSuffixForFieldName((IJavaProject)this.fField.getJavaProject(), (String)this.fField.getElementName(), (int)this.fField.getFlags()), lineDelimiter)) != null) {
            Javadoc javadoc = (Javadoc)this.fRewriter.createStringPlaceholder(string, 29);
            result.setJavadoc(javadoc);
        }
        return result;
    }

    private int createModifiers() throws JavaModelException {
        int result = 0;
        if (Flags.isPublic((int)this.fVisibility)) {
            result |= 1;
        } else if (Flags.isProtected((int)this.fVisibility)) {
            result |= 4;
        } else if (Flags.isPrivate((int)this.fVisibility)) {
            result |= 2;
        }
        if (JdtFlags.isStatic((IMember)this.fField)) {
            result |= 8;
        }
        return result;
    }

    private String createFieldAccess() throws JavaModelException {
        String fieldName = this.fField.getElementName();
        boolean nameConflict = this.fArgName.equals(fieldName);
        if (JdtFlags.isStatic((IMember)this.fField)) {
            if (nameConflict) {
                return JavaModelUtil.concatenateName(this.fField.getDeclaringType().getElementName(), fieldName);
            }
        } else if (nameConflict || StubUtility.useThisForFieldAccess(this.fField.getJavaProject())) {
            return "this." + fieldName;
        }
        return fieldName;
    }

    private void checkArgName() {
        String fieldName = this.fField.getElementName();
        boolean isStatic = true;
        try {
            isStatic = JdtFlags.isStatic((IMember)this.fField);
        }
        catch (JavaModelException javaModelException) {}
        if (isStatic && this.fArgName.equals(fieldName) && fieldName.equals(this.fField.getDeclaringType().getElementName()) || JavaConventionsUtil.validateIdentifier(this.fArgName, (IJavaElement)this.fField).getSeverity() == 4) {
            this.fArgName = "_" + this.fArgName;
        }
    }

    private String getTypeName(ASTNode type) {
        if (type instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)type).getName().getIdentifier();
        }
        if (type instanceof AnonymousClassDeclaration) {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.jdt.core.dom.ClassInstanceCreation");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ClassInstanceCreation node = (ClassInstanceCreation)ASTNodes.getParent(type, clazz);
            return ASTNodes.asString((ASTNode)node.getType());
        }
        Assert.isTrue((boolean)false, (String)"Should not happen");
        return null;
    }

    public RefactoringStatus initialize(JavaRefactoringArguments arguments) {
        String insertion;
        String handle = arguments.getAttribute("input");
        if (handle != null) {
            IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
            if (element == null || !element.exists() || element.getElementType() != 8) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getName(), "org.eclipse.jdt.ui.self.encapsulate");
            }
            this.fField = (IField)element;
            try {
                this.initialize(this.fField);
            }
            catch (JavaModelException javaModelException) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getName(), "org.eclipse.jdt.ui.self.encapsulate");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        String name = arguments.getAttribute(ATTRIBUTE_GETTER);
        if (name == null || NO_NAME.equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_GETTER));
        }
        this.fGetterName = name;
        name = arguments.getAttribute(ATTRIBUTE_SETTER);
        if (name == null || NO_NAME.equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_SETTER));
        }
        this.fSetterName = name;
        String encapsulate = arguments.getAttribute(ATTRIBUTE_DECLARING);
        if (encapsulate == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_DECLARING));
        }
        this.fEncapsulateDeclaringClass = Boolean.valueOf(encapsulate);
        String matches = arguments.getAttribute(ATTRIBUTE_COMMENTS);
        if (matches == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_COMMENTS));
        }
        this.fGenerateJavadoc = Boolean.valueOf(matches);
        String visibility = arguments.getAttribute(ATTRIBUTE_VISIBILITY);
        if (visibility != null && !NO_NAME.equals(visibility)) {
            int flag = 0;
            try {
                flag = Integer.parseInt(visibility);
            }
            catch (NumberFormatException numberFormatException) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_VISIBILITY));
            }
            this.fVisibility = flag;
        }
        if ((insertion = arguments.getAttribute(ATTRIBUTE_INSERTION)) != null && !NO_NAME.equals(insertion)) {
            int index = 0;
            try {
                index = Integer.parseInt(insertion);
            }
            catch (NumberFormatException numberFormatException) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_INSERTION));
            }
            this.fInsertionIndex = index;
        }
        return new RefactoringStatus();
    }

    public boolean isUsingLocalGetter() {
        return SelfEncapsulateFieldRefactoring.checkName(this.fGetterName, this.fUsedReadNames);
    }

    public boolean isUsingLocalSetter() {
        return SelfEncapsulateFieldRefactoring.checkName(this.fSetterName, this.fUsedModifyNames);
    }

    private static boolean checkName(String name, List usedNames) {
        Iterator iter = usedNames.iterator();
        while (iter.hasNext()) {
            IMethodBinding method = (IMethodBinding)iter.next();
            String selector = method.getName();
            if (!selector.equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean isIgnorableProblem(IProblem problem) {
        return problem.getID() == 33554503;
    }

    public boolean isConsiderVisibility() {
        return this.fConsiderVisibility;
    }

    public void setConsiderVisibility(boolean considerVisibility) {
        this.fConsiderVisibility = considerVisibility;
    }
}

