/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bookmark;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smackx.PrivateDataManager;
import org.jivesoftware.smackx.bookmark.BookmarkedConference;
import org.jivesoftware.smackx.bookmark.BookmarkedURL;
import org.jivesoftware.smackx.packet.PrivateData;
import org.jivesoftware.smackx.provider.PrivateDataProvider;
import org.xmlpull.v1.XmlPullParser;

public class Bookmarks
implements PrivateData {
    private List bookmarkedURLS;
    private List bookmarkedConferences;

    public Bookmarks() {
        PrivateDataManager.addPrivateDataProvider("storage", "storage:bookmarks", new Provider());
        this.bookmarkedURLS = new ArrayList();
        this.bookmarkedConferences = new ArrayList();
    }

    public void addBookmarkedURL(BookmarkedURL bookmarkedURL) {
        this.bookmarkedURLS.add(bookmarkedURL);
    }

    public void removeBookmarkedURL(BookmarkedURL bookmarkedURL) {
        this.bookmarkedURLS.remove(bookmarkedURL);
    }

    public void clearBookmarkedURLS() {
        this.bookmarkedURLS.clear();
    }

    public void addBookmarkedConference(BookmarkedConference bookmarkedConference) {
        this.bookmarkedConferences.add(bookmarkedConference);
    }

    public void removeBookmarkedConference(BookmarkedConference bookmarkedConference) {
        this.bookmarkedConferences.remove(bookmarkedConference);
    }

    public void clearBookmarkedConferences() {
        this.bookmarkedConferences.clear();
    }

    public Collection getBookmarkedURLS() {
        return this.bookmarkedURLS;
    }

    public Collection getBookmarkedConferences() {
        return this.bookmarkedConferences;
    }

    public String getElementName() {
        return "storage";
    }

    public String getNamespace() {
        return "storage:bookmarks";
    }

    public String toXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("<storage xmlns=\"storage:bookmarks\">");
        Iterator urls = this.getBookmarkedURLS().iterator();
        while (urls.hasNext()) {
            BookmarkedURL urlStorage = (BookmarkedURL)urls.next();
            buf.append("<url name=\"").append(urlStorage.getName()).append("\" url=\"").append(urlStorage.getURL()).append("\" />");
        }
        Iterator conferences = this.getBookmarkedConferences().iterator();
        while (conferences.hasNext()) {
            BookmarkedConference conference = (BookmarkedConference)conferences.next();
            buf.append("<conference ");
            buf.append("name=\"").append(conference.getName()).append("\" ");
            buf.append("autojoin=\"").append(conference.isAutoJoin()).append("\" ");
            buf.append("jid=\"").append(conference.getJid()).append("\" ");
            buf.append(">");
            if (conference.getNickname() != null) {
                buf.append("<nick>").append(conference.getNickname()).append("</nick>");
            }
            if (conference.getPassword() != null) {
                buf.append("<password>").append(conference.getPassword()).append("</password>");
            }
            buf.append("</conference>");
        }
        buf.append("</storage>");
        return buf.toString();
    }

    private static BookmarkedURL getURLStorage(XmlPullParser parser) {
        String name = parser.getAttributeValue("", "name");
        String url = parser.getAttributeValue("", "url");
        BookmarkedURL urlStore = new BookmarkedURL();
        urlStore.setName(name);
        urlStore.setURL(url);
        return urlStore;
    }

    private static BookmarkedConference getConferenceStorage(XmlPullParser parser) throws Exception {
        BookmarkedConference conf = new BookmarkedConference();
        String name = parser.getAttributeValue("", "name");
        String autojoin = parser.getAttributeValue("", "autojoin");
        String jid = parser.getAttributeValue("", "jid");
        conf.setName(name);
        conf.setAutoJoin(Boolean.valueOf(autojoin));
        conf.setJid(jid);
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2 && "nick".equals(parser.getName())) {
                conf.setNickname(parser.nextText());
                continue;
            }
            if (eventType == 2 && "password".equals(parser.getName())) {
                conf.setPassword(parser.nextText());
                continue;
            }
            if (eventType != 3 || !"conference".equals(parser.getName())) continue;
            done = true;
        }
        return conf;
    }

    public static class Provider
    implements PrivateDataProvider {
        public PrivateData parsePrivateData(XmlPullParser parser) throws Exception {
            Bookmarks storage = new Bookmarks();
            boolean done = false;
            while (!done) {
                int eventType = parser.next();
                if (eventType == 2 && "url".equals(parser.getName())) {
                    BookmarkedURL urlStorage = Bookmarks.getURLStorage(parser);
                    if (urlStorage == null) continue;
                    storage.addBookmarkedURL(urlStorage);
                    continue;
                }
                if (eventType == 2 && "conference".equals(parser.getName())) {
                    BookmarkedConference conference = Bookmarks.getConferenceStorage(parser);
                    storage.addBookmarkedConference(conference);
                    continue;
                }
                if (eventType != 3 || !"storage".equals(parser.getName())) continue;
                done = true;
            }
            return storage;
        }
    }
}

