/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.text.DateFormatSymbols;
import java.util.Calendar;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;

public class DateTime
extends Composite {
    Color fg;
    Color bg;
    Calendar calendar = Calendar.getInstance();
    DateFormatSymbols formatSymbols = new DateFormatSymbols();
    Button down;
    Button up;
    Button monthDown;
    Button monthUp;
    Button yearDown;
    Button yearUp;
    Text text;
    Point[] fieldIndices;
    int[] fieldNames;
    int fieldCount;
    int currentField = 0;
    int characterCount = 0;
    boolean ignoreVerify = false;
    static final String DEFAULT_SHORT_DATE_FORMAT = "MM/YYYY";
    static final String DEFAULT_MEDIUM_DATE_FORMAT = "MM/DD/YYYY";
    static final String DEFAULT_LONG_DATE_FORMAT = "MM/DD/YYYY";
    static final String DEFAULT_SHORT_TIME_FORMAT = "HH:MM AM";
    static final String DEFAULT_MEDIUM_TIME_FORMAT = "HH:MM:SS AM";
    static final String DEFAULT_LONG_TIME_FORMAT = "HH:MM:SS AM";
    static final int MARGIN_WIDTH = 2;
    static final int MARGIN_HEIGHT = 1;
    static final int MIN_YEAR = 1752;
    static final int MAX_YEAR = 9999;

    public DateTime(Composite parent, int style) {
        super(parent, DateTime.checkStyle(style) | 0x100000);
        if ((this.style & 0x400) != 0) {
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 9: {
                            DateTime.this.handlePaint(event);
                            break;
                        }
                        case 11: {
                            DateTime.this.handleResize(event);
                            break;
                        }
                        case 3: {
                            DateTime.this.handleMouseDown(event);
                            break;
                        }
                        case 1: {
                            DateTime.this.handleKeyDown(event);
                            break;
                        }
                        case 31: {
                            DateTime.this.handleTraverse(event);
                        }
                    }
                }
            };
            this.addListener(9, listener);
            this.addListener(11, listener);
            this.addListener(3, listener);
            this.addListener(1, listener);
            this.addListener(31, listener);
            this.yearDown = new Button(this, 16388);
            this.monthDown = new Button(this, 16388);
            this.monthUp = new Button(this, 131076);
            this.yearUp = new Button(this, 131076);
            listener = new Listener(){

                public void handleEvent(Event event) {
                    DateTime.this.handleSelection(event);
                }
            };
            this.yearDown.addListener(13, listener);
            this.monthDown.addListener(13, listener);
            this.monthUp.addListener(13, listener);
            this.yearUp.addListener(13, listener);
        } else {
            this.text = new Text(this, 4);
            if ((this.style & 0x20) != 0) {
                this.setFormat((this.style & 0x8000) != 0 ? DEFAULT_SHORT_DATE_FORMAT : ((this.style & 0x10000000) != 0 ? "MM/DD/YYYY" : "MM/DD/YYYY"));
            } else {
                this.setFormat((this.style & 0x8000) != 0 ? DEFAULT_SHORT_TIME_FORMAT : ((this.style & 0x10000000) != 0 ? "HH:MM:SS AM" : "HH:MM:SS AM"));
            }
            this.text.setText(this.getFormattedString(this.style));
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 1: {
                            DateTime.this.onKeyDown(event);
                            break;
                        }
                        case 15: {
                            DateTime.this.onFocusIn(event);
                            break;
                        }
                        case 16: {
                            DateTime.this.onFocusOut(event);
                            break;
                        }
                        case 3: {
                            DateTime.this.onMouseClick(event);
                            break;
                        }
                        case 4: {
                            DateTime.this.onMouseClick(event);
                            break;
                        }
                        case 25: {
                            DateTime.this.onVerify(event);
                        }
                    }
                }
            };
            this.text.addListener(1, listener);
            this.text.addListener(15, listener);
            this.text.addListener(16, listener);
            this.text.addListener(3, listener);
            this.text.addListener(4, listener);
            this.text.addListener(25, listener);
            this.up = new Button(this, 132);
            this.down = new Button(this, 1028);
            this.up.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    DateTime.this.incrementField(1);
                    DateTime.this.text.setFocus();
                }
            });
            this.down.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    DateTime.this.incrementField(-1);
                    DateTime.this.text.setFocus();
                }
            });
            this.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    DateTime.this.onResize(event);
                }
            });
        }
    }

    static int checkStyle(int style) {
        style = DateTime.checkBits(style, 32, 128, 1024, 0, 0, 0);
        return DateTime.checkBits(style, 65536, 32768, 0x10000000, 0, 0, 0);
    }

    String formattedStringValue(int fieldName, int value, boolean adjust) {
        if (fieldName == 9) {
            String[] ampm = this.formatSymbols.getAmPmStrings();
            return ampm[value];
        }
        if (adjust) {
            if (fieldName == 10 && value == 0) {
                return String.valueOf(12);
            }
            if (fieldName == 2) {
                return String.valueOf(value + 1);
            }
        }
        return String.valueOf(value);
    }

    String getFormattedString(int style) {
        if ((style & 0x80) != 0) {
            String[] ampm = this.formatSymbols.getAmPmStrings();
            int h = this.calendar.get(10);
            if (h == 0) {
                h = 12;
            }
            int m = this.calendar.get(12);
            int s = this.calendar.get(13);
            int a = this.calendar.get(9);
            if ((style & 0x8000) != 0) {
                return (h < 10 ? " " : "") + h + ":" + (m < 10 ? "0" : "") + m + " " + ampm[a];
            }
            return (h < 10 ? " " : "") + h + ":" + (m < 10 ? "0" : "") + m + ":" + (s < 10 ? "0" : "") + s + " " + ampm[a];
        }
        int y = this.calendar.get(1);
        int m = this.calendar.get(2) + 1;
        int d = this.calendar.get(5);
        if ((style & 0x8000) != 0) {
            return (m < 10 ? " " : "") + m + "/" + y;
        }
        return (m < 10 ? " " : "") + m + "/" + (d < 10 ? " " : "") + d + "/" + y;
    }

    String getComputeSizeString(int style) {
        if ((style & 0x20) != 0) {
            return (style & 0x8000) != 0 ? DEFAULT_SHORT_DATE_FORMAT : ((style & 0x10000000) != 0 ? "MM/DD/YYYY" : "MM/DD/YYYY");
        }
        return (style & 0x8000) != 0 ? DEFAULT_SHORT_TIME_FORMAT : ((style & 0x10000000) != 0 ? "HH:MM:SS AM" : "HH:MM:SS AM");
    }

    int getFieldIndex(int fieldName) {
        int i = 0;
        while (i < this.fieldCount) {
            if (this.fieldNames[i] == fieldName) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void commitCurrentField() {
        if (this.characterCount > 0) {
            int newValue;
            this.characterCount = 0;
            int fieldName = this.fieldNames[this.currentField];
            int start = this.fieldIndices[this.currentField].x;
            int end = this.fieldIndices[this.currentField].y;
            String value = this.text.getText(start, end - 1);
            int s = value.lastIndexOf(32);
            if (s != -1) {
                value = value.substring(s + 1);
            }
            if ((newValue = this.unformattedIntValue(fieldName, value, this.characterCount == 0, this.calendar.getActualMaximum(fieldName))) != -1) {
                this.setTextField(fieldName, newValue, true, true);
            }
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if ((this.style & 0x400) != 0) {
            Point cellSize = this.getCellSize(null);
            Point buttonSize = this.monthDown.computeSize(-1, -1, changed);
            width = cellSize.x * 7;
            height = cellSize.y * 7 + Math.max(cellSize.y, buttonSize.y);
        } else {
            GC gc = new GC(this.text);
            Point textSize = gc.stringExtent(this.getComputeSizeString(this.style));
            gc.dispose();
            Rectangle trim = this.text.computeTrim(0, 0, textSize.x, textSize.y);
            Point buttonSize = this.up.computeSize(-1, -1, changed);
            width = trim.width + buttonSize.x;
            height = Math.max(trim.height, buttonSize.y);
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int borderWidth = this.getBorderWidth();
        return new Point(width + 2 * borderWidth, height + 2 * borderWidth);
    }

    void drawDay(GC gc, Point cellSize, int day) {
        int cell = this.getCell(day);
        Point location = this.getCellLocation(cell, cellSize);
        String str = String.valueOf(day);
        Point extent = gc.stringExtent(str);
        int date = this.calendar.get(5);
        if (day == date) {
            Display display = this.getDisplay();
            gc.setBackground(display.getSystemColor(26));
            gc.setForeground(display.getSystemColor(27));
            gc.fillRectangle(location.x, location.y, cellSize.x, cellSize.y);
        }
        gc.drawString(str, location.x + (cellSize.x - extent.x) / 2, location.y + (cellSize.y - extent.y) / 2, true);
        if (day == date) {
            gc.setBackground(this.getBackground());
            gc.setForeground(this.getForeground());
        }
    }

    void drawDays(GC gc, Point cellSize, Rectangle client) {
        gc.setBackground(this.getBackground());
        gc.setForeground(this.getForeground());
        gc.fillRectangle(0, cellSize.y, client.width, cellSize.y * 7);
        int firstDay = this.calendar.getActualMinimum(5);
        int lastDay = this.calendar.getActualMaximum(5);
        int day = firstDay;
        while (day <= lastDay) {
            this.drawDay(gc, cellSize, day);
            ++day;
        }
    }

    void drawDaysOfWeek(GC gc, Point cellSize, Rectangle client) {
        Display display = this.getDisplay();
        gc.setBackground(display.getSystemColor(22));
        gc.setForeground(display.getSystemColor(21));
        gc.fillRectangle(0, 0, client.width, cellSize.y);
        String[] days = this.formatSymbols.getShortWeekdays();
        int x = 0;
        int y = 0;
        int i = 1;
        while (i < days.length) {
            String day = days[i];
            Point extent = gc.stringExtent(day);
            gc.drawString(day, x + (cellSize.x - extent.x) / 2, y + (cellSize.y - extent.y) / 2, true);
            x += cellSize.x;
            ++i;
        }
        gc.drawLine(0, cellSize.y - 1, client.width, cellSize.y - 1);
    }

    void drawMonth(GC gc, Point cellSize, Rectangle client) {
        Display display = this.getDisplay();
        gc.setBackground(display.getSystemColor(22));
        gc.setForeground(display.getSystemColor(21));
        int y = cellSize.y * 7;
        gc.fillRectangle(0, y, client.width, cellSize.y);
        gc.drawLine(0, y - 1, client.width, y - 1);
        String str = String.valueOf(this.formatSymbols.getShortMonths()[this.calendar.get(2)]) + ", " + this.calendar.get(1);
        Point extent = gc.stringExtent(str);
        gc.drawString(str, (cellSize.x * 7 - extent.x) / 2, y + (cellSize.y - extent.y) / 2, true);
    }

    Point getCellSize(GC gc) {
        boolean dispose;
        boolean bl = dispose = gc == null;
        if (gc == null) {
            gc = new GC(this);
        }
        int width = 0;
        int height = 0;
        String[] days = this.formatSymbols.getShortWeekdays();
        int i = 0;
        while (i < days.length) {
            Point extent = gc.stringExtent(days[i]);
            width = Math.max(width, extent.x);
            height = Math.max(height, extent.y);
            ++i;
        }
        int firstDay = this.calendar.getMinimum(5);
        int lastDay = this.calendar.getMaximum(5);
        int day = firstDay;
        while (day <= lastDay) {
            Point extent = gc.stringExtent(String.valueOf(day));
            width = Math.max(width, extent.x);
            height = Math.max(height, extent.y);
            ++day;
        }
        if (dispose) {
            gc.dispose();
        }
        return new Point(width + 4, height + 2);
    }

    Point getCellLocation(int cell, Point cellSize) {
        return new Point(cell % 7 * cellSize.x, cell / 7 * cellSize.y);
    }

    int getCell(int date) {
        int day = this.calendar.get(5);
        this.calendar.set(5, 1);
        int result = date + this.calendar.get(7) + 5;
        this.calendar.set(5, day);
        return result;
    }

    int getDate(int cell) {
        int day = this.calendar.get(5);
        this.calendar.set(5, 1);
        int result = cell - this.calendar.get(7) - 5;
        this.calendar.set(5, day);
        return result;
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.bg == null) {
            return this.getDisplay().getSystemColor(25);
        }
        return this.bg;
    }

    public int getDay() {
        this.checkWidget();
        return this.calendar.get(5);
    }

    public Color getForeground() {
        this.checkWidget();
        if (this.fg == null) {
            return this.getDisplay().getSystemColor(24);
        }
        return this.fg;
    }

    public int getHours() {
        this.checkWidget();
        return this.calendar.get(11);
    }

    public int getMinutes() {
        this.checkWidget();
        return this.calendar.get(12);
    }

    public int getMonth() {
        this.checkWidget();
        return this.calendar.get(2);
    }

    String getNameText() {
        return (this.style & 0x80) != 0 ? String.valueOf(this.getHours()) + ":" + this.getMinutes() + ":" + this.getSeconds() : String.valueOf(this.getMonth() + 1) + "/" + this.getDay() + "/" + this.getYear();
    }

    public int getSeconds() {
        this.checkWidget();
        return this.calendar.get(13);
    }

    public int getYear() {
        this.checkWidget();
        return this.calendar.get(1);
    }

    void handleKeyDown(Event event) {
        int newDay = this.calendar.get(5);
        switch (event.keyCode) {
            case 0x1000002: {
                newDay += 7;
                break;
            }
            case 0x1000001: {
                newDay -= 7;
                break;
            }
            case 0x1000004: {
                ++newDay;
                break;
            }
            case 0x1000003: {
                --newDay;
            }
        }
        this.setDay(newDay, true);
    }

    void handleMouseDown(Event event) {
        this.setFocus();
        Point cellSize = this.getCellSize(null);
        int column = event.x / cellSize.x;
        int row = event.y / cellSize.y;
        int cell = row * 7 + column;
        int newDay = this.getDate(cell);
        this.setDay(newDay, true);
    }

    void handlePaint(Event event) {
        GC gc = event.gc;
        Rectangle client = this.getClientArea();
        Point cellSize = this.getCellSize(gc);
        this.drawDaysOfWeek(gc, cellSize, client);
        this.drawDays(gc, cellSize, client);
        this.drawMonth(gc, cellSize, client);
    }

    void handleResize(Event event) {
        this.yearDown.pack();
        this.monthDown.pack();
        this.monthUp.pack();
        this.yearUp.pack();
        Point cellSize = this.getCellSize(null);
        Point size = this.monthDown.getSize();
        int height = Math.max(cellSize.y, size.y);
        int y = cellSize.y * 7 + (height - size.y) / 2;
        this.yearDown.setLocation(0, y);
        this.monthDown.setLocation(size.x, y);
        int x = cellSize.x * 7 - size.x;
        this.monthUp.setLocation(x - size.x, y);
        this.yearUp.setLocation(x, y);
    }

    void handleSelection(Event event) {
        if (event.widget == this.monthDown) {
            this.calendar.add(2, -1);
        } else if (event.widget == this.monthUp) {
            this.calendar.add(2, 1);
        } else if (event.widget == this.yearDown) {
            this.calendar.add(1, -1);
        } else if (event.widget == this.yearUp) {
            this.calendar.add(1, 1);
        } else {
            return;
        }
        this.redraw();
        this.postEvent(13);
    }

    void handleTraverse(Event event) {
        switch (event.detail) {
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 256: 
            case 512: {
                event.doit = true;
            }
        }
    }

    boolean isValid(int fieldName, int value) {
        int min = this.calendar.getActualMinimum(fieldName);
        int max = this.calendar.getActualMaximum(fieldName);
        return value >= min && value <= max;
    }

    boolean isValid(int year, int month, int day) {
        Calendar valid = Calendar.getInstance();
        valid.set(year, month, day);
        return valid.get(1) == year && valid.get(2) == month && valid.get(5) == day;
    }

    void onKeyDown(Event event) {
        switch (event.keyCode) {
            case 0x1000004: 
            case 16777263: {
                this.selectField((this.currentField + 1) % this.fieldCount);
                break;
            }
            case 0x1000003: {
                int index = this.currentField - 1;
                this.selectField(index < 0 ? this.fieldCount - 1 : index);
                break;
            }
            case 0x1000001: 
            case 16777259: {
                this.commitCurrentField();
                this.incrementField(1);
                break;
            }
            case 0x1000002: 
            case 16777261: {
                this.commitCurrentField();
                this.incrementField(-1);
                break;
            }
            case 0x1000007: {
                int fieldName = this.fieldNames[this.currentField];
                this.setTextField(fieldName, this.calendar.getActualMinimum(fieldName), true, true);
                break;
            }
            case 0x1000008: {
                int fieldName = this.fieldNames[this.currentField];
                this.setTextField(fieldName, this.calendar.getActualMaximum(fieldName), true, true);
                break;
            }
            default: {
                switch (event.character) {
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': {
                        this.selectField((this.currentField + 1) % this.fieldCount);
                    }
                }
            }
        }
    }

    void onFocusIn(Event event) {
        this.selectField(this.currentField);
    }

    void onFocusOut(Event event) {
        this.commitCurrentField();
    }

    void onMouseClick(Event event) {
        if (event.button != 1) {
            return;
        }
        Point sel = this.text.getSelection();
        int i = 0;
        while (i < this.fieldCount) {
            if (sel.x >= this.fieldIndices[i].x && sel.x <= this.fieldIndices[i].y) {
                this.currentField = i;
                break;
            }
            ++i;
        }
        this.selectField(this.currentField);
    }

    void onResize(Event event) {
        Rectangle rect = this.getClientArea();
        int width = rect.width;
        int height = rect.height;
        Point buttonSize = this.up.computeSize(-1, height);
        int buttonHeight = buttonSize.y / 2;
        this.text.setBounds(0, 0, width - buttonSize.x, height);
        this.up.setBounds(width - buttonSize.x, 0, buttonSize.x, buttonHeight);
        this.down.setBounds(width - buttonSize.x, buttonHeight, buttonSize.x, buttonHeight);
    }

    void onVerify(Event event) {
        if (this.ignoreVerify) {
            return;
        }
        event.doit = false;
        int fieldName = this.fieldNames[this.currentField];
        int start = this.fieldIndices[this.currentField].x;
        int end = this.fieldIndices[this.currentField].y;
        int length = end - start;
        String newText = event.text;
        if (fieldName == 9) {
            String[] ampm = this.formatSymbols.getAmPmStrings();
            if (newText.equalsIgnoreCase(ampm[0].substring(0, 1)) || newText.equalsIgnoreCase(ampm[0])) {
                this.setTextField(fieldName, 0, true, false);
            } else if (newText.equalsIgnoreCase(ampm[1].substring(0, 1)) || newText.equalsIgnoreCase(ampm[1])) {
                this.setTextField(fieldName, 1, true, false);
            }
            return;
        }
        if (this.characterCount > 0) {
            try {
                Integer.parseInt(newText);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            String value = this.text.getText(start, end - 1);
            int s = value.lastIndexOf(32);
            if (s != -1) {
                value = value.substring(s + 1);
            }
            newText = value + newText;
        }
        int newTextLength = newText.length();
        boolean first = this.characterCount == 0;
        this.characterCount = newTextLength < length ? newTextLength : 0;
        int max = this.calendar.getActualMaximum(fieldName);
        int min = this.calendar.getActualMinimum(fieldName);
        int newValue = this.unformattedIntValue(fieldName, newText, this.characterCount == 0, max);
        if (newValue == -1) {
            this.characterCount = 0;
            return;
        }
        if (first && newValue == 0 && length > 1) {
            this.setTextField(fieldName, newValue, false, false);
        } else if (min <= newValue && newValue <= max) {
            this.setTextField(fieldName, newValue, this.characterCount == 0, this.characterCount == 0);
        } else if (newTextLength >= length && (newValue = this.unformattedIntValue(fieldName, newText = newText.substring(newTextLength - length + 1), this.characterCount == 0, max)) != -1) {
            this.characterCount = length - 1;
            if (min <= newValue && newValue <= max) {
                this.setTextField(fieldName, newValue, this.characterCount == 0, true);
            }
        }
    }

    void incrementField(int amount) {
        int fieldName = this.fieldNames[this.currentField];
        int value = this.calendar.get(fieldName);
        if (fieldName == 10) {
            int max = this.calendar.getMaximum(10);
            int min = this.calendar.getMinimum(10);
            if (value == max && amount == 1 || value == min && amount == -1) {
                int temp = this.currentField;
                this.currentField = this.getFieldIndex(9);
                this.setTextField(9, (this.calendar.get(9) + 1) % 2, true, true);
                this.currentField = temp;
            }
        }
        this.setTextField(fieldName, value + amount, true, true);
    }

    void selectField(int index) {
        if (index != this.currentField) {
            this.commitCurrentField();
        }
        final int start = this.fieldIndices[index].x;
        final int end = this.fieldIndices[index].y;
        Point pt = this.text.getSelection();
        if (index == this.currentField && start == pt.x && end == pt.y) {
            return;
        }
        this.currentField = index;
        this.display.asyncExec(new Runnable(){

            public void run() {
                if (!DateTime.this.text.isDisposed()) {
                    String value = DateTime.this.text.getText(start, end - 1);
                    int s = value.lastIndexOf(32);
                    s = s == -1 ? start : start + s + 1;
                    DateTime.this.text.setSelection(s, end);
                }
            }
        });
    }

    void setTextField(int fieldName, int value, boolean commit, boolean adjust) {
        if (commit) {
            int max = this.calendar.getActualMaximum(fieldName);
            int min = this.calendar.getActualMinimum(fieldName);
            if (fieldName == 1) {
                max = 9999;
                min = 1752;
                int currentYear = Calendar.getInstance().get(1);
                int currentCentury = currentYear / 100 * 100;
                if (value < (currentYear + 30) % 100) {
                    value += currentCentury;
                } else if (value < 100) {
                    value += currentCentury - 100;
                }
            }
            if (value > max) {
                value = min;
            }
            if (value < min) {
                value = max;
            }
        }
        int start = this.fieldIndices[this.currentField].x;
        int end = this.fieldIndices[this.currentField].y;
        this.text.setSelection(start, end);
        String newValue = this.formattedStringValue(fieldName, value, adjust);
        StringBuffer buffer = new StringBuffer(newValue);
        int prependCount = end - start - buffer.length();
        int i = 0;
        while (i < prependCount) {
            switch (fieldName) {
                case 12: 
                case 13: {
                    buffer.insert(0, 0);
                    break;
                }
                default: {
                    buffer.insert(0, ' ');
                }
            }
            ++i;
        }
        newValue = buffer.toString();
        this.ignoreVerify = true;
        this.text.insert(newValue);
        this.ignoreVerify = false;
        this.selectField(this.currentField);
        if (commit) {
            this.setField(fieldName, value);
        }
    }

    void setField(int fieldName, int value) {
        if (this.calendar.get(fieldName) == value) {
            return;
        }
        if (fieldName == 9) {
            this.calendar.roll(11, 12);
        }
        this.calendar.set(fieldName, value);
        this.postEvent(13);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    void redraw(int cell, Point cellSize) {
        Point location = this.getCellLocation(cell, cellSize);
        this.redraw(location.x, location.y, cellSize.x, cellSize.y, false);
    }

    public void setBackground(Color color) {
        this.checkWidget();
        super.setBackground(color);
        this.bg = color;
        if (this.text != null) {
            this.text.setBackground(color);
        }
    }

    public void setDate(int year, int month, int day) {
        this.checkWidget();
        if (!this.isValid(year, month, day)) {
            return;
        }
        this.calendar.set(1, year);
        this.calendar.set(2, month);
        if ((this.style & 0x400) != 0) {
            this.updateControl();
            this.setDay(day, false);
        } else {
            this.calendar.set(5, day);
            this.updateControl();
        }
    }

    public void setDay(int day) {
        this.checkWidget();
        if (!this.isValid(5, day)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.setDay(day, false);
        } else {
            this.calendar.set(5, day);
            this.updateControl();
        }
    }

    void setDay(int newDay, boolean notify) {
        int firstDay = this.calendar.getActualMinimum(5);
        int lastDay = this.calendar.getActualMaximum(5);
        if (firstDay > newDay || newDay > lastDay) {
            return;
        }
        Point cellSize = this.getCellSize(null);
        this.redraw(this.getCell(this.calendar.get(5)), cellSize);
        this.calendar.set(5, newDay);
        this.redraw(this.getCell(this.calendar.get(5)), cellSize);
        if (notify) {
            this.postEvent(13);
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        if (this.text != null) {
            this.text.setFont(font);
        }
        this.redraw();
    }

    public void setForeground(Color color) {
        this.checkWidget();
        super.setForeground(color);
        this.fg = color;
        if (this.text != null) {
            this.text.setForeground(color);
        }
    }

    void setFormat(String string) {
        this.checkWidget();
        this.fieldCount = (this.style & 0x20) != 0 ? ((this.style & 0x8000) != 0 ? 2 : 3) : ((this.style & 0x8000) != 0 ? 3 : 4);
        this.fieldIndices = new Point[this.fieldCount];
        this.fieldNames = new int[this.fieldCount];
        if ((this.style & 0x20) != 0) {
            this.fieldNames[0] = 2;
            this.fieldIndices[0] = new Point(0, 2);
            if ((this.style & 0x8000) != 0) {
                this.fieldNames[1] = 1;
                this.fieldIndices[1] = new Point(3, 7);
            } else {
                this.fieldNames[1] = 5;
                this.fieldIndices[1] = new Point(3, 5);
                this.fieldNames[2] = 1;
                this.fieldIndices[2] = new Point(6, 10);
            }
        } else {
            this.fieldNames[0] = 10;
            this.fieldIndices[0] = new Point(0, 2);
            this.fieldNames[1] = 12;
            this.fieldIndices[1] = new Point(3, 5);
            if ((this.style & 0x8000) != 0) {
                this.fieldNames[2] = 9;
                this.fieldIndices[2] = new Point(6, 8);
            } else {
                this.fieldNames[2] = 13;
                this.fieldIndices[2] = new Point(6, 8);
                this.fieldNames[3] = 9;
                this.fieldIndices[3] = new Point(9, 11);
            }
        }
    }

    public void setHours(int hours) {
        this.checkWidget();
        if (!this.isValid(11, hours)) {
            return;
        }
        this.calendar.set(11, hours);
        this.updateControl();
    }

    public void setMinutes(int minutes) {
        this.checkWidget();
        if (!this.isValid(12, minutes)) {
            return;
        }
        this.calendar.set(12, minutes);
        this.updateControl();
    }

    public void setMonth(int month) {
        this.checkWidget();
        if (!this.isValid(2, month)) {
            return;
        }
        this.calendar.set(2, month);
        this.updateControl();
    }

    public void setSeconds(int seconds) {
        this.checkWidget();
        if (!this.isValid(13, seconds)) {
            return;
        }
        this.calendar.set(13, seconds);
        this.updateControl();
    }

    public void setTime(int hours, int minutes, int seconds) {
        this.checkWidget();
        if (!this.isValid(11, hours)) {
            return;
        }
        if (!this.isValid(12, minutes)) {
            return;
        }
        if (!this.isValid(13, seconds)) {
            return;
        }
        this.calendar.set(11, hours);
        this.calendar.set(12, minutes);
        this.calendar.set(13, seconds);
        this.updateControl();
    }

    public void setYear(int year) {
        this.checkWidget();
        if (year < 1752 || year > 9999) {
            return;
        }
        this.calendar.set(1, year);
        this.updateControl();
    }

    int unformattedIntValue(int fieldName, String newText, boolean adjust, int max) {
        int newValue;
        try {
            newValue = Integer.parseInt(newText);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        if (fieldName == 2 && adjust && --newValue == -1) {
            newValue = max;
        }
        if (fieldName == 10 && adjust && newValue == 12) {
            newValue = 0;
        }
        return newValue;
    }

    void updateControl() {
        if (this.text != null) {
            String string = this.getFormattedString(this.style);
            this.ignoreVerify = true;
            this.text.setText(string);
            this.ignoreVerify = false;
        }
        this.redraw();
    }
}

