/***************************************************************************
                          schro.cc  -  description
                             -------------------
    begin                : Sat Jan 1 2000
    copyright            : (C) 2000 by Alessandro MIRONE
    email                : mirone@lure.u-psud.fr
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <stdarg.h>
#include <iostream.h>
#include <complex.h>
#include "integrate.h"

#ifndef PI
#define PI M_PI
#endif

// ***************************************************************
// ** Risoluzione dell'equazione di Schroedinger per
// **   una singola autofunzione N,L. 
// ** N sta in [1..inf], L sta in [0..inf]
// ** Il potenziale V comprende il potenziale centrifugo
// ** (cha va quindi aggiunto al potenziale PRIMA di chiamare
// **   schro!!!)
// **
// ** Le autofunzioni sono ==0 al contorno dell'atomo (fine del magliaggio)
// **
// ** I vettori r,V,y sono rispettivamente la griglia, il potenziale
// **  e la funzione d'onda. 
// ** Una parte non locale e contenuta in nonloc
// ** I puntatori r,V,y devono puntare ad array di dimensione NGRID
// ** I vettori partono da 0.
// ** Se si desidera chiamare schro da un programma in cui
// **   i vettori partono da 1 occorre commentare gli shifts
// **   sottostanti
void schro(double &E, double *r, double *V,double *nonloc, double *y, int NGRID,
           int nsol,double l);
void schro(double &E, double *r, double *V, double *y, int NGRID,
           int nsol,double l)
{
  double nonloc[NGRID];
  schro(E, r, V,nonloc, y,  NGRID,
           nsol, l);
}
void schro(double &E, double *r, double *V,double *nonloc, double *y, int NGRID,
           int nsol,double l)
{
  
  double Phase (double E,double *r, double *V,double *nonloc, double *y,int N,double  l, int normalize=0);
  double zbrent(double * X,double * V, double *nonloc, double * y,
		int N, double l,double but, double x1,double x2,double tol);
  

  //************************************************
  //**  questo shift e necessario se i vettori
  //**  nel programma chiamante partono da 0
  //**  (in schro i vettori partono da 1)
   r--;
   V--;
   nonloc--;
   y--;
  //**
  //************************************************

  double Elow=0;
  int i;
  for(i=1; i<=NGRID; i++)
    {
      if(V[i] < Elow) Elow=V[i];
    }
  double Z=V[2]*r[2];
  if( Elow < -Z*Z) Elow = -Z*Z;
  
  double Ehigh;
  //    Ehigh =(2*nsol+1)* PI/r[NGRID];
  //    Ehigh = 0.5*Ehigh*Ehigh;
  Ehigh = 0.0;

  double Eguess;
  
  double pathh = Phase(Ehigh,r,V,nonloc,y, NGRID, l );
  double pathl = Phase(Elow ,r,V,nonloc,y, NGRID, l );

 
  if( pathl>0.0) 
    {
      Phase(Elow ,r,V,nonloc,y, NGRID, l,1 );
      exit(0);
    }
  
  double pathm;

  int ns;
    double but;
    for(ns=nsol; ns>=nsol; ns--)
      {
	but= PI*(ns-l-1);
	if(but > pathh)
	  {
	    Ehigh = (but+1)*(but+1)/r[NGRID-1]/r[NGRID-1];
	    while( but > Phase(Ehigh ,r,V,nonloc,y, NGRID, l )
		  )
	      {
		Ehigh +=Ehigh;
		cout << " Ehigh " << Ehigh << endl ;
	      }
	  }
	  {
	    Eguess= zbrent(r, V,nonloc , y,
			   NGRID, l, but, Elow, Ehigh, 1.0e-7);
	    
	    pathm  = Phase(Eguess,r,V,nonloc,y, NGRID,l,1  );
            E=Eguess;
          }
      }
}


double Phase (double E,double *r, double *V,double *nonloc, double *y,int N,double l,
               int normalize )
{
    int i,j,I;
    double phase=0,ypI;

    int yNcross=0,yflag=0;

    double  R,dh,dl,dh2,dl2,dp,dl3,dhdl2,dh2dl,dh3,add1,add2,deno,num;
    double Gh,Gl,G0,Nlc,Nla,Nlb;
    double ca,cb,ep,em,y1,y2;


    //-- Calcul du point intermediaire o le V est minimum
	I=0;
	for(i=1; i<=N-1; i++)
	  {
	     if(V[i+1] >= V[i] ) 
		{
		   I=i;
		   if(i==1) 
		     {
		       I=4;
		       if(I>=N-3)
			 {
			   cout << " attenzione !!! if(I>=n-3) in schro.cc \n";
			   exit(0);
			 }
		     }
		   break;
		}
	  }
	if(I==0) 
	  {
	    I=N-1;
	    cout << " attenzione !!!I=N-1 in schro.cc  \n";
	    cout << " l est " << l << endl;
	    for(int i=1; i<=N;i++)
	      {
		cout <<r[i]<<"  "<< V[i]<<endl;
	      }
	    exit(0);
	  }
	
    //printf("V[%d]=%lf\n",I,V[I]);
    
    
//------------ Propagation de  1 a I  ----------------------
    
    for(i=1;i<=2;i++)
    {
      if(r[i]==0 && l!=-1)
	{
	  y[i]=0;
	}
      else
	{
	  y[i] = exp((l+1)*log(r[i]));
	}
    }
    
     for(i=2;i<=I;i++)
       {
	 dh = r[i+1]-r[i];
	 dl = r[i  ]-r[i-1];
	 G0 = 2*(V[i]  -E);
	 Nlb=nonloc[i];
	 if(fabs(G0*dh*dl)<1.0)
	   {

	     dh2= dh*dh;
	     dl2= dl*dl;
	     dp = dh*dl;

	     Gh = 2*(V[i+1]-E);
	     Gl = 2*(V[i-1]-E);

	     Nlc=nonloc[i+1];
	     Nla=nonloc[i-1];

	     R  = dh2 + dl2 + dp ;

	     dh3=dh2*dh;
	     dhdl2=dl*dp;
	     dh2dl=dh*dp;
	     dl3=dl*dl2;


	     // ********************************************************************************
	     // ** 17 luglio 1998. Aggiunta della parte per il termine non locale.
	     // ** Vedere file numerov.mathematica
	     // ** ( h^3*(-Nla  + Nlb ) + l^3*(Nlb  - Nlc) + 
	     // **      h^2*l*(Nla+4*Nlbd+Nlc)+h*l^2*(Nla+4*Nlb+Nlc))/l*(12-(h^2+h*l-l^2)*Gc))
	     
	     deno=(dl*(1.-Gh*(R-2*dl2)/12.));
	     
	     add1=( y[i]*(dh+(dl*Gh*(R-2*dl2)+G0*(dh+dl)*(R+2*dh*dl))/12)
		    -y[i-1]*dh*(1.-Gl*(R-2*dh2)/12.) 
		    )/deno;
	     
	     
	     add2=( dh3*(-Nla  + Nlb ) + dl3*(Nlb  - Nlc) + 
		    dh2dl*(Nla  + 4*Nlb + Nlc ) + dhdl2*(Nla + 4*Nlb + Nlc) )/deno;
	     
	     y[i+1] = y[i]+add1+add2;
	   }
	 else
	   {
	     if(G0<0.0)
	       {
		 y[i+1] = y[i]+dh*( (y[i]-y[i-1])/dl +0.5*(G0*y[i]+Nlb)*(dh+dl) );
	       }
	     else
	       {
		 ep = exp(dl*sqrt(G0));
		 em = 1./ep;

		 // **************************************************
		 // ** si prepara un cambio di variabili 
		 // ** y''= G0 y + Nlb
		 // **
		 double shift=-Nlb/G0;

		 y2=y[i]-shift;
		 y1=y[i-1]-shift;
		 dl=r[i]-r[i-1];
		 dh=r[i+1]-r[i];
		 
		 cb=em*(y2-y1*ep)/(em-ep);
		 ca=ep*(y1*em-y2)/(em-ep);
		 ep = exp(dh*sqrt(G0));
		 em = 1./ep;
		 y[i+1]=ca*ep+cb*em+shift;
	       }
	   }
	 if(fabs(y[i+1])>1e8) 
	   {
	     double fact= 1./fabs(y[i+1]) ;
	     int count =0;
	     for(j=i+1;j>=1;j--) {
	       if(y[j]==0) count++;
	       else count =0;
	       if(count > 2) break;
	       y[j]=y[j]*fact; 
	     }
	   } 

	if( (i+1) <=I )  // LA PHASE EST CALCULE EN I
	{
 	 if((y[i]*y[i+1])<0) yNcross++;
	 if(yflag && (y[i]*y[i+1])==0) { yflag=1-yflag;yNcross++;}
        }

       }
    if( y[I]==0.0) 
      {
	printf(" y[I] == 0.0 dans Schroedinger \n");
	exit(0);
      }
    
    // ypI=(y[I+1]*dl2-y[I-1]*dh2+y[I]*(dh2-dl2))/((dh+dl)*dl*dh); // vecchia maniera di calcolare yp
    // sostituita con la maniera seguente, presa dal metodo numerov (vedi numerov.nb)

    {
      int i;
      double Ga,Gb,Gc;
      i=I;
      dh = r[i+1]-r[i];
      dl = r[i  ]-r[i-1];

      Nlc=nonloc[i+1];
      Nla=nonloc[i-1];
      Nlb=nonloc[i];
	

      Gb = 2*(V[i]  -E);
      if(fabs(G0*dh*dl)>1.0)
	{
	  cout << " problema fabs(G0*dh*dl)>1.0 in calcolo di yp in I \n";
	  exit(0);
	}
      Gc = 2*(V[i+1]-E);
      Ga = 2*(V[i-1]-E);
      double ya,yb,yc;
      ya=y[I-1];
      yb=y[I];
      yc=y[I+1];

      ypI=(dh*(Ga*pow(dl,2)*(-12*dh + Gc*pow(dh,3) - 6*dl + 
			   Gc*pow(dh,2)*dl) - 
	      6*(-12*dh + Gc*pow(dh,3) - 12*dl + 2*Gc*pow(dh,2)*dl))*ya + 
	   (dh + dl)*(Gb*pow(dl,2)*
		    (-24*dh + 2*Gc*pow(dh,3) - 6*dl + 3*Gc*pow(dh,2)*dl) + 
		    6*(-12*dh + Gc*pow(dh,3) + Gc*pow(dh,2)*dl - 
		       Gc*dh*pow(dl,2) + Gc*pow(dl,3)))*yb)/
	(6.*dh*dl*(dh + dl)*(-12 + Gc*(pow(dh,2) + dh*dl - pow(dl,2)))) ;

      // *****************************************************************************
      // ** Termine aggiuntivo
      // **
      // 6*l^3*Nlc + 
      // Nla*(-12*h^2*l - 6*h*l^2 + h^3*l*(h + l)*Gc) + 
      // Nlb*(-24*h^2*l - 30*h*l^2 - 6*l^3 +      2*h^3*l*(h + l)*Gc + 3*h^2*l^2*(h + l)*Gc)
      // / al denominatore
      //
      //  6*h*(h + l)*(-12 + (h^2 + h*l - l^2)*Gc)

      deno= 6*dh*(dh + dl)*(-12 + (dh*dh + dh*dl - dl*dl)*Gc);

      num=  6*dl*dl*dl*Nlc
	+Nla*(-12*dh*dh*dl-6*dh*dl*dl+dh*dh*dh*dl*(dh + dl)*Gc)
	+Nlb*(-24*dh*dh*dl - 30*dh*dl*dl - 
	      6*dl*dl*dl+2*dh*dh*dh*dl*(dh + dl)*Gc +3*dh*dh*dl*dl*(dh+dl)*Gc
	      );
      ypI=ypI+num/deno;

    }



    
    if(fabs(y[I]) > fabs( ypI ) )
     {
      phase=-atan(ypI/y[I]);
     }
    else
     {
	double r = y[I]/ypI ;
	if(  r >0.  )
	{
	   phase=-( PI/2. - atan(r) );
	}
	else
	{
	   phase=- ( - PI/2. - atan( r ));
	}
     }
    if( fabs(y[I]) > fabs(ypI))
      {
	y[I+1]=y[I+1]/y[I];
	for(i=1;i<=I;i++) { y[i]=y[i]/y[I]; }
      }
    else
      {
	for(i=1;i<=I+1;i++) { y[i]=y[i]/ypI; }
      }
    
    
    
    //------------ Propagation de   I     rinf --------------------------
    
    for(i=N;i>=N-1;i--) y[i]=N-i;     //y[i]=exp(-sqrt(-2*E)*r[i]);
    
    for(i=N-1;i>=I;i--)
      {
	dh = r[i]-r[i-1];
	dl = r[i+1]-r[i];
	G0 = 2*(V[i]  -E);
	Nlb=nonloc[i];
	
	if(fabs(G0*dh*dl)<1.0)
	  {
	    dh2= dh*dh;
	    dl2=dl*dl;
	    dp = dh*dl;

	    Gh = 2*(V[i-1]-E);
	    Gl = 2*(V[i+1]-E);

	    Nlc=nonloc[i-1];
	    Nla=nonloc[i+1];
	    
	    R  = dh2 + dl2 + dp ;
	    
	    dh3=dh2*dh;
	    dhdl2=dl*dp;
	    dh2dl=dh*dp;
	    dl3=dl*dl2;
	
	    // ********************************************************************************
	    // ** 17 luglio 1998. Aggiunta della parte per il termine non locale.
	    // ** Vedere file numerov.mathematica
	    // ** ( h^3*(-Nla  + Nlb ) + l^3*(Nlb  - Nlc) + 
	    // **      h^2*l*(Nla+4*Nlbd+Nlc)+h*l^2*(Nla+4*Nlb+Nlc))/l*(12-(h^2+h*l-l^2)*Gc))
	    
	    deno=(dl*(1.-Gh*(R-2*dl2)/12.));
	    
	    add1=( y[i]*(dh+(dl*Gh*(R-2*dl2)+G0*(dh+dl)*(R+2*dh*dl))/12)
		   -y[i+1]*dh*(1.-Gl*(R-2*dh2)/12.) 
		   )/deno;
	    
	    add2=( dh3*(-Nla  + Nlb ) + dl3*(Nlb  - Nlc) + 
		   dh2dl*(Nla  + 4*Nlb + Nlc ) + dhdl2*(Nla + 4*Nlb + Nlc) )/deno;
	    
	    
	    y[i-1] = y[i]+add1+add2;
	    
	    
	    /*  
		y[i-1] = y[i]+( y[i]*(dh+(dl*Gh*(R-2*dl2)+G0*(dh+dl)*(R+2*dh*dl))/12)
		-y[i+1]*dh*(1.-Gl*(R-2*dh2)/12.)
		)/
		(dl*(1.-Gh*(R-2*dl2)/12.));
	    */
	  }
	else
	  {
	    if(G0<0.0)
	      {
		y[i-1] = y[i]+dh*( (y[i]-y[i+1])/dl +0.5*(G0*y[i]+Nlb)*(dh+dl) );
	      }
	    else
	      {
		dl=r[i+1]-r[i];
		dh=r[i]-r[i-1];
		ep = exp(dl*sqrt(G0));
		em = 1./ep;

		// **************************************************
		// ** si prepara un cambio di variabili 
		// ** y''= G0 y + Nlb
		// **
		double shift=-Nlb/G0;
		
		y2=y[i]-shift;
		y1=y[i+1]-shift;

		cb=(y2-y1*ep)/(em-ep);
		ca= (y1*em-y2)/(em-ep);
		cb *= em;
		ca *= ep;
		ep = exp(dh*sqrt(G0));
		em = 1./ep;
		y[i-1]=ca*ep+cb*em+shift;
	      }
	  }
	if(fabs(y[i-1])>1e8) 
	  {
	    double fact= 1./fabs(y[i-1]) ;
	    int count =0;
	    for(j=i-1;j<=N;j++) {
	      if(y[j]==0) count++;
	      else count =0;
	      if(count) break;
	      y[j]=y[j]*fact; 
	    }
	  } 
	if( (i-1) >=I )  // LA PHASE EST CALCULE EN I
	{
	  if((y[i]*y[i-1] )<0) yNcross++;
	  if(yflag && (y[i]*y[i-1])==0) { yflag=1-yflag;yNcross++;}
	}
      }
    // ypI=(y[I+1]*dh2-y[I-1]*dl2+y[I]*(dl2-dh2))/((dh+dl)*dl*dh);
    // sostituita con la maniera seguente, presa dal metodo numerov (vedi numerov.nb)
    {
      int i;
      double Ga,Gb,Gc;
      i=I;
      dh = r[i+1]-r[i];
      dl = r[i  ]-r[i-1];

      Nlc=nonloc[i+1];
      Nla=nonloc[i-1];
      Nlb=nonloc[i];


      Gb = 2*(V[i]  -E);
      if(fabs(G0*dh*dl)>1.0)
	{
	  cout << " problema fabs(G0*dh*dl)>1.0 in calcolo di yp in I \n";
	  exit(0);
	}
      Gc = 2*(V[i+1]-E);
      Ga = 2*(V[i-1]-E);
      double ya,yb,yc;
      ya=y[I-1];
      yb=y[I];
      yc=y[I+1];
      
      ypI=(dh*(Ga*pow(dl,2)*(-12*dh + Gc*pow(dh,3) - 6*dl + 
			   Gc*pow(dh,2)*dl) - 
	      6*(-12*dh + Gc*pow(dh,3) - 12*dl + 2*Gc*pow(dh,2)*dl))*ya + 
	   (dh + dl)*(Gb*pow(dl,2)*
		    (-24*dh + 2*Gc*pow(dh,3) - 6*dl + 3*Gc*pow(dh,2)*dl) + 
		    6*(-12*dh + Gc*pow(dh,3) + Gc*pow(dh,2)*dl - 
		       Gc*dh*pow(dl,2) + Gc*pow(dl,3)))*yb)/
	(6.*dh*dl*(dh + dl)*(-12 + Gc*(pow(dh,2) + dh*dl - pow(dl,2)))) ;

      // *****************************************************************************
      // ** Termine aggiuntivo
      // **
      // 6*l^3*Nlc + 
      // Nla*(-12*h^2*l - 6*h*l^2 + h^3*l*(h + l)*Gc) + 
      // Nlb*(-24*h^2*l - 30*h*l^2 - 6*l^3 +      2*h^3*l*(h + l)*Gc + 3*h^2*l^2*(h + l)*Gc)
      // / al denominatore
      //
      //  6*h*(h + l)*(-12 + (h^2 + h*l - l^2)*Gc)

      deno= 6*dh*(dh + dl)*(-12 + (dh*dh + dh*dl - dl*dl)*Gc);

      num=  6*dl*dl*dl*Nlc
	+Nla*(-12*dh*dh*dl-6*dh*dl*dl+dh*dh*dh*dl*(dh + dl)*Gc)
	+Nlb*(-24*dh*dh*dl - 30*dh*dl*dl - 
	      6*dl*dl*dl+2*dh*dh*dh*dl*(dh + dl)*Gc +3*dh*dh*dl*dl*(dh+dl)*Gc
	      );

      ypI=ypI+num/deno;

    }
    
    phase=phase+PI*yNcross /*+ atan(ypI/y[I]) */;
    
    if(fabs(y[I]) > fabs( ypI ) )
     {
      phase +=atan(ypI/y[I]);
     }
    else
     {
	double r = y[I]/ypI ;
	if(  r >0.  )
	{
	   phase +=( PI/2. - atan(r) );
	}
	else
	{
	   phase += ( - PI/2. - atan( r ));
	}
     }





    if( fabs(y[I]) > fabs(ypI))
      {
	y[I-1]=y[I-1]/y[I];
	for(i=N;i>=I;i--) { y[i]=y[i]/y[I]; }
      }
    else
      {
	for(i=N;i>=I-1;i--) { y[i]=y[i]/ypI; }
      }
    
    
    //------------------------------------------------------------------------------
    
        
    
    if(normalize)
      {
	
	double norm=0;
	double func[N+1];
	for(i=1;i<=N;i++)
	  {
	    func[i]=y[i]*y[i];
	  }
	norm=integrate(&func[1],&r[1],N);
	norm=sqrt(norm);
	for(i=1;i<N;i++)
	  {
	    y[i]=y[i]/norm;
	  }
	/*
	FILE *soly;
	soly=fopen("soly","w");
	for(i=1;i<=N;i++) fprintf(soly,"%lg %lg\n",r[i],y[i]/r[i]);
	fclose(soly);
	*/
	
      }
    return phase;
  }


#define ITMAX 100
#define EPS 3.0e-8
double zbrent(double * X,double * V,double *nonloc,double * y,
	      int N, double l, double but, double x1,double x2,double tol)

{
  double Phase (double E,double *r, double *V,double *nonloc,
		double *y,int N,double l, int normalize=0);

	int iter;
	double a=x1,b=x2,c=x2,d,e,min1,min2;
	double fa=  Phase(a,X,V,nonloc, y,N,l)-but,
               fb=  Phase(b,X,V,nonloc,y,N,l)-but
               ,fc,p,q,r,s,tol1,xm;

	if ((fa > 0.0 && fb > 0.0) || (fa < 0.0 && fb < 0.0))
	  {
	    printf("Root must be bracketed in zbrent");exit(0);
	  }
	fc=fb;
	for (iter=1;iter<=ITMAX;iter++) {
		if ((fb > 0.0 && fc > 0.0) || (fb < 0.0 && fc < 0.0)) {
			c=a;
			fc=fa;
			e=d=b-a;
		}
		if (fabs(fc) < fabs(fb)) {
			a=b;
			b=c;
			c=a;
			fa=fb;
			fb=fc;
			fc=fa;
		}
		tol1=2.0*EPS*fabs(b)+0.5*tol;
		xm=0.5*(c-b);
		if (fabs(xm) <= tol1 || fb == 0.0) return b;
		if (fabs(e) >= tol1 && fabs(fa) > fabs(fb)) {
			s=fb/fa;
			if (a == c) {
				p=2.0*xm*s;
				q=1.0-s;
			} else {
				q=fa/fc;
				r=fb/fc;
				p=s*(2.0*xm*q*(q-r)-(b-a)*(r-1.0));
				q=(q-1.0)*(r-1.0)*(s-1.0);
			}
			if (p > 0.0) q = -q;
			p=fabs(p);
			min1=3.0*xm*q-fabs(tol1*q);
			min2=fabs(e*q);
			if (2.0*p < (min1 < min2 ? min1 : min2)) {
				e=d;
				d=p/q;
			} else {
			  d=xm;
			  e=d;
			}
		      } else {
			d=xm;
			e=d;
		      }
		a=b;
		fa=fb;
		if (fabs(d) > tol1)
		  b += d;
		else
		  b += (xm >0.0 ? fabs(tol1) : -fabs(tol1));
		fb=Phase(b,X,V,nonloc,y,N,l)-but; 
	      }
  {
    printf("Maximum number of iterations exceeded in zbrent");exit(0);
  }  
  return 0.0;
}
#undef ITMAX
#undef EPS
/* (C) Copr. 1986-92 Numerical Recipes Software <%8. */








// *****************************************************
// ** INTERFACCIA PER STEFAN
// **
// **  






