/***************************************************************************
                          hfs.cc  -  description
                             -------------------
    begin                : Sat Jan 1 2000
    copyright            : (C) 2000 by Alessandro MIRONE
    email                : mirone@lure.u-psud.fr
 ***************************************************************************/

#include<stdio.h>
#include<iostream.h>
#include<string.h>
#include<math.h>
#include<complex.h>
#include"fichier.h"
  
#include "hfs.h"


#define SWAP(a,b,dum)  dum=a;a=b;b=dum;
double _tmpmx1,_tmpmx2;
#define MAX(a,b) ((_tmpmx1=(a))>(_tmpmx2=(b))) ? (_tmpmx1):(_tmpmx2) 
#define Abs(a)  ((a)>=0) ? (a) : (-(a))
#ifndef PI
#define PI M_PI
#endif
#ifndef Min
#define Min(a,b) (((a)<(b))  ? (a) : (b)  )
#endif

#define SCAMBIONONLOCALE

extern "C"
{
  int tfguess_(double *x, double *v, double *zp, double *T,double *P, 
               int *ngrille, double *Z, double *Ch);
  int ferinc_(...);

   int MAIN__()
   {
	return 0;
    };
}

double  gammaln(double xx)
{
        double x,y,tmp,ser;
        static double cof[6]={76.18009172947146,-86.50532032941677,
                24.01409824083091,-1.231739572450155,
                0.1208650973866179e-2,-0.5395239384953e-5};
        int j;

        y=x=xx;
        tmp=x+5.5;
        tmp -= (x+0.5)*log(tmp);
        ser=1.000000000190015;
        for (j=0;j<=5;j++) ser += cof[j]/++y;
        return -tmp+log(2.5066282746310005*ser/x);
}

#include"integrate.h"

Wignercoef Atomo_sferico::trej;

void Atomo_sferico::stampa_free_wave(char *nf, int ninterp )
{

  FILE *fout=fopen(nf,"w");

  for(int i=0; i< Min( free_wkb_start, n_grille) ; i++)
   {
     fprintf(fout,"%g %g\n",x[i],wfunc_libre[i]);
   }


 double xj, phase, ampiezza;
 for(int i=free_wkb_start;i<n_grille-1;i++)
   {
     for(int j=1;j<=ninterp ;j++)
       {
	 xj=x[i]+(x[i+1]-x[i])*(j-1)/(ninterp);
	 phase=wfunc_libre_WKB_phase[i]+(wfunc_libre_WKB_phase[i+1]
				        -wfunc_libre_WKB_phase[i])
	   *(xj-x[i])/(x[i+1]-x[i]);
	 ampiezza = wfunc_libre_WKB_amp[i]+(wfunc_libre_WKB_amp[i+1]-
					    wfunc_libre_WKB_amp[i])
	   *(xj-x[i])/(x[i+1]-x[i]);
	 ampiezza *= sin(phase);
	 fprintf(fout,"%g %g\n",xj,ampiezza);
       }
    
   }
 fclose(fout); 
};



void Atomo_sferico::stampa_wave_functions(char *nf)
{
   char nomef[90];
   FILE *file;
   for(int is=0; is<n_stati;  is++)
     {
      	sprintf(nomef,"%sN%dL%d.wfunc",nf,N[is],L[is]);
        file=fopen(nomef,"w");
        fprintf(file,"# Energia = %g \n", E[is]);
        fprintf(file,"# N       = %d  \n", N[is]);
        fprintf(file,"# L       = %d  \n", L[is]);
        for(int i=0; i< n_grille; i++)
           {
           	fprintf(file,"%g  %g\n", x[i],y[is][i]);
           }
        fclose(file);
     }	
}

double Atomo_sferico::scalareFreeBoundR(int is)
{
  double result=0;
  for(int i=0; i< Min( free_wkb_start, n_grille-1) ; i++)
    {
      result += (y[is][i]*wfunc_libre[i]*x[i] +
		 y[is][i+1]*wfunc_libre[i+1]*x[i+1])
	*(x[i+1]-x[i]);
    }
  double  phase1,phase2, ampiezza1,ampiezza2,c1,c2; // s1,s2;
  phase1=wfunc_libre_WKB_phase[ free_wkb_start ];
  ampiezza1=wfunc_libre_WKB_amp[free_wkb_start];
  c1= -cos(phase1);
  // s1= sin(phase1);
  for(int i=free_wkb_start+1;i<n_grille;i++)
    {
      phase2=wfunc_libre_WKB_phase[ i ];
      ampiezza2=wfunc_libre_WKB_amp[i];
      c2 = -cos(phase2);
      // s2=sin(phase2);
      
      result += (ampiezza1*y[is][i-1]*x[i-1]     +ampiezza2*y[is][i]*x[i]   )*
	(c2-c1)/(phase2-phase1) *(x[i]-x[i-1]);
      
      ampiezza1=ampiezza2;
      phase1=phase2;
      c1=c2;

    }
  return 0.5*result;
}

void Atomo_sferico::find_free_wave_function(double ef, double L)
{
  double  schrofreeWKB(double E,double *r, double *V, double *y,double *y_aux,
		       double *y_aux2,
		    double &aJ, double &aY,  int &wkb_start,
		    int N,double  l, int normalize );
  
  double  VplsCnt[n_grille];
  for(int ix=0; ix<n_grille; ix++)
    {
      // VplsCnt[ix]=v_non_local[0][ix] + L*(L+1)*cnt[ix];
      VplsCnt[ix]=v[ix] + L*(L+1)*cnt[ix];
    }
  
  schrofreeWKB( ef, x , VplsCnt, wfunc_libre ,wfunc_libre_WKB_amp,
		wfunc_libre_WKB_phase,
	     aJ,aY, free_wkb_start, n_grille,    L, 1 );
}


void Atomo_sferico::find_wave_functions()
{
  void schro(double &E, double *r, double *V, double *Vnonloc ,double *y, int NGRID, int nsol,
	     double l);
  double VplsCnt[n_grille];
  for(int is=0; is<n_stati;  is++)
    {
      for(int ix=0; ix<n_grille; ix++)
         {
           VplsCnt[ix]=v[ix] + L[is]*(L[is]+1)*cnt[ix];
         }
      schro( E[is], x , VplsCnt,v_non_local[is], y[is], n_grille,  N[is],  L[is]);
    }
}

void  Atomo_sferico::set_pot(double *p)
{
  memcpy(v,p, n_grille*sizeof(double));
  memcpy(v_old ,p, n_grille*sizeof(double));
  

  for(int ns=0; ns<n_stati; ns++)
     {
      memset(v_non_local_old[ns],0, n_grille*sizeof(double));  
      memset(v_non_local[ns],0, n_grille*sizeof(double));
     }  
};

void Atomo_sferico::set_pot_tf(double Zi)
{
  double *Zp = new double [n_grille] ;
  double P,T=0.001, dec;
  if(Z<Zi)
    {
      cout << " Z < Zi in set_pot_tf \n";
      exit(0);
    }
  cout << " entro tfguess \n";
  tfguess_(x,v,Zp,&T,&P,&n_grille,&Z,&Zi);
  cout << " tfguess OK \n";
  dec = v[n_grille-1]/x[n_grille-1];
  FILE *ou=fopen("v.dat","w");
  for(int i=0; i<n_grille; i++)
    {
      v[i] = -v[i]/x[i]+dec;
      fprintf(ou,"%g %g\n",x[i],v[i]);
    }
 

  for(int ns=0; ns<n_stati; ns++)
     {
      memset(v_non_local_old[ns],0, n_grille*sizeof(double));  
      memset(v_non_local[ns],0, n_grille*sizeof(double));
     }  
  fclose(ou);
  delete Zp;
}


void Atomo_sferico::set_pot_coul()
{
  for(int i=0; i< n_grille;i++)
    v[i]=-Z/x[i];
  for(int ns=0; ns<n_stati; ns++)
     {
      memset(v_non_local_old[ns],0, n_grille*sizeof(double));  
      memset(v_non_local[ns],0, n_grille*sizeof(double));
     }  
}

void Atomo_sferico::calcolakin()
{
  for(int is=0; is < n_stati; is++)
    {
      for(int i=0; i< n_grille;i++)
	{
	  ykin[is][i]=(E[is]-v[i])*y[is][i]-v_non_local[is][i];
	}
    }
};


void Atomo_sferico::calcolaEsfericomixed(double *occuser, double *Esfer)
{
  // *************************************************************
  // **  declarations
  void CalcRhoLie(double *rho, int Nlie, int Nx, double *occ, 
		  double *x, double **psi);
  void  Poisson(double *rho,double *x, int Nx, double *G, double * rhoint,
		double *rhoext);

  // *************************************
  // ** Densita elettroni legati

  CalcRhoLie( rhodum, n_stati , n_grille , occuser, 
	      x,y);

  Poisson(rhodum,x,n_grille,rhodumb, rhoint, vext);




  // *********************************************
  // ** 
  double urs;
  double numel=0;

  for(int i=0; i< n_stati; i++) numel += occuser[i];

  double ztot=Z-numel;

  for (int i=0; i< n_grille; i++)
    {
      urs=pow(4*(rho[i])/3.*PI, 1./3.) ;
      vech[i] =0.91633*urs/1.5 ; 
 
      rhodumb[i] = -Z/x[i] - vech[i] +rhodumb[i];

      if(rhodumb[i]>-(ztot+1)/x[i])
	{
	  rhodumb[i]=-(ztot+1)/x[i];
	}
   }


    double dh,dl,dh2,dl2;
    for(int i=1; i<n_grille-1; i++)
    {
      dh=x[i+1]-x[i];
      dl=x[i]-x[i-1];
      dh2=dh*dh;
      dl2=dl*dl;
      Esfer[i]=(   rhodumb[i+1]*dl2 - rhodumb[i-1]*dh2 + rhodumb[i]*(dh2-dl2)   )/((dh+dl)*dl*dh);
    }

    // Completiamo i punti estremi in maniera cialtronesca
    
  Esfer[0]=Esfer[1];
  Esfer[n_grille-1]=Esfer[n_grille-2];

};
void Atomo_sferico::calcolaEsfericomixedNew(double *occuser, double *Esfer)
{
  // *************************************************************
  // **  declarations
  void CalcRhoLie(double *rho, int Nlie, int Nx, double *occ, 
		  double *x, double **psi);
  void  Poisson(double *rho,double *x, int Nx, double *G, double * rhoint,
		double *rhoext);


  // *********************************************
  // **
  double *El;
  for(int is=0; is< n_stati; is++) 
    {
      El=Esfer+is*n_grille;
      double store= occuser[is];
      // occuser[is] -=1;
      
      CalcRhoLie( rhodum, n_stati , n_grille , occuser, 
		  x,y); 
      Poisson(rhodum,x,n_grille,rhodumb, rhoint, vext);
  
      for (int i=0; i< n_grille; i++)
	{ 
          double urs=pow(4*(rhodum[i])/3.*PI, 1./3.) ;
          vech[i] =0.91633*urs/1.5 ;

          rhodumb[i] = -Z/x[i] - vech[i] +rhodumb[i];
 	}
      
      double dh,dl,dh2,dl2;
      for(int i=1; i<n_grille-1; i++)
	{
	  dh=x[i+1]-x[i];
	  dl=x[i]-x[i-1];
	  dh2=dh*dh;
	  dl2=dl*dl;
	  El[i]=(   rhodumb[i+1]*dl2 - rhodumb[i-1]*dh2 + rhodumb[i]*(dh2-dl2)   )/((dh+dl)*dl*dh);
	}
      
      // Completiamo i punti estremi in maniera cialtronesca
      
      El[0]=El[1];
      El[n_grille-1]=El[n_grille-2];
      
      occuser[is]=store;
    }

};

void Atomo_sferico::ricalcola_v()
{
  // *************************************************************
  // **  declarations
  void CalcRhoLie(double *rho, int Nlie, int Nx, double *occ, 
		  double *x, double **psi);
  void  Poisson(double *rho,double *x, int Nx, double *G, double * rhoint,
		double *rhoext);
  
  // *************************************
  // ** Densita elettroni legati
  CalcRhoLie( rho, n_stati , n_grille , occ, 
	      x,y);
  // ******************************************
  // ** Energia elettrostatica elettroni legati
  memcpy(v_old,v, n_grille*sizeof(double));
  Poisson(rho,x,n_grille,v, rhoint, vext);

  // *********************************************
  // ** 
  static double ce  = 1.5  *pow(3./PI, 1./3.); 
  double urs;
  double ztot=Z-getnel();
  for (int i=0; i< n_grille; i++)
    {
      urs=pow(4*(rho[i])/3.*PI, 1./3.) ;
      vech[i] =0.91633*urs/1.5 ; 
      if(CORRELAZIONE)
	{
	  if(urs> 1.0e-9)
	    {
	      vcorr[i]=0.09329+0.06218*log(urs);
	    }
	  else vcorr[i]=0.0;
	  
	  if(vcorr[i]<0) vcorr[i]=0;
	}
      else  vcorr[i]=0.0;

      v[i] = -Z/x[i] - vech[i] +v[i]-vcorr[i] ;
      if(v[i]>-(ztot+1)/x[i])
	{
	  v[i]=-(ztot+1)/x[i];
	}
   }

  double v0 = v[ n_grille - 1 ] ;
  for (int i=0; i< n_grille; i++)
    {
	v[i] -= v0 ;
    }

  for(int ns=0; ns<n_stati; ns++)
     {
       memset(v_non_local[ns], 0, n_grille*sizeof(double));
     }
}


void Atomo_sferico::ricalcola_v(double *rh)
{
  void  Poisson(double *rho,double *x, int Nx, double *G, double * rhoint,
		double *rhoext);
  
  memcpy(rho,rh, n_grille*sizeof(double));

  // ******************************************
  // ** Energia elettrostatica elettroni legati
  memcpy(v_old,v, n_grille*sizeof(double));
  Poisson(rho,x,n_grille,v, rhoint, vext);

  // *********************************************
  // ** 
  static double ce  = 1. *pow(3./PI, 1./3.); 
  double urs;
  for (int i=0; i< n_grille; i++)
    {
      urs=pow(4*(rho[i])/3.*PI, 1./3.) ;
      vech[i] =0.91633*urs ; 
      if(CORRELAZIONE)
	{

	  if(urs> 1.0e-9)
	    {
	      vcorr[i]=0.09329+0.06218*log(urs);
	      if(vcorr[i]<0) vcorr[i]=0;
	    }
	  else vcorr[i]=0.0;
	}
      else  vcorr[i]=0.0;

      v[i] = -Z/x[i] - vech[i] +v[i]-vcorr[i] ;
    }
  double v0 = v[ n_grille - 1 ] ;
  for (int i=0; i< n_grille; i++)
    {
      v[i] -= v0 ;
    }
  
  for(int ns=0; ns<n_stati; ns++)
    {
      memcpy(v_non_local_old[ns],v_non_local[ns], n_grille*sizeof(double)); 
      memcpy(v_non_local[ns],v, n_grille*sizeof(double));
     }
}



void Atomo_sferico::ricalcola_v_nonloc()
{
  // *********************************************
  // ** 
  /*
  memcpy(v_old,v, n_grille*sizeof(double)); 

  for (int i=0; i< n_grille; i++)
    {
      v[i] = 0 ;
    }
  
  for(int ns=0; ns<n_stati; ns++)
    {
      memcpy(v_non_local_old[ns],v_non_local[ns], n_grille*sizeof(double)); 
      for (int i=0; i< n_grille; i++)
	{
	  v_non_local[ns][i] = -Z/x[i] - dum +v[i]-v_el[ns][i] ;
	}
      double v0 = v_non_local[ns][ n_grille - 1 ] ;
      for (int i=0; i< n_grille; i++)
	{
	  v_non_local[ns][i] -= v0 ;
	}
    }
    */
}

void Atomo_sferico::melange_new_old(double f)
{
  for (int i=0; i< n_grille; i++)
    {
      v[i] -=(1-f)*(v[i]- v_old[i] );
    }
  /*  for(int ns=0; ns<n_stati; ns++)
     {
       for (int i=0; i< n_grille; i++)
	 {
	   v_non_local[ns][i] -=(1-f)*(v_non_local[ns][i]-
				       v_non_local_old[ns][i] );
	 }
     }
     */
}

void Atomo_sferico::stampa_local(char *nf)
{
   FILE *file;
   file=fopen(nf,"w");


   for(int i=0; i< n_grille; i++)
       {
	        
        if(fabs(v[i])>0) 
    fprintf(file,"%g  %g %g\n", x[i],fabs(v[i]), vech[i]);
       }
   fclose(file);
}


void Atomo_sferico::set_grille(double a,double b)
{
  double alfa=  exp( log(b/a)/(n_grille-1) ) ;
  x[0] = a;
  for(int i=1; i< n_grille; i++)
     {
       x[i]=x[i-1]*alfa;
     }
  for(int i=0; i< n_grille; i++)
     {
       cnt[i] =0.5/x[i]/x[i];  
     }
}

void Atomo_sferico::set_stati(int *Np, int *Lp)
{
  for(int i=0; i< n_stati; i++)
    {
      N[i] = Np[i];
      L[i] = Lp[i];
    }

#ifdef SCAMBIONONLOCALE
  alloca_nonloc();
#endif
}

void Atomo_sferico::set_occ( double *occp )
{
  for(int i=0; i< n_stati ; i++)
    occ[i] = occp[i];
}

void Atomo_sferico::set_parametres(double Zp, int n_grillep, int n_statip)
{
  Z=Zp;
  libera();
  n_grille=n_grillep;
  n_stati = n_statip;
  allocazione();
  int n=1,l=0,ns;
  for(ns=0; ns < n_stati; ns++)
    {
      N[ns] = n;
      L[ns] = l;
      if(l<(n-1)) { l++;}
      else         { n++; l=0; }
    }
}

Atomo_sferico::Atomo_sferico()
{
  n_grille=0;
  occ = x=v=v_old=NULL;
  y = NULL ;

  CORRELAZIONE=0;
  n_stati=0;

  Kk=0; Kkx=0;

}


Atomo_sferico::~Atomo_sferico()
{
 libera();
}


void Atomo_sferico::libera()
{
  libera_nonloc();

  if(n_grille)
    {
      delete occ;
      delete x;
      delete v; 
      delete v_old; 
      delete N;
      delete L;
      delete E; delete cnt; delete rho; delete rhoint ; delete vext;
      delete rhodum; delete rhodumb;
      delete vech;
      delete vcorr;
      for(int s=n_stati-1; s>=0; s--) delete y[s];
      delete y; 
      for(int s=n_stati-1; s>=0; s--) delete ykin[s];
      delete ykin; 
      for(int s=n_stati-1; s>=0; s--) delete rho_el[s];
      delete rho_el; 
      for(int s=n_stati-1; s>=0; s--) delete v_el[s];
      delete v_el; 
      for(int s=n_stati-1; s>=0; s--) delete y_aux[s];
      delete y_aux; 
      for(int s=n_stati-1; s>=0; s--) delete v_non_local[s];
      delete v_non_local;       
      for(int s=n_stati-1; s>=0; s--) delete v_non_local_old[s];
      delete v_non_local_old;
      delete wfunc_libre;
      delete wfunc_libre_aux1;
      delete wfunc_libre_aux2;
     }
}

void Atomo_sferico::allocazione()
{
  
  x     = new double[n_grille];
  cnt   = new double[n_grille];
  vech  = new double[n_grille];
  vcorr = new double[n_grille];
  v     = new double[n_grille];
  v_old = new double[n_grille];
  rho   = new double[n_grille];
  rhodum   = new double[n_grille];
  rhodumb   = new double[n_grille];
  rhoint   = new double[n_grille];
  vext   = new double[n_grille];

  y     = new double * [n_stati];
  for(int s=0 ; s<n_stati; s++)  y[s] = new double[n_grille];  
  ykin     = new double * [n_stati];
  for(int s=0 ; s<n_stati; s++)  ykin[s] = new double[n_grille];  
  y_aux     = new double * [n_stati];
  for(int s=0 ; s<n_stati; s++)  y_aux[s] = new double[n_grille];  


  wfunc_libre= new double[n_grille+3];
  wfunc_libre_aux1= new double[n_grille+3];
  wfunc_libre_aux2= new double[n_grille+3];

  wfunc_libre_WKB_phase = wfunc_libre_aux2;
  wfunc_libre_WKB_amp   = wfunc_libre_aux1;

  L     = new int [n_stati];
  N     = new int [n_stati];
  E     = new double [n_stati];
  occ   = new double[n_stati];

  v_non_local =  new double * [n_stati];
  for(int s=0 ; s<n_stati; s++)  v_non_local[s] = new double[n_grille];  
  v_non_local_old =  new double * [n_stati];
  for(int s=0 ; s<n_stati; s++)  v_non_local_old[s] = new double[n_grille];  
  rho_el =  new double * [n_stati];
  for(int s=0 ; s<n_stati; s++)  rho_el[s] = new double[n_grille];  
  v_el =  new double * [n_stati];
  for(int s=0 ; s<n_stati; s++)  v_el[s] = new double[n_grille];  

}

#ifdef SCAMBIONONLOCALE

void  Atomo_sferico::alloca_nonloc()
{
  libera_nonloc();
  Kkx=new double ***[n_stati];
  for(int i=0; i<n_stati; i++)
    {
      Kkx[i]=(new double **[n_stati-i])-i;
      for(int j=i;j<n_stati;j++)
	{
	  int kmin,kmax;
	  kmax=L[i]+L[j]    ;
	  kmin= Abs( L[j]-L[i] );
	  //  Kkx[i][j]=(new double * [1+kmax-kmin]) -kmin  ;
	  Kkx[i][j]=(new double * [kmax+  1+kmax+1] )+kmax+1 ;
	  for(int l=-kmax-1;l<kmax+1;l++) 
	    {
	      Kkx[i][j][l]=new double [n_grille]; // i<=j,0<=l<=kmax+1
	    }
	}
    } 
  Kk=new double **[n_stati];
  for(int i=0; i<n_stati; i++)
    {
      Kk[i]=(new double *[n_stati-i])-i;
      for(int j=i;j<n_stati;j++)
	{
	  int kmin,kmax;
	  kmax=L[i]+L[j];
	  kmin=Abs(L[i]-L[j]);
	  Kk[i][j]=(new double  [kmax+1])   ;
	}
    }
}

void  Atomo_sferico::libera_nonloc()
{
  cout << " libera non loc " <<endl;
  if(n_stati==0) return;
  if(Kkx==0) return;
  //  Kkx=new double ***[nstati];
  for(int i=0; i<n_stati; i++)
    {
      for(int j=i;j<n_stati;j++)
	{
	  int kmax;
	  kmax=L[i]+L[j];
	  for(int l=-kmax-1;l<kmax+1;l++)
	    {
	      delete Kkx[i][j][l]; 
	    }
	  delete ( Kkx[i][j] -kmax-1) ;
	}
      delete (Kkx[i]+i);
    }
  delete Kkx;
  Kkx=0;
  for(int i=0; i<n_stati; i++)
    {
      for(int j=i;j<n_stati;j++)
	{
	  int kmin;
	  kmin=Abs(L[i]-L[j]);
	  delete (Kk[i][j]) ;
	}
      delete (Kk[i]+i);
    }
  delete Kk;
  Kk=0;

}
#endif



double Atomo_sferico::energiaLDA(int ricalcolav)
{
  // *************************************************************
  // **  declarations
  void CalcRhoLie(double *rho, int Nlie, int Nx, double *occ, 
		  double *x, double **psi);
  void  Poisson(double *rho,double *x, int Nx, double *G, double * rhoint,
		double *rhoext);

  // *************************************
  // ** Densita elettroni legati
  CalcRhoLie( rho, n_stati , n_grille , occ, 
	      x,y);
  
   for(int i=0;i<n_grille;i++)
    {
      vech[i] =0.91633*  pow(4*(rho[i])/3.*PI, 1./3.)      ; 
    }
   
  // ******************************************
  // ** Energia elettrostatica elettroni legati
   double vbid[n_grille];
   Poisson(rho,x,n_grille,vbid, rhoint, vext); 

   double somma = 0.0;


  // si ricalcola il potenziale
  // cioe' v, vech, rho
  if( ricalcolav  ) ricalcola_v();

  double func[n_grille];

  somma=0.0;
  double add;

  for(int is=0; is< n_stati; is++)
    {
      // ********************************************
      // si comincia con l`energia monoparticella
      add= E[is];
      // *************************************************
      // se ne estrae la parte cinetica+nucleo  sottraendo
      // il potenziale monoparticella (eccetto il nucleo)
      for (int  i=0; i< n_grille; i++)
	{
	  func[i]=(v[i] + Z/x[i] ) *y[is][i]*y[is][i];
	}
      add -= integrate(func,x,n_grille);
      somma += occ[is]*add;
    }

  for(int i=0;i<n_grille;i++)
    {
      func[i]= 4*PI*x[i]*x[i]*rho[i]*( 
				       0.5*(rhoint[i]/x[i] + vext[i])
				       - 3.*(vech[i]) /4. 
				       );
    }
  
  somma+=  integrate(func,x,n_grille);

 
  return somma; 

}



// da il numero di elettroni;
double Atomo_sferico::getnel()
{
  double sum=0;
  for(int k=0; k<get_n_stati();k++)
    sum += getocc()[k];
  return sum;
  
};


double Atomo_sferico::energiaLDApot(double *pot)
{
  double res;
  for(int ns=0; ns<n_stati; ns++)
    {
      memcpy(v_non_local[ns],pot, n_grille*sizeof(double));
    }  
  find_wave_functions();
  res=27.2*energiaLDA();
  cout << " res " << res << endl ; 
  return res; 
}

void  Atomo_sferico::consistenza(int metodo,double tol, double para)
{
  cout << " sono in cons \n";

  //******************************************************************
  //**  Calcul les fonctions d `ondes dans le potentiel(s) (non locale ?)
  //**
  find_wave_functions();
  //**
  //***************************************************************************

  // *************************************************************
  // **
  ricalcola_v();  
  // melange_new_old(0.2);
 
  cout << " sono in cons 2 \n";
    /*
  obj1d o1d;
  o1d.set_dim(n_grille);
  o1d.set_obj( this  , (void*) ( energiaLDApot ) );
  double vline[n_grille];
  */
  

  double  a,b,xmin,fa,fx,fb;
  a=0;
  double minold=0,minnew=0;
  
  for(int i=1; i<10000  ; i++)
    {
      if(metodo==METODOLDA) 
	{
		/*
	  find_wave_functions();
	  ricalcola_v();
	  for(int ix=0; ix< n_grille; ix++) 
	    {
	      vline[ix]= para*(getv()[ix]-getvold()[ix]);
	    };
	  
	  o1d.set_line(getv() ,vline); 
	  
	  
	  
	  mnbrakobj((void *) &o1d,  &a,&para,&b ,&fa,&fx,&fb,
		    (double (*)(double) ) o1d.value);
	  minnew=brentobj(&o1d, a,para,b,
			   (void *) ( o1d.value ),1.0e-2,&xmin);
	  
	  memcpy(getvold(),getv(),n_grille*sizeof(double));
	  
	  para=xmin;
		*/
	}
      else   if(metodo==METODOSOSTITUZIONE) 
	{
	  cout << " sono in cons  3\n";

	  find_wave_functions();
	  int ricalcolav=0 ;
	  minnew=energiaLDA(ricalcolav);
	  cout << minnew << endl ;
	  ricalcola_v();
	  melange_new_old(para);
	}   
      else   if(metodo==METODOSOSTITUZIONENONLOC) 
	{
	  find_wave_functions();
	  int ricalcolav=0 ;
	  minnew=energiaLDA(ricalcolav);
	  cout << minnew << endl ;
	  ricalcola_v_nonloc();
	  melange_new_old(para);
	}   
      
      for (int j=0; j< get_n_stati(); j++)
	cout <<27.2* get_energia(j) << " OK " ;
      cout << endl;
      
      if(fabs((minnew-minold)/minnew/para)<tol) break;
      
      minold=minnew;
    }
};





//********************************************************************
//** Calcola la densita elettronica degli stati legati 
//** La funziona ritorna nell array *rho, per gli Nx punti del magliaggio
//** la densita degli elettroni legati
//** 
//**  << double  *rho ; densita dimensione Nx
//**  >> int     Nlie; numero di stati legati
//**  >> int     Nx  ; dimensione del magliaggio
//**  >> double  *occ  ; Occupazione dei Livelli (dimensione Nlie)
//**  >> double  *x  ; Magliaggio
//**  >> double **psi;  L integrale di psi**2 da 0 a Inf e uguale a uno

void CalcRhoLie(double *rho, int Nlie, int Nx, double *occ, 
		double *x, double **psi)
{
  double dum;
  for(int i=0;i<Nx;i++)
    {
      rho[i]=0.0;
      dum = 1./x[i]/x[i]/4./PI;
      for(int j=0;j<Nlie;j++)
         {
            rho[i] += occ[j]*psi[j][i]*psi[j][i]*dum ;
	 }
    }
}

void CalcRhoLieSingle(double *rho, int Nlie, int Nx, 
		double *x, double **psi)
{
  double dum;
  for(int i=0;i<Nx;i++)
    {
      rho[i]=0.0;
      dum = 1./x[i]/x[i]/4./PI;
      rho[i] += psi[Nlie][i]*psi[Nlie][i]*dum ;
    }
}
//********************************************************************
//** Calcola la densita di elettroni liberi *rho 
//**    sugli Nx punti del magliaggio
//**
//**  << double  *rho; densita dimensione Nx
//**  >> int     Nx  ; dimensione del magliaggio
//**  >> double  *x  ; Magliaggio
//**  >> double  *v  ; potenziale
//**  >> double  *V  ; Potenziale Locale 
//**  >> double   T  ; Temperatura 
//**  >> double   mu ;  Potenziale chimico
//**  >> double   xc ;  potenziale di scambio al confine della cella
//**                    Si ha densita elettronica anche per mu=V 
//**  >> double  E ; Energia limite del continuo (=0)
 
void CalcRhoLibre(double *rho,int Nx,double *, double *v,
	     double T,double mu, double xc, double E)
{

         double Dlibre(  double  V, double mu, double T);

//------------------ Calcul de la densite electronique libre--------------------
  
  int i;
  for(i=0;i<Nx;i++)
    {
      rho[i]  = Dlibre(v[i]+xc-E,  mu,  T);
    }
}


// **************************************************************
// **  Questa funzione fa appello alla routine de Michele Goano
// **  ferminc che calcola gli integrali incompleti di fermi dirac
// **   La routine di Miche Goano si trova nel file femidiracintegrals.f
// **
// **  La funzione ritorna la densita di elettroni liberi
// **  che si trovano al di sopra di V, per un potenziale chimico mu
// **  ed una temperatura T, il tutto in unita atomiche
// ** 
// **  V potenziale locale (negativo=attrattivo)
// **  mu potenziale chimico
// **  T temperatura


double Dlibre(  double  V, double mu, double T)
{
  double a1,a2,a3,a4, a5;
  int ierr;
  // **************************************************
  // **  Per il significato di questi parametri
  // **  guardare il sorgente di michele guano
  // **  (a4 est la precisione)

  a1=0.5; a2=(mu-V)/T; a3=(-V )/T; a4=1.0e-6;

  if(a3<0.0) a3=0.0;
  
  if( a2< -200.) 
    {
      a5=0.0;
    }
  else
    if( a2 > 500)
             {
	       if (a3>a2)
		  {
		    a5=0.0;
		  }
	       else	
		 {
		   a5=2*( (a2*a2+PI*PI/8.)/sqrt(a2)-a3*sqrt(a3))/3.;
		 }
	      }
    else
      {
        // *************************************************
	// ** Rispetto alla sua definizione convenzionale
	// ** gli integrali di fermi sono rinormalizzati con
	// ** un fattore 1./GAMMA(1+A1)
	ferinc_(&a1,&a2,&a3,&a4,&a5,&ierr);
	//****************************************************
	//** SI MOLTIPLICA QUINDI PER GAMMA(1+A1)
	a5 *=sqrt(PI)/2. ;
      }  

  // *************************************************************
  // **  A questo punto a5 est
  // **  Integrale[ 1/(1+exp(x-a2), {x,a3,Inf}] 
  return  a5*sqrt(2*T)*T/(PI*PI);
  // *******************************************************
  // ** 2*V/(2*PI)**3 Integrale[1*dk**3,K**2 /2 < Ef ]
  // **
}



// *******************************************************
// ** 
void  Poisson(double *rho,double *x, int Nx, double *V, double *rhoint,
  double *Vrhoext  )
{

  rhoint[0]=0;

  double *func;

  func=new double [Nx];

  for(int i=0;i< (Nx) ;i+=1)
    {
      func[i] = 4*PI*rho[i]*x[i]*x[i] ;
    }

  integrate(func, rhoint,x,Nx);

  for(int i=0;i< (Nx) ;i+=1)
    {
      func[i] = 4*PI*rho[i]*x[i] ;
    }

  integrate(func,Vrhoext ,x,Nx);

  for(int i=0;i< Nx;i++)
    {
      Vrhoext[i] = Vrhoext[Nx-1] - Vrhoext[i] ;
    }
  /* 
  for(int i=0;i< (Nx) ;i+=1)
    {
      V[i]=rhoint[i]/x[i]+Vrhoext[i];
    }
    */
  
    for(int i=0;i< (Nx) ;i+=1)
    {
      func[i] =  rhoint[i]/x[i]/x[i];
    }
    
    integrate(func,V  ,x,Nx);
    
    /* 
     TOGLIERE QUESTO
     for(int i=0;i<Nx;i++) 
     {
     V[i]=-V[i]+V[Nx-1];
     }
     */
    
   
    double fixed=rhoint[Nx-1]/x[Nx-1]+Vrhoext[Nx-1];
    for(int i=0;i<Nx;i++) 
      {
	V[i]=fixed+V[Nx-1] -V[i];
      }
    /*
    for(int i=0;i<Nx;i++) 
      {
	V[i]=-V[i];
      }
      */

  delete func;

}


#ifdef SCAMBIONONLOCALE
void Atomo_sferico::calcola_slater()
{
 
  int i,j,kmin,kmax,l;
  double func[n_grille],funcinv[n_grille];
  
  for( i=0; i<n_stati; i++)
    {
      for( j=i;j<n_stati;j++)
	{
	  kmax=L[i]+L[j];
	  kmin=0;
          for(int ex=0;ex<n_grille;ex++)
	    {
	      func[ex]= y[i][ex]*y[j][ex];
	      funcinv[ex]=y[i][ex]*y[j][ex]/x[ex];
	    }
	  for( l=0;l<kmax+1;l++)
	    {
	      integrate(func,Kkx[i][j][l],x,n_grille);
	      integrate(funcinv,Kkx[i][j][-l-1],x,n_grille);
	      for(int ex=0;ex<n_grille;ex++)
		{
		  func[ex]    *= x[ex];
		  funcinv[ex] /= x[ex];
		}
	    }
	}
    }

}



double  Atomo_sferico::energiaSlater()
{
  int i;
  double somma = 0.0;

  double func[n_grille];

  somma=0.0;
  double add;
  // **  declarations
  void CalcRhoLie(double *rho, int Nlie, int Nx, double *occ, 
		  double *x, double **psi);
  void  Poisson(double *rho,double *x, int Nx, double *G, double * rhoint,
		double *rhoext);

  // *************************************
  // ** Densita elettroni legati
  CalcRhoLie( rho, n_stati , n_grille , occ, 
	      x,y);
  
  // ******************************************
  // ** Energia elettrostatica elettroni legati
  double vbid[n_grille];
  Poisson(rho,x,n_grille,vbid, rhoint, vext);
  //calcolakin();

  for(int is=0; is< n_stati; is++)
    {
      // ********************************************
      // si comincia con l`energia monoparticella
      add= E[is];
      // *************************************************
      // se ne estrae la parte cinetica+nucleo  sottraendo
      // il potenziale monoparticella (eccetto il nucleo)
      for (  i=0; i< n_grille; i++)
	{
	  func[i]=(v[i] + Z/x[i] ) *y[is][i]*y[is][i];
	}
      add -= integrate(func,x,n_grille);



      // prova ykin
      // for (  i=0; i< n_grille; i++)
      //	{
      // func[i]= (ykin[is][i]-Z/x[i]*y[is][i] )*y[is][i];
      //	}      
      //  add = integrate(func,x,n_grille);
      

      somma += occ[is]*add;
    }

   cout << " somma in energia slater est " << somma<< endl;
  // ** ora bisogna sommare i termini diretti e di scambio 
  int kmin,kmax;
  double fattore;
  double w;
  for( i=0; i<n_stati; i++)
    {
      fattore=0.5;
      for(int  j=i;j<n_stati;j++)
	{
	  // **********************************
	  // termine diretto

	  for(int ex=0; ex<n_grille; ex++)
	    {
	      func[ex]=y[j][ex]*y[j][ex]*
		(Kkx[i][i][0][ex]/x[ex]+ 
		 (Kkx[i][i][-1][n_grille-1]-
		  Kkx[i][i][-1][ex]) ) ;
	    }
	  somma+=occ[i]*occ[j]*fattore*integrate(func,x,n_grille);

	  // *** termini di scambio 
	  double puisx[n_grille];
	  int l;
	  for(int ex=0; ex<n_grille; ex++) puisx[ex] =  1.0;
	  kmax=L[i]+L[j];
	  kmin=Abs( L[i]-L[j] );
	  // kmin=0;
	  for( l=1; l<=kmin; l++)
	    {
	      for(int ex=0; ex<n_grille; ex++)  puisx[ex]*=x[ex];
	    }
	  for( l=kmin; l<=kmax;l++)
	    {
	      for(int ex=0; ex<n_grille; ex++)
		{
		  func[ex]=y[i][ex]*y[j][ex]*
		    (Kkx[i][j][l][ex]/puisx[ex]/x[ex]+ 
		     (Kkx[i][j][-l-1][n_grille-1]-
		      Kkx[i][j][-l-1][ex])*puisx[ex] ) ;
		}
	      w=trej( L[j],L[i],l, 0,0,0 );


	      somma -= 0.5*occ[i]*occ[j]*w*w*fattore*
		integrate(func,x,n_grille );
	      for(int ex=0; ex<n_grille; ex++) puisx[ex] *=  x[ex];
	    }
	  fattore=1;
	}
    }
  return somma; 
}

void Atomo_sferico::serializza(fichier &f)
{


  f.serialcomment("HFS", LINEASALTO);

  f.serialcomment("nstati");
  f.serialint(&n_stati, LINEASALTO);

  cout << n_stati << endl;

  f.serialcomment("n_grille");
  f.serialint(&n_grille, LINEASALTO);

  if(f.serial==LEGGI) allocazione();

  f.serialcomment("Z");
  f.serialdouble(&Z, LINEASALTO);

  f.serialcomment("occNLE", LINEASALTO);
  for(int i=0; i<n_stati; i++)
    {
      f.serialdouble(&occ[i]);
      f.serialint(&N[i]);
      f.serialint(&L[i]);
      f.serialdouble(&E[i], LINEASALTO);
     }

  f.serialcomment("xV", LINEASALTO);
  for(int i=0; i<n_grille; i++)
    {
      f.serialdouble(&x[i]);
      f.serialdouble(&v[i], LINEASALTO);
    }

  f.serialcomment("FUNZIONIDONDA", LINEASALTO);
  for(int i=0; i<n_grille; i++)
    {
    	if(f.getversion()>1) f.serialdouble(&x[i]);
      for(int j=0; j<n_stati; j++)
			{
	  		f.serialdouble(&y[j][i]);
			}
      f.saltolinea();
    }
};



#endif


