/***************************************************************************
                          da0ama.cc  -  description
                             -------------------
    begin                : Mon Jan 3 2000
    copyright            : (C) 2000 by Alessandro MIRONE
    email                : mirone@lure.u-psud.fr
 ***************************************************************************/

#include<stdio.h>
#include<iostream.h>
#include<string.h>
#include<math.h>
#include<complex.h>
#include<nMatrix/nMatrix.h>
#include <nMatrix/nLapack.h>
#include"../atomosferico/fichier.h"
#include"../atomosferico/hfs.h"
#include"../atomosferico/integrate.h"
#include"../atomosferico/wigner.h"

#include<Sparsa/Sparsa.h>

#include"../libasfhfs/asfhfs.h"

#define DEBUG

#define Abs(a) ( ((a)>0)?  (a):(-(a)) )
#define Min(a,b) ( ((a)<(b))?  (a):(b) )
#define Max(a,b) ( ((a)>(b))?  (a):(b) 

char  opzioni[2000];


void  calcolodegliR(double ****Kkx, double ** y, double *x,int is,int it,
		    int iu,int iv, int n_grille,int kmin, int kmax, double *R,
		    uMatrix<double> &RidS, uMatrix<double> &RidD );



int main(int argc, char **argv)
{


  char *usage = " \n *** utilisation ***:\n \n %s fichier_input   parametrihfs\n\n ";
  
  if(argc<2)
    {
      printf(usage, argv[0]);
      exit(0);
    }
 
  asfhfs atomo;

  atomo.lettura(argv[1]);

  int pippo=atomo.conta_determinanti() ;
  printf( " ci sono %d determinanti \n",pippo);

  if(pippo==0)
    { 
      printf( " non esistono stati soddisfacenti le specifiche date\n");
      exit(0);
    }
  atomo.crea_determinanti() ;

  atomo.inizializza_sottospazi();

  printf( " inizializzati sottospazi\n");
  printf( " ci sono   %d sottospazi\n", atomo.nsottospazi);

  printf( " ci sono %d  sottospazi\n", atomo.nsottospazi );
  for(int i=0; i< 0*atomo.nsottospazi; i++)
    {
      printf( "CIAO CIAO CIAO  Sottospazioi%d \n" ,i );
      atomo.sottospazi[i].stampa();
    }
  
  if(argc==2)
    {
      printf( " ho eseguito tutto quel che dovevo fare \n"
	      " ho inizializzato i sottospazi\n");
      
    }
  
  
  
  atomo.inizializza_hfs(argv[2]);
  
  
  atomo.inizializzaautostato();
  
  atomo.hfs.calcola_slater();
  
  printf(" Slater calcolati \n");
    
  {
    uMatrix<double> RidS,RidD;
    
    RidS.resize(atomo.nstati);
    RidD.resize(atomo.nstati,atomo.nstati);
    RidS=1.0;
    RidD=1.0;
    
    while(1) {
      
      int is, it;
      
      printf(" introduci is , it, from 0  up to %d-1 \n", atomo.nstati);
      scanf("%d %d", &is, &it);
      if(it<0) break;
      
      int kmin=0;
      int kmax=2*Min(atomo.loforb(is),atomo.loforb(it));
      
      double F[kmax+1];
      memset(F,0,(kmax+1)*sizeof(double)) ;
      calcolodegliR( atomo.hfs.Kkx , atomo.hfs.y,atomo.hfs.x,  is , is, it, it , atomo.hfs.n_grille, kmin,
		     kmax, F,RidS,RidD );
      
      cout << " F SONO \n" ;
      for(int i=0; i< kmax+1; i++) 
	{
	  cout << F[i]<< endl;
	}
      
      
      kmin=Abs(atomo.loforb(is)-atomo.loforb(it));
      kmax=atomo.loforb(is)+atomo.loforb(it);	  
      double G[kmax+1];
      memset(G,0,(kmax+1)*sizeof(double)) ;
      
      calcolodegliR( atomo.hfs.Kkx , atomo.hfs.y,atomo.hfs.x, is , it, is, it , atomo.hfs.n_grille, kmin, kmax, G ,RidS,RidD);
      
      cout << " G SONO \n" ;
      for(int i=0; i< kmax+1; i++) 
	{
	  cout << G[i]<< endl;
	}
      
      
    }
    
  }


  void calcolaelementiSONew( double **y, double *x, int n_grille, int n_stati, double /* Z */,double *E,	uMatrix<double> &SO);

 
  // ** Spin orbita
  uMatrix<double> SO( atomo.hfs.n_stati,   atomo.hfs.n_stati );
  {
    
    uMatrix<double>  occmixed(atomo.loforb.rows());
    atomo.calcolaoccmixed(occmixed);
    
    double Esfer[ atomo.hfs.n_stati *  atomo.hfs.n_grille];
    atomo.hfs.calcolaEsfericomixedNew(occmixed.address(), Esfer);
    printf( " OK  edNew \n");

    calcolaelementiSONew( atomo.hfs.y,  atomo.hfs.x,  atomo.hfs. n_grille, 
			  atomo.hfs.n_stati,  atomo.hfs.Z,  Esfer,
			  SO); 
    printf( " OK  SONew \n");
  }
  cout << SO << endl ; 
    
}
		   
		   
		   
