/***************************************************************************/
/* Written 1994++ by Peter Boesecke                                        */
/* Copyright (C) 2011 European Synchrotron Radiation Facility              */
/*                       Grenoble, France                                  */
/*                                                                         */
/*    Principal authors: Peter Boesecke  (boesecke@esrf.eu)                */
/*                                                                         */
/*    This program is free software: you can redistribute it and/or modify */
/*    it under the terms of the GNU General Public License as published by */
/*    the Free Software Foundation, either version 3 of the License, or    */
/*    (at your option) any later version.                                  */
/*                                                                         */
/*    This program is distributed in the hope that it will be useful,      */
/*    but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*    GNU General Public License for more details.                         */
/*                                                                         */
/*    You should have received a copy of the GNU General Public License    */
/*    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/***************************************************************************/
/*+++***********************************************************************
NAME

    schulz.h

SYNOPSIS

    #include "schulz.h"

DESCRIPTION
    Header of the module "schulz.c". 
***********************************************************************---*/
#ifndef _SCHULZ_
# define _SCHULZ_

/***************************************************************************
* General Definitions                                                      *
***************************************************************************/

#ifndef PRIVATE
#  define PRIVATE static // used to declare variables of private type 
#endif

#ifndef PUBLIC
#  define PUBLIC         // used to declare variables of public type 
#endif

/****************************************************************************
*  Include                                                                  *
****************************************************************************/

# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include <ctype.h>
# include <limits.h>
# include <errno.h>
# include <stdio.h>
# include <fcntl.h>
# include <math.h>
# include <float.h>

# include "gamma.h"

/***************************************************************************
* Functions                                                                *
***************************************************************************/

PUBLIC extern double 
    // Schulz distribution
       schulz( double R, double Z, double X ), 
    // sqrt(<R^2>-<R>^2)
       sigma_schulz( double R, double Z ), 
    // <R^2>
       R2_schulz( double R, double Z ),
    // <R^3>
       R3_schulz( double R, double Z ),
    // Average form factor of spheres following a Schulz distribution
       f2_schulz( double Z, double qR );


#endif
