/***************************************************************************/
/* Written 1994++ by Peter Boesecke                                        */
/* Copyright (C) 2011 European Synchrotron Radiation Facility              */
/*                       Grenoble, France                                  */
/*                                                                         */
/*    Principal authors: Peter Boesecke  (boesecke@esrf.eu)                */
/*                                                                         */
/*    This program is free software: you can redistribute it and/or modify */
/*    it under the terms of the GNU General Public License as published by */
/*    the Free Software Foundation, either version 3 of the License, or    */
/*    (at your option) any later version.                                  */
/*                                                                         */
/*    This program is distributed in the hope that it will be useful,      */
/*    but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*    GNU General Public License for more details.                         */
/*                                                                         */
/*    You should have received a copy of the GNU General Public License    */
/*    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/***************************************************************************/
/*+++***********************************************************************
NAME
   SaxsParameter --- Replaces keys in strings with values
 
SYNOPSIS
 
   # include SaxsReplacekey.h
 
DESCRIPTION
    Header of the module "SaxsParameter.c"
 
HISTORY
2003-08-11 V1.0 Peter Boesecke
***************************************************************************/

#ifndef _SAXSPAR_ 
#  define _SAXSPAR_

/***************************************************************************
* General Definitions                                                      *
***************************************************************************/
#  ifndef PRIVATE
#    define PRIVATE   static
#    define PUBLIC
#  endif

# include "SaxsReplacekey.h"
# include "SaxsOption.h"

PUBLIC extern const char
   // return version
 * option_parameter_version ( void );

extern void
   option_define             ( int ptyp, const char *option, const char *defval,
                               CmdBlk *pcb );
 
extern void
   *option_parameter_update  ( const char * Value, int I, const char *option,
                               CmdBlk *pcb, int * pstatus ),
 
   *option_parameter_search  ( const char *option,
                               CmdBlk *pcb, int * pstatus );

extern IO_long
   *option_flag_update       ( long Value, int I, const char *option,
                               CmdBlk *pcb, int * pstatus );
extern IO_line
   option_line               ( const char *option,
                               CmdBlk *pcb, ImgBlk ib[], long num[],
                               long blkno, int * pstatus );
 
extern IO_float
   option_float              ( const char *option,
                               CmdBlk *pcb, ImgBlk ib[], long num[],
                               long blkno, int * pstatus );
extern IO_long
   option_long               ( const char *option,
                               CmdBlk *pcb, ImgBlk ib[], long num[],
                               long blkno, int * pstatus );
extern IO_long
   option_flag               ( const char *option,
                               CmdBlk *pcb, int * pstatus );
 
extern int
    option_type              ( const char *option, CmdBlk *pcb );
 
extern const char
   *option_type2string       ( int ptyp );                                                                                                    

#endif
/************************************************************************---*/

