
/* 
  This routine reads a file and de/compresses using the cmpr routines 
  cmpr_deflatefile and cmpr_inflatefile.
*/

/****************************************************************************
*  Include                                                                  *
****************************************************************************/
# include <stdio.h>
# include <stdlib.h>
# include <stdarg.h>
# include <string.h>
# include <ctype.h>
# include <limits.h>
# include <errno.h>
# include <fcntl.h>
# include <math.h>
# include <float.h>

# include "cmpr.h"
# include "strlib.h"
# include "filename.h"
# include "numio.h"

# define BUFLEN PATH_MAX

# define Usage "[debug=<debug>] [-v:verbose|--v:nonverbose] [cmpr=<1:uncmpr,2:gzip(default),3:Z>] <input> [<output>]"
int main (int argc, char *argv[]) 
{ int debug=0; 
  int dcmpr=0, cmprin=0, cmpr=GzipCompression;
  int verbose=1;
  char *nul = (char *) NULL;
  char **pargv;
  char *ps;
  int cnt=0, fcnt=0;

  char errbuf[BUFLEN];
  char output[BUFLEN];

  char *input="input.dat";

  FILE *inp=NULL, *outp=NULL;

  int status=-1;

  pargv=&argv[1];
  while ( *pargv!=nul ) {

    if ( strncmp( *pargv,"debug=", 6 ) == 0 ) {
      // set debug level
      ps=*pargv+6;
      debug = (int) num_str2double ( ps, NULL, NULL);
      if (debug>1) cmpr_debug ( 1 );
    } else if ( strncmp( *pargv,"cmpr=", 5 ) == 0 ) {
      // set compression 
      ps=*pargv+5;
      cmpr = (int) num_str2double ( ps, NULL, NULL);
    } else if ( strncmp( *pargv,"-v", 2 ) == 0 ) {
      // set verbose 
      ps=*pargv+2;
      verbose=1;
    } else if ( strncmp( *pargv,"--v", 3 ) == 0 ) {
      // unset verbose 
      ps=*pargv+3;
      verbose=0;
    } else {

      input=*pargv;

      cmprin = cmpr_checkfiletype(input);

      if (cmpr>1) {
        if (cmprin == 1) {
          dcmpr = cmpr;  // compress
        } else {
          dcmpr = 0; // already compressed, do nothing
        }
      } else {
        cmpr = 1;
        if (cmprin <= 1) {
          dcmpr = 0; // already uncompressed, do nothing
        } else {
          dcmpr = -cmprin; // uncompress
        }
      }

      if (debug>0)
        printf("debug = %d, dcmpr = %d (-3:unZ,-2:gunzip,2:gzip,3:Z)\n",debug,dcmpr);

      if ((fabs(dcmpr)>UnCompressed)&&(fabs(dcmpr)<EndDCompression)) {
        cmpr_filename(output, BUFLEN, input, cmpr);

        /* Open input file */
        if (debug>0) printf("fopen(>>%s<<)\n",input);
        if ( !( inp=fopen(input,"rb") ) ) {
          sprintf(errbuf,"fopen(%s,\"rb\")",input);
          perror(errbuf); goto main_error;
        }

        /* Open output file */
        if (debug>0) printf("fopen(>>%s<<)\n",output);
        if ( !( outp=fopen(output,"wb") ) ) {
          sprintf(errbuf,"fopen(%s,\"wb\")",output);
          perror(errbuf); goto main_error;
        }

        /* Copy inp to outp */
        if (debug>0) printf("Copy >>%s<< to >>%s<<\n",input,output);
        if (verbose) printf("  %s -> %s\n",input,output);
        if(dcmpr>0) {
          if (cmpr_deflatefile ( outp, inp,
              dcmpr, NULL, NULL )) goto main_error;
        } else {
          if (cmpr_inflatefile ( outp, inp,
              -dcmpr, NULL, NULL )) goto main_error;
        }
  
        /* Close outp */
        if (debug>0) printf("fclose(outp)\n");
        fclose(outp);

        /* Close inp */
        if (debug>0) printf("fclose(inp)\n");
        fclose(inp);

        fcnt++;

      }

      cnt++;

    } // filename input argument

    if (*pargv) pargv++;

  } // while

  if (cnt<1) {
    printf("%s %s\n",argv[0],Usage);
    goto main_error1;
  } else {
    if (verbose)
      printf("\n  %d file%s %scompressed\n\n",
        fcnt,fcnt!=1?"s":"",(cmpr==1)?"un":"");
  }

  status = 0;

  return( status );

main_error: 
  printf("Error exit\n");
  if (outp) fclose(outp);
  if (inp) fclose(inp);
main_error1: 
  return(status);
  
} /* main */
