#       include <errno.h>
#       include <stdio.h>
#       include <fcntl.h>
#       include "edfio.h"
#       include "edfio.c"

/*+++------------------------------------------------------------------------
main
---------------------------------------------------------------------------*/
# define Usage "<maxlen> <string> [<value>]"
   
main (int argc, char *argv[])
{ char *string, *value;
  char *out;
  const char *nxt;
  size_t maxlen, buflen;
  char *buffer;
  char *bufout;
  
  if (argc<=2) { printf("%s %s\n",argv[0],Usage); return(-1); }

  maxlen=128;
  if (argc>1) sscanf(argv[1],"%u",&maxlen);

  string="string";
  if (argc>2) string = argv[2];

  printf("maxlen = %u\n",maxlen);
  printf("string = >%s<\n",string);

  buflen = sizeof(char)*(maxlen+1);
  buffer = (char *) malloc( buflen );
  if (!buffer) { 
    printf("Allocation error of %s bytes\n",buflen);
    return(-1);
  }
  value = str2val( buffer, buflen, string,&nxt);
  if (argc>3) value = argv[3];

  if (argc>3) printf(" value = >%s<\n",value);

  bufout = (char *) malloc( buflen );
  if (!bufout) {
    printf("Allocation error of %s bytes\n",buflen);
    return(-1);
  }
  out = val2str( bufout, buflen, value );

  if (argc<=3) printf(">%s< = str2val(>%s<), nxt = >%s<\n",value,string,nxt);
  printf(">%s< = val2str(>%s<)\n",out,value);

  free(buffer); 
  free(bufout); 

} /* contest */

