#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef WIN32
# include <unistd.h>
#endif

#include <ctype.h>
#include <limits.h>

#include "filename.h"
#include "numio.h"

# define Usage "<maxlen> <pattern> [<debug>]"

main (int argc, char *argv[])
{ char *pattern;
  char *out;
  const char *nxt;
  size_t maxlen, buflen;
  char *fname, *fname_pattern, *fname_full, *Number, *number;
  int  debug=0;
  int errval;

  long first, last, inc;
  long tmp;

  if (argc<=1) { printf("%s %s\n",argv[0],Usage); return(-1); }

  maxlen=256;
  if (argc>1) sscanf(argv[1],"%u",&maxlen);

  pattern="pat%%te%%rn.pat";
  if (argc>2) pattern = argv[2];

  if (argc>3) if (sscanf(argv[2],"%d",debug)!=1) debug=0;
  numio_debug(debug);

  printf("maxlen = %lu\n",maxlen);
  printf("pattern = >%s<\n",pattern);

  buflen = sizeof(char)*(maxlen+1);
  fname = (char *) malloc( buflen );
  if (!fname) {
    printf("Allocation error of %lu bytes\n",buflen);
    return(-1);
  }
  fname_pattern = (char *) malloc( buflen );
  if (!fname_pattern) {
    printf("Allocation error of %lu bytes\n",buflen);
    return(-1);
  }
  fname_full = (char *) malloc( buflen );
  if (!fname_full) {
    printf("Allocation error of %lu bytes\n",buflen);
    return(-1);
  }
  Number = (char *) malloc( buflen );
  if (!Number) {
    printf("Allocation error of %lu bytes\n",buflen);
    return(-1);
  }

  /* get full file name */
  filename_parameter (fname_pattern,buflen,pattern,0);
  printf("fname_pattern=>%s<\n",fname_pattern);

  first=0;
  tmp = num_str2long(filename_parameter(Number,buflen,pattern,1),NULL,&errval );
  if (!errval) first = tmp;
  printf("first=%ld\n",first);

  last=first;
  tmp = num_str2long(filename_parameter(Number,buflen,pattern,2),NULL,&errval );
  if (!errval) last = tmp;
  printf("last=%ld\n",last);

  inc=1;
  tmp = num_str2long(filename_parameter(Number,buflen,pattern,3),NULL,&errval );
  if (!errval) inc = tmp;
  printf("inc=%ld\n",inc);

  filename_pattern (fname,buflen,fname_pattern,first);
  filename_full(fname_full,buflen,fname);
  printf("first file=%s\n",fname);
  printf("first file (full)=%s\n",fname_full);

  filename_pattern (fname,buflen,fname_pattern,last);
  filename_full(fname_full,buflen,fname);
  printf("last file=%s\n",fname);
  printf("last file (full)=%s\n",fname_full);

  free ( Number );
  free ( fname_full );
  free ( fname_pattern );
  free ( fname );

}
