#       include <errno.h>
#       include <stdio.h>
#       include <fcntl.h>

#       include "numio.h"

/*
 <  <= >  >= == !=
 1  2  3  4  5  6
 PROBLEM
 dpexpression
   fuehrt immer zu einem Fehler, wenn terminierendes Zeichen unbekannt, z.B. "=", ist -> aendern!!!!
*/

int   dpcomparation( const char **ps, int level, int *perrval)
{ int mode=0, value=0;
  double expr1, expr2;

  *perrval = NumScanError;

  if (level<1) return(value);

  *perrval = NumSuccess;

  expr1=num_str2double(*ps, ps, perrval);
  printf("expr1=%g, >>%s<<, errval=%d\n",expr1,*ps,*perrval);
  if (*perrval!=NumSuccess) return(value);

  switch (**ps) {
    case '<': (*ps)++;
      switch (**ps) {
        case '=': (*ps)++; 
                  mode=2; // "<=" LE
                  break;
        default: mode=1; // "<" LT
      } break;
      
    case '>': (*ps)++;
      switch (**ps) {
        case '=': (*ps)++; 
                  mode=4; // ">=" GE
                  break;
        default: mode=3; // ">" GT
      } break;

    case '=': (*ps)++;
      switch (**ps) {
        case '=': (*ps)++; 
                  mode=5; // "==" EQ
                  break;
        default: *perrval = NumScanError; 
      } break;
    case '!': (*ps)++;
      switch (**ps) {
        case '=': (*ps)++; 
                  mode=6; // "==" NE 
                  break;
        default: *perrval = NumScanError; 
      } break;
    default: *perrval = NumScanError;
  }
  printf("mode=%d, >>%s<<, errval=%d\n",mode,*ps,*perrval);
  if (*perrval!=NumSuccess) return(value);

  expr2=num_str2double(*ps, ps, perrval);
  printf("expr2=%g, >>%s<<, errval=%d\n",expr1,*ps,*perrval);
  if (*perrval!=NumSuccess) return(value);

  // <  <= >  >= == !=
  // 1  2  3  4  5  6
  switch (mode) {
    case 1: if (expr1<expr2)  value=1; break;
    case 2: if (expr1<=expr2) value=1; break;
    case 3: if (expr1>expr2)  value=1; break;
    case 4: if (expr1>=expr2) value=1; break;
    case 5: if (expr1==expr2) value=1; break;
    case 6: if (expr1!=expr2) value=1; break;
    default: *perrval = NumScanError;
  }

  return( value );

} // dpcomparation
   

/*+++------------------------------------------------------------------------
main
---------------------------------------------------------------------------*/
# define Usage "<string>"

main (int argc, char *argv[])
{ 
  int value;
  int errval, level=1;
  const char *ps, *string;

  numio_debug ( 3 );
  
  if (argc<=1) { printf("%s %s\n",argv[0],Usage); return(-1); }

  if (argc>1) string = argv[1];

  printf("string = >%s<\n", string);
  printf("strlen(%s) = %d\n",string,strlen(string));

  ps=string;
  value = dpcomparation( &ps, level, &errval);

  printf("errval = %d\n",errval);
  printf("value = %d\n",value);

} /* condition */

