/***************************************************************************/
/* Written 1994++ by Peter Boesecke                                        */
/* Copyright (C) 2011 European Synchrotron Radiation Facility              */
/*                       Grenoble, France                                  */
/*                                                                         */
/*    Principal authors: Peter Boesecke  (boesecke@esrf.eu)                */
/*                                                                         */
/*    This program is free software: you can redistribute it and/or modify */
/*    it under the terms of the GNU General Public License as published by */
/*    the Free Software Foundation, either version 3 of the License, or    */
/*    (at your option) any later version.                                  */
/*                                                                         */
/*    This program is distributed in the hope that it will be useful,      */
/*    but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*    GNU General Public License for more details.                         */
/*                                                                         */
/*    You should have received a copy of the GNU General Public License    */
/*    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/***************************************************************************/
/******************************************************************************/
/* edftiff.h                                                                  */
/******************************************************************************/

#ifndef _EDF_TIFF

// TIFF output routine (bps: 8|16|32, compression: no=1, dpcm: points per cm)
extern void
 * float2unsigned (float * src, float dummy, float ddummy,
                   long xdim, long ydim, int autorange, 
                   int automin, float vmin, int automax, float vmax,
                   short bps, char comment[], int * pstatus);

extern int
   write_tiff ( const char * fname, long xdim, long ydim, short bps,
                short compression, const void * data, int orientation,
                const char * description, float xdpcm, float ydpcm,
                int * pstatus );

// TIFF error status
# include "SaxsError.h"

# define TIFF_STATUS_ERROR         Failed 
# define TIFF_STATUS_SUCCESS       Success
# define TIFF_STATUS_OPENERROR     FileOpeningError
# define TIFF_STATUS_READERROR     FileReadError
# define TIFF_STATUS_WRITEERROR    FileWriteError
# define TIFF_STATUS_SIZEMISMATCH  SizeMismatch

# define _EDF_TIFF
#endif

