/***************************************************************************/
/* Written 1994++ by Peter Boesecke                                        */
/* Copyright (C) 2011 European Synchrotron Radiation Facility              */
/*                       Grenoble, France                                  */
/*                                                                         */
/*    Principal authors: Peter Boesecke  (boesecke@esrf.eu)                */
/*                                                                         */
/*    This program is free software: you can redistribute it and/or modify */
/*    it under the terms of the GNU General Public License as published by */
/*    the Free Software Foundation, either version 3 of the License, or    */
/*    (at your option) any later version.                                  */
/*                                                                         */
/*    This program is distributed in the hope that it will be useful,      */
/*    but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*    GNU General Public License for more details.                         */
/*                                                                         */
/*    You should have received a copy of the GNU General Public License    */
/*    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/***************************************************************************/
/****************************************************************************
* SaxsRoutine.h                                                             *
****************************************************************************/

#ifndef _SAXS_ROUTINE_
# define SR_Version  "SaxsRoutine : V1.49 Peter Boesecke 2011-07-24"

# include "SaxsImage.h"

  extern void
     ArgvBlocks            ( CmdBlk * pcb, ImgBlk ib[], ImgHeadBlk ihb[],
                             void (*InitFunction) 
                                 (CmdBlk *,long [],ImgHeadBlk [],int * ),
                             const char *Extension, 
                             int block_1st, int block_lst, int * pstatus),
     ArgvFilenames         ( CmdBlk * pcb, ImgBlk ib[], ImgHeadBlk ihb[],
                             int block_1st, int block_lst, int * pstatus),
     GetLinearRange        ( CmdBlk *pcb,      ImgHeadBlk ihb[],
                             int   OutCoordinate, int InCoordinate,
                             int   OutImage,   int   MinImage, int MaxImage,
                             int   W1InI,      float W1In,
                             int   W3InI,      float W3In,
                             float Off_1[],    float Ps_1[],
                             float Off_2[],    float Ps_2[],
                             float f1[],       float f3[],     float Df[],
                             int   *Imin,      int   *Imax,
                             float *Wmin,      float *Wmax,    float *DW,
                             int    mode ),
     GetImageRange         ( CmdBlk * pcb, ImgHeadBlk ihb[],
                             int MinImage, int MaxImage,
                             float Off_1[], float Off_2[],
                             float Ps_1[],  float Ps_2[],
                             float f1_1[], float f3_1[], float Df_1[],
                             float f1_2[], float f3_2[], float Df_2[],
                             int   * Imin_1, int * Imax_1,
                             int   * Imin_2, int * Imax_2,
                             float * Wmin_1, float * Wmax_1, float *DW_1,
                             float * Wmin_2, float * Wmax_2, float *DW_2,
                             int    mode ),
     UpdateLinearParameters( CmdBlk *pcb, ImgHeadBlk ihb[],
                             int OutCoordinate, int InCoordinate,
                             int OutImage, int MinImage, int MaxImage,
                             float Off_1[],    float Off_2[],
                             float Ps_1[],     float Ps_2[],
                             int * pstatus ),
     UpdateImageParameters ( CmdBlk *pcb, ImgHeadBlk ihb[],
                             int MinImage, int MaxImage,
                             float Off_1[],    float Off_2[],
                             float Ps_1[],     float Ps_2[],
                             int * pstatus ),
     GetReferenceParameters( CmdBlk * pcb, ImgHeadBlk ihb[],
                             int MinImage, int MaxImage,
                             float Off_1[], float Off_2[],
                             float Ps_1[],  float Ps_2[],
                             int * pstatus ),
     GetReference          ( long RSys, int blockno, ImgHeadBlk ihb[],
                             float * Off_1, float * Off_2,
                             float * Ps_1,  float * Ps_2,
                             int * pstatus ),
     GetReferenceParametersC(long RSys, CmdBlk * pcb, ImgHeadBlk ihb[],
                             int coordinate, int MinImage, int MaxImage,
                             float Off[], float Ps[],
                             int * pstatus ),
     GetReferenceC         ( long RSys, ImgHeadBlk ihb[],
                             int coordinate, int blockno,
                             float *Off, float *Ps, 
                             int * pstatus ),
     GetSmallRectangle     ( CmdBlk *pcb,      ImgHeadBlk ihb[],
                             int   OutCoordinate, int InCoordinate,
                             int   OutImage, int   MinImage,   int   MaxImage,
                             float Off_1[],    float Ps_1[],
                             float Off_2[],    float Ps_2[],
                             float *W1,        float *W3 ),
     GetLargeRectangle     ( CmdBlk *pcb,      ImgHeadBlk ihb[],
                             int   OutCoordinate, int InCoordinate,
                             int   OutImage, int   MinImage,   int   MaxImage,
                             float Off_1[],    float Ps_1[],
                             float Off_2[],    float Ps_2[],
                             float *W1,        float *W3 ),
     TransformFloat2d      ( float *data, long int dim_1, long int dim_2,
                             float dummy, float ddummy,
                             float factor, float constant ),
     ClipFloat2d           ( float *data, long int dim_1, long int dim_2,
                             float dummy, float ddummy,
                             float minclip, int minclipI,
                             float maxclip, int maxclipI ),
     RebinFloat2d          ( float * dataIn, float * dataOut,
                             long int * dim_1, long int * dim_2,
                             float dummy, float ddummy,
                             long int bin_1, long int bin_2,
                             long int ave ),
     GnawFloat2d           ( float * data, float * vardat,
                             long int dim_1, long int dim_2,
                             float dummy, float ddummy,
                             long int gnaw_1, long int gnaw_2,
                             int * pstatus ),
     AffineFloat2d         ( float *data, float *vardat, 
                             long dim_1, long dim_2,
                             float dummy, float ddummy,
                             float *out, float *varout, 
                             long odim_1, long odim_2,
                             float odummy, float oddummy,
                             double t[3][2], int isw, int initialize,
                             int *pstatus ),
     Affine               (  CmdBlk * pcb, ImgHeadBlk ihb[],
                             int InputBlock, int OutputBlock,
                             double t[3][2], int initialize,
                             int * pstatus );
  extern int
    copy_amat              ( double t[3][2], double p[3][2] ),
    invert_amat            ( double t[3][2], double p[3][2] );
  extern void           
   Projection_1            ( float *line, float *varline, int dim,
                             int imin, int imax, float initvalue, float factor,
                             float *data, float *vardat, int dim_1, int dim_2,
                             float f1_1, float f3_1, float Df_1,
                             float f1_2, float f3_2,
                             float dummy, float ddummy, int ave, int testbit ),
   Projection_2            ( float *line, float *varline, int dim,
                             int imin, int imax, float initvalue, float factor,
                             float *data, float *vardat, int dim_1, int dim_2,
                             float f1_1, float f3_1,
                             float f1_2, float f3_2, float Df_2,
                             float dummy, float ddummy, int ave, int testbit );

  extern void
   arc_lfactor             ( float * Data,   float * EData,
                             int   Dim_1,    int   Dim_2,
                             float Offset_1, float PSize_1, float Center_1,
                             float Offset_2, float PSize_2, float Center_2,
                             float SampleDistance, float WaveLength,
                             float Dummy,    float DDummy,
                             float sangle,   int   rsys,
                             int csym, int s2, int testbit, int * pstatus );

  extern char
    *SaxsRoutineVersion    ( void );

# define _SAXS_ROUTINE_
#endif /* _SAXS_ROUTINE_ */

/****************************************************************************
*                                                                           *
****************************************************************************/
