/*+++
1 test_edfio.c

2 HISTORY
  2010-12-18 test compression
---*/
# include "edfio.h" 

# define STRCMP(s1,s2) strcmp ( (char *) s1, (char *) s2 )

# define DIM1 150 
# define DIM2 3 
# define TOTAL DIM1*DIM2 

# define DefaultExtension ".edf"
# define DefaultFilename "datafile"DefaultExtension

/*****************************************************************************
* test_datatypes_fixed_compressed                                            *
* data and dimension buffers fixed                                           *
*****************************************************************************/
int test_datatypes_fixed_compressed( const char * filename, const char * mode,
     unsigned short start, int compression,  int level, int verbose )
{
  int ret = 0;

  int ErrorValue, status;
  int stream;

  long DataNumber=1, DataChain=1;
  long i;

  long  Dim2Array[2+1] = { 2, DIM1, DIM2 };
  long  *Dim2          = Dim2Array;

  unsigned short value;

  unsigned char  UByteArray[TOTAL];
  signed char    SByteArray[TOTAL];
  unsigned short UShortArray[TOTAL];
  signed short   SShortArray[TOTAL];
  unsigned int   UIntArray[TOTAL];
  signed int     SIntArray[TOTAL];
  float          FloatArray[TOTAL];
  double         DoubleArray[TOTAL];

  float          OutArray[TOTAL];            

  unsigned char  *UByte  = UByteArray;
  signed char    *SByte  = SByteArray;
  unsigned short *UShort = UShortArray;
  signed short   *SShort = SShortArray;
  unsigned int   *UInt   = UIntArray;
  signed int     *SInt   = SIntArray;
  float          *Float  = FloatArray;
  double         *Double = DoubleArray;
  float          *Out    = OutArray;

  size_t UByteArraySize  = sizeof(unsigned char) * TOTAL;
  size_t SByteArraySize  = sizeof(signed char) * TOTAL;
  size_t UShortArraySize = sizeof(unsigned short) * TOTAL;
  size_t SShortArraySize = sizeof(signed short) * TOTAL;
  size_t UIntArraySize   = sizeof(unsigned int) * TOTAL;
  size_t SIntArraySize   = sizeof(signed int) * TOTAL;
  size_t FloatArraySize  = sizeof(float) * TOTAL;
  size_t DoubleArraySize = sizeof(double) * TOTAL;

  size_t OutArraySize    = sizeof(float) * TOTAL;

  edfio_debug(level);

//----------------------------------------------------------------------------
value = start;
// fill array UByte
for (i=0;i<TOTAL;i++) UByteArray[i]  = (unsigned char) value; value++;
// fill array SByte
for (i=0;i<TOTAL;i++) SByteArray[i]  = (char) value; value++;
// fill array UShort
for (i=0;i<TOTAL;i++) UShortArray[i] = value; value++;
// fill array SHORT
for (i=0;i<TOTAL;i++) SShortArray[i] = value; value++;
// fill array UInt
for (i=0;i<TOTAL;i++) UIntArray[i]   = value; value++;
// fill array SInt
for (i=0;i<TOTAL;i++) SIntArray[i]   = value; value++;
// fill array Float
for (i=0;i<TOTAL;i++) FloatArray[i]  = value; value++;
// fill array Double
for (i=0;i<TOTAL;i++) DoubleArray[i] = value; value++;
 
//----------------------------------------------------------------------------
// write file filename

  stream = edf_open_data_file ( filename, mode, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  DataNumber=1;
  edf_write_data ( stream, DataNumber++, DataChain, 
                   Dim2, UByte, MUnsignedChar, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  edf_set_datacompression     ( compression );
  edf_write_data ( stream, DataNumber++, DataChain,
                   Dim2, SByte, MChar, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  edf_set_datacompression     ( UnCompressed );
  edf_write_data ( stream, DataNumber++, DataChain,
                   Dim2, UShort, MUnsignedShort, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  edf_set_datacompression     ( compression );
  edf_write_data ( stream, DataNumber++, DataChain,
                   Dim2, SShort, MShort, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  edf_set_datacompression     ( UnCompressed );
  edf_write_data ( stream, DataNumber++, DataChain,
                   Dim2, UInt, MUnsignedInteger, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }
  edf_set_datacompression     ( InValidDCompression );

  edf_set_datacompression     ( compression );
  edf_write_data ( stream, DataNumber++, DataChain,
                   Dim2, SInt, MInteger, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  edf_set_datacompression     ( UnCompressed );
  edf_write_data ( stream, DataNumber++, DataChain,
                   Dim2, Float, MFloat, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  edf_set_datacompression     ( compression );
  edf_write_data ( stream, DataNumber++, DataChain,
                   Dim2, Double, MDouble, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  if ( STRCMP(mode,"temp") ) { // close and open only, if mode!="temp"
    edf_close_data_file( stream, &ErrorValue, &status );
    if (status) { 
      printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); 
    }

  /* reset to default */
  edf_set_datacompression     ( InValidDCompression );

//----------------------------------------------------------------------------
// read file filename and convert to MFloat

    stream = edf_open_data_file  ( filename, "old", &ErrorValue, &status );
    if (status) { 
      printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); 
      }
    } else { // if not "temp"
  //  edf_print_filetable( stdout, 4, True );
    }

  value = start;
  for (DataNumber=1;DataNumber<=8;DataNumber++) {
    printf("Converting data %d to %s\n", DataNumber,"Float");
    edf_read_data (stream,DataNumber,DataChain, &Dim2, &OutArraySize,
                   (void**) &Out, MFloat, &ErrorValue, &status );
    if (status) { 
      printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

    for (i=0;i<TOTAL;i++) {
      if (Out[i]!=(float) value) { 
        ret=-1; printf("%g != %g\n",Out[i],(float) value); }
    }
    value++;
  }

  edf_close_data_file( stream, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  return(ret);

} /* test_datatypes_fixed_compressed */

/*****************************************************************************
* test_datatypes_fixed                                                       *
* data and dimension buffers fixed                                           *
*****************************************************************************/
int test_datatypes_fixed( const char * filename, const char * mode,
                          unsigned short start, int level, int verbose )
{ 
  int ret = 0;

  int ErrorValue, status;
  int stream;

  long DataNumber=1, DataChain=1;
  long i;

  long  Dim2Array[2+1] = { 2, DIM1, DIM2 };
  long  *Dim2          = Dim2Array;

  unsigned short value;

  unsigned char  UByteArray[TOTAL];
  signed char    SByteArray[TOTAL];
  unsigned short UShortArray[TOTAL];
  signed short   SShortArray[TOTAL];
  unsigned int   UIntArray[TOTAL];
  signed int     SIntArray[TOTAL];
  float          FloatArray[TOTAL];
  double         DoubleArray[TOTAL];

  float          OutArray[TOTAL];            

  unsigned char  *UByte  = UByteArray;
  signed char    *SByte  = SByteArray;
  unsigned short *UShort = UShortArray;
  signed short   *SShort = SShortArray;
  unsigned int   *UInt   = UIntArray;
  signed int     *SInt   = SIntArray;
  float          *Float  = FloatArray;
  double         *Double = DoubleArray;
  float          *Out    = OutArray;

  size_t UByteArraySize  = sizeof(unsigned char) * TOTAL;
  size_t SByteArraySize  = sizeof(signed char) * TOTAL;
  size_t UShortArraySize = sizeof(unsigned short) * TOTAL;
  size_t SShortArraySize = sizeof(signed short) * TOTAL;
  size_t UIntArraySize   = sizeof(unsigned int) * TOTAL;
  size_t SIntArraySize   = sizeof(signed int) * TOTAL;
  size_t FloatArraySize  = sizeof(float) * TOTAL;
  size_t DoubleArraySize = sizeof(double) * TOTAL;

  size_t OutArraySize    = sizeof(float) * TOTAL;

  edfio_debug(level);

//----------------------------------------------------------------------------
value = start;
// fill array UByte
for (i=0;i<TOTAL;i++) UByteArray[i]  = (unsigned char) value; value++;
// fill array SByte
for (i=0;i<TOTAL;i++) SByteArray[i]  = (char) value; value++;
// fill array UShort
for (i=0;i<TOTAL;i++) UShortArray[i] = value; value++;
// fill array SHORT
for (i=0;i<TOTAL;i++) SShortArray[i] = value; value++;
// fill array UInt
for (i=0;i<TOTAL;i++) UIntArray[i]   = value; value++;
// fill array SInt
for (i=0;i<TOTAL;i++) SIntArray[i]   = value; value++;
// fill array Float
for (i=0;i<TOTAL;i++) FloatArray[i]  = value; value++;
// fill array Double
for (i=0;i<TOTAL;i++) DoubleArray[i] = value; value++;
 
//----------------------------------------------------------------------------
// write file filename

  stream = edf_open_data_file ( filename, mode, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  DataNumber=1;
  edf_write_data ( stream, DataNumber++, DataChain, 
                   Dim2, UByte, MUnsignedChar, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }
  edf_write_data ( stream, DataNumber++, DataChain,
                   Dim2, SByte, MChar, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }
  edf_write_data ( stream, DataNumber++, DataChain,
                   Dim2, UShort, MUnsignedShort, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }
  edf_write_data ( stream, DataNumber++, DataChain,
                   Dim2, SShort, MShort, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }
  edf_write_data ( stream, DataNumber++, DataChain,
                   Dim2, UInt, MUnsignedInteger, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }
  edf_write_data ( stream, DataNumber++, DataChain,
                   Dim2, SInt, MInteger, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }
  edf_write_data ( stream, DataNumber++, DataChain,
                   Dim2, Float, MFloat, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }
  edf_write_data ( stream, DataNumber++, DataChain,
                   Dim2, Double, MDouble, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  if ( STRCMP(mode,"temp") ) { // close and open only, if mode!="temp"
    edf_close_data_file( stream, &ErrorValue, &status );
    if (status) { 
      printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); 
      }

//----------------------------------------------------------------------------
// read file filename and convert to MFloat

    stream = edf_open_data_file  ( filename, "old", &ErrorValue, &status );
    if (status) { 
      printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); 
      }
    } else { // if not "temp"
  //  edf_print_filetable( stdout, 4, True );
    }

  value = start;
  for (DataNumber=1;DataNumber<=8;DataNumber++) {
    printf("Converting data %d to %s\n", DataNumber,"Float");
    edf_read_data (stream,DataNumber,DataChain, &Dim2, &OutArraySize,
                   (void**) &Out, MFloat, &ErrorValue, &status );
    if (status) { 
      printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

    for (i=0;i<TOTAL;i++) {
      if (Out[i]!=(float) value) { 
        ret=-1; printf("%g != %g\n",Out[i],(float) value); }
      }
    value++;
    }

  edf_close_data_file( stream, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  return(ret);

} /* test_datatypes_fixed */

/*****************************************************************************
* test_datatypes                                                             *
* data and dimension buffers allocated by edfio                              *
*****************************************************************************/
int test_datatypes( const char * filename, const char * mode,
                    unsigned short start, int level, int verbose )
{
  int ret = 0;

  int ErrorValue, status;
  int stream;

  long DataNumber=1, DataChain=1;
  long i;

  long  *Dim = NULL;
  float *Data = NULL;

  size_t FloatArraySize = (size_t) NULL;

  unsigned short value;

  edfio_debug(level);

//----------------------------------------------------------------------------
// read file filename and convert to MFloat

  stream = edf_open_data_file  ( filename, mode, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  value = start;
  for (DataNumber=1;DataNumber<=8;DataNumber++) {
    printf("Converting data %d to %s\n", DataNumber,"Float");
    Dim = (long *) NULL; Data = (float *) NULL;
    edf_read_data (stream,DataNumber,DataChain, &Dim, &FloatArraySize,
                   (void**) &Data, MFloat, &ErrorValue, &status );
    if (status) {
      printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

    if (Dim[0]!=2)    { ret=-1; printf("Dim[0] = %d\n",Dim[0]); }
    if (Dim[1]!=DIM1) { ret=-1; printf("Dim[1] = %d\n",Dim[1]); }
    if (Dim[2]!=DIM2) { ret=-1; printf("Dim[2] = %d\n",Dim[2]); }

    for (i=0;i<TOTAL;i++) {
      if (Data[i]!=(float) value) { ret=-1; printf("%g\n",Data[i]); }
      }
    value++;
    }

  edf_close_data_file( stream, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  return(ret);

} /* test_datatypes */

/*****************************************************************************
* test_toobig                                                                *
* data and dimension buffers allocated by edfio                              *
*****************************************************************************/
int test_toobig( const char * filename, const char * mode,
                 unsigned short start, int level, int verbose )
{
  int ret = 0;

  int ErrorValue, status;
  int stream;

  long DataNumber=1, DataChain=1;
  long i;

  long  Dim2Array[2+1] = { 2, DIM1, DIM2 };
  long  *Dim2          = Dim2Array;

  long  *Dim = NULL;
  float *Data = NULL;

  size_t DataArraySize = (size_t) NULL;

  unsigned short value;

  signed int     SIntArray[TOTAL];
  signed int     *SInt   = SIntArray;
  size_t SIntArraySize   = sizeof(signed int) * TOTAL;

  edfio_debug(level);

//----------------------------------------------------------------------------
// write file filename

  stream = edf_open_data_file ( filename, mode, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  value = start;
  for (DataNumber=1;DataNumber<=10;DataNumber++) {

    printf("Try to write integer array with value %d to block %d\n", value, DataNumber);

    // fill array SInt
    for (i=0;i<TOTAL;i++) SIntArray[i]   = value; value++;

    edf_write_data ( stream, DataNumber, DataChain,
                     Dim2, SInt, MInteger, &ErrorValue, &status );
    if (status) { 
       printf("%s\n",edf_report_data_error(ErrorValue)); 
       printf("To recover from a bad ouput action the file must be closed and reopened\n");
       printf("Close file\n");
       edf_close_data_file( stream, &ErrorValue, &status );
       if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }
       printf("Reopen file\n");
       stream = edf_open_data_file ( filename, mode, &ErrorValue, &status );
       if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }
       }
    }

  edf_close_data_file( stream, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

//----------------------------------------------------------------------------
// read file filename and convert to MFloat

  stream = edf_open_data_file  ( filename, "old", &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  value = start;
  for (DataNumber=1;DataNumber<=10;DataNumber++) {
    printf("Converting data %d to %s\n", DataNumber,"Float");
    Dim = (long *) NULL; Data = (float *) NULL;
    edf_read_data (stream,DataNumber,DataChain, &Dim, &DataArraySize,
                   (void**) &Data, MFloat, &ErrorValue, &status );
    if (status) {
      printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

    if (Dim[0]!=2)    { ret=-1; printf("Dim[0] = %d\n",Dim[0]); }
    if (Dim[1]!=DIM1) { ret=-1; printf("Dim[1] = %d\n",Dim[1]); }
    if (Dim[2]!=DIM2) { ret=-1; printf("Dim[2] = %d\n",Dim[2]); }

    for (i=0;i<TOTAL;i++) {
      if (Data[i]!=(float) value) { ret=-1; printf("%g\n",Data[i]); }
      }
    value++;
    }

  edf_close_data_file( stream, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  return(ret);

} /* test_toobig */

int test_header( const char * filename, const char * mode,
                 const char * name, int level, int verbose )
{
  int ret = 0;

  int ErrorValue, status;
  int stream;

  long DataNumber=1, DataChain=1;

  int ok;

  edfio_debug(level);

  stream = edf_open_data_file  ( filename, "old", &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  edf_new_header          ( name );

  edf_read_header          ( stream, DataNumber, DataChain, name ,
                             &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  edf_write_header_line ( stream, DataNumber, DataChain, "Title",
                   "hulahula", &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  edf_read_header          ( stream, DataNumber++, DataChain, name ,
                             &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  edf_write_header         ( stream, DataNumber++, DataChain, name,
                             &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  edf_free_header         ( name );

  for (DataNumber=1;DataNumber<15;DataNumber++) {
      ok = edf_test_header( stream, DataNumber, DataChain, 
                            &ErrorValue, &status );
      if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }
      printf(" DataNumber = %d, DataChain = %d %s\n",
           DataNumber, DataChain, ok?"found":"missing");
    }

  edf_close_data_file( stream, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  return(ret);

} /* test_header */

/* test_header_routines creates two headers (name1 and name2) and access them
  with edf_first_header_element, edf_next_header_element, 
  edf_add_header_element, edf_search_header_element and 
  edf_delete_header_element. If verbose, the headers are printed.
*/
int test_header_routines( const char * filename, const char * mode,
                          long DataNumber1, const char * name1, 
                          long DataNumber2, const char * name2,
                          int level, int verbose )
{
  int ret = 0;

  int ErrorValue, status;
  int stream;

  long DataChain=1;

  const char * key, * value;
  const char * name3 = "empty";

  int ok;

  edfio_debug(level);

  // read header from file
  stream = edf_open_data_file  ( filename, "old", &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  edf_new_header          ( name1 );
  edf_read_header          ( stream, DataNumber1, DataChain, name1 ,
                             &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  edf_new_header          ( name2 );
  edf_read_header          ( stream, DataNumber2, DataChain, name2 ,
                             &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  edf_close_data_file( stream, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  key = "newkey";
  value = "newvalue";
  edf_add_header_element(name1, key, value,&ErrorValue, &status);
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  edf_search_header_element(name1, key, &value,&ErrorValue, &status);
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }
  ret = STRCMP(value,"newvalue")?1:ret;
  if (verbose) {
    printf("   \'%s\' = \'%s\' ",key,value);
    printf("%s\n",STRCMP(value,"newvalue")?"ERROR (written!=read)":
      "successfully created");
  }

  // first use of edf_first_header_element
  if (verbose) printf("HEADER \"%s\"\n",name1);
  edf_first_header_element(name1, &key, &value, &ErrorValue, &status);
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  while (key) {
    if (verbose) printf("   \'%s\' = \'%s\'\n",key,value);
    edf_next_header_element(name1, &key, &value, &ErrorValue, &status);
    if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }
  }

  key = "newkey";
  edf_delete_header_element( name1, key,&ErrorValue, &status);
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  edf_search_header_element(name1, key, &value,&ErrorValue, &status);
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }
  ret = value?1:ret;
  if (verbose) {
    printf("   key '%s' ",key);
    printf("%s\n",value?"ERROR (not deleted)":"successfully deleted");
  }

  // second use of edf_first_header_element (the same header)
  if (verbose) printf("HEADER \"%s\"\n",name1);
  edf_first_header_element(name1, &key, &value, &ErrorValue, &status);
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  while (key) {
    if (verbose) printf("   \'%s\' = \'%s\'\n",key,value);
    edf_next_header_element(name1, &key, &value, &ErrorValue, &status);
    if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1);}
  }

  key = "newkey";
  value = "newvalue";
  edf_add_header_element(name1, key, value,&ErrorValue, &status);
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  edf_search_header_element(name1, key, &value,&ErrorValue, &status);
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }
  ret = STRCMP(value,"newvalue")?1:ret;
  if (verbose) {
    printf("   \'%s\' = \'%s\' ",key,value);
    printf("%s\n",STRCMP(value,"newvalue")?"ERROR (written!=read)":
      "successfully created");
  }

  edf_delete_header_element( name1, key,&ErrorValue, &status);
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  edf_search_header_element(name1, key, &value,&ErrorValue, &status);
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }
  ret = value?1:ret;
  if (verbose) {
    printf("   key '%s' ",key);
    printf("%s\n",value?"ERROR (not deleted)":"successfully deleted");
  }

  // third use of edf_first_header_element (empty header)

  edf_new_header          ( name3 );

  /* test edf_print_header */
  edf_print_header( stdout, (const char *) NULL, level, verbose );
  edf_print_header( stdout, name1, level, verbose );

  if (verbose) printf("HEADER \"%s\"\n",name3);
  edf_first_header_element(name3, &key, &value, &ErrorValue, &status);
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  while (key) {
    if (verbose) printf("   \'%s\' = \'%s\'\n",key,value);
    edf_next_header_element(name3, &key, &value, &ErrorValue, &status);
    if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1);}
  }

  key = "newkey";
  value = "newvalue";
  edf_add_header_element(name3, key, value,&ErrorValue, &status);
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  edf_search_header_element(name3, key, &value,&ErrorValue, &status);
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }
  ret = STRCMP(value,"newvalue")?1:ret;
  if (verbose) {
    printf("   \'%s\' = \'%s\' ",key,value);
    printf("%s\n",STRCMP(value,"newvalue")?"ERROR (written!=read)":
      "successfully created");
  }

  edf_delete_header_element( name3, key,&ErrorValue, &status);
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  edf_search_header_element(name3, key, &value,&ErrorValue, &status);
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }
  ret = value?1:ret;
  if (verbose) {
    printf("   key '%s' ",key);
    printf("%s\n",value?"ERROR (not deleted)":"successfully deleted");
  }

  edf_free_header         ( name3 );
  edf_free_header         ( name1 );

  // second use of edf_first_header_element (different header)
  if (verbose) printf("HEADER \"%s\"\n",name2);
  edf_first_header_element(name2, &key, &value, &ErrorValue, &status);
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  while (key) {
    if (verbose) printf("   \'%s\' = \'%s\'\n",key,value);
    edf_next_header_element(name2, &key, &value, &ErrorValue, &status);
    if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1);}
  }

  key = "newkey";
  value = "newvalue";
  edf_add_header_element(name2, key, value,&ErrorValue, &status);
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  edf_search_header_element(name2, key, &value,&ErrorValue, &status);
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }
  ret = STRCMP(value,"newvalue")?1:ret;
  if (verbose) {
    printf("   \'%s\' = \'%s\' ",key,value);
    printf("%s\n",STRCMP(value,"newvalue")?"ERROR (written!=read)":
      "successfully created");
  }

  edf_delete_header_element( name2, key,&ErrorValue, &status);
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }

  edf_search_header_element(name2, key, &value,&ErrorValue, &status);
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }
  ret = value?1:ret;
  if (verbose) {
    printf("   key '%s' ",key);
    printf("%s\n",value?"ERROR (not deleted)":"successfully deleted");
  }

  edf_free_header         ( name2 );


  return(ret);

} /* test_header_routines */

int test_history( const char * filename, int level, int verbose )
{ char key_buffer[256];
  int ret = 0;
 
  int ErrorValue, status;
  int stream;
 
  long DataNumber=1, DataChain=1;
 
  int ok;
 
  edfio_debug(level);

  /* write history */

  for (DataNumber=1;DataNumber<15;DataNumber++) {
    sprintf(key_buffer,"key %d",DataNumber);
    edf_history_new         ( key_buffer );
  }
 
  stream = edf_open_data_file  ( filename, "old", &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }
 
  for (DataNumber=1;DataNumber<15;DataNumber++) {
        sprintf(key_buffer,"key %d",DataNumber);
        edf_history_argv ( key_buffer, key_buffer );
        edf_write_header_history ( stream, DataNumber,
                           DataChain, key_buffer,
                           &ErrorValue, &status );
        if (status) {
           printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }
    }
 
  edf_close_data_file( stream, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }
 
  edf_history_free         ( (char *) NULL ); 

  /* read history */
 
  for (DataNumber=1;DataNumber<15;DataNumber++) {
    sprintf(key_buffer,"key %d",DataNumber);
    edf_history_new         ( key_buffer );
  }

  stream = edf_open_data_file  ( filename, "old", &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }
 
  for (DataNumber=1;DataNumber<15;DataNumber++) {
      if (edf_test_header(stream,DataNumber,DataChain,&ErrorValue,&status)) {
        sprintf(key_buffer,"key %d",DataNumber);
        edf_read_header_history  ( stream, DataNumber,
               DataChain, key_buffer, &ErrorValue, &status );
        if (status) {
           printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }
        edf_history_argv            ( key_buffer, "new argv" );
        }
    }
 
  edf_close_data_file( stream, &ErrorValue, &status );
  if (status) { printf("%s\n",edf_report_data_error(ErrorValue)); return(-1); }


  /* copy history */
  printf(" edf_history_print: copy %s to %s\n",key_buffer,"edf_history_copy");
  edf_history_print   ( stdout, key_buffer, level, verbose );

  if ( !edf_history_copy ( "edf_history_copy", key_buffer ) ) return(-1);
  edf_history_print   ( stdout, "edf_history_copy", level, verbose ); 

  /* write history to header */
  printf(" edf_history_write_header: write  %s to header %s\n",
    "edf_history_copy","history_header");

  if ( !edf_new_header          ( "history_header" ) ) return(-1);
  if ( !edf_history_write_header( "history_header", "edf_history_copy",
                                 &ErrorValue, &status ) ) return(-1);
  edf_print_header( stdout, "history_header", level, verbose ); 

  /* read history from header */
  printf(" edf_history_read_header: read %s from header %s\n",
    "edf_history_read","history_header");
  if ( !edf_history_new               ( "edf_history_read" )) return(-1);
  if ( !edf_history_read_header ( "history_header", "edf_history_read",
                                   &ErrorValue, &status ) ) return(-1);
  edf_history_print   ( stdout, "edf_history_read", level, verbose ); 

  /* free history */

  edf_free_header          ( (char *) NULL );
  edf_history_free         ( (char *) NULL );

  return(ret);
 
} /* test_history */

/*+++------------------------------------------------------------------------
main
---------------------------------------------------------------------------*/
# define Usage "<level> <verbose>"

main (int argc, char *argv[])
{ int level = 0, verbose = 0;

  if (argc<=2) { printf("%s %s\n",argv[0],Usage); return(-1); }

  if (argc>1) sscanf(argv[1],"%d",&level);
  if (argc>2) sscanf(argv[2],"%d",&verbose);

  printf("level = %d, verbose = %d\n",level,verbose);

  printf("--------------------------------------------------------------------------\n");
  printf("datatypes (fixed buffer)\n"); 
  printf("%s\n",
   test_datatypes_fixed(DefaultFilename,"new",1,
                         level,verbose)?"failed":"passed");

  printf("--------------------------------------------------------------------------\n");
  printf("datatypes\n"); 
  printf(" %s\n",
         test_datatypes(DefaultFilename,"old",1,
                         level,verbose)?"failed":"passed");

  // Error: HeaderID will be changed to 2 ?????????????
  printf("--------------------------------------------------------------------------\n");
  printf("rewrite file\n"); 
  printf(" %s\n",
   test_datatypes_fixed(DefaultFilename,"old",1,
                         level,verbose)?"failed":"passed");

  printf("--------------------------------------------------------------------------\n");
  printf("write integer arrays into all blocks (1 to 4 should fail):\n");
  printf(" %s\n",
    test_toobig(DefaultFilename,"old",1, level,verbose)?"failed":"passed");

  printf("--------------------------------------------------------------------------\n");
  printf("datatypes\n"); 
  printf(" %s\n",
   test_datatypes_fixed(DefaultFilename,"old",100,
                         level,verbose)?"failed":"passed");

  printf("--------------------------------------------------------------------------\n");
  printf("read/write header\n"); 
  printf(" %s\n",
            test_header(DefaultFilename,"old","9999",
                         level,verbose)?"failed":"passed");

  printf("--------------------------------------------------------------------------\n");
  printf("header routines\n"); 
  printf(" %s\n",
            test_header_routines(DefaultFilename,"old",5,"header1",6,"header2",
                         level,verbose)?"failed":"passed");

  printf("--------------------------------------------------------------------------\n");
  printf("temporary file (fixed buffer)\n"); 
  printf(" %s\n",
   test_datatypes_fixed(DefaultFilename,"temp",1,
                         level,verbose)?"failed":"passed");

  printf("--------------------------------------------------------------------------\n");
  printf("read history\n"); 
  printf(" %s\n",
   test_history(DefaultFilename,level,verbose)?"failed":"passed");

  printf("--------------------------------------------------------------------------\n");
  printf("datatypes (fixed buffer) ZCompression\n");
  printf("%s\n",
   test_datatypes_fixed_compressed(DefaultFilename,"new",1,
                ZCompression,level,verbose)?"failed":"passed");

  printf("--------------------------------------------------------------------------\n");
  printf("datatypes (fixed buffer) GzipCompression \n");
  printf("%s\n",
   test_datatypes_fixed_compressed(DefaultFilename,"new",1,
                GzipCompression,level,verbose)?"failed":"passed");



  exit(0);

} /* edftest */
