/* -*- coding: utf-8 -*-
*
* PyNX - Python tools for Nano-structures Crystallography
*   (c) 2020-present : ESRF-European Synchrotron Radiation Facility
*       authors:
*         Vincent Favre-Nicolin, favre@esrf.fr
*/

void CalcIllumination(const int i, __global float2* probe, __global float* obj_illum,
                      __global float* cx, __global float* cy, const int npsi, const int stack_size,
                      const int nx, const int ny, const int nxo, const int nyo,
                      const int nbmode, __global float* scale, const char interp, const int padding,
                      __global int* probe_idx, __global float* beamx, __global float* beamy)
{
  const int prx = i % nx;
  const int pry = i / nx;
  const int nxy = nx * ny;
  if((prx<padding) || (prx>=(nx-padding)) || (pry<padding) || (pry>=(ny-padding))) return;

  for(int imode=0; imode < nbmode; imode++)
  {
    const int iprobe = probe_idx[imode];
    const float bx = beamx[imode];
    const float by = beamy[imode];

    const float2 p = probe[i + iprobe*nxy];
    const float n = dot(p,p);

    // cx too large indicate a frame with the direct beam
    for(int j=0;j<npsi;j++)
      if(cx[j]< 1e8) bilinear_atomic_add_f(obj_illum, n * scale[j], cx[j] + bx + prx, cy[j] + by + pry, 0, nxo, nyo, interp);
  }
}
