import os
import argparse
import shutil


def get_paths_config():
    pth = os.path.dirname(os.path.abspath(__file__))
    cwd = os.getcwd()
    # Environment variable to store where we are working.
    v = f"PYNX_HT_CWD={cwd}"
    return pth, cwd, v


def make_parser(name):
    """
    Script to launch wipow [https://gitlab.esrf.fr/favre/wipow]
    """
    pth, cwd, v = get_paths_config()
    epilog = """"""

    parser = argparse.ArgumentParser(prog=name,
                                     description=__doc__,
                                     epilog=epilog)
    parser.add_argument("--copy", action='store_true',
                        help="If used, the notebook used to launch the widget will be copied "
                             "in the current directory, so that it can be modified.")
    parser.add_argument("--notebook", type=str,
                        default=os.path.join(pth, 'holotomo_live.ipynb'),
                        help="path to the notebook to use (default: the one in the pynx package)")
    parser.add_argument("--port", type=int,
                        help="Web port to use for the server. Will default to 8866.")
    parser.add_argument("--no-browser", action='store_true',
                        help="Don't open the live widget notebook in a browser after startup.")
    return parser


def parse_args(name):
    params = make_parser(name).parse_args()
    if params.copy:
        shutil.copy(params.notebook, os.getcwd())
        params.notebook = os.path.join(os.getcwd(), os.path.split(params.notebook)[-1])
    return params


def run_voila():
    pth, cwd, v = get_paths_config()
    params = parse_args('voila')
    nbk = params.notebook
    port = f"--port {params.port}" if params.port is not None else ""
    no_browser = "--no-browser" if params.no_browser else ""
    os.system(f"{v} voila {port} {no_browser} {nbk} ")


def run_notebook():
    pth, cwd, v = get_paths_config()
    params = parse_args('voila-notebook')
    nbk = params.notebook
    port = f"--ServerApp.port={params.port}" if params.port is not None else ""
    no_browser = "--no-browser" if params.no_browser else ""
    os.system(f"{v} jupyter-notebook {port} {no_browser} {nbk}")


def run_lab():
    pth, cwd, v = get_paths_config()
    params = parse_args('voila-lab')
    nbk = params.notebook
    port = f"--port {params.port}" if params.port is not None else ""
    no_browser = "--no-browser" if params.no_browser else ""
    os.system(f"{v} jupyter-lab {port} {no_browser} {nbk}")


if __name__ == '__main__':
    run_voila()
