#!/usr/bin/env bash

# This script was written to install PyNX using mamba
# This is a very simplified version, using mamba for faster installation
# It is recommended to use with https://conda-forge.org/miniforge/
# This version installs all optional packages for holo-tomography, and graphical displays

# create the conda virtual environment with necessary packages
# NOTE: if you do not want to install the environment in the default location,
# you should use --prefix
mamba create --yes -n $1 python=$2 pip wheel numpy cython scipy=1.9.3 matplotlib fabio ipympl pytools \
      scikit-image silx ipython notebook h5py hdf5plugin ipywidgets psutil scikit-learn mako \
      mpi4py pyopengl jupyterlab ipyvolume ipyfilechooser xraydb pyqt pythreejs=2.3.0
# Note on pinned versions:
#  scipy for nabu
#  pythreejs for ipywidgets/ipyvolume display

# Activate conda environment (see https://github.com/conda/conda/issues/7980)
eval "$(conda shell.bash hook)"
conda activate $1

# Install packages which are better managed by pip. This avoids installing the conda
# version of the cuda-toolkit which would come with pycuda, and it makes
# a local install witha fresh compilation since these
pip install h5glance pyopencl pycuda pyvkfft nabu tomoscan --no-cache
pip install xrayutilities --no-cache  # Something goes wrong here on p9 (h5py) ?


echo
echo "#############################################################################################"
echo " Installing PyNX"
echo "#############################################################################################"
echo
echo "Select method to download PyNX: git (if you have a https://gitlab.esrf.fr account) or ftp (no login required):"
select yn in "ftp" "git" "manual"; do
    case $yn in
        ftp ) curl -O http://ftp.esrf.fr/pub/scisoft/PyNX/pynx-latest.tar.bz2 ; tar -xjf pynx-latest.tar.bz2 ; break;;
        git ) git clone https://gitlab.esrf.fr/favre/PyNX.git pynx ; break;;
        manual ) echo "PyNX installation skipped-sould be manually installed (local git copy, etc..)" ; break;;
    esac
done
cd pynx

if [ -z $3 ];
    then echo "No tag given - using git pynx master head"
else
    git checkout tags/$3
fi

pip install .


echo
echo "#############################################################################################"
echo "Finished installation !"
echo "#############################################################################################"
echo
echo "To use the silx viewer in 3D, also install pyopengl with:"
echo "     conda install --yes -n $1 pyopengl"
echo
echo "To use the PyNX environment, use 'conda activate $1'"
echo
echo "To test pynx installation, run 'pynx-test"


# Notes to also install paraview and ipyparaview:
#  conda install --yes -n $1 paraview nodejs jupyterlab
#  cd $BASEDIR/dev
#  git clone https://github.com/NVIDIA/ipyparaview.git
#  cd ipyparaview
#  ./build.sh
#  jupyter nbextension enable ipyparaview --py --sys-prefix
