#! /opt/local/bin/python
# -*- coding: utf-8 -*-

# PyNX - Python tools for Nano-structures Crystallography
#   (c) 2018-present : ESRF-European Synchrotron Radiation Facility
#       authors:
#         Vincent Favre-Nicolin, favre@esrf.fr

import sys
from pynx.test import *

help_text = """
pynx-test: script to run PyNX unit tests

Example:
    pynx-test: will run all tests

command-line arguments can be used to specify specific tests to be run (by default: all):
    processing_unit: run processing_unit tests
    cdi: run CDI API tests
    cdi_runner: run CDI runner scripts test
    opencl: only perform tests using OpenCL - this excludes CUDA tests
    cuda: only perform tests using CUDA - this excludes OpenCL tests
    live_plot: include live plotting tests

"""

if __name__ == '__main__':
    suites = []
    for arg in sys.argv:
        if 'pynx-test.py' in arg:
            continue
        elif arg.lower() == 'help':
            print(help_text)
        elif arg.lower() == 'opencl':
            continue
        elif arg.lower() == 'cuda':
            continue
        else:
            try:
                suites.append(eval("%s_suite()" % arg))
            except:
                print("Could not find the following unittest suite: %s_suite" % arg)

    if len(suites) == 0:
        suites.append(suite())
    for s in suites:
        res = unittest.TextTestRunner(verbosity=2, descriptions=False).run(s)
