/** Compute the center of mass of a 3d complex-valued array.
*
*
*/
__device__ my_float4 center_mass_complex(const int i, complexf *d, const int nx, const int ny, const int nz,
                                         const int power)
{
  const float v = ComplexNormN(d[i], power);
  const int ix = i % nx;
  const int iy = (i % (nx * ny)) / nx;
  const int iz = (i % (nx * ny * nz)) / (nx * ny);
  return my_float4(ix * v, iy * v, iz * v, v);
}


/** Compute the center of mass of a 3d floating-point array.
*
*
*/
__device__ my_float4 center_mass_float(const int i, float *d, const int nx, const int ny, const int nz)
{
  const float v = d[i] * d[i];
  const int ix = i % nx;
  const int iy = (i % (nx * ny)) / nx;
  const int iz = (i % (nx * ny * nz)) / (nx * ny);
  return my_float4(ix * v, iy * v, iz * v, v);
}
