/* -*- coding: utf-8 -*-
*
* PyNX - Python tools for Nano-structures Crystallography
*   (c) 2017-present : ESRF-European Synchrotron Radiation Facility
*       authors:
*         Vincent Favre-Nicolin, favre@esrf.fr
*/

/// HIO
__device__ void HIO(const int i, complexf *d, complexf* dold, signed char *support, const float beta)
{
  if(support[i]==0) d[i] = dold[i] - beta * d[i] ;
}


/// HIO, biasing real part to be positive
__device__ void HIO_real_pos(const int i, complexf *d, complexf* dold, signed char *support, const float beta)
{
  if((support[i]==0)||(d[i].real()<0)) d[i] = dold[i] - beta * d[i] ;
}


/// Error reduction
__device__ void ER(const int i, complexf *d, signed char *support)
{
  if(support[i]==0) d[i] = complexf(0,0) ;
}


/// Error reduction, forcing real part to be positive
__device__ void ER_real_pos(const int i, complexf *d, signed char *support)
{
  if((support[i]==0)||(d[i].real()<0)) d[i] = complexf(0,0) ;
}


/// Charge flipping
__device__ void CF(const int i, complexf *d, signed char *support)
{
  if(support[i]==0) d[i].imag(-d[i].imag()) ;
}

/// Charge flipping, biasing real part to be positive
__device__ void CF_real_pos(const int i, complexf *d, signed char *support)
{
  if((support[i]==0)||(d[i].real()<0)) d[i].imag(-d[i].imag()) ;
}

/// RAAR
__device__ void RAAR(const int i, complexf *d, complexf* dold, signed char *support, const float beta)
{
  if(support[i]==0) d[i] = (1 - 2 * beta) * d[i] + beta * dold[i];
}

/// RAAR, biasing real part to be positive
__device__ void RAAR_real_pos(const int i, complexf *d, complexf* dold, signed char *support, const float beta)
{
  if((support[i]==0)||(d[i].real()<0)) d[i] = (1 - 2 * beta) * d[i] + beta * dold[i];
}
