# -*- coding: utf-8 -*-

# PyNX - Python tools for Nano-structures Crystallography
#   (c) 2008-2015 : Univ. Joseph Fourier (Grenoble 1), CEA/INAC/SP2M
#   (c) 2016-present : ESRF-European Synchrotron Radiation Facility
#       authors:
#         Vincent Favre-Nicolin, favre@esrf.fr
#         Ondrej Mandula


from setuptools import setup, find_packages, Extension
from pynx.version import __version__, __authors__, __copyright__, __license__, __date__, __docformat__

cmdclass = {}

try:
    # Use scipy.weave when present (only python2.x)
    from scipy import weave

    cython_modules = []
except:
    try:
        # Otherwise, try cython
        from Cython.Distutils import build_ext
        import numpy

        cython_modules = [
            Extension("pynx.scattering.cpu", sources=["pynx/scattering/cpu.pyx", "pynx/scattering/c_cpu.c"],
                      include_dirs=[numpy.get_include()],
                      extra_compile_args=['-O3', '-ffast-math', '-msse', '-msse2', '-mssse3', '-msse4.1',
                                          '-march=native', '-mfpmath=sse', '-fstrict-aliasing', '-pipe',
                                          '-fomit-frame-pointer', '-funroll-loops', '-ftree-vectorize'])]
        cmdclass['build_ext'] = build_ext
    except:
        cython_modules = []

setup(
    name="PyNX",
    version=__version__,
    packages=find_packages(),
    scripts=['pynx/ptycho/scripts/pynx-id01pty.py', 'pynx/ptycho/scripts/pynx-id13pty.py',
             'pynx/ptycho/scripts/pynx-id16apty.py', 'pynx/ptycho/scripts/pynx-tps25apty.py',
             'pynx/ptycho/scripts/pynx-ptypy.py', 'pynx/ptycho/scripts/pynx-cristalpty.py',
             'pynx/ptycho/scripts/pynx-analyzeprobe.py', 'pynx/ptycho/scripts/pynx-cxipty.py',
             'pynx/cdi/scripts/pynx-id10cdi.py', 'pynx/cdi/scripts/pynx-id01cdi.py',
             'pynx/utils/scripts/pynx-resolution-FSC.py'],
    cmdclass=cmdclass,
    ext_modules=cython_modules,

    install_requires=['numpy>=1.5', 'scipy>=0.17', 'setuptools', 'cython', 'matplotlib', 'scikit-image',
                      'h5py', 'hdf5plugin', 'fabio', 'silx'],
    extras_require={'CUDA': ['pycuda>=2017', 'scikit-cuda'], 'OpenCL': ['pyopencl>=2017', 'gpyfft>=0.7.0', 'mako'],
                    'GID': ["cctbx"]},
    include_package_data=True,
    # package_data = {'pynx.opencl': ['*.h', 'pynx/opencl/*.cl', 'pynx/ptycho/opencl/*.cl', 'pynx/wavefront/opencl/*.cl', 'pynx/cdi/opencl/*.cl']},
    data_files=[('pynx/ptycho/examples/data',
                 ['pynx/ptycho/examples/data/data_113.npz', 'pynx/ptycho/examples/data/data_intensity_004.npy',
                  'pynx/ptycho/examples/data/obj0_random.npy', 'pynx/ptycho/examples/data/pos_004.npy',
                  'pynx/ptycho/examples/data/readme.txt', ])],

    # metadata for upload to PyPI
    author="vincefn",
    author_email="favre@esrf.fr",
    description="PyNX - GPU-accelerated python toolkit for coherent X-ray imaging and nano-crystallography",
    license="CeCILL-B",
    keywords="PyNX GPU OpenCL CUDA crystallography diffraction scattering coherent X-rays ptychography CDI",
    url="http://ftp.esrf.fr/pub/scisoft/PyNX/",
    long_description=
    "PyNX provides Python tools for coherent X-ray imaging and nano-crystallography: \
      1) to compute the X-ray scattering for nano-structures, using GPU (CUDA or OpenCL) acceleration, including in grazing incidence conditions.\
      2) X-rays scattering atomic scattering factors\
      3) 2D X-ray wavefront propagation\
      4) tools for ptychography reconstruction\
      5) Coherent Diffraction Imaging (2D and 3D) reconstruction algorithms",
    classifiers=[
        'Development Status :: 4 - Beta',
        'Environment :: Console',
        'Intended Audience :: Developers',
        'Intended Audience :: Science/Research',
        'Intended Audience :: Education',
        'License :: License :: CEA CNRS Inria Logiciel Libre License B (CeCILL-B)',
        'Operating System :: MacOS :: MacOS X',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3.4',
        'Topic :: Scientific/Engineering :: Physics',
    ],
)
