# -*- coding: utf-8 -*-

# PyNX - Python tools for Nano-structures Crystallography
#   (c) 2017-present : ESRF-European Synchrotron Radiation Facility
#       authors:
#         Vincent Favre-Nicolin, favre@esrf.fr


from ..processing_unit import has_cuda, has_opencl
from ..processing_unit import default_processing_unit as main_default_processing_unit
from .cpu_operator import *
import warnings

# Prefer OpenCL operators for now - once CUDA operators are fully tested, they will become the default
# Import OpenCL operators if possible, otherwise CUDA, unless a language has already been set through the default
# main processing unit
if has_opencl and main_default_processing_unit.pu_language not in ['cuda', 'cpu']:
    from .cl_operator import *
elif has_cuda and main_default_processing_unit.pu_language not in ['opencl', 'cpu']:
    warnings.warn("You have explicitely selected CUDA Ptycho operators, which are still in testing !")
    from .cu_operator import *
