
extern "C++" {

/// We need to reimplement float4 to have the volatile version of operator=
struct my_float4
{
  // Constructors
  __device__ my_float4() : x(0), y(0), z(0), w(0) {}

  __device__ my_float4(const int& v)
    :  x(v), y(v), z(v), w(v) {}

  __device__ my_float4(const float& v)
    :  x(v), y(v), z(v), w(v) {}

  __device__ my_float4(const float& __x,const float& __y,const float& __z,const float& __w)
    :  x(__x), y(__y), z(__z), w(__w) {}

  __device__ my_float4(const my_float4& __z)
    :  x(__z.x), y(__z.y), z(__z.z), w(__z.w) {}

  // Operators
  __device__ my_float4& operator=(const my_float4& rhs)
  {
    x = rhs.x;
    y = rhs.y;
    z = rhs.z;
    w = rhs.w;
    return *this;
  }

  __device__ volatile my_float4& operator=(const my_float4& rhs) volatile
  {
    x = rhs.x;
    y = rhs.y;
    z = rhs.z;
    w = rhs.w;
    return *this;
  }

  __device__ my_float4& operator=(const float& rhs)
  {
    x = rhs;
    y = rhs;
    z = rhs;
    w = rhs;
    return *this;
  }

  __device__ volatile my_float4& operator=(const float& rhs) volatile
  {
    x = rhs;
    y = rhs;
    z = rhs;
    w = rhs;
    return *this;
  }

  __device__ my_float4& operator=(const int& rhs)
  {
    x = rhs;
    y = rhs;
    z = rhs;
    w = rhs;
    return *this;
  }

  __device__ volatile my_float4& operator=(const int& rhs) volatile
  {
    x = rhs;
    y = rhs;
    z = rhs;
    w = rhs;
    return *this;
  }

  __device__ my_float4& operator+= (const my_float4 &rhs) {
    x += rhs.x;
    y += rhs.y;
    z += rhs.z;
    w += rhs.w;
    return *this;
  }

  // Data members
  float x,y,z,w;
};

inline __device__ my_float4 operator+(const my_float4 &v1, const my_float4 &v2)
{
  return my_float4(v1.x+v2.x, v1.y+v2.y, v1.z+v2.z, v1.w+v2.w);
}

inline __device__ my_float4 operator+(const volatile my_float4 &v1, const volatile my_float4 &v2)
{
  return my_float4(v1.x+v2.x, v1.y+v2.y, v1.z+v2.z, v1.w+v2.w);
}

}// extern "C++"

