#include <pycuda-complex.hpp>
typedef pycuda::complex<float> complexf;

/// dot product
inline __device__ float dot(complexf a, complexf b)
{
    return a.real() * b.real() + a.imag() * b.imag();
}

inline __device__ float ComplexNormN(const complexf v, const int nn)
{
  const float a = sqrtf(dot(v, v));
  float an = a;
  for(int i=1;i<nn;i++) an *= a;
  return an;
}
