/* -*- coding: utf-8 -*-
*
* PyNX - Python tools for Nano-structures Crystallography
*   (c) 2017-present : ESRF-European Synchrotron Radiation Facility
*       authors:
*         Vincent Favre-Nicolin, favre@esrf.fr
*/

/// Update support from smoothed amplitude
int SupportUpdate(int i, __global float* d, __global char* support, const float threshold, const bool force_shrink)
{
    const char v = d[i] > threshold;
    if(force_shrink)
    {
        support[i] *= v;
    }
    else
    {
        support[i] = v;
    }
    return (int) v;
}

/// Init support from float2 array (for auto-correlation)
int SupportInit(int i, __global float2* d, __global char* support, const float threshold)
{
    if(length(d[i]) > threshold)
    {
       support[i] = 1;
       return 1;
    }

    return 0;
}
