/** Apply the observed amplitude to a complex calculated array.
* Masked pixels (Iobs<0) are just multiplied by a scale factor.
*/
void ApplyAmplitude(const int i, __global float *iobs, __global float2* dcalc, const float scale)
{
  const float obs = iobs[i];
  if(obs<0)
  {
    if(scale !=1.0f) dcalc[i] = (float2) (scale*dcalc[i].x , scale*dcalc[i].y);
    return;
  }

  const float2 dc=dcalc[i];
  const float a = native_sqrt(obs) / fmax(length(dc), 1e-20f) * scale;
  dcalc[i] = (float2) (a*dc.x , a*dc.y);
}

/** Apply the observed amplitude to a complex calculated array, using already calculated intensities
* (taking into account PSF)
*/
void ApplyAmplitudeIcalc(const int i, __global float *iobs, __global float2* dcalc, __global float *icalc, const float scale)
{
  const float obs = iobs[i];
  if(obs<0)
  {
    if(scale !=1.0f) dcalc[i] = (float2) (scale*dcalc[i].x , scale*dcalc[i].y);
    return;
  }

  const float2 dc=dcalc[i];

  // KLUDGE: The GPU FFT-based convolution can produce negative values, which can be avoided by reverting to
  // non-convoluted values...
  float calc = icalc[i];
  if(calc < 1e-8f) calc = fmax(dot(dc, dc), icalc[i]);

  const float a = native_sqrt(obs / calc) * scale;
  dcalc[i] = (float2) (a*dc.x , a*dc.y);
}
