/* -*- coding: utf-8 -*-
*
* PyNX - Python tools for Nano-structures Crystallography
*   (c) 2017-present : ESRF-European Synchrotron Radiation Facility
*       authors:
*         Vincent Favre-Nicolin, favre@esrf.fr
*/

/// Update support from smoothed amplitude
__device__ int SupportUpdate(int i, float* d, signed char * support, const float threshold, const bool force_shrink)
{
    const int tmp = d[i] > threshold;
    if(force_shrink)
    {
        support[i] *= tmp;
    }
    else
    {
        support[i] = tmp;
    }
    return tmp;
}

/// Init support from float2 array (for auto-correlation)
__device__ int SupportInit(int i, complexf* d, signed char * support, const float threshold)
{
    if(dot(d[i], d[i]) > threshold)
    {
        support[i] = 1;
        return 1;
    }
    return 0;
}
