/* -*- coding: utf-8 -*-
*
* PyNX - Python tools for Nano-structures Crystallography
*   (c) 2017-present : ESRF-European Synchrotron Radiation Facility
*       authors:
*         Vincent Favre-Nicolin, favre@esrf.fr
*/
// Likelihood gradient using Poisson noise (needs to be Fourier Transformed)
__device__ void PsiGradient(const int i, complexf* psi, complexf* dpsi, float* iobs)
{
  const float obs = iobs[i];
  if(obs<0)
  { // masked pixel
    dpsi[i] = complexf(0,0);
  }
  else
  {
    const complexf ps = psi[i];
    const float ps2 = fmaxf(dot(ps,ps),1e-12f); // Calculated amplitude TODO: adjust minimum value

    const float f = (1 - obs / ps2);

    dpsi[i] = conj(f*ps);
  }
}


// Calculate gradient due to the support constraint, and adds it to the current object gradient
__device__ void RegSupportGradient(const int i, complexf* obj, complexf* objgrad, signed char* support, const float reg_fac)
{
  const complexf o = obj[i];
  const int m = 1-support[i];
  const complexf g = objgrad[i];

  objgrad[i] = g + (reg_fac * m) * o;
}
