/** Apply the observed amplitude (from intensities) to a complex calculated array.
*
*/
__device__ void ApplyAmplitude(const int i, float *iobs, complexf* dcalc, const float scale)
{
  // iobs is floating point data array, dcalc is interleaved complex data array
  const float obs = iobs[i];
  if(obs<0)
  {
    if(scale !=1.0f) dcalc[i] = scale * dcalc[i];
    return;
  }

  const complexf dc=dcalc[i];
  const float a = sqrtf(fmaxf(obs, 0.0f)) / fmaxf(abs(dc), 1e-20f) * scale;
  dcalc[i] = a * dc;
}

/** Apply the observed amplitude to a complex calculated array, using already calculated intensities
* (taking into account PSF)
*/
__device__ void ApplyAmplitudeIcalc(const int i, float *iobs, complexf* dcalc, float *icalc, const float scale)
{
  const float obs = iobs[i];
  if(obs<0)
  {
    if(scale !=1.0f) dcalc[i] = scale * dcalc[i];
    return;
  }

  const complexf dc=dcalc[i];

  // KLUDGE: The GPU FFT-based convolution can produce negative values, which can be avoided by reverting to
  // non-convoluted values...
  float calc = icalc[i];
  if(calc < 1e-8f) calc = fmaxf(dot(dc, dc), calc);

  const float a = sqrtf(obs / calc) * scale;
  dcalc[i] = a * dc;
}
