# !/bin/bash

############################# NOTES
# An 8Gb image is not large enought to install all the requirements (CUDA toolkit) and libraries.
# 20Gb suggested for test, plus what is needed for data

# This is an installation of debian 10 (Buster, testing as of 03/2018) from the AWS Debian 9 image

############################# Upgrade to debian 10 ##########################################

sudo apt-get update
sudo apt-get upgrade -y
sudo apt-get dist-upgrade -y
sudo apt-get clean

sed -i 's/stretch/buster/g' /etc/apt/sources.list

echo "deb http://httpredir.debian.org/debian/ buster contrib non-free" >> buster-contrib-nonfree-backports.list
sudo mv buster-contrib-nonfree-backports.list /etc/apt/sources.list.d/

sudo apt-get update
sudo apt-get upgrade -y         # INTERACTIVE
sudo apt-get dist-upgrade -y    # INTERACTIVE

############################# Install base packages ##########################################

sudo apt-get install -y git cmake vim xauth x11-apps fftw3 fftw3-dev aptitude g++ eog rsync

# We install matplotlib to get all graphical packages dependencies, it will be later installed in the virtualenv
sudo apt-get install -y python3-matplotlib python3-virtualenv virtualenv python3-dev

########################## nVidia packages (not availble yet for stretch) #######################################
sudo apt-get install -y nvidia-driver nvidia-smi libcuda1 nvidia-cuda-dev nvidia-cuda-toolkit clinfo    # INTERACTIVE

sudo apt-get autoremove -y
sudo apt-get clean

# Needed to activate drivers and deactivate nouveau
sudo  reboot                                      # REBOOT

# Need manual install of nvidia kernel module ? WHY ??
sudo dkms autoinstall -m nvidia
sudo modprobe nvidia

########################### NEW USER
sudo adduser pynx                       # INTERACTIVE: enter password

sudo apt-get install fail2ban -y        # More secure
sudo vim /etc/fail2ban/jail.conf        # need to whitelist esrf and epn-campus
    => ignoreip = 127.0.0.1/8 ::1 160.103.0.0/16 193.49.0.0/16

sudo service fail2ban restart

sudo vim /etc/ssh/sshd_config           # INTERACTIVE: Enable PasswordAuthentication

sudo service sshd restart

############### The following should be done as the user who will do the calculations, or a shared directory

# Use the 'install-pynx-venv.sh' script for installation

su - pynx
cd
wget http://ftp.esrf.fr/pub/scisoft/PyNX/install-scripts/install-pynx-venv.sh
chmod +x install-pynx-venv.sh
./install-pynx-venv.sh pynx-env python3.6
