/*
Copyright (c) 2014, Tom Schoonjans
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
    * The names of the contributors may not be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY Tom Schoonjans ''AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL Tom Schoonjans BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
 * This file was automatically generated by nuclides.pl
 * Modify at your own risk...
 */

#include "xrayvars.h"
#include <xraylib-radionuclides.h>
#include <xraylib-radionuclides-internal.h>
#include <string.h>
#include <search.h>
#include <xraylib-aux.h>
#include <stdlib.h>
#include <stdio.h>

static int CompareRadioNuclideData(const void *a, const void *b) {
	struct radioNuclideData *ac = (struct radioNuclideData *) a;
	struct radioNuclideData *bc = (struct radioNuclideData *) b;
	return strcmp(ac->name, bc->name);
}

struct radioNuclideData *GetRadioNuclideDataByName(const char radioNuclideString[]) {

	struct radioNuclideData*key = malloc(sizeof(struct radioNuclideData));
	struct radioNuclideData*rv;
	char *buffer;
#ifndef _WIN32
	size_t nelp;
#else
	unsigned int nelp;
#endif
	key->name = strdup(radioNuclideString);
	

#ifndef _WIN32
	nelp = nNuclideDataList;

	rv = lfind(key, nuclideDataList, &nelp, sizeof(struct radioNuclideData), CompareRadioNuclideData);
#else
	nelp = nNuclideDataList;

	rv = _lfind(key, nuclideDataList, &nelp, sizeof(struct radioNuclideData), CompareRadioNuclideData);
#endif

	free(key->name);

	if (rv != NULL) {
		key->name = strdup(rv->name);
		key->Z = rv->Z; 
		key->A = rv->A; 
		key->N = rv->N; 
		key->Z_xray = rv->Z_xray; 
		key->nXrays = rv->nXrays; 
		key->nGammas= rv->nGammas; 
		key->XrayLines = malloc(sizeof(int)*rv->nXrays);
		memcpy(key->XrayLines, rv->XrayLines, sizeof(int)*rv->nXrays);
		key->XrayIntensities = malloc(sizeof(double)*rv->nXrays);
		memcpy(key->XrayIntensities, rv->XrayIntensities, sizeof(double)*rv->nXrays);
		key->GammaEnergies = malloc(sizeof(double)*rv->nGammas);
		memcpy(key->GammaEnergies, rv->GammaEnergies, sizeof(double)*rv->nGammas);
		key->GammaIntensities = malloc(sizeof(double)*rv->nGammas);
		memcpy(key->GammaIntensities, rv->GammaIntensities, sizeof(double)*rv->nGammas);
	}
	else {
		free(key);
		buffer = malloc(sizeof(char)*(strlen("xraylib-radionuclides: no match found for ")+strlen(radioNuclideString)+1));
		sprintf(buffer,"xraylib-radionuclides: no match found for %s", radioNuclideString);
		ErrorExit(buffer);
		free(buffer);
		key = NULL;
	}
	return key;
}

struct radioNuclideData *GetRadioNuclideDataByIndex(int radioNuclideIndex) {
	struct radioNuclideData *key;

	if (radioNuclideIndex < 0 || radioNuclideIndex >= nNuclideDataList) {
		char buffer[1000];
		sprintf(buffer,"xraylib-radionuclides: no match found for index %i", radioNuclideIndex);
		ErrorExit(buffer);
		/* radioNuclideIndex out of range */
		return NULL;
	}

	key = malloc(sizeof(struct radioNuclideData));
	key->name = strdup(nuclideDataList[radioNuclideIndex].name);
	key->Z = nuclideDataList[radioNuclideIndex].Z; 
	key->A = nuclideDataList[radioNuclideIndex].A; 
	key->N = nuclideDataList[radioNuclideIndex].N; 
	key->Z_xray = nuclideDataList[radioNuclideIndex].Z_xray; 
	key->nXrays = nuclideDataList[radioNuclideIndex].nXrays; 
	key->nGammas= nuclideDataList[radioNuclideIndex].nGammas; 
	key->XrayLines = malloc(sizeof(int)*nuclideDataList[radioNuclideIndex].nXrays);
	memcpy(key->XrayLines, nuclideDataList[radioNuclideIndex].XrayLines, sizeof(int)*nuclideDataList[radioNuclideIndex].nXrays);
	key->XrayIntensities = malloc(sizeof(double)*nuclideDataList[radioNuclideIndex].nXrays);
	memcpy(key->XrayIntensities, nuclideDataList[radioNuclideIndex].XrayIntensities, sizeof(double)*nuclideDataList[radioNuclideIndex].nXrays);
	key->GammaEnergies = malloc(sizeof(double)*nuclideDataList[radioNuclideIndex].nGammas);
	memcpy(key->GammaEnergies, nuclideDataList[radioNuclideIndex].GammaEnergies, sizeof(double)*nuclideDataList[radioNuclideIndex].nGammas);
	key->GammaIntensities = malloc(sizeof(double)*nuclideDataList[radioNuclideIndex].nGammas);
	memcpy(key->GammaIntensities, nuclideDataList[radioNuclideIndex].GammaIntensities, sizeof(double)*nuclideDataList[radioNuclideIndex].nGammas);

	return key;
}

char **GetRadioNuclideDataList(int *nRadioNuclides) {
	int i;
	char **rv;

	if (nRadioNuclides != NULL)
		*nRadioNuclides = nNuclideDataList;

	rv = malloc(sizeof(char *)*(nNuclideDataList+1));

	for (i = 0 ; i < nNuclideDataList; i++)
		rv[i] = strdup(nuclideDataList[i].name);

	rv[nNuclideDataList] = NULL;

	return rv;
}

void FreeRadioNuclideData(struct radioNuclideData *radioNuclideData) {
	free(radioNuclideData->name);
	free(radioNuclideData->XrayLines);
	free(radioNuclideData->XrayIntensities);
	free(radioNuclideData->GammaEnergies);
	free(radioNuclideData->GammaIntensities);
	free(radioNuclideData);
}
