/* /////////////////////////////////////////////////////////////////////////////

	y[YE^CO
	   ^[gEOtBNXi{xj̎gp

	2002/11/04 originally written by Masaru Wakasugi
	2003/03/06 modified by Tsuguhiro Tamaribuchi for GrWin

///////////////////////////////////////////////////////////////////////////// */

#include <stdio.h>
#include <math.h>
#include "GrWin.h"

#define RD		(3.1415926535897932385/180.0)
#define scale	(0.5/cos(36*RD))
/* ************************************************************************** */

void rhombusF(int, int, double, double, double, double);
void rhombusS(int, int, double, double, double, double);

int main(void)
{
	int i = 0, 
		m = 5,
		n = 3,
		t = 0;
	double x0 = 100.0,
		  y0 = 100.0,
		leng = 50.0,
		angle;
	double min;

	printf ("seed (1-8) ? "); scanf ("%d", &m);
	printf ("generation (0-7) ? "); scanf ("%d", &n);

	min = leng / pow(2*cos(36*RD), n + 1) * cos(72*RD);

	GWopen(0);
	GWindow(100.0, -10.0, 100.0, 210.0);
	GWrect(0.0, 0.0, 200.0, 200.0);
	t = GWDTspawn(t, 1, 16);

	GWDTsetcol(t, 13);
	do {
		switch (m) {
		default:
		case 1:
			angle = 36.0 / 2.0;
			rhombusS(t, i, x0, y0, leng, angle);
			rhombusF(t, i, 
				x0 + leng*cos(angle*RD),
				y0 + leng*sin(angle*RD),
				leng, angle + 180);
			rhombusF(t, i, 
				x0 + leng*cos((angle + 144)*RD),
				y0 + leng*sin((angle + 144)*RD),
				leng, angle - 108);
			break;
		case 2:
			angle = 54.0 ;
			rhombusF(t, i, x0, y0, leng, angle ) ;
			rhombusF(t, i, x0, y0-leng, leng, angle-36.0 ) ; 
			rhombusF(t, i, x0, y0-leng, leng, angle+36.0 ) ;
			rhombusS(t, i, x0+leng*cos((angle)*RD) ,
				y0+leng*sin((angle)*RD) ,
				leng, angle -180.0 ) ; 
			rhombusS(t, i, x0+leng*cos((angle+72.0)*RD) , 
				y0+leng*sin((angle+72.0)*RD) , 
				leng, angle + 108.0 ) ; 
			break ;
		case 3:
			angle = 126.0 ;
			rhombusF(t, i , x0 , y0 , leng , angle ) ;
			rhombusF(t, i , x0 , y0 , leng , angle+72.0 ) ; 
			rhombusF(t, i , x0 , y0 , leng , angle+72.0*2 ) ;
			rhombusF(t, i , x0 , y0 , leng , angle+72.0*3 ) ;
			rhombusS(t, i , x0+leng*cos((angle)*RD) , 
				y0+leng*sin((angle)*RD) , 
				leng , angle - 180.0 ) ; 
			rhombusS(t, i , x0+leng*cos((angle-72.0)*RD) , 
				y0+leng*sin((angle-72.0)*RD) , 
				leng , angle - 36.0 ) ; 
			break ;
		case 4:
			angle = 90.0-36.0 ;
			rhombusF(t, i , x0 , y0 , leng , angle ) ;
			rhombusF(t, i , x0 , y0 , leng , angle+180.0-36.0 ) ; 
			rhombusF(t, i , x0 , y0 , leng , angle+180.0+36.0 ) ;
			rhombusS(t, i , x0+leng*cos((angle)*RD) , 
				y0+leng*sin((angle)*RD) , 
				leng , angle - 180.0 ) ; 
			rhombusS(t, i , x0+leng*cos((angle-72.0)*RD) , 
				y0+leng*sin((angle-72.0)*RD) , 
				leng , angle - 36.0 ) ; 
			rhombusS(t, i , x0+leng*cos((angle+72.0)*RD) , 
				y0+leng*sin((angle+72.0)*RD) , 
				leng , angle +72.0+36.0 ) ; 
			rhombusS(t, i , x0+leng*cos((angle+72.0+36.0*2)*RD) , 
				y0+leng*sin((angle+72.0+36.0*2)*RD) , 
				leng , angle - 36.0 ) ; 
			break ;
		case 5:
			angle = -90;
			rhombusF(t, i, x0, y0, leng, angle);
			rhombusF(t, i, x0, y0, leng, angle + 72);
			rhombusF(t, i, x0, y0, leng, angle + 72 * 2);
			rhombusF(t, i, x0, y0, leng, angle + 72 * 3);
			rhombusF(t, i, x0, y0, leng, angle + 72 * 4);
			break;
		case 6 :
			angle = 54.0 ;
			rhombusF(t, i , x0+leng*2*cos((36.0)*RD)*cos((angle+36.0)*RD) , 
				y0+leng*2*cos((36.0)*RD)*sin((angle+36.0)*RD),
				leng , angle+180.0 ) ;
			rhombusS(t, i , x0+leng*2*cos((72.0)*RD)*cos((angle-72.0)*RD) ,
				y0+leng*2*cos((72.0)*RD)*sin((angle-72.0)*RD) ,
				leng , angle+36.0 ) ;
			rhombusS(t, i , x0+leng*2*cos((72.0)*RD)*cos((angle+72.0*2)*RD) , 
				y0+leng*2*cos((72.0)*RD)*sin((angle+72.0*2)*RD) , 
				leng , angle - 108.0 ) ; 
			break ;
		case 7 :
			angle = -36.0/2 ;
			rhombusF(t, i , x0+leng*2*cos((36.0)*RD)*cos((angle+36.0)*RD) , 
				y0+leng*2*cos((36.0)*RD)*sin((angle+36.0)*RD) , 
				leng , angle+180.0 ) ;
			rhombusF(t, i , x0+leng*2*cos((36.0)*RD)*cos((angle+108.0)*RD) , 
				y0+leng*2*cos((36.0)*RD)*sin((angle+108.0)*RD) , 
				leng , angle-108.0 ) ;
			rhombusF(t, i , x0+leng*2*cos((36.0)*RD)*cos((angle+180.0)*RD) , 
				y0+leng*2*cos((36.0)*RD)*sin((angle+180.0)*RD) , 
				leng , angle-36.0 ) ;
			rhombusS(t, i , x0+leng*2*cos((72.0)*RD)*cos((angle-72.0)*RD) , 
				y0+leng*2*cos((72.0)*RD)*sin((angle-72.0)*RD) , 
				leng , angle +36.0 ) ; 
			break ;
		case 8 :
			angle = 54.0 ;
			rhombusF(t, i , x0+leng*2*cos((36.0)*RD)*cos((angle+36.0)*RD) , 
				y0+leng*2*cos((36.0)*RD)*sin((angle+36.0)*RD) , 
				leng , angle+180.0 ) ;
			rhombusF(t, i , x0+leng*2*cos((36.0)*RD)*cos((angle+36.0*3)*RD) , 
				y0+leng*2*cos((36.0)*RD)*sin((angle+36.0*3)*RD) , 
				leng , angle-108.0 ) ;
			rhombusF(t, i , x0+leng*2*cos((36.0)*RD)*cos((angle+36.0*5)*RD) , 
				y0+leng*2*cos((36.0)*RD)*sin((angle+36.0*5)*RD) , 
				leng , angle-36.0) ;
			rhombusF(t, i , x0+leng*2*cos((36.0)*RD)*cos((angle+36.0*7)*RD) , 
				y0+leng*2*cos((36.0)*RD)*sin((angle+36.0*7)*RD) , 
				leng , angle+36.0 ) ;
			rhombusF(t, i , x0+leng*2*cos((36.0)*RD)*cos((angle+36.0*9)*RD) , 
				y0+leng*2*cos((36.0)*RD)*sin((angle+36.0*9)*RD) , 
				leng , angle+108.0 ) ;
			break ;
		}
		GWDTsetcol(t, 16);
	} while((n > 0) && ((i += n) <= n));
	GWquit();
	return(0);
}


void rhombusF(int t, int n, double x0, double y0, double leng, double angle)
{
	double ll = leng*scale, ls = leng*(1-scale);
	if (n == 0) {
		GWDTsetpos(t, x0, y0);
		GWDTsetdir(t, angle/360);
		GWDTforward(t, leng);
		GWDTturn(t, 72.0/360);
		GWDTforward(t, leng);
		GWDTturn(t, 108.0/360);
		GWDTforward(t, leng);
		GWDTturn(t, 72.0/360);
		GWDTforward(t, leng);
	} else if (n == 1) {
		GWDTsetpos(t, x0, y0);
		GWDTsetdir(t, angle/360);
		GWDTforward(t, ll);
		GWDTturn(t, 72.0/360);
		GWDTforward(t, ll);
		GWDTturn(t, -144.0/360);
		GWDTforward(t, ll);
		GWDTturn(t, 144.0/360);
		GWDTforward(-t, leng);
		GWDTturn(t, 144.0/360);
		GWDTforward(t, ll);
		GWDTturn(t, -72.0/360);
		GWDTforward(t, ll);
		GWDTturn(t, 108.0/360);
		GWDTforward(-t, ls);
		GWDTturn(t, 108.0/360);
		GWDTforward(t, ll);
		GWDTforward(-t, -ll);
		GWDTturn(t, -108.0/360);
		GWDTforward(t, ll);
	} else {
		rhombusF(t, n - 1, 
			x0 + leng/scale*cos((angle + 36)*RD),
			y0 + leng/scale*sin((angle + 36)*RD),
			ll, angle + 144);
		rhombusF(t, n - 1, 
			x0 + leng/scale*cos((angle + 36)*RD),
			y0 + leng/scale*sin((angle + 36)*RD),
			ll, angle - 144);
		rhombusF(t, n - 1, 
			x0 + leng*cos((angle + 36)*RD),
			y0 + leng*sin((angle + 36)*RD),
			ll, angle + 180);
		rhombusS(t, n - 1, 
			x0 + ll*cos(angle*RD),
			y0 + ll*sin(angle*RD),
			ll, angle - 72);
		rhombusS(t, n - 1, 
			x0 + ll*cos((angle + 72)*RD),
			y0 + ll*sin((angle + 72)*RD),
			ll, angle);
	}
}


void rhombusS(int t, int n, double x0, double y0, double leng, double angle)
{
	double ll = leng*scale, ls = leng*(1-scale);
	if (n == 0) {
		GWDTsetpos(t, x0, y0);
		GWDTsetdir(t, angle/360);
		GWDTforward(t, leng);
		GWDTturn(t, 144.0/360);
		GWDTforward(t, leng);
		GWDTturn(t, 36.0/360);
		GWDTforward(t, leng);
		GWDTturn(t, 144.0/360);
		GWDTforward(t, leng);
	} else if(n == 1) {
		GWDTsetpos(t, x0, y0);
		GWDTsetdir(t, angle/360);
		GWDTforward(-t, ls);
		GWDTturn(t, 108.0/360);
		GWDTforward(t, ll);
		GWDTturn(t, 144.0/360);
		GWDTforward(t, ll);
		GWDTturn(t, -108.0/360);
		GWDTforward(-t, ls);
		GWDTturn(t, -108.0/360);
		GWDTforward(t, ll);
	} else {
		rhombusF(t, n - 1,
			x0 + leng*2*cos(72*RD)*cos((angle + 72)*RD),
			y0 + leng*2*cos(72*RD)*sin((angle + 72)*RD),
			ll, angle - 72);
		rhombusF(t, n - 1,
			x0 + leng*2*cos(72*RD)*cos((angle + 72)*RD),
			y0 + leng*2*cos(72*RD)*sin((angle + 72)*RD),
			ll, angle + 144);
		rhombusS(t, n - 1,
			x0 + ls*cos(angle*RD),
			y0 + ls*sin(angle*RD),
			ll, angle + 108);
		rhombusS(t, n - 1,
			x0 + ls*cos((angle + 144)*RD),
			y0 + ls*sin((angle + 144)*RD),
			ll, angle - 108);
	}
}
