#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef __WATCOMC__
typedef struct CHARACTER {
	char		*p;
	unsigned	l;
} CHARACTER;

#pragma aux LEN_TRIM "^";
int LEN_TRIM(CHARACTER *str)
{
	int l = str->l;
	while(--l >= 0 && str->p[l] == ' ');
	return l+1;
}
#endif

/**GRDATE -- get date and time as character string (Cray)
 *+
 *    SUBROUTINE GRDATE(STRING, L)
 *    CHARACTER*(*) STRING
 *     INTEGER L
 *
 * Return the current date and time, in format 'dd-Mmm-yyyy hh:mm'.
 * To receive the whole string, the STRING should be declared
 * CHARACTER*17.
 *
 * Arguments:
 *  STRING : receives date and time, truncated or extended with
 *           blanks as necessary.
 *  SLEN   : receives the number of characters in STRING, excluding
 *           trailing blanks. This will always be 17, unless the length
 *           of the string supplied is shorter.
 *--
 * 09-Nov-1994 - [mcs] Fortran callable C version for CRAY.
 * 20-May-2003 - modified for OpenWatcom, etc.
 *-----------------------------------------------------------------------
 */
#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GRDATE "^";
void GRDATE(CHARACTER *string, int *slen)
#else
void GRDATE(char *string, int *slen, int maxlen)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
void __stdcall GRDATE(char *string, int maxlen, int *slen)
#else
void grdate_(char *string, int *slen, int maxlen)
#endif
#endif
{
  char vtime[18];  /* Output string compilation buffer */
  char *utime;     /* Returned string from ctime() */
  time_t x;        /* Time returned by time() */
  int i;
/*
 * Get the standard C time string.
 */
  time(&x);
  utime = ctime(&x);
/*
 * Copy a re-organised version of the time string into vtime[].
 */
  vtime[0] = utime[8];
  vtime[1] = utime[9];
  vtime[2] = '-';
  vtime[3] = utime[4];
  vtime[4] = utime[5];
  vtime[5] = utime[6];
  vtime[6] = '-';
  vtime[7] = utime[20];
  vtime[8] = utime[21];
  vtime[9] = utime[22];
  vtime[10] = utime[23];
  vtime[11] = ' ';
  strncpy(vtime+12, utime+11, 5);
  vtime[17]='\0';
/*
 * Copy up to maxlen characters of vtime into the output FORTRAN string.
 */
#ifdef __WATCOMC__
  strncpy(string->p, vtime, string->l);
  *slen = (string->l < 17) ? string->l : 17;
/*
 * Pad the FORTRAN string with spaces.
 */
  for(i=17; i<string->l; i++)
    string->p[i] = ' ';
#else
  strncpy(string, vtime, maxlen);
  *slen = (maxlen < 17) ? maxlen : 17;
/*
 * Pad the FORTRAN string with spaces.
 */
  for(i=17; i<maxlen; i++)
    string[i] = ' ';
#endif
  return;
}

/**GRGENV -- get value of PGPLOT environment parameter
 *+
 *      SUBROUTINE GRGENV(CNAME, CVALUE, LVALUE)
 *      CHARACTER CNAME*(*), CVALUE*(*)
 *      INTEGER   LVALUE
 *
 * Return the value of a PGPLOT environment parameter.
 *
 * Arguments:
 * CNAME   : (input) the name of the parameter to evaluate.
 * CVALUE  : receives the value of the parameter, truncated or extended
 *           with blanks as necessary. If the parameter is undefined,
 *           a blank string is returned.
 * LVALUE  : receives the number of characters in CVALUE, excluding
 *           trailing blanks. If the parameter is undefined, zero is
 *           returned.
 *-----------------------------------------------------------------------
 */
#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GRGENV "^";
void GRGENV(CHARACTER *CNAME, CHARACTER *CVALUE, int *LVALUE)
#else
void GRGENV(char *CNAME, char *CVALUE, int *LVALUE, int CNAME_l, int CVALUE_l)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
void __stdcall GRGENV(char *CNAME, int CNAME_l, char *CVALUE, int CVALUE_l, int *LVALUE)
#else
void grgenv_(char *CNAME, char *CVALUE, int *LVALUE, int CNAME_l, int CVALUE_l)
#endif
#endif
{
	size_t l;
	char ctmp[80], *ctemp;
	strcpy(ctmp, "PGPLOT_");
#ifdef __WATCOMC__
	strncpy(ctmp+7, CNAME->p, CNAME->l);
	ctmp[CNAME->l+7] = '\0';
#else
	strncpy(ctmp+7, CNAME, CNAME_l);
	ctmp[CNAME_l+7] = '\0';
#endif
	ctemp = getenv(ctmp);
	if( ctemp != NULL ) {
#ifdef __WATCOMC__
		strncpy(CVALUE->p, ctemp, CVALUE->l);
		l = CVALUE->l;
		while(--l >= strlen(ctemp))
			CVALUE->p[l] = ' ';
#else
		strncpy(CVALUE, ctemp, CVALUE_l);
		l = CVALUE_l;
		while(--l >= strlen(ctemp))
			CVALUE[l] = ' ';
#endif
		*LVALUE = strlen(ctemp);
	} else {
#ifdef __WATCOMC__
		CVALUE->p[0] = ' ';
#else
		CVALUE[0] = ' ';
#endif
		*LVALUE = 0;
	}
}

/**GRUSER -- get user name
 *+
 *    SUBROUTINE GRUSER(CUSER, LUSER)
 *    CHARACTER CUSER*(*)
 *    INTEGER   LUSER
 *
 * Return the name of the user running the program.
 *
 * Arguments:
 *  CUSER  : receives user name, truncated or extended with
 *           blanks as necessary.
 *  LUSER  : receives the number of characters in VALUE, excluding
 *           trailing blanks.
 *--
 * 1989-Mar-19 - [AFT]
 *-----------------------------------------------------------------------
 */
#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GRUSER "^";
void GRUSER(CHARACTER *CUSER, int *LUSER)
#else
void GRUSER(char *CUSER, int *LUSER, int CUSER_l)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
void __stdcall GRUSER(char *CUSER, int CUSER_l, int *LUSER)
#else
void gruser_(char *CUSER, int *LUSER, int CUSER_l)
#endif
#endif
{
	size_t l;
	char *vlist[] = {"PGPLOT_USER", "USERNAME", "USER", NULL}, **env = vlist, *p;
	while(*env) {
		p = getenv(*env);
		if(p) {
#ifdef __WATCOMC__
			strncpy(CUSER->p, p, CUSER->l);
			l = CUSER->l;
			while(--l >= strlen(p))
				CUSER->p[l] = ' ';
#else
			strncpy(CUSER, p, CUSER_l);
			l = CUSER_l;
			while(--l >= strlen(p))
				CUSER[l] = ' ';
#endif
			*LUSER = strlen(p);
			return;
		}
		++env;
	}
#ifdef __WATCOMC__
	CUSER->p[0] = ' ';
#else
	CUSER[0] = ' ';
#endif
	*LUSER = 0;
}
