/* Brush.c
 *
 * Copyright (C) 1998-2001 by TAMARIBUCHI, Tsuguhiro
 *
 *   WWW: http://sip.sci.shizuoka.ac.jp/grwin
 *
 */

#include "gw.h"

/*1
uV̎w
*******************************************************************************
[F] SUBROUTINE GWSETBRS(IRTN, IBC, IBS, IBH)
    INTEGER IRTN, IBC, IBS, IBH

[C] int GWsetbrs(int IBC, int IBS, int IBH);
-------------------------------------------------------------------------------
()
   JgEEBhEŎgpuV̐FCށCnb`p^[w肷B
   ݒlł΂̍ڂ͕ύXȂBIBC ̏ꍇɂ -1 ȊO̐̕l
   ͕ʂ̈Ӗ̂ŒӁB
-------------------------------------------------------------------------------
(͕ϐ)
  IBC = _Fԍ
         -1 ̏ꍇ͕ύXȂ
         ̑̏ꍇɂĂ GWCOLOR ̍QƁB

  IBS = 0: NULLBRUSH      ̃uV
        1: SOLIDBRUSH     F̃uV
        2: HATCHED        nb` uV
        3: BSPATTERN      p^[ uV(\)
        4: DIBPATTERN     p^[ uV(\)
        5: DIBPATTERNPT   p^[ uV(\)

  IBH = 1: HORIZONTAL     ̃nb`
        2: VERTICAL       ̃nb`
        3: FDIAGONAL      ォEւ 45 x̃nb`
        4: BDIAGONAL      Eւ 45 x̃nb`
        5: CROSS          Åiq̃nb`
        6: DIAGCROSS      45 x̊iq̃nb`
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Set Brush Attributes
*******************************************************************************
[F] SUBROUTINE GWSETBRS(IRTN, IBC, IBS, IBH)
    INTEGER IRTN, IBC, IBS, IBH

[C] int GWsetbrs(int IBC, int IBS, int IBH);
-------------------------------------------------------------------------------
Description
   Set color, style and hatch pattern of the current brush.   If a negative 
   number is specified as an input parameter the corresponding attribute 
   is not changed.    It should be noted that for IBC, negative numbers other 
   than -1 have special meanings.

Input
  IBC >= 0: Logical color number.
      = -1: unchanged
      < -1: Refer to GWCOLOR in this manual

  IBS = 1: SOLIDBRUSH
        2: HATCHED
        3: BSPATTERN    (not implemented)
        4: DIBPATTERN   (not implemented)
        5: DIBPATTERNPT (not implemented)

  IBH = 1: HORIZONTAL
        2: VERTICAL
        3: FDIAGONAL
        4: BDIAGONAL
        5: CROSS
        6: DIAGCROSS

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWSETBRS "^";
#endif
int GWSETBRS(int *ret, int *k, int *style, int *hatch)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWSETBRS(int *ret, int *k, int *style, int *hatch)
#else
int gwsetbrs_(int *ret, int *k, int *style, int *hatch)
#endif
#endif
{
	return (*ret = GW_setbrush(nDOC, *k, *style, *hatch));
}

int GWsetbrs(int k, int style, int hatch)
{

	return GW_setbrush(nDOC, k, style, hatch);
}

int GW_setbrush(int nDoc, int k, int style, int hatch)
{
	if(k != -1) {
		GW_Params(nDoc)->p.GW_flags |= FLG_BCOLOR;
		GW_Params(nDoc)->p.GW_Bc = k;
	}

	if((style >= 0) && (style < NBRUSH)) {
		GW_Params(nDoc)->p.GW_flags |= FLG_BSTYLE;
		GW_Params(nDoc)->p.GW_Bs = style;
	}

	if((hatch >= 0) && (hatch < NHATCH)) {
		GW_Params(nDoc)->p.GW_flags |= FLG_BHATCH;
		GW_Params(nDoc)->p.GW_Bh = hatch;
	}

	return _command1(nDoc, GW_GENDOTOOL, TOOL_SETGDI);
}

/*0
uV̎擾
*******************************************************************************
[F] SUBROUTINE GWGETBRS(IRTN, IBC, IBS, IBH)
    INTEGER IRTN, IBC, IBS, IBH

[C] int GWgetbrs(int *IBC, int *IBS, int *IBH);
-------------------------------------------------------------------------------
()
   JgEEBhEŎgpĂuV̐FCށCnb`p^[擾B
   p^[̈Ӗ GWSETBRS QƁB
-------------------------------------------------------------------------------
(͕ϐ)
   Ȃ
-------------------------------------------------------------------------------
(o͕ϐ)
  IBC = _Fԍ
  IBS = uV̎
  IPW = nb`p^[
 IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Get Brush Attributes
*******************************************************************************
[F] SUBROUTINE GWGETBRS(IRTN, IBC, IBS, IBH)
    INTEGER IRTN, IBC, IBS, IBH

[C] int GWgetbrs(int *IBC, int *IBS, int *IBH);
-------------------------------------------------------------------------------
Description
   Get color, style and hatch pattern of the current brush.    Refer to GWSETBRS 
   to know meanings of parameters .

Input
   None

Output
  IBC = logical color value
  IBS = Style
  IPW = Hatch pattern
 IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWGETBRS "^";
#endif
int GWGETBRS(int *ret, int *c, int *style, int *hatch)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWGETBRS(int *ret, int *c, int *style, int *hatch)
#else
int gwgetbrs_(int *ret, int *c, int *style, int *hatch)
#endif
#endif
{
	return (*ret = GWgetbrs(c, style, hatch));
}

int GWgetbrs(int *c, int *style, int *hatch)
{
	if(c) *c = GW_pParams->p.GW_Bc;
	if(style) *style = GW_pParams->p.GW_Bs;
	if(hatch) *hatch = GW_pParams->p.GW_Bh;
	return nDOC;
}
