#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <windows.h>
#include <math.h>
#include "GrWin.h"

#define X(I) ((float)cos((I)*PAI2/N))
#define Y(I) ((float)sin((I)*PAI2/N))
#define RAND(n) ((rand()-1)/(RAND_MAX/(n)))

#define ID_EDIT       1010
#define ID_BUTTON1    1020
#define ID_BUTTON2    1030

#define BUFFLEN       80

HWND hEWnd, hBWnd1, hBWnd2;

#ifdef _UWIN		// for UWIN 2.X (X > 0)
int main() {return 0;}
#endif

int WINAPI GWinputs(HINSTANCE hInst, HINSTANCE hPrev, LPSTR lpCmd, int nShow);
LRESULT CALLBACK GWinputproc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp);

char szClassName[] = "tstwinapp";
char buff[BUFFLEN];

int WINAPI WinMain (HINSTANCE hInst, HINSTANCE hPrev, LPSTR lpCmd, int nShow)
{
    float PAI2=6.28319f, XM, YM;
    int MCPY=4, MXOR=7, NLBRS=0, NLHCH=0;
    int N, NC, I, J, K=1, IBS, IBH, LLW, LLH, ret;

    ret = GWinputs(hInst, hPrev, lpCmd, nShow);
    if(!strlen(buff)) return ret;
    if(!isdigit((int)buff[0])) return ret;
    if((N = atoi(buff)) < 3) return ret;
    GWopen(0);
    NC = GWncolor();
    GWvport(0.0f,0.0f,1.0f,1.0f);
    if(GWsize(5, &LLW, &LLH)) {
        if(LLW > LLH)
            LLW = LLH;
        else
            LLH = LLW;
        GWsize(-5, &LLW, &LLH);
        GWsize(-3, NULL, NULL);
    }
    GWindow(-1.1f,-1.1f,1.1f,1.1f);
    GWsetpen(K,-1,-1,MXOR);
    for(I=0; I < N - 1; ++I) {
        for(J=I+1; J < N; ++J) {
            K %= NC;
            GWsetpen(K,-1,-1,-1);
            GWline(X(I),Y(I),X(J),Y(J));
            ++K;
        }
    }
    GWsetpen(-999, -1, -1, MCPY);
    GWsetbrs(-1,NLBRS,NLHCH);
    GWrect(-1.05f, -1.05f, 1.05f, 1.05f);
    GWellipse(-1.05f, -1.05f, 1.05f, 1.05f);
    MessageBox (NULL, "Click L-button at any point to fill the area, \n   or at any point near the center to quit.", "Polygon", MB_OK);
    GWcappnt(&XM,&YM,"Click at any point");
    while(XM*XM+YM*YM > 0.1) {
        K = RAND(36);
        IBS = 1 + RAND(2);
        IBH = 1 + RAND(5);
        GWsetbrs(K,IBS,IBH);
        GWflood(XM,YM);
        GWcappnt(&XM,&YM,"Click at any point");
    }
    GWquit();
    return 0;
}

int WINAPI GWinputs(HINSTANCE hInst, HINSTANCE hPrev, LPSTR lpCmd, int nShow)
{
    MSG msg;
    HWND hWnd;
    WNDCLASS wc;

    if (!hPrev) {
        wc.style = CS_HREDRAW | CS_VREDRAW;
        wc.lpfnWndProc = GWinputproc;
        wc.cbClsExtra = 0;
        wc.cbWndExtra = 0;
        wc.hInstance = hInst;
        wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
        wc.hCursor = LoadCursor(NULL, IDC_ARROW);
        wc.hbrBackground = GetStockObject(WHITE_BRUSH);
        wc.lpszMenuName = NULL;
        wc.lpszClassName = (LPCSTR)szClassName;
        if (!RegisterClass(&wc))
             return FALSE;
    }

    if(!(hWnd = CreateWindow(szClassName,
            "Input # of vertices",
            WS_OVERLAPPED | WS_SYSMENU,          // window style
            CW_USEDEFAULT,        // horizontal position of window
            CW_USEDEFAULT,        // vertical position of window
            310,        // window width
            120,        // window height
            NULL, NULL, hInst, NULL)))
        return FALSE;
    ShowWindow(hWnd, nShow);
    UpdateWindow(hWnd);

    while (GetMessage(&msg, NULL, 0, 0)) {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }
    lpCmd = NULL;
    return msg.wParam;
}


LRESULT CALLBACK GWinputproc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
    int id;
    PAINTSTRUCT ps;
    HDC hdc;
    HINSTANCE hInst;

    switch (msg) {
        case WM_CREATE:
            hInst = ((LPCREATESTRUCT)lp)->hInstance;
            hEWnd = CreateWindow("EDIT",     // edit control
                "input here",                // initial string
                WS_CHILD | WS_VISIBLE | WS_BORDER, // window style
                50,                // horizontal position of window
                10,                // vertical position of window
                200,               // window width
                20,                // window height
                hWnd,              // handle to parent or owner window
                (HMENU)ID_EDIT,    // handle to menu or child-window identifier
                hInst,             // handle to application instance
                NULL);
            hBWnd1 = CreateWindow("BUTTON",
                "Ok",
                WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
                40, 50,
                100, 30,
                hWnd,
                (HMENU)ID_BUTTON1,
                hInst,
                NULL);
            hBWnd2 = CreateWindow("BUTTON",
                "Cancel",
                WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
                160, 50,
                100, 30,
                hWnd,
                (HMENU)ID_BUTTON2,
                hInst,
                NULL);
            break;
        case WM_PAINT:
            hdc = BeginPaint(hWnd, &ps);
            TextOut(hdc, 10, 10, (LPCTSTR)"N = ", 4); 
            EndPaint(hWnd, &ps);
            break;
        case WM_COMMAND:
            switch (LOWORD(wp)) {
                case ID_BUTTON1:
                    GetWindowText(hEWnd, (LPTSTR)buff, BUFFLEN);
                    DestroyWindow(hWnd);
                    break;
                case ID_BUTTON2:
                    buff[0] = '\0';
                    DestroyWindow(hWnd);
                    break;
                default:
                    return(DefWindowProc(hWnd, msg, wp,lp));
            }
            break;
        case WM_CLOSE:
            id = MessageBox(hWnd,
                (LPCSTR)"Ok ?",
                (LPCSTR)"Close",
                MB_YESNO | MB_ICONQUESTION);
            if (id == IDYES) {
                DestroyWindow(hWnd);
            }
            break;
        case WM_DESTROY:
            PostQuitMessage(0);
            break;
        default:
            return (DefWindowProc(hWnd, msg, wp, lp));
    }
    return 0L;
}
