      PARAMETER(PAI2=6.28319)
      EXTERNAL F1,F2
      REAL F1,F2
      CHARACTER BUFF*80
      DATA K/1/
      DATA X1,X2,Y,N,MN/0.0,PAI2,1.0,100,20/
      DATA M1,M2,M3,S,SS/6,5,4,0.1,0.2/
      CALL GWOPEN(ID,0)
      CALL GWINDOW(IR,-.3,-1.1,PAI2+0.3,1.1)
      CALL GWLINE(IR,-.1,0.0,PAI2+0.1,0.0)
      CALL GWSETTXT(IR,0.1, 0.0, 3, 0, -1, ' ')
      CALL GWPUTTXT(IR,PAI2, -0.02, 'X-axis')
      CALL GWLINE(IR,0.0,1.1,0.0,-1.1)
      CALL GWSETTXT(IR,-1.0, 0.25, 2, -1, -1, ' ')
      CALL GWPUTTXT(IR,-0.02, 1.0, 'Y-axis')
      CALL GWSETMRK(IR,-1,S,K,-1,-1)
      CALL PLOTFN(X1, X2, N, MN, M1, K, F1)
      CALL PLOTFN(X1, X2, N, MN, M2, K, F2)
      X = PAI2*0.425
      CALL GWSETTXT(IR,SS, ATAN(COS(X+S)/GWASPECT(-1))/PAI2, 
     +   6, -1, -1, '*')
C    +   6, -1, -1, 'Arial')
      CALL GWPUTTXT(IR,X+S, SIN(X)+S, 'sin')
      X = PAI2*0.325
      CALL GWSETTXT(IR,-1.0, ATAN(-SIN(X+S)/GWASPECT(-1))/PAI2, 
     +   6, -1, -1, ' ')
      CALL GWPUTTXT(IR,X+S, COS(X)+S, 'cos')
      K=MOD(K+1,36)
      CALL GWSETMRK(IR,M3,S,K,-1,-1)
      WRITE(BUFF,*) X,Y,K
  100 DO WHILE(X**2+Y**2.GT.0.1)
         CALL GWCAPPNT(KI,X,Y,BUFF)
         K=MOD(K+1,36)
         CALL GWSETMRK(IR,-1,-1.0,K,-1,-1)
         CALL GWPUTMRK(IR,X,Y)
         WRITE(BUFF,*) X,Y,KI,K
         WRITE(*,*) X,Y,KI,K
      END DO
      IRET = MSGBOX('Quit ?')
      if(IRET.NE.1) THEN
         X = 1
         GOTO 100
      ENDIF
      CALL GWQUITX(IR,0)
      END

      SUBROUTINE PLOTFN(X1, X2, N, MN, MK, K, F)
      WRITE(*,*) X1, X2, N, MN, MK
      X0 = X1
      DO I=1,N
         X = I*(X2-X1)/N
         Y = F(X)
         CALL GWLINE(IR,X0,F(X0),X,F(X))
         X0 = X
      END DO
      DO I=0,MN
         X = I*(X2-X1)/MN
         Y = F(X)
         K=MOD(K+1,36)
         CALL GWSETMRK(IR,MK,-1.0,K,-1,-1)
         CALL GWPUTMRK(IR,X,Y)
      END DO
      END

      FUNCTION F1(X)
      F1 = SIN(X)
      END

      FUNCTION F2(X)
      F2 = COS(X)
      END
