      PARAMETER(TRH = 0.4330127, TRHM = -TRH, PI = 3.141592)
      CHARACTER S*80
      DATA RX, RY/-0.5, TRHM/
      DATA GX, GY/ 0.0, TRH/
      DATA BX, BY/ 0.5, TRHM/
      DATA ID,MX,ND/0,11,256/, A/2.0/
      DATA S/'testmix'/
      DATA IBC,IBS,IBH/0,1,0/
      DATA X1, X2/0.0,1.0/
      WRITE(*,*) 'Mix Mode:'
      WRITE(*,*) '    0:NOP'
      WRITE(*,*) '    1:BLACK'
      WRITE(*,*) '    2:WHITE'
      WRITE(*,*) '    3:NOT'
      WRITE(*,*) '    4:COPYPEN'
      WRITE(*,*) '    5:MASKPEN'
      WRITE(*,*) '    6:MERGEPEN'
      WRITE(*,*) '    7:XORPEN'
      WRITE(*,*) '    8:NOTCOPYPEN'
      WRITE(*,*) '    9:NOTMASKPEN'
      WRITE(*,*) '   10:NOTMERGEPEN'
      WRITE(*,*) '   11:NOTXORPEN'
      WRITE(*,*) '   12:MASKNOTPEN'
      WRITE(*,*) '   13:MASKPENNOT'
      WRITE(*,*) '   14:MERGENOTPEN'
      WRITE(*,*) '   15:MERGEPENNOT'
      WRITE(*,'(A,$)') 'Enter MIX mode (0-15): '
      READ(*,*) MX
      CALL GWOPENX(ID, 0, -1, -1, -1, -1, -1, S)
      CALL GWVPORT(IR,0.0,0.0,1.0,1.0)
      IF(ID.EQ.0) STOP '''failed to open a window''\n'
      CALL GWSIZE(IR,1, LLW, LLH)
      CALL GWSIZE(IR,2, LW, LH)
      CALL GWSIZE(IR,3, LFW, LFH)
      CALL GWSIZE(IR,4, LSW, LSH)
      WRITE(*,*) '   Size:',LLW,' x',LLH
      WRITE(*,*) '   View:',LW,' x',LH
      WRITE(*,*) '  Frame:',LFW,' x',LFH
      WRITE(*,*) ' Screen:',LSW,' x',LSH

      CALL GWVPORT(IR,0.0,0.0,1.0,1.0)
      CALL GWINDOW(IR,-A*1.1,-A*1.1,A*1.1,A*1.1)
      WH = 2*A/ND
      CALL GWmode(IR,3,0)
      DO iy = 0, ND - 1
         y = iy * WH - A
         DO ix = 0, ND - 1
            x = ix * WH - A
            r = (x**2+y**2)**(0.3)
            ired = 256*SQRT((x-RX)**2+(y-RY)**2)*r
            IF(ired .GT. 255) ired = 255
            igreen = 256*SQRT((x-GX)**2+(y-GY)**2)*r
            IF(igreen .GT. 255) igreen = 255
            iblue = 256*SQRT((x-BX)**2+(y-BY)**2)*r
            IF(iblue .GT. 255) iblue = 255
            IF(ired+igreen+iblue .LT. 3*255)
     +         CALL GWSRECT(IR,x-WH/2,y-WH/2,x+WH/2,y+WH/2,
     +                      KRGB(ired,igreen,iblue))
         ENDDO
      ENDDO
C      CALL GWmode(IR,3,1)

      WRITE(*,*) 
     +   'Drag mouse with L-button then R-button or R-button to quit'
      CALL GWSETPEN(IR,-1,-1,-1,MX)
      DO WHILE(X1.NE.X2)
         CALL GWCAPRECT(IR,X1, Y1, X2, Y2, 'Drag mouse')
         IBC = MOD(IBC+1,36)
         CALL GWSETBRS(IR,IBC,IBS,IBH)
         CALL GWELLIPSE(IR,X1, Y1, X2, Y2)
      ENDDO
      WRITE(S,*) '(', X1, ',', Y1, ' )'
      CALL GWSETTXT(IR,A*0.05, 0.0, -1, -1, -1, ' ')
      CALL GWPUTTXT(IR,X1, Y1, S)
      WRITE(*,*) S
      CALL GWQUIT(IR)
      END
