/* Tortoise.c
 *
 * Copyright (C) 1998-2003 by TAMARIBUCHI, Tsuguhiro
 *
 *   WWW: http://sip.sci.shizuoka.ac.jp/grwin
 *
 */

#include "gw.h"

/*0
^[gF
*******************************************************************************
[F] SUBROUTINE GWTSPAWN(IRTN, IT, IS, M)
    INTEGER IRTN, IT, IS, M

[C] int GWTspawn(int IT, int IS, int M);
-------------------------------------------------------------------------------
()
   ^[gEOtBNX̂߂̃^[g(T)𐶐B^[gƂ̋O
   Ղ`悳B`IuWFNgƂẮCyC}[NCLCrbg}bvC
   R{̉ꂩgpłB^[g͉Cł邱ƂłCe^[g
   ͂̔ԍ (IT)C`IuWFNg̎ (IS)CсC݂̈ʒuƐis
   ƂĎBIT > 0 ̏ꍇɂ́Cw肳ꂽԍ IT ̃^[g𐶐B
   łɎw肳ꂽԍ̃^[g݂ꍇɂ͉ȂBIT = 0 ̏ꍇ
   gĂȂ^[gԍgpB`IuWFNg̎ʂ͓͕ϐ IS 
   w肷B͕ϐ M ̈Ӗ IS ɂقȂB`IuWFNgyC}[
   NCL̉ꂩ̏ꍇɂ́CftHgł̘_FԍC'(^[gԍ) 
   mod 18 + 1'ɐݒ肳BɐꍇCIRTN ɂ͎ۂɐ^[g
   ̔ԍԂC݂̃^[gԍɎۂɐ^[g̔ԍݒ肷B
   IS < 0 ̏ꍇ͕`IuWFNgƂČ݂̃y (GWSETPEN Q) ݒ肳
   Bɂ́C݂̈ʒuƂČ݂̃yʒu (GWLINE2 Q) ݒ肳C
   is͉Eɐݒ肳B
-------------------------------------------------------------------------------
(͕ϐ)
   IT = ^[gԍ
   IS = `IuWFNg̎ (M ̈Ӗ)
      = 1: y (y̘_Fԍ)
      = 2: }[N (}[N̘_Fԍ)
      = 3:* L (L̘_Fԍ)
      = 4:* rbg}bv (rbg}bvԍ)
      = 5:* R{ (R{ԍ)

     iF* ͖T|[gj
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = ۂɐ^[g̔ԍ ( > 0 ), ŝƂ 0
_______________________________________________________________________________
*/
/*E
Tortoise: Create
*******************************************************************************
[F] SUBROUTINE GWTSPAWN(IRTN, IT, IS, M)
    INTEGER IRTN, IT, IS, M

[C] int GWTspawn(int IT, int IS, int M);
-------------------------------------------------------------------------------
Description
   Creates a tortoise for Tortoise Graphics, a.k.a. Turtle Graphics.  A 
   tortoise possesses a graphic object, which is one of a pen, a mark, a 
   symbol, a bitmap or a combo, to leave its trail as graphics and has the 
   current position and the current direction as its attributes.  Any number 
   of tortoises can be created and each tortoise is identified with a positive 
   number, the tortoise number.  The tortoise number of a tortoise to be 
   created can be specified with the input parameter IT.   If IT <= 0 is 
   specified, an available number for the tortoise number is used.  If 
   succeeded this returnes the tortoise number of the one created, otherwise 
   returnes 0 if failed due to a tortoise that has the same tortoise number, 
   for example.  The sort of the graphic object is specified by IS with M.  The 
   initial position is set equal to the current position (see GWLINE2) and the 
   initial direction to the right.  When the specified graphic object is not a 
   bitmap nor a combo, its logical color number is set equal to '(the tortoise 
   number) mod 18 + 1' if none specified.  Other initial attributes of the 
   graphic object are the same as those of the corresponding current object 
   (see GWSETPEN, GWTSETMRK, GWTSETSYM).   As default a pen is used for the 
   graphic object.  

Input
   IT = a tortoise number of a tortoise to be created
   IS = sort of the graphic object (meaning of the input parameter M)
      = 1: pen (the logical color number)
      = 2: mark (the logical color number)
      = 3: symbol (the logical color number) --- not supported yet
      = 4: bitmap (the bitmap number) --- not supported yet
      = 5: combo (the combo number) --- not supported yet

Output
 IRTN = the number of the tortoise created ( > 0 ), 0 if failed.
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWTSPAWN "^";
#endif
int GWTSPAWN(int *ret, int *it, int *s, int *m)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWTSPAWN(int *ret, int *it, int *s, int *m)
#else
int gwtspawn_(int *ret, int *it, int *s, int *m)
#endif
#endif
{
	GW_Params(nDOC)->x = *it;
	GW_Params(nDOC)->y = *s;
	GW_Params(nDOC)->z = *m;
	*ret = _command0(GW_TORTOISE, cDOC, TTS_SPAWN);
	return *ret;
}

int GWTspawn(int it, int s, int m)
{
	GW_Params(nDOC)->x = it;
	GW_Params(nDOC)->y = s;
	GW_Params(nDOC)->z = m;
	return _command0(GW_TORTOISE, cDOC, TTS_SPAWN);
}

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWDTSPAWN "^";
#endif
int GWDTSPAWN(int *ret, int *it, int *s, int *m)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWDTSPAWN(int *ret, int *it, int *s, int *m)
#else
int gwdtspawn_(int *ret, int *it, int *s, int *m)
#endif
#endif
{
	GW_Params(nDOC)->x = *it;
	GW_Params(nDOC)->y = *s;
	GW_Params(nDOC)->z = *m;
	*ret = _command0(GWD_TORTOISE, cDOC, TTS_SPAWN);
	return *ret;
}

int GWDTspawn(int it, int s, int m)
{
	GW_Params(nDOC)->x = it;
	GW_Params(nDOC)->y = s;
	GW_Params(nDOC)->z = m;
	return _command0(GWD_TORTOISE, cDOC, TTS_SPAWN);
}


/*1
^[gFis̕ύX
*******************************************************************************
[F] SUBROUTINE GWTTURN(IRTN, IT, DA)
    INTEGER IRTN, IT
    REAL DA

[F] SUBROUTINE GWDTTURN(IRTN, IT, DA)
    INTEGER IRTN, IT
    REAL*8 DA

[C] int GWTturn(int IT, float DA);

[C] int GWDTturn(int IT, double DA);
-------------------------------------------------------------------------------
()
   ^[gԍ IT > 0 ̃^[ǧ݂̐is DA ωB
-------------------------------------------------------------------------------
(͕ϐ)
   IT = ^[gԍ ( > 0 )
   DA = ^[ǧ̕ω (x 甽vɑpx()/360)
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN > 0F ύXꂽꍇ ( ^[gԍ )
      = 0F sC܂͑ύXȂꍇ
_______________________________________________________________________________
*/
/*E
Tortoise: Turn
*******************************************************************************
[F] SUBROUTINE GWTTURN(IRTN, IT, DA)
    INTEGER IRTN, IT
    REAL DA

[F] SUBROUTINE GWDTTURN(IRTN, IT, DA)
    INTEGER IRTN, IT
    REAL*8 DA

[C] int GWTturn(int IT, float DA);

[C] int GWDTturn(int IT, double DA);
-------------------------------------------------------------------------------
Description
   Turns a specified tortoise by changing the current forward direction by an 
   amount DA.

Input
   IT = the tortoise number ( > 0 )
   DA = change in angle of the forward direction of the tortoise measured with 
        respect to the x-axis in counterclockwise in the unit of deg/360.

Output
 IRTN = the number of the tortoise ( > 0 ), 0 if failed.
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWTTURN "^";
#endif
int GWTTURN(int *ret, int *it, float *a)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWTTURN(int *ret, int *it, float *a)
#else
int gwtturn_(int *ret, int *it, float *a)
#endif
#endif
{
	GW_Params(nDOC)->x = *it;
	GW_Params(nDOC)->c.f.x = *a;
	return (*ret = _command0(GW_TORTOISE, cDOC, TTS_TURN));
}

int GWTturn(int it, float a)
{
	GW_Params(nDOC)->x = it;
	GW_Params(nDOC)->c.f.x = a;
	return _command0(GW_TORTOISE, cDOC, TTS_TURN);
}

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWDTTURN "^";
#endif
int GWDTTURN(int *ret, int *it, double *a)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWDTTURN(int *ret, int *it, double *a)
#else
int gwdtturn_(int *ret, int *it, double *a)
#endif
#endif
{
	GW_Params(nDOC)->x = *it;
	GW_Params(nDOC)->c.d.x = *a;
	return (*ret = _command0(GWD_TORTOISE, cDOC, TTS_TURN));
}

int GWDTturn(int it, double a)
{
	GW_Params(nDOC)->x = it;
	GW_Params(nDOC)->c.d.x = a;
	return _command0(GWD_TORTOISE, cDOC, TTS_TURN);
}


/*1
^[gFOi
*******************************************************************************
[F] SUBROUTINE GWTFORWARD(IRTN, IT, D)
    INTEGER IRTN, IT
    REAL D

[F] SUBROUTINE GWDTFORWARD(IRTN, IT, D)
    INTEGER IRTN, IT
    REAL*8 D

[C] int GWTforward(int IT, float D);

[C] int GWDTforward(int IT, double D);
-------------------------------------------------------------------------------
()
   ^[gԍ |IT| ̃^[g݈ʒu猻݂̐is֋ |D|i[h
   WnjړCIT > 0 ̏ꍇ͒`悷BD < 0 ̏ꍇɂ݂͌̐is
   ƋtɐiށB݈ʒu (x, y)Cis A (px/360) ƂƂCI_
   ̍W
 
     (x + D*cos(2*pi*A), y + D*sin(2*pi*A)) 
 
   ŎZo ( pi ͉~ )BāC[hWn ( GWINDOW Q ) 
   Iɐݒ肳ĂȂꍇɂ́Cʏ̐is̊px A Ŏw肵̂
   قȂĂ܂̂ŗvӁB
-------------------------------------------------------------------------------
(͕ϐ)
 |IT| = ^[gԍ
  |D| = ^[g̈ړ ( [hWn ) 
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN > 0F  ( ^[gԍ )
      = 0F s
_______________________________________________________________________________
*/
/*E
Tortoise: Move Forward
*******************************************************************************
[F] SUBROUTINE GWTFORWARD(IRTN, IT, D)
    INTEGER IRTN, IT
    REAL D

[F] SUBROUTINE GWDTFORWARD(IRTN, IT, D)
    INTEGER IRTN, IT
    REAL*8 D

[C] int GWTforward(int IT, float D);

[C] int GWDTforward(int IT, double D);
-------------------------------------------------------------------------------
Description
   Moves forward (D > 0) or backward (D < 0) the tortoise specified with |IT| 
   from its current position by the distance |D|, and draws a line segment if 
   IT > 0.   The world coordinates of the end point of the move is calculated 
   as

     (x + D*cos(2*pi*A), y + D*sin(2*pi*A)) 

   where (x, y) is the current world position and A the angle of the forward 
   direction (in deg/360) with pi = 3.14...   So it should be note that if the 
   world coordinate system ( see GWINDOW ) is not set isotropic the actual 
   angle of the line segment appeared on your display is different from that 
   expected with the value of the current direction A.

Input
 |IT| = the tortoise number
  |D| = the world distance to the end point

Output
 IRTN = the number of the tortoise ( > 0 ), 0 if failed.
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWTFORWARD "^";
#endif
int GWTFORWARD(int *ret, int *it, float *d)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWTFORWARD(int *ret, int *it, float *d)
#else
int gwtforward_(int *ret, int *it, float *d)
#endif
#endif
{
	GW_Params(nDOC)->x = *it;
	GW_Params(nDOC)->c.f.x = *d;
	return (*ret = _command0(GW_TORTOISE, cDOC, TTS_FORWARD));
}

int GWTforward(int it, float d)
{
	GW_Params(nDOC)->x = it;
	GW_Params(nDOC)->c.f.x = d;
	return _command0(GW_TORTOISE, cDOC, TTS_FORWARD);
}

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWDTFORWARD "^";
#endif
int GWDTFORWARD(int *ret, int *it, double *d)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWDTFORWARD(int *ret, int *it, double *d)
#else
int gwdtforward_(int *ret, int *it, double *d)
#endif
#endif
{
	GW_Params(nDOC)->x = *it;
	GW_Params(nDOC)->c.d.x = *d;
	return (*ret = _command0(GWD_TORTOISE, cDOC, TTS_FORWARD));
}

int GWDTforward(int it, double d)
{
	GW_Params(nDOC)->x = it;
	GW_Params(nDOC)->c.d.x = d;
	return _command0(GWD_TORTOISE, cDOC, TTS_FORWARD);
}


/*1
^[gFΈړ
*******************************************************************************
[F] SUBROUTINE GWTSHIFT(IRTN, IT, DX, DY)
    INTEGER IRTN, IT
    REAL DX, DY

[F] SUBROUTINE GWDTSHIFT(IRTN, IT, DX, DY)
    INTEGER IRTN, IT
    REAL*8 DX, DY

[C] int GWTshift(int IT, float DX, float DY);

[C] int GWDTshift(int IT, double DX, double DY);
-------------------------------------------------------------------------------
()
   ^[gԍ |IT| ̃^[g݈ʒu x  DXCy  DY ړ
   iψʁjCIT > 0 ̏ꍇ͒`悷B
-------------------------------------------------------------------------------
(͕ϐ)
 |IT| = ^[gԍ
   DX = ψʂ X ([hWn)
   DY = ψʂ Y ([hWn)
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN > 0F  ( ^[gԍ )
      = 0F s
_______________________________________________________________________________
*/
/*E
Tortoise: Displace
*******************************************************************************
[F] SUBROUTINE GWTSHIFT(IRTN, IT, DX, DY)
    INTEGER IRTN, IT
    REAL DX, DY

[F] SUBROUTINE GWDTSHIFT(IRTN, IT, DX, DY)
    INTEGER IRTN, IT
    REAL*8 DX, DY

[C] int GWTshift(int IT, float DX, float DY);

[C] int GWDTshift(int IT, double DX, double DY);
-------------------------------------------------------------------------------
Description
   Displaces the tortoise specified with |IT| from its current position by the 
   displacement (DX, DY) given in the world coordinate system, and draws a line 
   segment if IT > 0.  

Input
   IT = the tortoise number ( > 0 )
   DX = the world x component of the displacement
   DY = the world y component of the displacement

Output
 IRTN = the number of the tortoise ( > 0 ), 0 if failed.
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWTSHIFT "^";
#endif
int GWTSHIFT(int *ret, int *it, float *dx, float *dy)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWTSHIFT(int *ret, int *it, float *dx, float *dy)
#else
int gwtshift_(int *ret, int *it, float *dx, float *dy)
#endif
#endif
{
	GW_Params(nDOC)->x = *it;
	GW_Params(nDOC)->c.f.x = *dx;
	GW_Params(nDOC)->c.f.y = *dy;
	return (*ret = _command0(GW_TORTOISE, cDOC, TTS_SHIFT));
}

int GWTshift(int it, float dx, float dy)
{
	GW_Params(nDOC)->x = it;
	GW_Params(nDOC)->c.f.x = dx;
	GW_Params(nDOC)->c.f.y = dy;
	return _command0(GW_TORTOISE, cDOC, TTS_SHIFT);
}

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWDTSHIFT "^";
#endif
int GWDTSHIFT(int *ret, int *it, double *dx, double *dy)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWDTSHIFT(int *ret, int *it, double *dx, double *dy)
#else
int gwdtshift_(int *ret, int *it, double *dx, double *dy)
#endif
#endif
{
	GW_Params(nDOC)->x = *it;
	GW_Params(nDOC)->c.d.x = *dx;
	GW_Params(nDOC)->c.d.y = *dy;
	return (*ret = _command0(GWD_TORTOISE, cDOC, TTS_SHIFT));
}

int GWDTshift(int it, double dx, double dy)
{
	GW_Params(nDOC)->x = it;
	GW_Params(nDOC)->c.d.x = dx;
	GW_Params(nDOC)->c.d.y = dy;
	return _command0(GWD_TORTOISE, cDOC, TTS_SHIFT);
}


/*1
^[gFw_ւ̈ړ
*******************************************************************************
[F] SUBROUTINE GWTMOVE2(IRTN, IT, X, Y)
    INTEGER IRTN, IT
    REAL X, Y

[F] SUBROUTINE GWDTMOVE2(IRTN, IT, X, Y)
    INTEGER IRTN, IT
    REAL*8 X, Y

[C] int GWTmove2(int IT, float X, float Y);

[C] int GWDTmove2(int IT, double X, double Y);
-------------------------------------------------------------------------------
()
   ^[gԍ |IT| ̃^[g݈ʒu_ (X, Y) ֈړCIT > 0 ̏ꍇ
   ͒`悷B
-------------------------------------------------------------------------------
(͕ϐ)
 |IT| = ^[gԍ
    X = I_ X W([hWn)
    Y = I_ Y W([hWn)
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN > 0F  ( ^[gԍ )
      = 0F s
_______________________________________________________________________________
*/
/*E
Tortoise: Move To
*******************************************************************************
[F] SUBROUTINE GWTMOVE2(IRTN, IT, X, Y)
    INTEGER IRTN, IT
    REAL X, Y

[F] SUBROUTINE GWDTMOVE2(IRTN, IT, X, Y)
    INTEGER IRTN, IT
    REAL*8 X, Y

[C] int GWTmove2(int IT, float X, float Y);

[C] int GWDTmove2(int IT, double X, double Y);
-------------------------------------------------------------------------------
Description
   Moves the tortoise specified with |IT| from its current position to the 
   specified end point (X, Y) given in the world coordinate system, and draws a 
   line segment if IT > 0.  
Input
   IT = the tortoise number ( > 0 )
    X = the world x coordinate of the end point
    Y = the world x coordinate of the end point

Output
 IRTN = the number of the tortoise ( > 0 ), 0 if failed.
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWTMOVE2 "^";
#endif
int GWTMOVE2(int *ret, int *it, float *x, float *y)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWTMOVE2(int *ret, int *it, float *x, float *y)
#else
int gwtmove2_(int *ret, int *it, float *x, float *y)
#endif
#endif
{
	GW_Params(nDOC)->x = *it;
	GW_Params(nDOC)->c.f.x = *x;
	GW_Params(nDOC)->c.f.y = *y;
	return (*ret = _command0(GW_TORTOISE, cDOC, TTS_MOVE2));
}

int GWTmove2(int it, float x, float y)
{
	GW_Params(nDOC)->x = it;
	GW_Params(nDOC)->c.f.x = x;
	GW_Params(nDOC)->c.f.y = y;
	return _command0(GW_TORTOISE, cDOC, TTS_MOVE2);
}

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWDTMOVE2 "^";
#endif
int GWDTMOVE2(int *ret, int *it, double *x, double *y)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWDTMOVE2(int *ret, int *it, double *x, double *y)
#else
int gwdtmove2_(int *ret, int *it, double *x, double *y)
#endif
#endif
{
	GW_Params(nDOC)->x = *it;
	GW_Params(nDOC)->c.d.x = *x;
	GW_Params(nDOC)->c.d.y = *y;
	return (*ret = _command0(GWD_TORTOISE, cDOC, TTS_MOVE2));
}

int GWDTmove2(int it, double x, double y)
{
	GW_Params(nDOC)->x = it;
	GW_Params(nDOC)->c.d.x = x;
	GW_Params(nDOC)->c.d.y = y;
	return _command0(GWD_TORTOISE, cDOC, TTS_MOVE2);
}


/*0
^[g𕡐
*******************************************************************************
[F] SUBROUTINE GWTCLONE(IRTN, IT1, IT2)
    INTEGER IRTN, IT1, IT2

[C] int GWTclone(int IT1, int IT2);
-------------------------------------------------------------------------------
()
   ^[gԍ IT1 > 0 ̃^[g^[gԍ IT2 ɃRs[()B
   ԍ IT1 ̃^[g݂ȂCԍ IT2 ̃^[gɑ݂ꍇɂ
   sCȂBIT2 = 0 w肵ꍇɂ͋󂢂Ă^[gԍgB
   ꍇɂ́C݂̃^[gԍRs[̃^[gԍɐݒ肷B
-------------------------------------------------------------------------------
(͕ϐ)
   IT1 = Rs[̃^[gԍ ( > 0 )
   IT2 = Rs[̃^[gԍ ( >= 0 ) 
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = ꂽ^[g̔ԍ ( > 0 ), ŝƂ 0
_______________________________________________________________________________
*/
/*E
Tortoise: Copy
*******************************************************************************
[F] SUBROUTINE GWTCLONE(IRTN, IT1, IT2)
    INTEGER IRTN, IT1, IT2

[C] int GWTclone(int IT1, int IT2);
-------------------------------------------------------------------------------
Description
   Copies a tortoise of the specified number IT1 > 0 to one with the tortoise 
   number IT2 > 0.  If no tortoise with the specified number IT1 does not 
   exists or one with IT2 exists, this routine failes and does nothing.  If 
   IT2 == 0 is specified an available number is used as the destination 
   tortoise number.

Input
   IT1 = the source tortoise number ( > 0 )
   IT2 = the destination tortoise number ( > 0 ) or 0

Output
 IRTN = the number of the tortoise created ( > 0 ), 0 if failed.
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWTCLONE "^";
#endif
int GWTCLONE(int *ret, int *it1, int *it2)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWTCLONE(int *ret, int *it1, int *it2)
#else
int gwtclone_(int *ret, int *it1, int *it2)
#endif
#endif
{
	GW_Params(nDOC)->x = *it1;
	GW_Params(nDOC)->y = *it2;
	*ret = _command0(GW_TORTOISE, cDOC, TTS_CLONE);
	return *ret;
}

int GWTclone(int it1, int it2)
{
	GW_Params(nDOC)->x = it1;
	GW_Params(nDOC)->y = it2;
	return _command0(GW_TORTOISE, cDOC, TTS_CLONE);
}

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWDTCLONE "^";
#endif
int GWDTCLONE(int *ret, int *it1, int *it2)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWDTCLONE(int *ret, int *it1, int *it2)
#else
int gwdtclone_(int *ret, int *it1, int *it2)
#endif
#endif
{
	GW_Params(nDOC)->x = *it1;
	GW_Params(nDOC)->y = *it2;
	*ret = _command0(GWD_TORTOISE, cDOC, TTS_CLONE);
	return *ret;
}

int GWDTclone(int it1, int it2)
{
	GW_Params(nDOC)->x = it1;
	GW_Params(nDOC)->y = it2;
	return _command0(GWD_TORTOISE, cDOC, TTS_CLONE);
}



/*0
^[g菜
*******************************************************************************
[F] SUBROUTINE GWTREMOVE(IRTN, IT)
    INTEGER IRTN, IT

[C] int GWTremove(int IT);
-------------------------------------------------------------------------------
()
   ^[gԍ IT > 0 ̃^[g菜Bw肳ꂽԍ̃^[g݂
   ꍇɂ͉ȂB
-------------------------------------------------------------------------------
(͕ϐ)
   IT = ^[gԍ
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = 菜^[g̔ԍ ( > 0 ), ŝƂ 0
_______________________________________________________________________________
*/
/*E
Tortoise: Remove
*******************************************************************************
[F] SUBROUTINE GWTREMOVE(IRTN, IT)
    INTEGER IRTN, IT

[C] int GWTremove(int IT);
-------------------------------------------------------------------------------
Description
   Removes a tortoise of the specified number IT > 0.  If no tortoise with the 
   specified number exists this routine does nothing.

Input
   IT = a tortoise number of a tortoise to be removed

Output
 IRTN = the number of the tortoise removed ( > 0 ), 0 if failed.
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWTREMOVE "^";
#endif
int GWTREMOVE(int *ret, int *it)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWTREMOVE(int *ret, int *it)
#else
int gwtremove_(int *ret, int *it)
#endif
#endif
{
	GW_Params(nDOC)->x = *it;
	*ret = _command0(GW_TORTOISE, cDOC, TTS_REMOVE);
	return *ret;
}

int GWTremove(int it)
{
	GW_Params(nDOC)->x = it;
	return _command0(GW_TORTOISE, cDOC, TTS_REMOVE);
}

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWDTREMOVE "^";
#endif
int GWDTREMOVE(int *ret, int *it)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWDTREMOVE(int *ret, int *it)
#else
int gwdtremove_(int *ret, int *it)
#endif
#endif
{
	GW_Params(nDOC)->x = *it;
	*ret = _command0(GWD_TORTOISE, cDOC, TTS_REMOVE);
	return *ret;
}

int GWDTremove(int it)
{
	GW_Params(nDOC)->x = it;
	return _command0(GWD_TORTOISE, cDOC, TTS_REMOVE);
}


/*1
^[gʒuݒ
*******************************************************************************
[F] SUBROUTINE GWTSETPOS(IRTN, IT, X, Y)
    INTEGER IRTN, IT
    REAL X, Y

[F] SUBROUTINE GWDTSETPOS(IRTN, IT, X, Y)
    INTEGER IRTN, IT
    REAL*8 X, Y

[C] int GWTsetpos(int IT, float X, float Y);

[C] int GWDTsetpos(int IT, double X, double Y);
-------------------------------------------------------------------------------
()
   ^[gԍ IT > 0 ̃^[g̈ʒuݒ肷B̂Ƃ`͍sȂB
-------------------------------------------------------------------------------
(͕ϐ)
   IT = ^[gԍ ( > 0 )
    X = ^[gʒu X W([hWn)
    Y = ^[gʒu Y W([hWn)
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN > 0F i ^[gԍ )
      = 0F s
_______________________________________________________________________________
*/
/*E
Tortoise: Set Position
*******************************************************************************
[F] SUBROUTINE GWTSETPOS(IRTN, IT, X, Y)
    INTEGER IRTN, IT
    REAL X, Y

[F] SUBROUTINE GWDTSETPOS(IRTN, IT, X, Y)
    INTEGER IRTN, IT
    REAL*8 X, Y

[C] int GWTsetpos(int IT, float X, float Y);

[C] int GWDTsetpos(int IT, double X, double Y);
-------------------------------------------------------------------------------
Description
   Sets the position of a specified tortoise without drawing.

Input
   IT = the tortoise number ( > 0 )
    X = the world x coordinate of the tortoise
    Y = the world x coordinate of the tortoise

Output
 IRTN = the number of the tortoise ( > 0 ), 0 if failed.
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWTSETPOS "^";
#endif
int GWTSETPOS(int *ret, int *it, float *x, float *y)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWTSETPOS(int *ret, int *it, float *x, float *y)
#else
int gwtsetpos_(int *ret, int *it, float *x, float *y)
#endif
#endif
{
	GW_Params(nDOC)->x = *it;
	GW_Params(nDOC)->c.f.x = *x;
	GW_Params(nDOC)->c.f.y = *y;
	return (*ret = _command0(GW_TORTOISE, cDOC, TTS_SETPOS));
}

int GWTsetpos(int it, float x, float y)
{
	GW_Params(nDOC)->x = it;
	GW_Params(nDOC)->c.f.x = x;
	GW_Params(nDOC)->c.f.y = y;
	return _command0(GW_TORTOISE, cDOC, TTS_SETPOS);
}

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWDTSETPOS "^";
#endif
int GWDTSETPOS(int *ret, int *it, double *x, double *y)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWDTSETPOS(int *ret, int *it, double *x, double *y)
#else
int gwdtsetpos_(int *ret, int *it, double *x, double *y)
#endif
#endif
{
	GW_Params(nDOC)->x = *it;
	GW_Params(nDOC)->c.d.x = *x;
	GW_Params(nDOC)->c.d.y = *y;
	return (*ret = _command0(GWD_TORTOISE, cDOC, TTS_SETPOS));
}

int GWDTsetpos(int it, double x, double y)
{
	GW_Params(nDOC)->x = it;
	GW_Params(nDOC)->c.d.x = x;
	GW_Params(nDOC)->c.d.y = y;
	return _command0(GWD_TORTOISE, cDOC, TTS_SETPOS);
}


/*0
^[gʒu̎擾
*******************************************************************************
[F] SUBROUTINE GWTGETPOS(IRTN, IT, X, Y)
    INTEGER IRTN, IT
    REAL X, Y

[F] SUBROUTINE GWDTGETPOS(IRTN, IT, X, Y)
    INTEGER IRTN, IT
    REAL*8 X, Y

[C] int GWTgetpos(int IT, float *X, float *Y);

[C] int GWDTgetpos(int IT, double *X, double *Y);
-------------------------------------------------------------------------------
()
   ^[gԍ IT > 0 ̃^[ǧ݂̈ʒu[hWnŕԂB
-------------------------------------------------------------------------------
(͕ϐ)
   IT = ^[gԍ ( > 0 )
-------------------------------------------------------------------------------
(o͕ϐ)
    X = ^[gʒu X W([hWn)
    Y = ^[gʒu Y W([hWn)
 IRTN > 0F i ^[gԍ )
      = 0F s
_______________________________________________________________________________
*/
/*E
Tortoise: Get Position
*******************************************************************************
[F] SUBROUTINE GWTGETPOS(IRTN, IT, X, Y)
    INTEGER IRTN, IT
    REAL X, Y

[F] SUBROUTINE GWDTGETPOS(IRTN, IT, X, Y)
    INTEGER IRTN, IT
    REAL*8 X, Y

[C] int GWTgetpos(int IT, float *X, float *Y);

[C] int GWDTgetpos(int IT, double *X, double *Y);
-------------------------------------------------------------------------------
Description
   Retrieves the current position in the world coordinate.

Input
   IT = the tortoise number ( > 0 )

Output
    X = the world x coordinate of the tortoise
    Y = the world x coordinate of the tortoise
 IRTN = the number of the tortoise ( > 0 ), 0 if failed.
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWTGETPOS "^";
#endif
int GWTGETPOS(int *ret, int *it, float *x, float *y)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWTGETPOS(int *ret, int *it, float *x, float *y)
#else
int gwtgetpos_(int *ret, int *it, float *x, float *y)
#endif
#endif
{
	GW_Params(nDOC)->x = *it;
	*ret = _command0(GW_TORTOISE, cDOC, TTS_GETPOS);
	if(*ret > 0) {
		*x = GW_Params(nDOC)->c.f.x;
		*y = GW_Params(nDOC)->c.f.y;
	}
	return *ret;
}

int GWTgetpos(int it, float *x, float *y)
{
	int ret;
	GW_Params(nDOC)->x = it;
	ret = _command0(GW_TORTOISE, cDOC, TTS_GETPOS);
	if(ret > 0) {
		GW_asgn(x, GW_Params(nDOC)->c.f.x);
		GW_asgn(y, GW_Params(nDOC)->c.f.y);
	}
	return ret;
}

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWDTGETPOS "^";
#endif
int GWDTGETPOS(int *ret, int *it, double *x, double *y)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWDTGETPOS(int *ret, int *it, double *x, double *y)
#else
int gwdtgetpos_(int *ret, int *it, double *x, double *y)
#endif
#endif
{
	GW_Params(nDOC)->x = *it;
	*ret = _command0(GWD_TORTOISE, cDOC, TTS_GETPOS);
	if(*ret > 0) {
		*x = GW_Params(nDOC)->c.d.x;
		*y = GW_Params(nDOC)->c.d.y;
	}
	return *ret;
}

int GWDTgetpos(int it, double *x, double *y)
{
	int ret;
	GW_Params(nDOC)->x = it;
	ret = _command0(GWD_TORTOISE, cDOC, TTS_GETPOS);
	if(ret > 0) {
		GW_asgn(x, GW_Params(nDOC)->c.d.x);
		GW_asgn(y, GW_Params(nDOC)->c.d.y);
	}
	return ret;
}


/*1
^[gFis̐ݒ
*******************************************************************************
[F] SUBROUTINE GWTSETDIR(IRTN, IT, A)
    INTEGER IRTN, IT
    REAL A

[F] SUBROUTINE GWDTSETDIR(IRTN, IT, A)
    INTEGER IRTN, IT
    REAL*8 A

[C] int GWTsetdir(int IT, float A);

[C] int GWDTsetdir(int IT, double A);
-------------------------------------------------------------------------------
()
   ^[gԍ IT > 0 ̃^[g̐isݒ肷B
-------------------------------------------------------------------------------
(͕ϐ)
   IT = ^[gԍ ( > 0 )
    A = ^[g̐is (x 甽vɑp/360)
        |A| >= 1.0 ̏ꍇ݂͌̒lg
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN > 0F ύXꂽꍇ ( ^[gԍ )
      = 0F sC܂͑ύXȂꍇ
_______________________________________________________________________________
*/
/*E
Tortoise: Set Direction
*******************************************************************************
[F] SUBROUTINE GWTSETDIR(IRTN, IT, A)
    INTEGER IRTN, IT
    REAL A

[F] SUBROUTINE GWDTSETDIR(IRTN, IT, A)
    INTEGER IRTN, IT
    REAL*8 A

[C] int GWTsetdir(int IT, float A);

[C] int GWDTsetdir(int IT, double A);
-------------------------------------------------------------------------------
Description
   Sets the forward direction of a specified tortoise.

Input
   IT = the tortoise number ( > 0 )
    A = angle of the forward direction of the tortoise measured with respect to 
        the x-axis in counterclockwise with the unit of deg/360.  This 
        parameter is ignored if |A| >= 1.0.

Output
 IRTN = the number of the tortoise ( > 0 ), 0 if failed.
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWTSETDIR "^";
#endif
int GWTSETDIR(int *ret, int *it, float *a)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWTSETDIR(int *ret, int *it, float *a)
#else
int gwtsetdir_(int *ret, int *it, float *a)
#endif
#endif
{
	GW_Params(nDOC)->x = *it;
	GW_Params(nDOC)->c.f.x = *a;
	return (*ret = _command0(GW_TORTOISE, cDOC, TTS_SETDIR));
}

int GWTsetdir(int it, float a)
{
	GW_Params(nDOC)->x = it;
	GW_Params(nDOC)->c.f.x = a;
	return _command0(GW_TORTOISE, cDOC, TTS_SETDIR);
}

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWDTSETDIR "^";
#endif
int GWDTSETDIR(int *ret, int *it, double *a)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWDTSETDIR(int *ret, int *it, double *a)
#else
int gwdtsetdir_(int *ret, int *it, double *a)
#endif
#endif
{
	GW_Params(nDOC)->x = *it;
	GW_Params(nDOC)->c.d.x = *a;
	return (*ret = _command0(GWD_TORTOISE, cDOC, TTS_SETDIR));
}

int GWDTsetdir(int it, double a)
{
	GW_Params(nDOC)->x = it;
	GW_Params(nDOC)->c.d.x = a;
	return _command0(GWD_TORTOISE, cDOC, TTS_SETDIR);
}


/*0
^[gFis̎擾
*******************************************************************************
[F] SUBROUTINE GWTGETDIR(IRTN, IT, A)
    INTEGER IRTN, IT
    REAL A

[F] SUBROUTINE GWDTGETDIR(IRTN, IT, A)
    INTEGER IRTN, IT
    REAL*8 A

[C] int GWTgetdir(int IT, float *A);

[C] int GWDTgetdir(int IT, double *A);
-------------------------------------------------------------------------------
()
   ^[gԍ IT > 0 ̃^[ǧ݂̐is擾B
-------------------------------------------------------------------------------
(͕ϐ)
   IT = ^[gԍ ( > 0 )
-------------------------------------------------------------------------------
(o͕ϐ)
    A = ^[ǧ (x 甽vɑp/360)
 IRTN > 0F ύXꂽꍇ ( ^[gԍ )
      = 0F sC܂͑ύXȂꍇ
_______________________________________________________________________________
*/
/*E
Tortoise: Get Direction
*******************************************************************************
[F] SUBROUTINE GWTGETDIR(IRTN, IT, A)
    INTEGER IRTN, IT
    REAL A

[F] SUBROUTINE GWDTGETDIR(IRTN, IT, A)
    INTEGER IRTN, IT
    REAL*8 A

[C] int GWTgetdir(int IT, float *A);

[C] int GWDTgetdir(int IT, double *A);
-------------------------------------------------------------------------------
Description
   Gets the forward direction of a specified tortoise.

Input
   IT = the tortoise number ( > 0 )

Output
    A = angle of the forward direction of the tortoise measured with respect to 
        the x-axis in counterclockwise with the unit of deg/360.  
 IRTN = the number of the tortoise ( > 0 ), 0 if failed.
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWTGETDIR "^";
#endif
int GWTGETDIR(int *ret, int *it, float *a)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWTGETDIR(int *ret, int *it, float *a)
#else
int gwtgetdir_(int *ret, int *it, float *a)
#endif
#endif
{
	GW_Params(nDOC)->x = *it;
	*ret = _command0(GW_TORTOISE, cDOC, TTS_GETDIR);
	if(*ret > 0) *a = GW_Params(nDOC)->c.f.x;
	return *ret;
}

int GWTgetdir(int it, float *a)
{
	int ret;
	GW_Params(nDOC)->x = it;
	ret = _command0(GW_TORTOISE, cDOC, TTS_GETDIR);
	if(ret > 0) GW_asgn(a, GW_Params(nDOC)->c.f.x);
	return ret;
}

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWDTGETDIR "^";
#endif
int GWDTGETDIR(int *ret, int *it, double *a)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWDTGETDIR(int *ret, int *it, double *a)
#else
int gwdtgetdir_(int *ret, int *it, double *a)
#endif
#endif
{
	GW_Params(nDOC)->x = *it;
	*ret = _command0(GWD_TORTOISE, cDOC, TTS_GETDIR);
	if(*ret > 0) GW_asgn(a, GW_Params(nDOC)->c.d.x);
	return *ret;
}

int GWDTgetdir(int it, double *a)
{
	int ret;
	GW_Params(nDOC)->x = it;
	ret = _command0(GWD_TORTOISE, cDOC, TTS_GETDIR);
	if(ret > 0) GW_asgn(a, GW_Params(nDOC)->c.d.x);
	return ret;
}


/*1
^[gFF̐ݒ
*******************************************************************************
[F] SUBROUTINE GWTSETCOL(IRTN, IT, IPC)
    INTEGER IRTN, IT, IPC

[C] int GWTsetcol(int IT, int IPC);
-------------------------------------------------------------------------------
()
   ^[gԍ IT > 0 ̃^[g̐Fݒ肷B
-------------------------------------------------------------------------------
(͕ϐ)
   IT = ^[gԍ ( > 0 )
  IPC = _Fԍ (GWCOLOR Q)
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN > 0F ύXꂽꍇ ( ^[gԍ )
      = 0F sC܂͑ύXȂꍇ
_______________________________________________________________________________
*/
/*E
Tortoise: Set Color
*******************************************************************************
[F] SUBROUTINE GWTSETCOL(IRTN, IT, IPC)
    INTEGER IRTN, IT, IPC

[C] int GWTsetcol(int IT, int IPC);
-------------------------------------------------------------------------------
Description
   Sets the color of a specified tortoise.

Input
   IT = the tortoise number ( > 0 )
  IPC = the logical color number (see GWCOLOR)

Output
 IRTN = the number of the tortoise ( > 0 ), 0 if failed.
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWTSETCOL "^";
#endif
int GWTSETCOL(int *ret, int *it, int *pc)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWTSETCOL(int *ret, int *it, int *pc)
#else
int gwtsetcol_(int *ret, int *it, int *pc)
#endif
#endif
{
	GW_Params(nDOC)->x = *it;
	GW_Params(nDOC)->y = *pc;
	*ret = _command0(GW_TORTOISE, cDOC, TTS_SETCOL);
	return *ret;
}

int GWTsetcol(int it, int pc)
{
	GW_Params(nDOC)->x = it;
	GW_Params(nDOC)->y = pc;
	return _command0(GW_TORTOISE, cDOC, TTS_SETCOL);
}

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWDTSETCOL "^";
#endif
int GWDTSETCOL(int *ret, int *it, int *pc)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWDTSETCOL(int *ret, int *it, int *pc)
#else
int gwdtsetcol_(int *ret, int *it, int *pc)
#endif
#endif
{
	GW_Params(nDOC)->x = *it;
	GW_Params(nDOC)->y = *pc;
	*ret = _command0(GWD_TORTOISE, cDOC, TTS_SETCOL);
	return *ret;
}

int GWDTsetcol(int it, int pc)
{
	GW_Params(nDOC)->x = it;
	GW_Params(nDOC)->y = pc;
	return _command0(GWD_TORTOISE, cDOC, TTS_SETCOL);
}


/*1
^[gFF̎擾
*******************************************************************************
[F] SUBROUTINE GWTGETCOL(IPC, IT)
    INTEGER IPC, IT

[C] int GWTgetcol(int IT);
-------------------------------------------------------------------------------
()
   ^[gԍ IT > 0 ̃^[g̐F擾B
-------------------------------------------------------------------------------
(͕ϐ)
   IT = ^[gԍ ( > 0 )
-------------------------------------------------------------------------------
(o͕ϐ)
  IPC <> -1F _Fԍ (GWCOLOR Q)
       = -1F s
_______________________________________________________________________________
*/
/*E
Tortoise: Get Color
*******************************************************************************
[F] SUBROUTINE GWTGETCOL(IPC, IT)
    INTEGER IPC, IT

[C] int GWTgetcol(int IT);
-------------------------------------------------------------------------------
Description
   Gets the color of a specified tortoise.

Input
   IT = the tortoise number ( > 0 )

Output
  IPC <> -1; the logical color number (see GWCOLOR)
       = -1; if failed
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWTGETCOL "^";
#endif
int GWTGETCOL(int *pc, int *it)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWTGETCOL(int *pc, int *it)
#else
int gwtgetcol_(int *pc, int *it)
#endif
#endif
{
	GW_Params(nDOC)->x = *it;
	*pc = _command0(GW_TORTOISE, cDOC, TTS_GETCOL);
	return *pc;
}

int GWTgetcol(int it)
{
	GW_Params(nDOC)->x = it;
	return _command0(GW_TORTOISE, cDOC, TTS_GETCOL);
}

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWDTGETCOL "^";
#endif
int GWDTGETCOL(int *pc, int *it)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWDTGETCOL(int *pc, int *it)
#else
int gwdtgetcol_(int *pc, int *it)
#endif
#endif
{
	GW_Params(nDOC)->x = *it;
	*pc = _command0(GWD_TORTOISE, cDOC, TTS_GETCOL);
	return *pc;
}

int GWDTgetcol(int it)
{
	GW_Params(nDOC)->x = it;
	return _command0(GWD_TORTOISE, cDOC, TTS_GETCOL);
}


/*1
^[gFy̐ݒ
*******************************************************************************
[F] SUBROUTINE GWTSETPEN(IRTN, IT, IPC, IPS, IPW)
    INTEGER IRTN, IT, IPC, IPS, IPW

[C] int GWTsetpen(int IT, int IPC, int IPS, int IPW);
-------------------------------------------------------------------------------
()
   ^[gԍ IT > 0 ̃^[g̃yݒ肷B
-------------------------------------------------------------------------------
(͕ϐ)
   IT = ^[gԍ ( > 0 )
  IPC = _Fԍ (GWCOLOR Q)
  IPS =  (GWCOLOR Q)
  IPW =  (GWCOLOR Q)
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN > 0F ύXꂽꍇ ( ^[gԍ )
      = 0F sC܂͑ύXȂꍇ
_______________________________________________________________________________
*/
/*E
Tortoise: Set Pen Attributes
*******************************************************************************
[F] SUBROUTINE GWTSETPEN(IRTN, IT, IPC, IPS, IPW)
    INTEGER IRTN, IT, IPC, IPS, IPW

[C] int GWTsetpen(int IT, int IPC, int IPS, int IPW);
-------------------------------------------------------------------------------
Description
   Sets the pen attributes of a specified tortoise.

Input
   IT = the tortoise number ( > 0 )
  IPC = the logical color number (see GWCOLOR)
  IPS = pen style (see GWCOLOR)
  IPW = pen width (see GWCOLOR)

Output
 IRTN = the number of the tortoise ( > 0 ), 0 if failed.
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWTPEN "^";
#endif
int GWTSETPEN(int *ret, int *it, int *pc, int *ps, int *pw)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWTSETPEN(int *ret, int *it, int *pc, int *ps, int *pw)
#else
int gwtsetpen_(int *ret, int *it, int *pc, int *ps, int *pw)
#endif
#endif
{
	return (*ret = GWTsetpen(*it, *pc, *ps, *pw));
}

int GWTsetpen(int it, int pc, int ps, int pw)
{
	GW_Params(nDOC)->x = it;
	GW_Params(nDOC)->c.i.p1 = pc;
	if((ps < 0) || (ps >= NPEN)) 
		ps = -1;
	GW_Params(nDOC)->c.i.p2 = ps;
	if(pw < 0) 
		pw = -1;
	GW_Params(nDOC)->c.i.p3 = pw;

	return _command0(GW_TORTOISE, cDOC, TTS_SETPEN);
}

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWDTPEN "^";
#endif
int GWDTSETPEN(int *ret, int *it, int *pc, int *ps, int *pw)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWDTSETPEN(int *ret, int *it, int *pc, int *ps, int *pw)
#else
int gwdtsetpen_(int *ret, int *it, int *pc, int *ps, int *pw)
#endif
#endif
{
	return (*ret = GWDTsetpen(*it, *pc, *ps, *pw));
}

int GWDTsetpen(int it, int pc, int ps, int pw)
{
	GW_Params(nDOC)->x = it;
	GW_Params(nDOC)->c.i.p1 = pc;
	if((ps < 0) || (ps >= NPEN)) 
		ps = -1;
	GW_Params(nDOC)->c.i.p2 = ps;
	if(pw < 0) 
		pw = -1;
	GW_Params(nDOC)->c.i.p3 = pw;

	return _command0(GWD_TORTOISE, cDOC, TTS_SETPEN);
}


#if 0
!/*0
!^[gFy̎擾
!*******************************************************************************
![F] SUBROUTINE GWTGETPEN(IRTN, IT, IPC, IPS, IPW)
!    INTEGER IRTN, IT, IPC, IPS, IPW
!
![C] int GWTgetpen(int IT, int *IPC, int *IPS, int *IPW);
!-------------------------------------------------------------------------------
!()
!   ^[g̃y̘_FԍCC擾B
!-------------------------------------------------------------------------------
!(͕ϐ)
!   IT = ^[gԍ ( > 0 )
!   Ȃ
!-------------------------------------------------------------------------------
!(o͕ϐ)
!  IPC = _Fԍ
!  IPS = 
!  IPW = 
! IRTN = ^[ER[h
!_______________________________________________________________________________
!*/
!/*E
!Tortoise: Get Pen Attributes
!*******************************************************************************
![F] SUBROUTINE GWTGETPEN(IRTN, IT, IPC, IPS, IPW)
!    INTEGER IRTN, IT, IPC, IPS, IPW
!
![C] int GWTgetpen(int IT, int *IPC, int *IPS, int *IPW);
!-------------------------------------------------------------------------------
!Description
!   Get the logical color value, style and width of the pen for the specified 
!   tortoise.
!
!Input
!   IT = the tortoise number ( > 0 )
!   None
!
!Output
!  IPC = the logical color value
!  IPS = style
!  IPW = width
! IRTN = return code
!_______________________________________________________________________________
!*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWTGETPEN "^";
#endif
int GWTGETPEN(int *ret, int *it, int *pc, int *ps, int *pw)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWTGETPEN(int *ret, int *it, int *pc, int *ps, int *pw)
#else
int gwtgetpen_(int *ret, int *it, int *pc, int *ps, int *pw)
#endif
#endif
{
	return (*ret = GWTgetpen(*it, pc, ps, pw));
}

int GWTgetpen(int it, int *pc, int *ps, int *pw)
{
	int ret;
	GW_Params(nDOC)->x = it;
	ret = _command0(GW_TORTOISE, cDOC, TTS_GETPEN);
	if(ret) {
		GW_asgn(pc, GW_Params(nDOC)->c.i.p1);
		GW_asgn(ps, GW_Params(nDOC)->c.i.p2);
		GW_asgn(pw, GW_Params(nDOC)->c.i.p3);
	}
	return ret;
}

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWDTGETPEN "^";
#endif
int GWDTGETPEN(int *ret, int *it, int *pc, int *ps, int *pw)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWDTGETPEN(int *ret, int *it, int *pc, int *ps, int *pw)
#else
int gwdtgetpen_(int *ret, int *it, int *pc, int *ps, int *pw)
#endif
#endif
{
	return (*ret = GWDTgetpen(*it, pc, ps, pw));
}

int GWDTgetpen(int it, int *pc, int *ps, int *pw)
{
	int ret;
	GW_Params(nDOC)->x = it;
	ret = _command0(GWD_TORTOISE, cDOC, TTS_GETPEN);
	if(ret) {
		GW_asgn(pc, GW_Params(nDOC)->c.i.p1);
		GW_asgn(ps, GW_Params(nDOC)->c.i.p2);
		GW_asgn(pw, GW_Params(nDOC)->c.i.p3);
	}
	return ret;
}
#endif


/*1
^[gF}[Nݒ
*******************************************************************************
[F] SUBROUTINE GWTSETMRK(IRTN, IT, MT, S, K, KS, KB, MX)
    INTEGER IRTN, IT, MT, K, KS, KB, MX
    REAL S

[F] SUBROUTINE GWDTSETMRK(IRTN, IT, MT, S, K, KS, KB, MX)
    INTEGER IRTN, IT, MT, K, KS, KB, MX
    REAL*8 S

[C] int GWTsetmrk(int IT, int MT, float S, int K, int KS, int KB, int MX);

[C] int GWDTsetmrk(int IT, int MT, double S, int K, int KS, int KB, int MX);
-------------------------------------------------------------------------------
()
   }[Nԍ MT(0-6)C傫 S([hWn)C}[N̘_Fԍ KC}[N
   wiF̘_Fԍ KBC[h MX w肷B MX > 15 ̏ꍇ (MX-16) 
   ̒l̂܂ "binary raster-operation code[W]" ƂĎgpBK, KB 
   āC̓p[^̒lłΑΉ鑮͕ύXȂBMT  0 
   ꍇ́C傫 SisNZj̓_w肳C̏ꍇC`悳}[N
   傫̓r[i\j[hɉeȂB
-------------------------------------------------------------------------------
(͕ϐ)
   IT = ^[gԍ ( > 0 )
   MT = 0: _
        1: 
        2: {
        3: ~
        4: {Ɓ~d˂킹
        5: 
        6: 
        ̑:  ύXȂ
    S = hbg̑傫(sNZl)
      = }[N̍([hWn) > 0.0
    K = }[Niyj̘_Fԍ(GWCOLOR ̍Q)
        -1 ̏ꍇ͌ݒlg
   KS = }[NiuVj̘_Fԍ(GWCOLOR ̍Q)
        -1 ̏ꍇ͌ݒlg
   KB = }[N̔wiF̘_Fԍ(GWCOLOR ̍Q)
        -1 ̏ꍇ͌ݒlg
      = -100: (default)
   MX = }[N̍[h( GWSETPEN ̍Q)
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Tortoise: Set Mark Attributes
*******************************************************************************
[F] SUBROUTINE GWTSETMRK(IRTN, IT, MT, S, K, KS, KB, MX)
    INTEGER IRTN, IT, MT, K, KS, KB, MX
    REAL S

[F] SUBROUTINE GWDTSETMRK(IRTN, IT, MT, S, K, KS, KB, MX)
    INTEGER IRTN, IT, MT, K, KS, KB, MX
    REAL*8 S

[C] int GWTsetmrk(int IT, int MT, float S, int K, int KS, int KB, int MX);

[C] int GWDTsetmrk(int IT, int MT, double S, int K, int KS, int KB, int MX);
-------------------------------------------------------------------------------
Description
   Sets the mark number MT, the size S in world coordinate, the logical mark 
   color K for the pen, the logical mark color KS for the brush, the logical 
   background mark color KB,  and the mix mode MX to the current mark. 
   When MX > 15, the value (MX-16) is used as the "binary raster operation 
   code [W]".  Negative numbers specified for parameters do not change 
   corresponding attributes, except for K and KB (see GWCOLOR).   If MT = 0 
   is specified, the parameter S is read a size of a dot, precisely a small 
   solid rectangle, in pixels and so the size of any instance of such a dot 
   is independent of the view mode, or not expanded even in 'Zoom in' mode, 
   for example.

Input
   IT = the tortoise number ( > 0 )
   MT = 0: dot
        1: solid rectangle
        2: +
        3: x
        4: superposition of + and X
        5: filled rectangle
        6: filled circle
   others: neglected
    S  = the size of a dot in pixels (MT = 0)
       = the height in the world coordinate > 0.0  (MT > 0)
    K != -1: the logical color value for the pen (see GWCOLOR)
       = -1: unchanged
   KS != -1: the logical color value for the brush (see GWCOLOR)
       = -1: unchanged
   KB != -1: the logical color value for the background (see GWCOLOR)
       = -1: unchanged
       = -100: transparent(default)
   MX = mix mode for the mark (see GWSETPEN)

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWTSETMRK "^";
#endif
int GWTSETMRK(int *ret, int *it, int *t, float *s, int *k, int *ks, int *kb, int *mix)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWTSETMRK(int *ret, int *it, int *t, float *s, int *k, int *ks, int *kb, int *mix)
#else
int gwtsetmrk_(int *ret, int *it, int *t, float *s, int *k, int *ks, int *kb, int *mix)
#endif
#endif
{
	GW_Params(nDOC)->x = *it;
	GW_Params(nDOC)->y = *t;
	GW_Params(nDOC)->z = *k;
	GW_Params(nDOC)->c.i.p0 = *ks;
	GW_Params(nDOC)->c.i.p1 = *kb;
	GW_Params(nDOC)->c.f.x = *s;
	GW_Params(nDOC)->Work.Data[0] = *mix;
	*ret = _command0(GW_TORTOISE, cDOC, TTS_SETMRK);
	return *ret;
}

int GWTsetmrk(int it, int t, float s, int k, int ks, int kb, int mix)
{
	GW_Params(nDOC)->x = it;
	GW_Params(nDOC)->y = t;
	GW_Params(nDOC)->z = k;
	GW_Params(nDOC)->c.i.p0 = ks;
	GW_Params(nDOC)->c.i.p1 = kb;
	GW_Params(nDOC)->c.f.x = s;
	GW_Params(nDOC)->Work.Data[0] = mix;
	return _command0(GW_TORTOISE, cDOC, TTS_SETMRK);
}

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWDTSETMRK "^";
#endif
int GWDTSETMRK(int *ret, int *it, int *t, double *s, int *k, int *ks, int *kb, int *mix)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWDTSETMRK(int *ret, int *it, int *t, double *s, int *k, int *ks, int *kb, int *mix)
#else
int gwdtsetmrk_(int *ret, int *it, int *t, double *s, int *k, int *ks, int *kb, int *mix)
#endif
#endif
{
	return (*ret = GWDTsetmrk(*it, *t, *s, *k, *ks, *kb, *mix));
}

int GWDTsetmrk(int it, int t, double s, int k, int ks, int kb, int mix)
{
	GW_Params(nDOC)->x = it;
	GW_Params(nDOC)->y = t;
	GW_Params(nDOC)->z = k;
	GW_Params(nDOC)->c.i.p0 = ks;
	GW_Params(nDOC)->c.i.p1 = kb;
	GW_Params(nDOC)->c.d.x = s;
	GW_Params(nDOC)->Work.Data[0] = mix;
	return _command0(GWD_TORTOISE, cDOC, TTS_SETMRK);
}


#if 0
!/*0
!^[gF}[N̎擾
!*******************************************************************************
![F] SUBROUTINE GWTGETMRK(IRTN, IT, MT, S, K, KS, KB, MX)
!    INTEGER IRTN, IT, MT, K, KS, KB, MX
!    REAL S
!
![F] SUBROUTINE GWDTGETMRK(IRTN, IT, MT, S, K, KS, KB, MX)
!    INTEGER IRTN, IT, MT, K, KS, KB, MX
!    REAL*8 S
!
![C] int GWTgetmrk(int IT, int *MT, float *S, int *K, int *KS, int *KB, int *MX);
!
![C] int GWDTgetmrk(int IT, int *MT, double *S, int *K, int *KS, int *KB, int *MX);
!-------------------------------------------------------------------------------
!()
!   ݂̃}[NԍC}[NTCYC}[Nƃ}[NwiF̘_FԍC[h
!   擾B
!-------------------------------------------------------------------------------
!(͕ϐ)
!   IT = ^[gԍ ( > 0 )
!   Ȃ
!-------------------------------------------------------------------------------
!(o͕ϐ)
!   MT = }[Nԍ
!    S = }[NTCY([hWnŎw肷)
!    K = }[Niyj̐F COLORREF l (GWCOLOR ̍Q)
!   KS = }[NiuVj̐F COLORREF l (GWCOLOR ̍Q)
!   KB = }[N̔wiF COLORREF l (GWCOLOR ̍Q)
!   MX = }[N̍[h( GWSETPEN ̍Q)
! IRTN = ^[ER[h
!_______________________________________________________________________________
!*/
!/*E
!Tortoise: Get Mark Attributes
!*******************************************************************************
![F] SUBROUTINE GWTGETMRK(IRTN, IT, MT, S, K, KS, KB, MX)
!    INTEGER IRTN, IT, MT, K, KS, KB, MX
!    REAL S
!
![F] SUBROUTINE GWDTGETMRK(IRTN, IT, MT, S, K, KS, KB, MX)
!    INTEGER IRTN, IT, MT, K, KS, KB, MX
!    REAL*8 S
!
![C] int GWTgetmrk(int IT, int *MT, float *S, int *K, int *KS, int *KB, int *MX);
!
![C] int GWDTgetmrk(int IT, int *MT, double *S, int *K, int *KS, int *KB, int *MX);
!-------------------------------------------------------------------------------
!Description
!   Gets mark number, mark size, mark color, mark background color and mix mode 
!   for the current mark.
!
!Input
!   IT = the tortoise number ( > 0 )
!   None
!
!Output
!   MT = mark number
!    S = mark height in the world coordinate
!    K = the COLORREF value of the pen (see GWCOLOR)
!   KS = the COLORREF value of the brush (see GWCOLOR)
!   KB = the COLORREF value of the background (see GWCOLOR)
!   MX = mix mode for the mark (see GWSETPEN)
! IRTN = return code
!_______________________________________________________________________________
!*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWTGETMRK "^";
#endif
int GWTGETMRK(int *ret, int *it, int *t, float *s, int *k, int *ks, int *kb, int *m)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWTGETMRK(int *ret, int *it, int *t, float *s, int *k, int *ks, int *kb, int *m)
#else
int gwtgetmrk_(int *ret, int *it, int *t, float *s, int *k, int *ks, int *kb, int *m)
#endif
#endif
{
	return (*ret = GWTgetmrk(*it, t, s, k, ks, kb, m));
}

int GWTgetmrk(int it, int *t, float *s, int *k, int *ks, int *kb, int *m)
{
	int ret;
	GW_Params(nDOC)->x = it;
	ret = _command0(GW_TORTOISE, cDOC, TTS_GETMRK);
	if(ret) {
		GW_asgn(t, GW_Params(nDOC)->y);
		GW_asgn(k, GW_Params(nDOC)->z);
		GW_asgn(ks, GW_Params(nDOC)->c.i.p0);
		GW_asgn(kb, GW_Params(nDOC)->c.i.p1);
		GW_asgn(s, GW_Params(nDOC)->c.f.x);
		GW_asgn(m, GW_Params(nDOC)->Work.Data[0]);
	}
	return ret;
}

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWDTGETMRK "^";
#endif
int GWDTGETMRK(int *ret, int *it, int *t, double *s, int *k, int *ks, int *kb, int *m)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWDTGETMRK(int *ret, int *it, int *t, double *s, int *k, int *ks, int *kb, int *m)
#else
int gwdtgetmrk_(int *ret, int *it, int *t, double *s, int *k, int *ks, int *kb, int *m)
#endif
#endif
{
	float fs = (float)*s;
	*ret = GWTgetmrk(*it, t, &fs, k, ks, kb, m);
	*s = (float)fs;
	return *ret;
}

int GWDTgetmrk(int it, int *t, double *s, int *k, int *ks, int *kb, int *m)
{
	int ret;
	if(s) {
		float fs = (float)*s;
		ret = GWTgetmrk(*it, t, &fs, k, ks, kb, m);
		*s = (double)fs;
	} else
		ret = GWTgetmrk(*it, t, NULL, k, ks, kb, m);
	return ret;
}


!/*1
!^[gFLtHg̐ݒ
!*******************************************************************************
![F] SUBROUTINE GWTSETSYM(IRTN, IT, M)
!    INTEGER IRTN, IT, M
!
![C] int GWTsetsym(int IT, int M);
!-------------------------------------------------------------------------------
!()
!   ^[g̋LtHg̑ݒ肷B
!-------------------------------------------------------------------------------
!(͕ϐ)
!   IT  = ^[gԍ ( > 0 )
!   |M| = R[h
!    M  > 0: ]p͌Œ
!       < 0: isɂ킹ĉ]
!      == 0: ^[g̋LtHg̑C݂̋LtHg̑iGWSETSYM QƁjƓɂB
!-------------------------------------------------------------------------------
!(o͕ϐ)
!  IRTN = ^[ER[h
!_______________________________________________________________________________
!*/
!/*E
!Tortoise: Set Symbol Font
!*******************************************************************************
![F] SUBROUTINE GWTSETSYM(IRTN, IT, M)
!    INTEGER IRTN, IT, M
!
![C] int GWTsetsym(int IT, int IR);
!-------------------------------------------------------------------------------
!Description
!   Sets attributes for the current symbol font of the specified tortoise.
!
!Input
!    IT = the tortoise number ( > 0 )
!   |M| = the character code for the symbol font
!    M  > 0: sets in the fixed mode, where the symbol character is not rotated.
!       < 0: sets in the rotation mode, where the symbol character is rotated 
!            according to the current forward direction in each of subsequent 
!            draws.
!      == 0: sets the attributes for the current symbol font of the specified 
!            tortoise using the current symbol font (see GWSETSYM).
!
!Output
!  IRTN = return code
!_______________________________________________________________________________
!*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWTSETSYM "^";
int GWTSETSYM(int *ret, int *it, int *m)
#else
int GWTSETSYM(int *ret, int *it, int *m)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWTSETSYM(int *ret, int *it, int *m)
#else
int gwtsetsym_(int *ret, int *it, int *m)
#endif
#endif
{
	return (*ret = GWTsetsym(*it, *m));
}

int GWTsetsym(int it, int m)
{
	GW_Params(nDOC)->x = it;
	GW_Params(nDOC)->c.i.p0 = m;
	return _command0(GW_TORTOISE, cDOC, TTS_SETSYM);
}

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWDTSETSYM "^";
int GWDTSETSYM(int *ret, int *it, int *m)
#else
int GWDTSETSYM(int *ret, int *it, int *m)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWDTSETSYM(int *ret, int *it, int *m)
#else
int gwdtsetsym_(int *ret, int *it, int *m)
#endif
#endif
{
	GW_Params(nDOC)->x = *it;
	GW_Params(nDOC)->c.i.p0 = *m;
	return *ret = _command0(GWD_TORTOISE, cDOC, TTS_SETSYM);
}

int GWDTsetsym(int it, int m)
{
	GW_Params(nDOC)->x = it;
	GW_Params(nDOC)->c.i.p0 = m;
	return _command0(GWD_TORTOISE, cDOC, TTS_SETSYM);
}


!/*0
!^[gFL̎擾
!*******************************************************************************
![F] SUBROUTINE GWTGETSYM(IRTN, IT, W, H, IC)
!    INTEGER IRTN, IT, IC
!    REAL W, H
!
![F] SUBROUTINE GWDTGETSYM(IRTN, IT, W, H, IC)
!    INTEGER IRTN, IT, IC
!    REAL*8 W, H
!
![C] int GWTgetsym(int IT, float *W, float *H, int *IC);
!
![C] int GWDTgetsym(int IT, double *W, double *H, int *IC);
!-------------------------------------------------------------------------------
!()
!    ݂̋LR[hƋL̃[hWnł̕ƍ擾B
!-------------------------------------------------------------------------------
!(͕ϐ)
!   IT  = ^[gԍ ( > 0 )
!     W = ^[gԍ
!-------------------------------------------------------------------------------
!(o͕ϐ)
!     W = L̕([hWn)
!     H = L̍([hWn)
!    IC = LR[h(0`255)
!  IRTN = ^[ER[h
!_______________________________________________________________________________
!*/
!/*E
!Tortoise: Get Symbol Attributes
!*******************************************************************************
![F] SUBROUTINE GWTGETSYM(IRTN, IT, W, H, IC)
!    INTEGER IRTN, IT, IC
!    REAL W, H
!
![F] SUBROUTINE GWDTGETSYM(IRTN, IT, W, H, IC)
!    INTEGER IRTN, IT, IC
!    REAL*8 W, H
!
![C] int GWTgetsym(int IT, float *W, float *H, int *IC);
!
![C] int GWDTgetsym(int IT, double *W, double *H, int *IC);
!-------------------------------------------------------------------------------
!Description
!    Retrieve the current symbolcode and the extent of a symbol in the world 
!    coordinate.
!
!Input
!    IT = the tortoise number
!
!Output
!     W = width of the symbol in the world coordinate
!     H = height of the symbol in the world coordinate
!    IC = symbol code (0..255)
!  IRTN = return code
!_______________________________________________________________________________
!*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWTGETSYM "^";
#endif
int GWTGETSYM(int *ret, int *it, float *w, float *h, int *c)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWTGETSYM(int *ret, int *it, float *w, float *h, int *c)
#else
int gwtgetsym_(int *ret, int *it, float *w, float *h, int *c)
#endif
#endif
{
	return (*ret = GWTgetsym(*it, w, h, c));
}

int GWTgetsym(int it, float *w, float *h, int *c)
{
	int ret;
	GW_Params(nDOC)->x = it;
	ret = _command0(GW_TORTOISE, cDOC, TTS_GETSYM);
	if(ret) {
		GW_asgn(c, GW_Params(nDOC)->y);
		GW_asgn(w, GW_Params(nDOC)->c.f.x);
		GW_asgn(h, GW_Params(nDOC)->c.f.y);
	}
	return ret;
}

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWDTGETSYM "^";
#endif
int GWDTGETSYM(int *ret, int *it, double *w, double *h, int *c)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWDTGETSYM(int *ret, int *it, double *w, double *h, int *c)
#else
int gwdtgetsym_(int *ret, int *it, double *w, double *h, int *c)
#endif
#endif
{
	return (*ret = GWDTgetsym(*it, w, h, c));
}

int GWDTgetsym(int it, double *w, double *h, int *c)
{
	int ret;
	GW_Params(nDOC)->x = it;
	ret = _command0(GWD_TORTOISE, cDOC, TTS_GETSYM);
	if(ret) {
		GW_asgn(c, GW_Params(nDOC)->y);
		GW_asgn(w, GW_Params(nDOC)->c.d.x);
		GW_asgn(h, GW_Params(nDOC)->c.d.y);
	}
	return ret;
}


!/*1
!^[gFrbg}bv̐ݒ
!*******************************************************************************
![F] SUBROUTINE GWTSETBMP(IRTN, IT, NB, W, H, MX, ITR, IRO)
!    INTEGER IRTN, IT, NB, MX, ITR, IRO
!    REAL W, H
!
![F] SUBROUTINE GWDTSETBMP(IRTN, IT, NB, W, H, MX, ITR, IRO)
!    INTEGER IRTN, IT, NB, MX, ITR, IRO
!    REAL*8 W, H
!
![C] int GWTsetbmp(int IT, int NB, float W, float H, int MX, int ITR, int IRO);
!
![C] int GWDTsetbmp(int IT, int NB, double W, double H, int MX, int ITR, int IRO);
!-------------------------------------------------------------------------------
!()
!   ^[g̃rbg}bvݒ肷BIT  IRO āCep[^̈Ӗ
!    GWSETBMP ƓB][hZbg(1)ƕ`掞̐isɍ킹
!   rbg}bv_̂܂ŉ]B
!-------------------------------------------------------------------------------
!(͕ϐ)
!    IT = ^[gԍ
!   IRO = 10*M + IOF
!         M   = 0 ܂ 1: ][h
!         IOF = 0...8: _̈ʒuiGWSETBMP QƁj
!
!   ̓̓p[^ɂĂ GWSETBMP QƁB
!
!-------------------------------------------------------------------------------
!(o͕ϐ)
!  IRTN = ^[ER[h
!_______________________________________________________________________________
!*/
!/*E
!Tortoise: Set Bitmap Attributes
!*******************************************************************************
![F] SUBROUTINE GWTSETBMP(IRTN, IT, NB, W, H, MX, ITR, IRO)
!    INTEGER IRTN, IT, NB, MX, ITR, IRO
!    REAL W, H
!
![F] SUBROUTINE GWDTSETBMP(IRTN, IT, NB, W, H, MX, ITR, IRO)
!    INTEGER IRTN, IT, NB, MX, ITR, IRO
!    REAL*8 W, H
!
![C] int GWTsetbmp(int IT, int NB, float W, float H, int MX, int ITR, int IRO);
!
![C] int GWDTsetbmp(int IT, int NB, double W, double H, int MX, int ITR, int IRO);
!-------------------------------------------------------------------------------
!Description
!   Set attributes for the current bitmap of the tortoise.  Except IT and IRO 
!   all the input parameters have the same meanings as those for GWSETBMP.  If 
!   the ratation mode M is set (1) the bitmap is rotated around the reference 
!   point in each draw with the angle of the direction of the tortoise.
!
!Input
!    IT = the tortoise number
!   IRO = 10*M + IOF
!         M   = 0 or 1: the rotation mode
!         IOF = 0...8: flags for the reference point (See GWSETBMP)
!
!   See GWSETBMP for other input parameters.
!
!Output
!  IRTN = return code
!_______________________________________________________________________________
!*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWTSETBMP "^";
#endif
int GWTSETBMP(int *ret, int *it, int *b, float *w, float *h, int *x, int *t, int *o)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWTSETBMP(int *ret, int *it, int *b, float *w, float *h, int *x, int *t, int *o)
#else
int gwtsetbmp_(int *ret, int *it, int *b, float *w, float *h, int *x, int *t, int *o)
#endif
#endif
{
	return (*ret = GWTsetbmp(*it, *b, *w, *h, *x, *t, *o));
}

int GWTsetbmp(int it, int b, float w, float h, int x, int t, int o)
{
	GW_Params(nDOC)->x = it;
	GW_Params(nDOC)->y = b;
	GW_Params(nDOC)->z = x;
	GW_Params(nDOC)->c.f.x = w;
	GW_Params(nDOC)->c.f.y = h;
	GW_Params(nDOC)->Work.Data[0] = t;
	GW_Params(nDOC)->Work.Data[1] = o;
	return _command0(GW_TORTOISE, cDOC, TTS_SETBMP);
}

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWDTSETBMP "^";
#endif
int GWDTSETBMP(int *ret, int *it, int *b, double *w, double *h, int *x, int *t, int *o)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWDTSETBMP(int *ret, int *it, int *b, double *w, double *h, int *x, int *t, int *o)
#else
int gwdtsetbmp_(int *ret, int *it, int *b, double *w, double *h, int *x, int *t, int *o)
#endif
#endif
{
	GW_Params(nDOC)->x = *it;
	GW_Params(nDOC)->y = *b;
	GW_Params(nDOC)->z = *x;
	GW_Params(nDOC)->c.d.x = *w;
	GW_Params(nDOC)->c.d.y = *h;
	GW_Params(nDOC)->Work.Data[0] = *t;
	GW_Params(nDOC)->Work.Data[1] = *o;
	return *ret = _command0(GWD_TORTOISE, cDOC, TTS_SETBMP);
}

int GWDTsetbmp(int it, int b, double w, double h, int x, int t, int o)
{
	GW_Params(nDOC)->x = it;
	GW_Params(nDOC)->y = b;
	GW_Params(nDOC)->z = x;
	GW_Params(nDOC)->c.d.x = w;
	GW_Params(nDOC)->c.d.y = h;
	GW_Params(nDOC)->Work.Data[0] = t;
	GW_Params(nDOC)->Work.Data[1] = o;
	return _command0(GWD_TORTOISE, cDOC, TTS_SETBMP);
}


!/*1
!^[gFR{̐ݒ
!*******************************************************************************
![F] SUBROUTINE GWTSETCMB(IRTN, IT, NC, W, H, IRO)
!    INTEGER IRTN, IT, NC, IRO
!    REAL W, H
!
![F] SUBROUTINE GWDTSETCMB(IRTN, IT, NC, W, H, IRO)
!    INTEGER IRTN, IT, NC, IRO
!    REAL*8 W, H
!
![C] int GWTsetcmb(int IT, int NC, float W, float H, int IRO);
!
![C] int GWDTsetcmb(int IT, int NC, double W, double H, int IRO);
!-------------------------------------------------------------------------------
!()
!   ^[g̃R{ݒ肷BIT  IRO āCep[^̈Ӗ
!    GWSETCMB ƓB][hZbg(1)ƕ`掞̐isɍ킹
!   R{_̂܂ŉ]B
!-------------------------------------------------------------------------------
!(͕ϐ)
!    IT = ^[gԍ
!   IRO = 10*M + IOF
!         M   = 0 ܂ 1: ][h
!         IOF = 0...8: _̈ʒuiGWSETCMB QƁj
!
!   ̓̓p[^ɂĂ GWSETCMB QƁB
!
!-------------------------------------------------------------------------------
!(o͕ϐ)
!  IRTN = ^[ER[h
!_______________________________________________________________________________
!*/
!/*E
!Tortoise: Set Combo Attributes
!*******************************************************************************
![F] SUBROUTINE GWTSETCMB(IRTN, IT, NC, W, H, IRO)
!    INTEGER IRTN, IT, NC, IRO
!    REAL W, H
!
![F] SUBROUTINE GWDTSETCMB(IRTN, IT, NC, W, H, IRO)
!    INTEGER IRTN, IT, NC, IRO
!    REAL*8 W, H
!
![C] int GWTsetcmb(int IT, int NC, float W, float H, int IRO);
!
![C] int GWDTsetcmb(int IT, int NC, double W, double H, int IRO);
!-------------------------------------------------------------------------------
!Description
!   Set attributes for the current combo of the tortoise.  Except IT and IRO 
!   all the input parameters have the same meanings as those for GWSETCMB.  If 
!   the rotation mode M is set (1) the combo is rotatedaround the reference 
!   point  in each draw with the angle of the direction of the tortoise.
!
!Input
!    IT = the tortoise number
!   IRO = 10*M + IOF
!         M   = 0 or 1: the rotation mode
!         IOF = 0...8: flags for the reference point (See GWSETCMB)
!
!   See GWSETCMB for other input parameters.
!
!Output
!  IRTN = return code
!_______________________________________________________________________________
!*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWTSETCMB "^";
#endif
int GWTSETCMB(int *ret, int *it, int *c, float *w, float *h, int *o)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWTSETCMB(int *ret, int *it, int *c, float *w, float *h, int *o)
#else
int gwtsetcmb_(int *ret, int *it, int *c, float *w, float *h, int *o)
#endif
#endif
{
	return (*ret = GWTsetcmb(*it, *c, *w, *h, *o));
}

int GWTsetcmb(int it, int c, float w, float h, int o)
{
	GW_Params(nDOC)->x = it;
	GW_Params(nDOC)->y = c;
	GW_Params(nDOC)->z = o;
	GW_Params(nDOC)->c.f.x = w;
	GW_Params(nDOC)->c.f.y = h;
	return _command0(GW_TORTOISE, cDOC, TTS_SETCMB);
}

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWDTSETCMB "^";
#endif
int GWDTSETCMB(int *ret, int *it, int *c, double *w, double *h, int *o)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWDTSETCMB(int *ret, int *it, int *c, double *w, double *h, int *o)
#else
int gwdtsetcmb_(int *ret, int *it, int *c, double *w, double *h, int *o)
#endif
#endif
{
	GW_Params(nDOC)->x = *it;
	GW_Params(nDOC)->y = *c;
	GW_Params(nDOC)->z = *o;
	GW_Params(nDOC)->c.d.x = *w;
	GW_Params(nDOC)->c.d.y = *h;
	return *ret =  _command0(GWD_TORTOISE, cDOC, TTS_SETCMB);
}

int GWDTsetcmb(int it, int c, double w, double h, int o)
{
	GW_Params(nDOC)->x = it;
	GW_Params(nDOC)->y = c;
	GW_Params(nDOC)->z = o;
	GW_Params(nDOC)->c.d.x = w;
	GW_Params(nDOC)->c.d.y = h;
	return _command0(GWD_TORTOISE, cDOC, TTS_SETCMB);
}
#endif
