/* Tools.c
 *
 * Copyright (C) 1998-2003 by TAMARIBUCHI, Tsuguhiro
 *
 *   WWW: http://sip.sci.shizuoka.ac.jp/grwin
 *
 */

#include "gw.h"

/*0
yʒu
*******************************************************************************
[F] SUBROUTINE GWGETPOS(IRTN, X, Y)
    INTEGER IRTN
    REAL X, Y

[C] int GWgetpos(float *X, float *Y);
-------------------------------------------------------------------------------
()
   ݂̃yʒu (X, Y) [hWnŕԂB
-------------------------------------------------------------------------------
(͕ϐ)
   Ȃ
-------------------------------------------------------------------------------
(o͕ϐ)
    X = _ X W([hWn)
    Y = _ Y W([hWn)
 IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Pen Position
*******************************************************************************
[F] SUBROUTINE GWGETPOS(IRTN, X, Y)
    INTEGER IRTN
    REAL X, Y

[C] int GWgetpos(float *X, float *Y);
-------------------------------------------------------------------------------
Description
   Retrieves the current pen position in the world coordinate.

Input
   None

Output
    X = the world x-coordinate of the current pen position.
    Y = the world y-coordinate of the current pen position.
 IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWGETPOS "^";
#endif
int GWGETPOS(int *ret, float *x, float *y)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWGETPOS(int *ret, float *x, float *y)
#else
int gwgetpos_(int *ret, float *x, float *y)
#endif
#endif
{
	if(GW_pParams->p.GW_pu < 0) return 0;
	*x = LPtoWCx(GW_pParams->p.GW_pu);
	*y = LPtoWCy(GW_pParams->p.GW_pv);
	return (*ret = nDOC);
}

int GWgetpos(float *x, float *y)
{
	if(GW_pParams->p.GW_pu < 0) return 0;
	GW_asgn(x, LPtoWCx(GW_pParams->p.GW_pu));
	GW_asgn(y, LPtoWCy(GW_pParams->p.GW_pv));
	return nDOC;
}

int GW_getpos(int nDoc, int *u, int *v)
{
	if(GW_Params(nDoc)->p.GW_pu < 0) return 0;
	GW_asgn(u, GW_Params(nDoc)->p.GW_pu);
	GW_asgn(v, GW_Params(nDoc)->p.GW_pv);
	return nDoc;
}


/*1
ÿړ
*******************************************************************************
[F] SUBROUTINE GWMOVE2(IRTN, X, Y)
    INTEGER IRTN
    REAL X, Y

[C] int GWmove2(float X, float Y);
-------------------------------------------------------------------------------
()
   [hWn (X, Y) ɃyړB`ȂB
-------------------------------------------------------------------------------
(͕ϐ)
    X = _ X W([hWn)
    Y = _ Y W([hWn)
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Move Pen
*******************************************************************************
[F] SUBROUTINE GWMOVE2(IRTN, X, Y)
    INTEGER IRTN
    REAL X, Y

[C] int GWmove2(float X, float Y);
-------------------------------------------------------------------------------
Description
   Moves current pen position to the point (X, Y) in the world coordinate.
   Nothing is drawn.

Input
    X = x coordinate of the destination point.
    Y = y coordinate of the destination point.

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWMOVE2 "^";
#endif
int GWMOVE2(int *ret, float *x, float *y)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWMOVE2(int *ret, float *x, float *y)
#else
int gwmove2_(int *ret, float *x, float *y)
#endif
#endif
{
	return (*ret = GW_move2(nDOC, WCtoLPx(*x), WCtoLPy(*y)));
}

int GWmove2(float x, float y)
{
	return GW_move2(nDOC, WCtoLPx(x), WCtoLPy(y));
}


/*1
w肵_܂ł̒
*******************************************************************************
[F] SUBROUTINE GWLINE2(IRTN, X, Y)
    INTEGER IRTN
    REAL X, Y

[C] int GWline2(float X, float Y);
-------------------------------------------------------------------------------
()
   ݂̃y (GWSETPEN Q) gāC݂̃yʒuƎw肳ꂽ[hW
   n̓_ (X, Y) Ԓ`CyʒuXVByʒu`(
   )̏ꍇ́CyʒuXV邾Œ͕`ȂByʒu GWSETPEN 
   ŏłB
-------------------------------------------------------------------------------
(͕ϐ)
    X = _ X W([hWn)
    Y = _ Y W([hWn)
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Draw Line To
*******************************************************************************
[F] SUBROUTINE GWLINE2(IRTN, X, Y)
    INTEGER IRTN
    REAL X, Y

[C] int GWline2(float X, float Y);
-------------------------------------------------------------------------------
Description
   Draws a line connecting the current pen position and the point (X, Y) 
   specified, and then update the current pen position.   The current pen is 
   used to draw the line.  If the pen position is undefined, as in the initial 
   state, no line is drawn.  The pen position can be initialized by GWSETPEN.

Input
    X = the world x-coordinate of the destination point.
    Y = the world y-coordinate of the destination point.

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWLINE2 "^";
#endif
int GWLINE2(int *ret, float *x, float *y)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWLINE2(int *ret, float *x, float *y)
#else
int gwline2_(int *ret, float *x, float *y)
#endif
#endif
{
	return (*ret = GW_line2(nDOC, WCtoLPx(*x), WCtoLPy(*y)));
}

int GWline2(float x, float y)
{
	return GW_line2(nDOC, WCtoLPx(x), WCtoLPy(y));
}


/*2
Q_Ԓ
*******************************************************************************
[F] SUBROUTINE GWLINE(IRTN, X1, Y1, X2, Y2)
    INTEGER IRTN
    REAL X1, Y1, X2, Y2

[C] int GWline(float X1, float Y1, float X2, float Y2);
-------------------------------------------------------------------------------
()
   ݂̃y (GWSETPEN Q) gāC[hWn (X1, Y1)  (X2, Y2) 
   𒼐ŌԁB
-------------------------------------------------------------------------------
(͕ϐ)
   X1 = n_ X W([hWn)
   Y1 = n_ Y W([hWn)
   X2 = I_ X W([hWn)
   Y2 = I_ Y W([hWn)
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Draw Line
*******************************************************************************
[F] SUBROUTINE GWLINE(IRTN, X1, Y1, X2, Y2)
    INTEGER IRTN
    REAL X1, Y1, X2, Y2

[C] int GWline(float X1, float Y1, float X2, float Y2);
-------------------------------------------------------------------------------
Description
   Draws a line connecting the two points (X1, Y1) and (X2, Y2) using the 
   current pen. 

Output
   X1 = x coordinate of the beginning point.
   Y1 = y coordinate of the beginning point.
   X2 = x coordinate of the end point.
   Y2 = y coordinate of the end point.

Output
 IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWLINE "^";
#endif
int GWLINE(int *ret, float *x1, float *y1, float *x2, float *y2)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWLINE(int *ret, float *x1, float *y1, float *x2, float *y2)
#else
int gwline_(int *ret, float *x1, float *y1, float *x2, float *y2)
#endif
#endif
{
	return (*ret = 
		GW_line(nDOC, WCtoLPx(*x1), WCtoLPy(*y1), WCtoLPx(*x2), WCtoLPy(*y2)));
}

int GWline(float x1, float y1, float x2, float y2)
{
	return GW_line(nDOC, WCtoLPx(x1), WCtoLPy(y1), WCtoLPx(x2), WCtoLPy(y2));
}

int GW_line(int nDoc, int u1, int v1, int u2, int v2)
{
	if((GW_Params(nDoc)->p.GW_pu != u1) || (GW_Params(nDoc)->p.GW_pv != v1))
		GW_move2(nDoc, u1, v1);
	return GW_line2(nDoc, u2, v2);
}


/*1
lp`̕`
*******************************************************************************
[F] SUBROUTINE GWRECT(IRTN, X1, Y1, X2, Y2)
    INTEGER IRTN
    REAL X1, Y1, X2, Y2

[C] int GWrect(float X1, float Y1, float X2, float Y2);
-------------------------------------------------------------------------------
()
   ݂̃y (GWSETPEN Q) gāC[hWn̓_P (X1, Y1) Ɠ_Q 
   (X2, Y2) ΊpƂlp``B̂Ƃ݂̃uV (GWSETBRS Q) 
   hB
-------------------------------------------------------------------------------
(͕ϐ)
   X1 = _P X W([hWn)
   Y1 = _P Y W([hWn)
   X2 = _Q X W([hWn)
   Y2 = _Q Y W([hWn)
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Draw Rectangle
*******************************************************************************
[F] SUBROUTINE GWRECT(IRTN, X1, Y1, X2, Y2)
    INTEGER IRTN
    REAL X1, Y1, X2, Y2

[C] int GWrect(float X1, float Y1, float X2, float Y2);
-------------------------------------------------------------------------------
Description
   Draws a rectangle specified by a pair of two diagonal points (X1, Y1) and 
   (X2, Y2).   The current pen is used to draw the rectangle, and the current 
   brush is used to fill the rectangle.

Input
   X1 = the world x-coordinate of the point 1.
   Y1 = the world y-coordinate of the point 1.
   X2 = the world x-coordinate of the point 2.
   Y2 = the world y-coordinate of the point 2.

Output
 IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWRECT "^";
#endif
int GWRECT(int *ret, float *x1, float *y1, float *x2, float *y2)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWRECT(int *ret, float *x1, float *y1, float *x2, float *y2)
#else
int gwrect_(int *ret, float *x1, float *y1, float *x2, float *y2)
#endif
#endif
{
	return (*ret = GW_rectangle(nDOC, 
		WCtoLPx(*x1), WCtoLPy(*y1), WCtoLPx(*x2), WCtoLPy(*y2)));
}

int GWrect(float x1, float y1, float x2, float y2)
{
	return GW_rectangle(nDOC, 
		WCtoLPx(x1), WCtoLPy(y1), WCtoLPx(x2), WCtoLPy(y2));
}

int GW_rectangle(int nDoc, int u1, int v1, int u2, int v2)
{
	GW_Params(nDoc)->c.i.p0 = u1;
	GW_Params(nDoc)->c.i.p1 = v1;
	GW_Params(nDoc)->c.i.p2 = u2;
	GW_Params(nDoc)->c.i.p3 = v2;
	return _command1(nDoc, GW_GENDOTOOL, TOOL_RECTANGLE);
}


/*1
hԂꂽlp`̕`
*******************************************************************************
[F] SUBROUTINE GWSRECT(IRTN, X1, Y1, X2, Y2, K)
    INTEGER IRTN, K
    REAL X1, Y1, X2, Y2

[C] int GWsrect(float X1, float Y1, float X2, float Y2, int K);
-------------------------------------------------------------------------------
()
   [hWn̓_P (X1, Y1) Ɠ_Q (X2, Y2) ΊpƂlp`̓
   _Fԍ K œhԂB
-------------------------------------------------------------------------------
(͕ϐ)
   X1 = _P X W([hWn)
   Y1 = _P Y W([hWn)
   X2 = _Q X W([hWn)
   Y2 = _Q Y W([hWn)
    K = _Fԍ
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Draw Rectangle Filled with Solid Color
*******************************************************************************
[F] SUBROUTINE GWSRECT(IRTN, X1, Y1, X2, Y2, K)
    INTEGER IRTN, K
    REAL X1, Y1, X2, Y2

[C] int GWsrect(float X1, float Y1, float X2, float Y2, int K);
-------------------------------------------------------------------------------
Description
   Fills the given rectangle with the specified solid color in a logical color 
   value (LCV).  The rectangle is specified by a pair of two diagonal points 
   (X1, Y1) and (X2, Y2).

Input
   X1 = the world x-coordinate of the point 1.
   Y1 = the world y-coordinate of the point 1.
   X2 = the world x-coordinate of the point 2.
   Y2 = the world y-coordinate of the point 2.
    K = color in LCV

Output
 IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWSRECT "^";
#endif
int GWSRECT(int *ret, float *x1, float *y1, float *x2, float *y2, int *k)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWSRECT(int *ret, float *x1, float *y1, float *x2, float *y2, int *k)
#else
int gwsrect_(int *ret, float *x1, float *y1, float *x2, float *y2, int *k)
#endif
#endif
{
	return (*ret = GW_solidrect(nDOC, 
		WCtoLPx(*x1), WCtoLPy(*y1), WCtoLPx(*x2), WCtoLPy(*y2),	*k));
}

int GWsrect(float x1, float y1, float x2, float y2, int k)
{
	return GW_solidrect(nDOC, 
		WCtoLPx(x1), WCtoLPy(y1), WCtoLPx(x2), WCtoLPy(y2), k);
}

int GW_solidrect(int nDoc, int u1, int v1, int u2, int v2, int k)
{
	GW_Params(nDoc)->c.i.p0 = u1;
	GW_Params(nDoc)->c.i.p1 = v1;
	GW_Params(nDoc)->c.i.p2 = u2;
	GW_Params(nDoc)->c.i.p3 = v2;
	return _command2(nDoc, GW_GENDOTOOL, TOOL_SOLIDRECT, k);
}


/*1
p̊ۂlp`̕`
*******************************************************************************
[F] SUBROUTINE GWRRECT(IRTN, X1, Y1, X2, Y2, W, H)
    INTEGER IRTN
    REAL X1, Y1, X2, Y2, W, H

[C] int GWrrect(float X1, float Y1, float X2, float Y2, float W, float H);
-------------------------------------------------------------------------------
()
   ݂̃y (GWSETPEN Q) gāC[hWn̓_P (X1, Y1) Ɠ_Q 
   (X2, Y2) ΊpƂlp`ɓڂp̊ۂlp``B ̂Ƃ݂
   uV (GWSETBRS Q) œhBۂp`߂̑ȉ~̕ƍ 
   (W, H) Ŏw肷B
-------------------------------------------------------------------------------
(͕ϐ)
   X1 = _P X W([hWn)
   Y1 = _P Y W([hWn)
   X2 = _Q X W([hWn)
   Y2 = _Q Y W([hWn)
    W = p̑ȉ~̕([hWn)
    H = p̑ȉ~̍([hWn)
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Draw Round Rectangle
*******************************************************************************
[F] SUBROUTINE GWRRECT(IRTN, X1, Y1, X2, Y2, W, H)
    INTEGER IRTN
    REAL X1, Y1, X2, Y2, W, H

[C] int GWrrect(float X1, float Y1, float X2, float Y2, float W, float H);
-------------------------------------------------------------------------------
Description
   Draws a rectangle with rounded corners using the current pen.  The two 
   points (X1, Y1) and (X2, Y2) specify a pair of diagonal points of the 
   bounding rectangle, and (W, H) the width and the height of the ellipse 
   used to draw the rounded corners.  The interior of the rectangle is filled 
   using the current brush.

Input
   X1 = the world x-coordinate of the point 1.
   Y1 = the world y-coordinate of the point 1.
   X2 = the world x-coordinate of the point 2.
   Y2 = the world y-coordinate of the point 2.
    W = the width of the ellipse used to draw the rounded corners.
    H = the height of the ellipse used to draw the rounded corners.

Output
 IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWRRECT "^";
#endif
int GWRRECT(int *ret, float *x1, float *y1, float *x2, float *y2, 
		   float *w, float *h)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWRRECT(int *ret, float *x1, float *y1, float *x2, float *y2, 
		   float *w, float *h)
#else
int gwrrect_(int *ret, float *x1, float *y1, float *x2, float *y2, 
		   float *w, float *h)
#endif
#endif
{
	return (*ret = GW_roundrect(nDOC, 
		WCtoLPx(*x1), WCtoLPy(*y1), WCtoLPx(*x2), WCtoLPy(*y2), 
		WCtoLPw(*w), WCtoLPh(*h)));
}

int GWrrect(float x1, float y1, float x2, float y2, float w, float h)
{
	return GW_roundrect(nDOC, 
		WCtoLPx(x1), WCtoLPy(y1), WCtoLPx(x2), WCtoLPy(y2), 
		WCtoLPw(w), WCtoLPh(h));
}

int GW_roundrect(int nDoc, int u1, int v1, int u2, int v2, int w, int h)
{
	GW_Params(nDoc)->c.i.p0 = u1;
	GW_Params(nDoc)->c.i.p1 = v1;
	GW_Params(nDoc)->c.i.p2 = u2;
	GW_Params(nDoc)->c.i.p3 = v2;
	return _command(nDoc, GW_GENDOTOOL, TOOL_ROUNDRECT, w, h);
}


/*1
ȉ~̕`
*******************************************************************************
[F] SUBROUTINE GWELLIPSE(IRTN, X1, Y1, X2, Y2)
    INTEGER IRTN
    REAL X1, Y1, X2, Y2

[C] int GWellipse(float X1, float Y1, float X2, float Y2);
-------------------------------------------------------------------------------
()
   ݂̃y (GWSETPEN Q) gāC[hWn̓_P (X1, Y1) Ɠ_Q 
   (X2, Y2) ΊpƂlp`ɓڂȉ~`B̂Ƃ݂̃uV 
   (GWSETBRS Q) œhB
-------------------------------------------------------------------------------
(͕ϐ)
   X1 = _P X W([hWn)
   Y1 = _P Y W([hWn)
   X2 = _Q X W([hWn)
   Y2 = _Q Y W([hWn)
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Draw Ellipse
*******************************************************************************
[F] SUBROUTINE GWELLIPSE(IRTN, X1, Y1, X2, Y2)
    INTEGER IRTN
    REAL X1, Y1, X2, Y2

[C] int GWellipse(float X1, float Y1, float X2, float Y2);
-------------------------------------------------------------------------------
Description
   Draws an ellipse. The center of the ellipse is the center of the bounding 
   rectangle specified by a pair of two diagonal points (X1, Y1) and (X2, Y2).
   The ellipse is drawn with the current pen, and its interior is filled with 
   the current brush. 

Input
   X1 = the world x-coordinate of the point 1.
   Y1 = the world y-coordinate of the point 1.
   X2 = the world x-coordinate of the point 2.
   Y2 = the world y-coordinate of the point 2.

Output
 IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWELLIPSE "^";
#endif
int GWELLIPSE(int *ret, float *x1, float *y1, float *x2, float *y2)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWELLIPSE(int *ret, float *x1, float *y1, float *x2, float *y2)
#else
int gwellipse_(int *ret, float *x1, float *y1, float *x2, float *y2)
#endif
#endif
{
	return (*ret = GW_ellipse(nDOC, 
		WCtoLPx(*x1), WCtoLPy(*y1), WCtoLPx(*x2), WCtoLPy(*y2)));
}

int GWellipse(float x1, float y1, float x2, float y2)
{
	return GW_ellipse(nDOC, 
		WCtoLPx(x1), WCtoLPy(y1), WCtoLPx(x2), WCtoLPy(y2));
}

int GW_ellipse(int nDoc, int u1, int v1, int u2, int v2)
{
	GW_Params(nDoc)->c.i.p0 = u1;
	GW_Params(nDoc)->c.i.p1 = v1;
	GW_Params(nDoc)->c.i.p2 = u2;
	GW_Params(nDoc)->c.i.p3 = v2;
	return _command1(nDoc, GW_GENDOTOOL, TOOL_ELLIPSE);
}


/*1
ʂ̕`
*******************************************************************************
[F] SUBROUTINE GWARC(IRTN, X1, Y1, X2, Y2, A, AW)
    INTEGER IRTN
    REAL X1, Y1, X2, Y2, A, AW

[C] int GWarc(float X1, float Y1, float X2, float Y2, float A, float AW);
-------------------------------------------------------------------------------
()
   ݂̃y (GWSETPEN Q) gāC[hWn̓_P (X1, Y1) Ɠ_Q 
   (X2, Y2) ΊpƂlp`ɓڂȉ~̌ʂ`BhԂ͍s
   Bʂ́Cpx̒Pʂ "x/360" ƂCv𐳂ɂƂāC
   px A ̓_Cpx A + AW ̓_܂ŕ`悳BA  AW ɂ
   ́Cl -1.0 ȉ̏ꍇɂ̓ftHglpB
-------------------------------------------------------------------------------
(͕ϐ)
   X1 = _P X W([hWn)
   Y1 = _P Y W([hWn)
   X2 = _Q X W([hWn)
   Y2 = _Q Y W([hWn)
    A = ʂ̕`Jnp(deg/360; ftHgl 0.0)
   AW = ʂ̊px(deg/360; ftHgl 1.0)
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Draw Arc
*******************************************************************************
[F] SUBROUTINE GWARC(IRTN, X1, Y1, X2, Y2, A, AW)
    INTEGER IRTN
    REAL X1, Y1, X2, Y2, A, AW

[C] int GWarc(float X1, float Y1, float X2, float Y2, float A, float AW);
-------------------------------------------------------------------------------
Description
   Draws an arc of an ellipse. The center of the ellipse is the center of the 
   bounding rectangle specified by a pair of two diagonal points (X1, Y1) and 
   (X2, Y2).   The starting point of the arc is specified by the start angle A 
   measured counterclockwise from the x-direction in the unit of degrees/360.
   The ending point is similarly located by measuring counterclockwise from 
   the starting point with the sweep angle AW.   For A and AW, if a value less 
   than or equal to -1.0 is specified, the default value is used.  The arc is 
   drawn using the current pen, and it is not filled.

Input
   X1 = the world x-coordinate of the point 1.
   Y1 = the world y-coordinate of the point 1.
   X2 = the world x-coordinate of the point 2.
   Y2 = the world y-coordinate of the point 2.
    A = the start angle relative to the x-axis (in deg/360).
   AW = the sweep angle relative to the starting angle (in deg/360).

Output
 IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWARC "^";
#endif
int GWARC(int *ret, float *x1, float *y1, float *x2, float *y2, 
		   float *a, float *aw)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWARC(int *ret, float *x1, float *y1, float *x2, float *y2, 
		   float *a, float *aw)
#else
int gwarc_(int *ret, float *x1, float *y1, float *x2, float *y2, 
		   float *a, float *aw)
#endif
#endif
{
	return (*ret = GWarc(*x1, *y1, *x2, *y2, *a, *aw));
}

int GWarc(float x1, float y1, float x2, float y2, float a, float aw)
{
	float xc = (x1+x2)/2, yc = (y1+y2)/2;
	aw = (a+aw)*PI2;
	a *= PI2;
	return GW_arc(nDOC, 
		WCtoLPx(x1), WCtoLPy(y1), WCtoLPx(x2), WCtoLPy(y2), 
		WCtoLPx(xc+GW_DU*cos(a)), WCtoLPy(yc+GW_DU*sin(a)), 
		WCtoLPx(xc+GW_DU*cos(aw)), WCtoLPy(yc+GW_DU*sin(aw)));
}

int GW_arc(int nDoc, int u1, int v1, int u2, int v2, 
		   int u3, int v3, int u4, int v4)
{
	GW_Params(nDoc)->c.i.p0 = u1;
	GW_Params(nDoc)->c.i.p1 = v1;
	GW_Params(nDoc)->c.i.p2 = u2;
	GW_Params(nDoc)->c.i.p3 = v2;
	GW_Params(nDoc)->Work.Data[0] = u3;
	GW_Params(nDoc)->Work.Data[1] = v3;
	GW_Params(nDoc)->Work.Data[2] = u4;
	GW_Params(nDoc)->Work.Data[3] = v4;
	return _command1(nDoc, GW_GENDOTOOL, TOOL_ARC);
}


/*1
ʂ̕`
*******************************************************************************
[F] SUBROUTINE GWCHORD(IRTN, X1, Y1, X2, Y2, A, AW)
    INTEGER IRTN
    REAL X1, Y1, X2, Y2, A, AW

[C] int GWchord(float X1, float Y1, float X2, float Y2, float A, float AW);
-------------------------------------------------------------------------------
()
   ݂̃y (GWSETPEN Q) gāC[hWn̓_P (X1, Y1) Ɠ_Q 
   (X2, Y2) ΊpƂlp`ɓڂȉ~̌ʂƂ̗[Ԍ`B
   ̂Ƃ݂̃uV (GWSETBRS Q) œhBʂ́Cpx̒Pʂ 
   "x/360" ƂCv𐳂ɂƂāC瑪px A ̓_C
   px A + AW ̓_܂ŕ`悳BA  AW ɂẮCl -1.0 ȉ̏ꍇ
   ̓ftHglpB
-------------------------------------------------------------------------------
(͕ϐ)
   X1 = _P X W([hWn)
   Y1 = _P Y W([hWn)
   X2 = _Q X W([hWn)
   Y2 = _Q Y W([hWn)
    A = ʂ̕`Jnp(deg/360; ftHgl 0.0)
   AW = ʂ̊px(deg/360; ftHgl 1.0)
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Draw Closed Arc
*******************************************************************************
[F] SUBROUTINE GWCHORD(IRTN, X1, Y1, X2, Y2, A, AW)
    INTEGER IRTN
    REAL X1, Y1, X2, Y2, A, AW

[C] int GWchord(float X1, float Y1, float X2, float Y2, float A, float AW);
-------------------------------------------------------------------------------
Description
   Draws an arc of an ellipse with the chord closing the arc.  The center of 
   the arc is the center of the bounding rectangle specified by a pair of two 
   diagonal points (X1, Y1) and (X2, Y2).  The starting point of the arc is 
   specified by the start angle A measured counterclockwise from the x-
   direction in the unit of degrees/360.  The ending point is similarly 
   located by measuring counterclockwise from the starting point with the 
   sweep angle AW.   For A and AW, if a value less than or equal to -1.0 is 
   specified, the default value is used.  The curve is drawn using the current 
   pen, and it is filled using the current brush.

Input
   X1 = the world x-coordinate of the point 1.
   Y1 = the world y-coordinate of the point 1.
   X2 = the world x-coordinate of the point 2.
   Y2 = the world y-coordinate of the point 2.
    A = the start angle relative to the x-axis (in deg/360).
   AW = the sweep angle relative to the starting angle (in deg/360).

Output
 IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWCHORD "^";
#endif
int GWCHORD(int *ret, float *x1, float *y1, float *x2, float *y2, 
		   float *a, float *aw)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWCHORD(int *ret, float *x1, float *y1, float *x2, float *y2, 
		   float *a, float *aw)
#else
int gwchord_(int *ret, float *x1, float *y1, float *x2, float *y2, 
		   float *a, float *aw)
#endif
#endif
{
	return (*ret = GWchord(*x1, *y1, *x2, *y2, *a, *aw));
}

int GWchord(float x1, float y1, float x2, float y2, float a, float aw)
{
	float xc = (x1+x2)/2, yc = (y1+y2)/2;
	aw = (a+aw)*PI2;
	a *= PI2;
	return GW_chord(nDOC, 
		WCtoLPx(x1), WCtoLPy(y1), WCtoLPx(x2), WCtoLPy(y2), 
		WCtoLPx(xc+GW_DU*cos(a)), WCtoLPy(yc+GW_DU*sin(a)), 
		WCtoLPx(xc+GW_DU*cos(aw)), WCtoLPy(yc+GW_DU*sin(aw)));
}

int GW_chord(int nDoc, int u1, int v1, int u2, int v2, 
		   int u3, int v3, int u4, int v4)
{
	GW_Params(nDoc)->c.i.p0 = u1;
	GW_Params(nDoc)->c.i.p1 = v1;
	GW_Params(nDoc)->c.i.p2 = u2;
	GW_Params(nDoc)->c.i.p3 = v2;
	GW_Params(nDoc)->Work.Data[0] = u3;
	GW_Params(nDoc)->Work.Data[1] = v3;
	GW_Params(nDoc)->Work.Data[2] = u4;
	GW_Params(nDoc)->Work.Data[3] = v4;
	return _command1(nDoc, GW_GENDOTOOL, TOOL_CHORD);
}


/*1
`̕`
*******************************************************************************
[F] SUBROUTINE GWPIE(IRTN, X1, Y1, X2, Y2, A, AW)
    INTEGER IRTN
    REAL X1, Y1, X2, Y2, A, AW

[C] int GWpie(float X1, float Y1, float X2, float Y2, float A, float AW);
-------------------------------------------------------------------------------
()
   ݂̃y (GWSETPEN Q) gāC[hWn̓_P (X1, Y1) Ɠ_Q 
   (X2, Y2) ΊpƂlp`ɓڂ`𔽎vɕ`B̂Ƃ
   ̃uV (GWSETBRS Q) œhB`́Aȉ~̌ʂƁA2 ̒[_
   ꂼꂩȉ~̒SɈ\}`Bʂ́Cpx̒Pʂ 
   "x/360" ƂCv𐳂ɂƂāC瑪px A ̓_C
   px A + AW ̓_܂ŕ`悳BA  AW ɂẮCl -1.0 ȉ̏ꍇ
   ̓ftHglpB
-------------------------------------------------------------------------------
(͕ϐ)
   X1 = _P X W([hWn)
   Y1 = _P Y W([hWn)
   X2 = _Q X W([hWn)
   Y2 = _Q Y W([hWn)
    A = ʂ̕`Jnp(deg/360; ftHgl 0.0)
   AW = ʂ̊px(deg/360; ftHgl 1.0)
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Draw Pie
*******************************************************************************
[F] SUBROUTINE GWPIE(IRTN, X1, Y1, X2, Y2, A, AW)
    INTEGER IRTN
    REAL X1, Y1, X2, Y2, A, AW

[C] int GWpie(float X1, float Y1, float X2, float Y2, float A, float AW);
-------------------------------------------------------------------------------
Description
   Draws a pie.  The pie consists of an arc of an ellipse and the two closing 
   radials from the center of the ellipse.  The bounding rectangle of the 
   ellipse is specified by a pair of two diagonal points (X1, Y1) and (X2, Y2).
   The starting point of the arc is specified by the start angle A measured 
   counterclockwise from the x-direction in the unit of degrees/360.  The 
   ending point is similarly located by measuring counterclockwise from the 
   starting point with the sweep angle AW.   For A and AW, if a value less 
   than or equal to -1.0 is specified, the default value is used.  The curve 
   is drawn using the current pen, and it is filled using the current brush.

Input
   X1 = the world x-coordinate of the point 1.
   Y1 = the world y-coordinate of the point 1.
   X2 = the world x-coordinate of the point 2.
   Y2 = the world y-coordinate of the point 2.
    A = the start angle relative to the x-axis (in deg/360).
   AW = the sweep angle relative to the starting angle (in deg/360).

Output
 IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWPIE "^";
#endif
int GWPIE(int *ret, float *x1, float *y1, float *x2, float *y2, 
		   float *a, float *aw)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWPIE(int *ret, float *x1, float *y1, float *x2, float *y2, 
		   float *a, float *aw)
#else
int gwpie_(int *ret, float *x1, float *y1, float *x2, float *y2, 
		   float *a, float *aw)
#endif
#endif
{
	return (*ret = GWpie(*x1, *y1, *x2, *y2, *a, *aw));
}

int GWpie(float x1, float y1, float x2, float y2, float a, float aw)
{
	float xc = (x1+x2)/2, yc = (y1+y2)/2;
	aw = (a+aw)*PI2;
	a *= PI2;
	return GW_pie(nDOC, 
		WCtoLPx(x1), WCtoLPy(y1), WCtoLPx(x2), WCtoLPy(y2), 
		WCtoLPx(xc+GW_DU*cos(a)), WCtoLPy(yc+GW_DU*sin(a)), 
		WCtoLPx(xc+GW_DU*cos(aw)), WCtoLPy(yc+GW_DU*sin(aw)));
}

int GW_pie(int nDoc, int u1, int v1, int u2, int v2, 
		   int u3, int v3, int u4, int v4)
{
	GW_Params(nDoc)->c.i.p0 = u1;
	GW_Params(nDoc)->c.i.p1 = v1;
	GW_Params(nDoc)->c.i.p2 = u2;
	GW_Params(nDoc)->c.i.p3 = v2;
	GW_Params(nDoc)->Work.Data[0] = u3;
	GW_Params(nDoc)->Work.Data[1] = v3;
	GW_Params(nDoc)->Work.Data[2] = u4;
	GW_Params(nDoc)->Work.Data[3] = v4;
	return _command1(nDoc, GW_GENDOTOOL, TOOL_PIE);
}


/*x
1z̃vbg
*******************************************************************************
[F] SUBROUTINE GWPLOT1(IRTN, M, N, P1, PN, S, O, A, B, ARRY)
    INTEGER IRTN, M, N
    REAL P1, PN, S, O, A, B, ARRY(N)

[C] int GWplot1(int M, int N, float P1, float PN, float S, float O, 
                float A, float B, float *ARRY);
-------------------------------------------------------------------------------
()
   1z ARRY ̐擪 |N| ̃f[^ɂĐ`ϊŝ M 
   w肳ꂽ`œԊuɃvbgBvbg i Ԗ (i = 1..|N|) 
   _ (x,y) W([hW) FORTRAN ̏ꍇC
       (P1 + (i - 1)*(PN - P1)/(N - 1), A*ARRY(i)+B)     (N > 0)
   邢
       (A*ARRY(i)+B, P1 + (i - 1)*(PN - P1)/(- N - 1))   (N < 0)
   ƂȂBC ̏ꍇ ARRY(i)  ARRY[i-1] ɓǂݑւKvB
-------------------------------------------------------------------------------
(͕ϐ)
     M = vbg`
       = -1: ݂̃yg܂Ot
       = -2(-3): ݂̃yg󐂒()_Ot
       = -4(-5): ݂̃uVg()_Ot( S)
       = -6(-7): ݂̃yƌ݂̃uVg()_Ot( S)  
       =  0: ݂̃}[Ng'}[N'( S)
       >  0: R{ԍ M ̃R{i쐬̑傫jg'R{'
   |N| = vbgzvf ( > 1: ܂Ot̏ꍇ)BN > 0 ̏ꍇɂ 
         A*ARRY(i)+B  y WƂĈCN < 0 ̏ꍇɂ x WƂĈB
    P1 = ŏ̓_ x ܂ y W([hW)
    PN = Ō̓_ x ܂ y W([hW)
     S = _Ot̖_̕邢̓}[N̑傫([hW)
     O = M < -1 ̏ꍇF_Ot̏ꍇ̊̍W([hW)
         M >  0 ̏ꍇFR{ IOF (GWPUTCMB Q) p[^
     A = `ϊ̌W
     B = `ϊ̕t萔
  ARRY = vbg1z
------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Plot 1D Array Elements
*******************************************************************************
[F] SUBROUTINE GWPLOT1(IRTN, M, N, P1, PN, S, O, A, B, ARRY)
    INTEGER IRTN, M, N
    REAL P1, PN, S, O, A, B, ARRY(N)

[C] int GWplot1(int M, int N, float P1, float PN, float S, float O, 
                float A, float B, float *ARRY);
-------------------------------------------------------------------------------
Description
   Transforms lenearly the first |N| elements of the 1D array ARRY, and then 
   plots them at regular horizantal or vertical intervals in a format specified 
   by M.  The world (x,y) coordinate of the i-th point (i = 1..|N|) is given as
       (P1 + (i - 1)*(PN - P1)/(N - 1), A*ARRY(i)+B)      when N > 0
   or
       (A*ARRY(i)+B, P1 + (i - 1)*(PN - P1)/( - N - 1))   when N < 0
   in FORTRAN.  In C, ARRY(i) should read ARRY[i-1].

Input
     M = format of the plot
       = -1: line segments drawn with the current pen
       = -2(-3): vertical(horizontal) lines drawn with the current pen
       = -4(-5): vertical(horizontal) bars of the width S drawn with the current 
                 brush
       = -6(-7): vertical(horizontal) bars of the width S drawn with the current 
                 pen as edges and with the current brush for interiors
       =  0: marks of the current mark of the height S
       >  0: combo's of the combo number M already defined
   |N| = the number ( > 1: for line segments ) of points to be plot.  When N > 0 
         the values A*ARRY()+B are regarded as world y coordinates, and when 
         N < 0 as world x coordinates.
    P1 = the world x (or y) coordinate of the first point when N > 0 (< 0)
    PN = the world x (or y) coordinate of the last point when N > 0 (< 0)
     S = the width (in the world coordinate) of each bar when M < -1, or the 
         mark height when M == 0
     O = the base world y or x coordinate of each vertical or horizontal bar 
         when M < -1, or the IOF parameter (see GWPUTCMB) when M > 0.
     A = the coefficient in the linear transformation
     B = the additive constant in the linear transformation
  ARRY = 1D array to be plotted

Output
 IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWPLOT1 "^";
#endif
int GWPLOT1(int *ret, int *M, int *N, float *P1, float *PN, float *W, 
			float *O, float *A, float *B, float *ARRY)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWPLOT1(int *ret, int *M, int *N, float *P1, float *PN, float *W, 
			float *O, float *A, float *B, float *ARRY)
#else
int gwplot1_(int *ret, int *M, int *N, float *P1, float *PN, float *W, 
			float *O, float *A, float *B, float *ARRY)
#endif
#endif
{
	return (*ret = GWplot1(*M, *N, *P1, *PN, *W, *O, *A, *B, ARRY));
}

int GWplot1(int M, int N, float P1, float PN, float W, float O, 
			float A, float B, float *ARRY)
{
	int i0 = 0, i = 0, n = 0;

	if(!N) return 0;

	GW_Params(nDOC)->c.i.p0 = (N>0)?WCtoLPx(P1):WCtoLPy(P1);
	GW_Params(nDOC)->c.i.p1 = (N>0)?WCtoLPx(PN):WCtoLPy(PN);
	if(M == 0 || M < -1) {
		GW_Params(nDOC)->c.i.p2 = (N>0)?WCtoLPw(W):WCtoLPh(W);
		GW_Params(nDOC)->c.i.p3 = (N>0)?WCtoLPy(O):WCtoLPx(O);
	} else {
		GW_Params(nDOC)->c.i.p2 = (int)W;
		GW_Params(nDOC)->c.i.p3 = (int)O;
	}
	if(_command(nDOC, GW_GENTOOL, TOOL_PLOT, N, M)) {
		do {
			float x = *(ARRY++);
			GW_pData[n++] = (N>0)?WCtoLPy(A*x+B):WCtoLPx(A*x+B);
			if(n >= (int)MAXDATA || i == abs(N) - 1) {
				if(!_command(nDOC, GW_CMD, CMD_DATA, 
						i0*sizeof(INT), n*sizeof(INT))) {
					_command1(nDOC, GW_CMD, CMD_DELTOOL);
					return 0;
				}
				i0 += n;
				n = 0;
			}
		} while(++i < abs(N));
		_command1(nDOC, GW_CMD, CMD_DOTOOL);
		return nDOC;
	}
	return 0;
}

int GW_plot1(int nDoc, int M, int N, int P1, int PN, int W, int O, INT *ARRY)
{
	if(!N) return 0;

	GW_Params(nDoc)->c.i.p0 = P1;
	GW_Params(nDoc)->c.i.p1 = PN;
	GW_Params(nDoc)->c.i.p2 = W;
	GW_Params(nDoc)->c.i.p3 = O;
	GW_Params(nDoc)->y = N;
	GW_Params(nDoc)->z = M;
	return _polydo(nDoc, TOOL_PLOT, (LPCVOID)ARRY, abs(N)*sizeof(INT));
}


/*1
p`̕`
*******************************************************************************
[F] SUBROUTINE GWPOLYGON(IRTN, POINTS, N, MF)
    INTEGER IRTN, N, MF
    REAL POINTS(2,N)

[C] int GWpolygon(float *POINTS, int N, int MF);
-------------------------------------------------------------------------------
()
   ݂̃y (GWSETPEN Q) gāCN ̒_Ȃ鑽p`Ci (= 1..N) 
   Ԗڂ̒_̍W (POINTS(1,i), POINTS(2,i)) ŗ^ĕ`([F])B̂Ƃ
   ݂̃uV (GWSETBRS Q) pCw肳ꂽhԂ[hœh
   B[C] ̏ꍇɂ́C|C^ POINTS w[̈͘AIŁC 
   *(POINTS + 2*i - 2)  *(POINTS + 2*i - 1) ̂ꂼɁCi (= 1..N) Ԗڂ̒
   _ x, y Wi[ĂȂ΂ȂȂB
-------------------------------------------------------------------------------
(͕ϐ)
    POINTS(1,i)   = i Ԗڂ̒_ x W (i = 1..N)
    POINTS(2,i)   = i Ԗڂ̒_ y W (i = 1..N)
                N = _
               MF = hԂ[h
                    0: Alternate (default)
                    1: Winding
                   : ύXȂ
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Draw Polygon
*******************************************************************************
[F] SUBROUTINE GWPOLYGON(IRTN, POINTS, N, MF)
    INTEGER IRTN, N, MF
    REAL POINTS(2,N)

[C] int GWpolygon(float *POINTS, int N, int MF);
-------------------------------------------------------------------------------
Description
    Draws a polygon consisting of two or more points (vertices) connected by 
    lines, using the current pen. The system closes the polygon automatically, 
    if necessary, by drawing a line from the last vertex to the first.    The 
    current polygon-filling mode can be set by the parameter MF.   When MF < 0 
    it is not changed.  In C the memory block that the pointer POINTS points to 
    must be contiguous, and *(POINTS + 2*i - 2) and *(POINTS + 2*i - 1) must 
    be the x and the y cordinates of the i-th vertex, respectively, for i = 1 
    to N.

Input
    POINTS(1,i) = the world x-coordinate of the i-th vertex (i = 1 to N).
    POINTS(2,i) = the world y-coordinate of the i-th vertex (i = 1 to N).
              N = number of vertices
             MF = polygon-filling mode
                  0: Alternate mode (default)
                  1: Winding mode
          otherwise: Left unchanged

Output
 IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWPOLYGON "^";
#endif
int GWPOLYGON(int *ret, float *points, int *N, int *mf)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWPOLYGON(int *ret, float *points, int *N, int *mf)
#else
int gwpolygon_(int *ret, float *points, int *N, int *mf)
#endif
#endif
{
	return (*ret = GWpolygon(points, *N, *mf));
}

int GWpolygon(float *points, int N, int mf)
{
	int i0 = 0, i = 0, n = 0;

	if(N < 3) return 0;

	switch(mf) {
	case 0:
		GW_pParams->p.GW_Gm = ALTERNATE;
		break;
	case 1:
		GW_pParams->p.GW_Gm = WINDING;
		break;
	}

	if(_command2(nDOC, GW_GENTOOL, TOOL_POLYGON, N)) {
		do {
			float x = *(points++);
			GW_pData[n] = (++i%2)?WCtoLPx(x):WCtoLPy(x);
			if(++n >= (int)MAXDATA || i == 2*N) {
				if(!_command(nDOC, GW_CMD, CMD_DATA, 
						i0*sizeof(INT), n*sizeof(INT))) {
					_command1(nDOC, GW_CMD, CMD_DELTOOL);
					return 0;
				}
				i0 += n;
				n = 0;
			}
		} while(i < 2*N);
		_command1(nDOC, GW_CMD, CMD_DOTOOL);
		return nDOC;
	}
	return 0;
}

int GW_polygon(int nDoc, POINT* pnts, int N, int mf)
{
	if(N < 3) return 0;

	switch(mf) {
	case 0:
		GW_pParams->p.GW_Gm = ALTERNATE;
		break;
	case 1:
		GW_pParams->p.GW_Gm = WINDING;
		break;
	}
	GW_Params(nDoc)->y = N;
	return _polydo(nDoc, TOOL_POLYGON, (LPCVOID)pnts, N*sizeof(POINT));
}


/*1
܂̕`
*******************************************************************************
[F] SUBROUTINE GWPOLYLIN(IRTN, POINTS, N)
    INTEGER IRTN, N
    REAL POINTS(2,N)

[C] int GWpolylin(float *POINTS, int N);
-------------------------------------------------------------------------------
()
   ݂̃y (GWSETPEN Q) gāCN ̓_Ԑ܂Ci (= 1..N) Ԗ
   ̒_̍W (POINTS(1,i), POINTS(2,i)) ŗ^ĕ`([F])B}`Ă
   ĂhԂ͍sȂBC ̏ꍇ̓_̍W̗^ɂĂ 
   GWPOLYGON QƁB
-------------------------------------------------------------------------------
(͕ϐ)
    POINTS(1,i) = i Ԗڂ̓_ x W (i = 1..N)
    POINTS(2,i) = i Ԗڂ̓_ y W (i = 1..N)
              N = _̐ ( > 1 )
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Draw Line Segments
*******************************************************************************
[F] SUBROUTINE GWPOLYLIN(IRTN, POINTS, N)
    INTEGER IRTN, N
    REAL POINTS(2,N)

[C] int GWpolylin(float *POINTS, int N);
-------------------------------------------------------------------------------
Description
   Draws lines connecting the given points successively, using the current pen.
   The figure is not filled if it is a closed one.   In C the memory block that 
   the pointer POINTS points to must be contiguous, and *(POINTS + 2*i - 2) and 
   *(POINTS + 2*i - 1) must be the x and the y cordinates of the i-th vertex, 
   respectively, for i = 1 to N.

Input
    POINTS(1,i) = the world x-coordinate of the i-th point (i = 1 to N).
    POINTS(2,i) = the world y-coordinate of the i-th point (i = 1 to N).
              N = number of points ( > 1 )

Output
 IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWPOLYLIN "^";
#endif
int GWPOLYLIN(int *ret, float *points, int *N)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWPOLYLIN(int *ret, float *points, int *N)
#else
int gwpolylin_(int *ret, float *points, int *N)
#endif
#endif
{
	return (*ret = GWpolylin(points, *N));
}

int GWpolylin(float *points, int N)
{
	int i0 = 0, i = 0, n = 0;

	if(N < 2) return 0;

	if(_command2(nDOC, GW_GENTOOL, TOOL_POLYLINE, N)) {
		do {
			float x = *(points++);
			GW_pData[n] = (++i%2)?WCtoLPx(x):WCtoLPy(x);
			if(++n >= (int)MAXDATA || i == 2*N) {
				if(!_command(nDOC, GW_CMD, CMD_DATA, 
						i0*sizeof(INT), n*sizeof(INT))) {
					_command1(nDOC, GW_CMD, CMD_DELTOOL);
					return 0;
				}
				i0 += n;
				n = 0;
			}
		} while(i < 2*N);
		_command1(nDOC, GW_CMD, CMD_DOTOOL);
		return nDOC;
	}
	return 0;
}

int GW_polyline(int nDoc, POINT *pnts, int N)
{
	if(N < 2) return 0;

	GW_Params(nDoc)->y = N;
	return _polydo(nDoc, TOOL_POLYLINE, (LPCVOID)pnts, N*sizeof(POINT));
}


/*1
xWG XvC̕`
*******************************************************************************
[F] SUBROUTINE GWBEZIER(IRTN, POINTS, N)
    INTEGER IRTN, N
    REAL POINTS(2,N)

[C] int GWbezier(float *POINTS, int N);
-------------------------------------------------------------------------------
()
   ݂̃y (GWSETPEN Q) gāCxWG XvC`悷Bh
   ͍sȂB POINTS Ɏw肳ꂽI_Ɛ_g 3 xWGX
   vC`悷Bŏ̃XvĆAŏ̓_ 4 Ԗڂ̓_܂ŕ`悳
   B2 Ԗڂ̓_ 3 Ԗڂ̓_́A_ƂĎgB̌ɑÃXv
   C͂ꂼ 3 ̓_KvƂBÕXvC̏I_Jn_Ƃ
   gCA 2 _𐧌_C3 Ԗڂ̓_I_ƂĎgBāC
   XvCEZOg n ̏ꍇCN = 3*n+1 ̃f[^_^Ȃ΂
   ȂBC ̏ꍇ̓_̍W̗^ɂĂ GWPOLYGON QƁB
-------------------------------------------------------------------------------
(͕ϐ)
    POINTS(1,i) = i Ԗڂ̓_ x W (i = 1..N)
    POINTS(2,i) = i Ԗڂ̓_ y W (i = 1..N)
              N = _̐ ( 3 ̔{ + 1 )
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Draw Bezier
*******************************************************************************
[F] SUBROUTINE GWBEZIER(IRTN, POINTS, N)
    INTEGER IRTN, N
    REAL POINTS(2,N)

[C] int GWbezier(float *POINTS, int N);
-------------------------------------------------------------------------------
Description
    Draws one or more Bezier splines using the current pen without filling. 
    This function draws cubic Bezier splines by using the endpoints and control 
    points specified by the array POINT. The first spline is drawn from the 
    first point to the fourth point by using the second and third points as 
    control points. Each subsequent spline in the sequence needs exactly three 
    more points: the end point of the previous spline is used as the starting 
    point, the next two points in the sequence are control points, and the 
    third is the end point. The number of the points N must be one more than 
    three times the number of splines to be drawn.   In C the memory block that 
    the pointer POINTS points to must be contiguous, and *(POINTS + 2*i - 2) 
    and *(POINTS + 2*i - 1) must be the x and the y cordinates of the i-th 
    vertex, respectively, for i = 1 to N.

Input
    POINTS(1,i) = the world x-coordinate of the i-th point (i = 1 to N).
    POINTS(2,i) = the world y-coordinate of the i-th point (i = 1 to N).
              N = the number of points in the POINTS array.

Output
 IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWBEZIER "^";
#endif
int GWBEZIER(int *ret, float *points, int *N)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWBEZIER(int *ret, float *points, int *N)
#else
int gwbezier_(int *ret, float *points, int *N)
#endif
#endif
{
	return (*ret = GWbezier(points, *N));
}

int GWbezier(float *points, int N)
{
	int i0 = 0, i = 0, n = 0;

	if((N < 4) || ((N%3) != 1)) return 0;

	if(_command2(nDOC, GW_GENTOOL, TOOL_BEZIER, N)) {
		do {
			float x = *(points++);
			GW_pData[n] = (++i%2)?WCtoLPx(x):WCtoLPy(x);
			if(++n >= (int)MAXDATA || i == 2*N) {
				if(!_command(nDOC, GW_CMD, CMD_DATA, 
						i0*sizeof(INT), n*sizeof(INT))) {
					_command1(nDOC, GW_CMD, CMD_DELTOOL);
					return 0;
				}
				i0 += n;
				n = 0;
			}
		} while(i < 2*N);
		_command1(nDOC, GW_CMD, CMD_DOTOOL);
		return nDOC;
	}
	return 0;
}

int GW_bezier(int nDoc, POINT *pnts, int N)
{
	if(N < 4) return 0;

	GW_Params(nDoc)->y = N;
	return _polydo(nDoc, TOOL_BEZIER, (LPCVOID)pnts, N*sizeof(POINT));
}


/*1
̈̓hԂ
*******************************************************************************
[F] SUBROUTINE GWFLOOD(IRTN, X, Y)
    INTEGER IRTN
    REAL X, Y

[C] int GWflood(float X, float Y);
-------------------------------------------------------------------------------
()
   (X,Y) Ŏw肳ꂽhԂJn_CJn_܂݁CJn_ƈقȂFE
   Ƃ݂̈̃uVœhԂ [̃[`͔ɒᑬŁC
   v^͂̋@\T|[gĂȂ̂ŁCł邾gȂ悢]B
-------------------------------------------------------------------------------
(͕ϐ)
   X = hԂJn_ X W([hWn)
   Y = hԂJn_ Y W([hWn)
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Fill Bounded Area
*******************************************************************************
[F] SUBROUTINE GWFLOOD(IRTN, X, Y)
    INTEGER IRTN
    REAL X, Y

[C] int GWflood(float X, float Y);
-------------------------------------------------------------------------------
Description
   Fills an area of the display surface with the current brush. The area is 
   assumed to be bounded as specified by the same color as the color of the 
   pixel at the beginning point (X, Y) [This routine is rather inefficient, 
   and many printer (drivers) do not support this feature].  

Input
   X = the world x-coordinate of the point where filling begins.
   Y = the world x-coordinate of the point where filling begins.

Output
 IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWFLOOD "^";
#endif
int GWFLOOD(int *ret, float *x, float *y)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWFLOOD(int *ret, float *x, float *y)
#else
int gwflood_(int *ret, float *x, float *y)
#endif
#endif
{
	return (*ret = GW_flood(nDOC, WCtoLPx(*x), WCtoLPy(*y)));
}

int GWflood(float x, float y)
{
	return GW_flood(nDOC, WCtoLPx(x), WCtoLPy(y));
}

int GW_flood(int nDoc, int u, int v)
{
	return _command(nDoc, GW_GENDOTOOL, TOOL_FLOOD, u, v);
}


/*1
EBhEʂ̏
*******************************************************************************
[F] SUBROUTINE GWCLEAR(IRTN, K)
    INTEGER IRTN, K

[C] int GWclear(int K);
-------------------------------------------------------------------------------
()
   w肳ꂽFŌ݂̃r[|[ghԂB
-------------------------------------------------------------------------------
(͕ϐ)
    K = _Fԍ(GWCOLOR ̍Q)
        -1 ̏ꍇ͉ʏƂƂɂׂẴIuWFNg
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Clear Window
*******************************************************************************
[F] SUBROUTINE GWCLEAR(IRTN, K)
    INTEGER IRTN, K

[C] int GWclear(int K);
-------------------------------------------------------------------------------
Description
   Fills the current viewport with the specified collor.

Input
    K != -1: a logical color value (see GWCOLOR)
       = -1: clears the window with erasing the objects on memory

Output
 IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWCLEAR "^";
#endif
int GWCLEAR(int *ret, int *k)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWCLEAR(int *ret, int *k)
#else
int gwclear_(int *ret, int *k)
#endif
#endif
{
	return (*ret = GW_clear(nDOC, *k));
}

int GWclear(int k)
{
	return GW_clear(nDOC, k);
}

int GW_clear(int nDoc, int k)
{
	if(k == -1) {
		_command1(nDoc, GW_CMD, CMD_ERASEALL);
		return _command1(nDoc, GW_CMD, CMD_RESET);
	}
	GW_Params(nDoc)->c.i.p0 = k;
	return _command1(nDoc, GW_GENDOTOOL, TOOL_CLEAR);
}


/*1
}[N̎w
*******************************************************************************
[F] SUBROUTINE GWSETMRK(IRTN, MT, S, K, KB, MX)
    INTEGER IRTN, MT, K, KB, MX
    REAL S

[C] int GWsetmrk(int MT, float S, int K, int KB, int MX);
-------------------------------------------------------------------------------
()
   }[Nԍ MT(0-6)C傫 S([hWn)C}[N̘_Fԍ KC}[N
   wiF̘_Fԍ KBC[h MX w肷B MX > 15 ̏ꍇ (MX-16) 
   ̒l̂܂ "binary raster-operation code[W]" ƂĎgpBK, KB 
   āC̓p[^̒lłΑΉ鑮͕ύXȂBMT  0 
   ꍇ́C傫 SisNZj̓_w肳C̏ꍇC`悳}[N
   傫̓r[i\j[hɉeȂB
-------------------------------------------------------------------------------
(͕ϐ)
   MT = 0: _
        1: 
        2: {
        3: ~
        4: {Ɓ~d˂킹
        5: 
        6: 
        ̑:  ύXȂ
    S = hbg̑傫(sNZl)
      = }[N̍([hWn) > 0.0
    K = }[N̘_Fԍ(GWCOLOR ̍Q)
        -1 ̏ꍇ͌ݒlg
   KB = }[N̔wiF̘_Fԍ(GWCOLOR ̍Q)
        -1 ̏ꍇ͌ݒlg
      = -100: (default)
   MX = }[N̍[h( GWSETPEN ̍Q)
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Set Mark Attributes
*******************************************************************************
[F] SUBROUTINE GWSETMRK(IRTN, MT, S, K, KB, MX)
    INTEGER IRTN, MT, K, KB, MX
    REAL S

[C] int GWsetmrk(int MT, float S, int K, int KB, int MX);
-------------------------------------------------------------------------------
Description
   Sets mark number MT, size S in world coordinate, logical mark color K, 
   logical background mark color KB,  and the mix mode MX to the current mark. 
   When MX > 15, the value (MX-16) is used as the "binary raster operation 
   code [W]".  Negative numbers specified for parameters do not change 
   corresponding attributes, except for K and KB (see GWCOLOR).   If MT = 0 
   is specified, the parameter S is read a size of a dot, precisely a small 
   solid rectangle, in pixels and so the size of any instance of such a dot 
   is independent of the view mode, or not expanded even in 'Zoom in' mode, 
   for example.

Input
   MT = 0: dot
        1: solid rectangle
        2: +
        3: x
        4: superposition of + and X
        5: filled rectangle
        6: filled circle
   others: neglected
    S  = size of a dot in pixels (MT = 0)
       = height in the world coordinate > 0.0  (MT > 0)
    K != -1: logical mark color value (see GWCOLOR)
       = -1: unchanged
   KB != -1: logical mark background color value (see GWCOLOR)
       = -1: unchanged
       = -100: transparent(default)
   MX = mix mode for the mark (see GWSETPEN)

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWSETMRK "^";
#endif
int GWSETMRK(int *ret, int *t, float *s, int *k, int *kb, int *mix)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWSETMRK(int *ret, int *t, float *s, int *k, int *kb, int *mix)
#else
int gwsetmrk_(int *ret, int *t, float *s, int *k, int *kb, int *mix)
#endif
#endif
{
	int sz;
	if((*t == Mt_DOT) || 
		(*t < 0 && GW_Params(nDOC)->p.GW_Mt == Mt_DOT)) 
		sz = (int)(*s);
	else
		sz = WCtoLPh(*s);
	return (*ret = GW_setmrk(nDOC, *t, sz, *k, *kb, *mix));
}

int GWsetmrk(int t, float s, int k, int kb, int mix)
{
	int sz;
	if((t == Mt_DOT) || 
		(t < 0 && GW_Params(nDOC)->p.GW_Mt == Mt_DOT)) 
		sz = (int)(s);
	else
		sz = WCtoLPh(s);
	return GW_setmrk(nDOC, t, sz, k, kb, mix);
}

int GW_setmrk(int nDoc, int t, int s, int k, int kb, int mix)
{
	if((t >= 0) && (t < Mt_N) && (GW_Params(nDoc)->p.GW_Mt != t)) {
		GW_Params(nDoc)->p.GW_flags |= FLG_MTYPE;
		GW_Params(nDoc)->p.GW_Mt = t;
		if(t == Mt_DOT && s < 0) s = 0;
	}

	if((s >= 0) && (GW_Params(nDoc)->p.GW_Ms != s)) {
		GW_Params(nDoc)->p.GW_flags |= FLG_MSIZE;
		GW_Params(nDoc)->p.GW_Ms = s;
	}

	if((k != -1) && (GW_Params(nDoc)->p.GW_Mc != k)) {
		GW_Params(nDoc)->p.GW_flags |= FLG_MCOLOR;
		GW_Params(nDoc)->p.GW_Mc = k;
	}

	if((kb != -1) && (GW_Params(nDoc)->p.GW_Mb != kb)) {
		GW_Params(nDoc)->p.GW_flags |= FLG_MBACK;
		GW_Params(nDoc)->p.GW_Mb = kb;
	}

	if((mix >=0) && (GW_Params(nDoc)->p.GW_Mm != mix)) {
		GW_Params(nDoc)->p.GW_flags |= FLG_MROP2;
		GW_Params(nDoc)->p.GW_Mm = mix;
	}

	return _command1(nDoc, GW_GENDOTOOL, TOOL_SETGDI);
}


/*1
}[N`
*******************************************************************************
[F] SUBROUTINE GWPUTMRK(IRTN, X, Y)
    INTEGER IRTN
    REAL X, Y

[C] int GWputmrk(float X, float Y);
-------------------------------------------------------------------------------
()
    GWSETMRK Őݒ肳ꂽ}[Nʒu (X,Y) ɕ`悷B}[N\̕`
    ɂ݂͌̃y (GWSETPEN Q) gB
-------------------------------------------------------------------------------
(͕ϐ)
    X = }[NS_ X W([hWn)
    Y = }[NS_ Y W([hWn)
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Draw Mark
*******************************************************************************
[F] SUBROUTINE GWPUTMRK(IRTN, X, Y)
    INTEGER IRTN
    REAL X, Y

[C] int GWputmrk(float X, float Y);
-------------------------------------------------------------------------------
Description
    Draws the current mark set by GWSETMRK at the point (X, Y).

Input
    X = the world x-coordinate of the center of the mark)
    Y = the world y-coordinate of the center of the mark)

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWPUTMRK "^";
#endif
int GWPUTMRK(int *ret, float *x, float *y)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWPUTMRK(int *ret, float *x, float *y)
#else
int gwputmrk_(int *ret, float *x, float *y)
#endif
#endif
{
	return (*ret = GW_putmark(nDOC, WCtoLPx(*x), WCtoLPy(*y)));
}

int GWputmrk(float x, float y)
{
	return GW_putmark(nDOC, WCtoLPx(x), WCtoLPy(y));
}


/*0
}[N̎擾
*******************************************************************************
[F] SUBROUTINE GWGETMRK(IRTN, MT, S, K, KB, MX)
    INTEGER IRTN, MT, K, KB, MX
    REAL S

[C] int GWgetmrk(int *MT, float *S, int *K, int *KB, int *MX);
-------------------------------------------------------------------------------
()
   ݂̃}[NԍC}[NTCYC}[Nƃ}[NwiF̘_FԍC[h
   擾B
-------------------------------------------------------------------------------
(͕ϐ)
   Ȃ
-------------------------------------------------------------------------------
(o͕ϐ)
   MT = }[Nԍ
    S = }[NTCY([hWnŎw肷)
    K = }[N̘_Fԍ(GWCOLOR ̍Q)
   KB = }[N̔wiF̘_Fԍ(GWCOLOR ̍Q)
   MX = }[N̍[h( GWSETPEN ̍Q)
 IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Get Mark Attributes
*******************************************************************************
[F] SUBROUTINE GWGETMRK(IRTN, MT, S, K, KB, MX)
    INTEGER IRTN, MT, K, KB, MX
    REAL S

[C] int GWgetmrk(int *MT, float *S, int *K, int *KB, int *MX);
-------------------------------------------------------------------------------
Description
   Gets mark number, mark size, mark color, mark background color and mix mode 
   for the current mark.

Input
   None

Output
   MT = mark number
    S = mark height in the world coordinate
    K = logical mark color value (see GWCOLOR)
   KB = logical mark background color value (see GWCOLOR)
   MX = mix mode for the mark (see GWSETPEN)
 IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWGETMRK "^";
#endif
int GWGETMRK(int *ret, int *t, float *s, int *k, int *kb, int *m)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWGETMRK(int *ret, int *t, float *s, int *k, int *kb, int *m)
#else
int gwgetmrk_(int *ret, int *t, float *s, int *k, int *kb, int *m)
#endif
#endif
{
	int u;
	if((*ret = GW_getmrk(nDOC, t, &u, k, kb, m)))
		*s = LPtoWCh(u);
	return *ret;
}

int GWgetmrk(int *t, float *s, int *k, int *kb, int *m)
{
	int ret, u;
	if((ret = GW_getmrk(nDOC, t, &u, k, kb, m)))
		*s = LPtoWCh(u);
	return ret;
}

int GW_getmrk(int nDoc, int *t, int *s, int *k, int *kb, int *m)
{
	GW_asgn(t, GW_Params(nDoc)->p.GW_Mt);
	GW_asgn(s, GW_Params(nDoc)->p.GW_Ms);
	GW_asgn(k, GW_Params(nDoc)->p.GW_Mc);
	GW_asgn(kb, GW_Params(nDoc)->p.GW_Mb);
	GW_asgn(m, GW_Params(nDoc)->p.GW_Mm);
	return nDoc;
}


/*1
ϊs̐ݒ
*******************************************************************************
[F] SUBROUTINE GWSETXFRM(IRTN, XFRM)
    INTEGER IRTN
    REAL XFRM(6)

[C] int GWsetxfrm(float *XFRM);
-------------------------------------------------------------------------------
()
   ϊsݒ肷Bϊs̓rbg}bv}[N̉]ό`ɎgpC
   ϊÕ[hW̓_ (x, y) 
      x' = XFRM(1) + XFRM(2) * x + XFRM(3) * y
      y' = XFRM(4) + XFRM(5) * x + XFRM(6) * y
   ɂ (x', y') ɕϊB̋@\ Windows 9x/Me ł͐ɓ삵ȂB
-------------------------------------------------------------------------------
(͕ϐ)
   XFRM = ϊs̊e
-------------------------------------------------------------------------------
(o͕ϐ)
   IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Set Transformation Matrix
*******************************************************************************
[F] SUBROUTINE GWSETXFRM(IRTN, XFRM)
    INTEGER IRTN
    REAL XFRM(6)

[C] int GWsetxfrm(float *XFRM);
-------------------------------------------------------------------------------
Description
   Sets the transformation matrix.  The transformation matrix is used for 
   transformations such as rotations of bitmaps and marks.   A world coordinate 
   point (x, y) is transformed to (x', y') using 
      x' = XFRM(1) + XFRM(2) * x + XFRM(3) * y
      y' = XFRM(4) + XFRM(5) * x + XFRM(6) * y
   This does not work properly on Windows 9x/Me.

Input
   XFRM = the elements of the transformation matrix

Output
   IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWSETXFRM "^";
#endif
int GWSETXFRM(int *ret, float *XFRM)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWSETXFRM(int *ret, float *XFRM)
#else
int gwsetxfrm_(int *ret, float *XFRM)
#endif
#endif
{
	return (*ret = GWsetxfrm(XFRM));
}

int GWsetxfrm(float *XFRM)
{
	if(XFRM) {
		int x0, y0;
		x0 = (int)(WCtoLPx(XFRM[0]) - XFRM[1]*WCtoLPx(0.0F) - XFRM[2]*WCtoLPy(0.0F));
		y0 = (int)(WCtoLPy(XFRM[3]) - XFRM[4]*WCtoLPx(0.0F) - XFRM[5]*WCtoLPy(0.0F));
		return GW_setxfrm(nDOC, x0, y0, XFRM[1], -XFRM[2], -XFRM[4], XFRM[5]);
	} else {
		return GW_setxfrm(nDOC, 0, 0, 1.0F, 0.0F, 0.0F, 1.0F);
	}
}

int GW_setxfrm(int nDoc, int x0, int y0, 
		float t11, float t12, float t21, float t22)
{
	GW_Params(nDoc)->c.i.p0 = (int)(t11 * 65536);
	GW_Params(nDoc)->c.i.p1 = (int)(t12 * 65536);
	GW_Params(nDoc)->c.i.p2 = (int)(t21 * 65536);
	GW_Params(nDoc)->c.i.p3 = (int)(t22 * 65536);
	return _command(nDoc, GW_GENDOTOOL, TOOL_SETXFORM, x0, y0);
}


/*0
ϊs̎擾
*******************************************************************************
[F] SUBROUTINE GWGETXFRM(IRTN, XFRM)
    INTEGER IRTN
    REAL XFRM(6)

[C] int GWgetxfrm(float *XFRM);
-------------------------------------------------------------------------------
()
   ݂̕ϊs̐擾Bϊs̓rbg}bv}[N̉]ό`
   Ɏgp(GWGETXFRM Q)B
-------------------------------------------------------------------------------
(͕ϐ)
   Ȃ
-------------------------------------------------------------------------------
(o͕ϐ)
   XFRM = ϊs̊e(GWGETXFRM Q)
   IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Get Transformation Matrix
*******************************************************************************
[F] SUBROUTINE GWGETXFRM(IRTN, XFRM)
    INTEGER IRTN
    REAL XFRM(6)

[C] int GWgetxfrm(float *XFRM);
-------------------------------------------------------------------------------
Description
   Retrieves the current transformation matrix.  The transformation matrix is 
   used for transformations such as rotations of bitmaps and marks.

Input
   None

Output
   XFRM = the elements of the transformation matrix(See GWSETXFRM).
   IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWGETXFRM "^";
#endif
int GWGETXFRM(int *ret, float *XFRM)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWGETXFRM(int *ret, float *XFRM)
#else
int gwgetxfrm_(int *ret, float *XFRM)
#endif
#endif
{
	return (*ret = GWgetxfrm(XFRM));
}

int GWgetxfrm(float *XFRM)
{
	int ret, x0, y0;
	if(!XFRM) return 0;
	ret = GW_getxfrm(nDOC, &x0, &y0, &XFRM[1], &XFRM[2], &XFRM[4], &XFRM[5]);
	if(ret > 0) {
		XFRM[0] = LPtoWCx(x0);
		XFRM[3] = LPtoWCx(y0);
	}
	return ret;
}

int GW_getxfrm(int nDoc, int *x0, int *y0, 
		float *t11, float *t12, float *t21, float *t22)
{
	int ret = _command1(nDoc, GW_CMD, CMD_GETXFORM);
	if(ret > 0) {
		*x0 = GW_Params(nDoc)->y;
		*y0 = GW_Params(nDoc)->z;
		*t11 = GW_Params(nDoc)->c.i.p0/65536.0F;
		*t12 = GW_Params(nDoc)->c.i.p1/65536.0F;
		*t21 = GW_Params(nDoc)->c.i.p2/65536.0F;
		*t22 = GW_Params(nDoc)->c.i.p3/65536.0F;
	}
	return ret;
}


/*1
NbsÖ̐ݒ
*******************************************************************************
[F] SUBROUTINE GWSETRGN(IRTN, X1, Y1, X2, Y2, M)
    INTEGER IRTN, M
    REAL X1, Y1, X2, Y2

[C] int GWsetrgn(float X1, float Y1, float X2, float Y2, int M);
-------------------------------------------------------------------------------
()
   ݂̃NbsÖƃ[hWn̓_P (X1, Y1) Ɠ_Q (X2, Y2) Ίp
   Ƃlp` M Ŏw肳郂[hŌCVȃNbsÖƂB
   M < 0 ܂ M > 4 ŁCX1 = X2 ܂ Y1 = Y2 ̏ꍇɂ́CNbsO͉
   B
-------------------------------------------------------------------------------
(͕ϐ)
   X1 = _P X W([hWn)
   Y1 = _P Y W([hWn)
   X2 = _Q X W([hWn)
   Y2 = _Q Y W([hWn)
    M = 1: AND
        2: OR
        3: DIFF
        4: XOR
       : COPY

-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Set Clipping Region
*******************************************************************************
[F] SUBROUTINE GWSETRGN(IRTN, X1, Y1, X2, Y2, M)
    INTEGER IRTN, M
    REAL X1, Y1, X2, Y2

[C] int GWsetrgn(float X1, float Y1, float X2, float Y2, int M);
-------------------------------------------------------------------------------
Description
   Combines the current clipping region and a rectangular region specified by 
   a pair of two diagonal points (X1, Y1) and (X2, Y2) using a mode specified 
   by M, and sets the combined region as the current clipping region.   If 
   M < 0 or M > 4 and X1 = X2 or Y1 = Y2 the clipping region is removed.

Input
    X1 = the world x-coordinate of the point 1.
    Y1 = the world y-coordinate of the point 1.
    X2 = the world x-coordinate of the point 2.
    Y2 = the world y-coordinate of the point 2.
     M = 1: AND
         2: OR
         3: DIFF
         4: XOR
 otherwise: COPY

Output
 IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWSETRGN "^";
#endif
int GWSETRGN(int *ret, float *x1, float *y1, float *x2, float *y2, int *m)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWSETRGN(int *ret, float *x1, float *y1, float *x2, float *y2, int *m)
#else
int gwsetrgn_(int *ret, float *x1, float *y1, float *x2, float *y2, int *m)
#endif
#endif
{
	return (*ret = GW_setrgn(nDOC, 
		WCtoLPx(*x1), WCtoLPy(*y1), WCtoLPx(*x2), WCtoLPy(*y2), *m));
}

int GWsetrgn(float x1, float y1, float x2, float y2, int m)
{
	return GW_setrgn(nDOC, 
		WCtoLPx(x1), WCtoLPy(y1), WCtoLPx(x2), WCtoLPy(y2), m);
}

int GW_setrgn(int nDoc, int u1, int v1, int u2, int v2, int m)
{
	GW_Params(nDoc)->c.i.p0 = u1;
	GW_Params(nDoc)->c.i.p1 = v1;
	GW_Params(nDoc)->c.i.p2 = u2;
	GW_Params(nDoc)->c.i.p3 = v2;
	if(m < 0 || m >= GWR_NRGNOP) m = GWR_COPY;
	return _command2(nDoc, GW_GENDOTOOL, TOOL_SETRGN, m);
}
