/* Pen.c
 *
 * Copyright (C) 1998-2001 by TAMARIBUCHI, Tsuguhiro
 *
 *   WWW: http://sip.sci.shizuoka.ac.jp/grwin
 *
 */

#include "gw.h"

/*1
y̎w
*******************************************************************************
[F] SUBROUTINE GWSETPEN(IRTN, IPC, IPS, IPW, MX)
    INTEGER IRTN, IPC, IPS, IPW, MX

[C] int GWsetpen(int IPC, int IPS, int IPW, int MX);
-------------------------------------------------------------------------------
()
   JgEEBhEŎgpy̐FCCC[hw肷B
   (IPS=1)ȊO̐gpꍇ͐͂Pɐݒ肳B[hɂ
   CyuV̐FƁAłɕ`ĂȂǂƂ̐F̍@߂B
   MX > 15 ̏ꍇ MX-16 ̒l̂܂ "Q ROP R[h[W]" ƂĎgpB
   ƂāAlł΂̍ڂ͕ύXȂCIPC ɂĂ -1 ȊO
   ̒lɂ͓ʂ̈Ӗ̂ŒӁBׂĂ͕̓ϐ -1 ̏ꍇɂ̓yʒu
   (GWLINE2 Q)B
-------------------------------------------------------------------------------
(͕ϐ)
  IPC = _Fԍ
         -1 ̏ꍇ͕ύXȂ
         ̑̏ꍇɂĂ GWCOLOR ̍QƁB

  IPS = 
        0: (NULL)
        1: (SOLID)
        2: j(DASH)
        3: _(DOT)
        4: P_(DASHDOT)
        5: Q_(DASHDOTDOT)

  IPW = _foCXWnŎw肷B0 w肷ƃfoCXɂ炸
        1 sNZɂȂB

   MX = [h
        0:	NOP
        1:	BLACK
        2:	WHITE
        3:	NOT
        4:	COPYPEN
        5:	MASKPEN
        6:	MERGEPEN
        7:	XORPEN
        8:	NOTCOPYPEN
        9:	NOTMASKPEN
       10:	NOTMERGEPEN
       11:	NOTXORPEN
       12:	MASKNOTPEN
       13:	MASKPENNOT
       14:	MERGENOTPEN
       15:	MERGEPENNOT
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Set Pen Attributes
*******************************************************************************
[F] SUBROUTINE GWSETPEN(IRTN, IPC, IPS, IPW, MX)
    INTEGER IRTN, IPC, IPS, IPW, MX

[C] int GWsetpen(int IPC, int IPS, int IPW, int MX);
-------------------------------------------------------------------------------
Description
   Set color, style, width and mix mode of the current pen.   When the pen 
   style is specified other than as the solid line (IPS=1), the width is set 
   to 1.   The mix mode defines how to mix the colors of the current pen or 
   the current brush and the back grownd, or lines, etc., already drawn on the 
   window.   When MX > 15, the value (MX-16) is used as the "binary raster 
   operation code [W]".   In principle, a negative input parameter does not 
   change the corresponding attribute of the current pen.   It should be noted 
   that negative numbers other than -1 specified for IBC have special meanings.
   When the all parameters are specified to be equal to -1 the current pen 
   position is initialized (see GWLINE2).

Input
  IPC != -1: Logical color number (see GWCOLOR).
       = -1: unchanged

  IPS = pen style
        0: NULL
        1: SOLID
        2: DASH
        3: DOT
        4: DASHDOT
        5: DASHDOTDOT

  IPW = pen width in the logical device coordinate system.   When 0, the width 
        is set as 1 pixcel, regardless of the current output device. 

   MX = mix mode
        0:	NOP
        1:	BLACK
        2:	WHITE
        3:	NOT
        4:	COPYPEN
        5:	MASKPEN
        6:	MERGEPEN
        7:	XORPEN
        8:	NOTCOPYPEN
        9:	NOTMASKPEN
       10:	NOTMERGEPEN
       11:	NOTXORPEN
       12:	MASKNOTPEN
       13:	MASKPENNOT
       14:	MERGENOTPEN
       15:	MERGEPENNOT

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWSETPEN "^";
#endif
int GWSETPEN(int *ret, int *pc, int *ps, int *pw, int *pm)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWSETPEN(int *ret, int *pc, int *ps, int *pw, int *pm)
#else
int gwsetpen_(int *ret, int *pc, int *ps, int *pw, int *pm)
#endif
#endif
{
	return (*ret = GW_setpen(nDOC, *pc, *ps, *pw, *pm));
}

int GWsetpen(int pc, int ps, int pw, int pm)
{
	return GW_setpen(nDOC, pc, ps, pw, pm);
}

int GW_setpen(int nDoc, int pc, int ps, int pw, int pm)
{
	if(pc == -1 && ps == -1 && pw == -1 && pm == -1)
		return GW_move2(nDoc, -1, -1);	// initialize

	if(pc != -1) {
		GW_Params(nDoc)->p.GW_flags |= FLG_PCOLOR;
		GW_Params(nDoc)->p.GW_Pc = pc;
	}

	if((ps >= 0) && (ps < NPEN)) {
		GW_Params(nDoc)->p.GW_flags |= FLG_PSTYLE;
		GW_Params(nDoc)->p.GW_Ps = ps;
	}

	if(pw >= 0) {
		GW_Params(nDoc)->p.GW_flags |= FLG_PWIDTH;
		GW_Params(nDoc)->p.GW_Pw = pw;
	}

	if((pm >=0) && (pm < 32)) {
		GW_Params(nDoc)->p.GW_flags |= FLG_ROP2;
		GW_Params(nDoc)->p.GW_Px = pm;
	}

	return _command1(nDoc, GW_GENDOTOOL, TOOL_SETGDI);
}


/*0
y̎擾
*******************************************************************************
[F] SUBROUTINE GWGETPEN(IRTN, IPC, IPS, IPW, MX)
    INTEGER IRTN, IPC, IPS, IPW, MX

[C] int GWgetpen(int *IPC, int *IPS, int *IPW, int *MX);
-------------------------------------------------------------------------------
()
   JgEEBhEŎgpĂy̘_FԍCCC[h
   擾B
-------------------------------------------------------------------------------
(͕ϐ)
   Ȃ
-------------------------------------------------------------------------------
(o͕ϐ)
  IPC = _Fԍ
  IPS = 
  IPW = 
   MX = [h
 IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Get Pen Attributes
*******************************************************************************
[F] SUBROUTINE GWGETPEN(IRTN, IPC, IPS, IPW, MX)
    INTEGER IRTN, IPC, IPS, IPW, MX

[C] int GWgetpen(int *IPC, int *IPS, int *IPW, int *MX);
-------------------------------------------------------------------------------
Description
   Get the logical color value, style, width and mix mode of the current pen.

Input
   None

Output
  IPC = the logical color value
  IPS = style
  IPW = width
   MX = mix mode
 IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWGETPEN "^";
#endif
int GWGETPEN(int *ret, int *pc, int *ps, int *pw, int *pm)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWGETPEN(int *ret, int *pc, int *ps, int *pw, int *pm)
#else
int gwgetpen_(int *ret, int *pc, int *ps, int *pw, int *pm)
#endif
#endif
{
	return (*ret = GWgetpen(pc, ps, pw, pm));
}

int GWgetpen(int *pc, int *ps, int *pw, int *pm)
{
	if(pc) *pc = GW_pParams->p.GW_Pc;
	if(ps) *ps = GW_pParams->p.GW_Ps;
	if(pw) *pw = GW_pParams->p.GW_Pw;
	if(pm) *pm = GW_pParams->p.GW_Px;
	return nDOC;
}
