/* Lib.c
 *
 * Copyright (C) 1998-2002 by TAMARIBUCHI, Tsuguhiro
 *
 *   WWW: http://sip.sci.shizuoka.ac.jp/grwin
 *
 */

#include "gw.h"

UINT Cursors[] = {
	OCR_NORMAL,		// 32512
	OCR_IBEAM,		// 32513
	OCR_WAIT,		// 32514
	OCR_CROSS,		// 32515
	OCR_UP,			// 32516
	OCR_SIZE,		// 32640
	OCR_ICON,		// 32641
	OCR_SIZENWSE,	// 32642
	OCR_SIZENESW,	// 32643
	OCR_SIZEWE,		// 32644
	OCR_SIZENS,		// 32645
	OCR_SIZEALL,	// 32646
	OCR_NO,			// 32648
	OCR_APPSTARTING	// 32650
};


/*0
̓
*******************************************************************************
[F] SUBROUTINE GWINPUT(IRTN, TITLE, TXT)
    INTEGER IRTN
    CHARACTER TITLE*(*), TXT*(*)

[C] int GWinput(char *TITLE, char *TXT, int l);
-------------------------------------------------------------------------------
()
   L[{[h當͂邽߂̃_CAOJB
-------------------------------------------------------------------------------
(͕ϐ)
 TITLE = ^Cgo[ɕ\镶
     l = ϐ TXT ̒ ([C])
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ̒(oCg)
   TXT = (͂̏I̓^[L[)
*/
/*E
Input String
*******************************************************************************
[F] SUBROUTINE GWINPUT(IRTN, TITLE, TXT)
    INTEGER IRTN
    CHARACTER TITLE*(*), TXT*(*)

[C] int GWinput(char *TITLE, char *TXT, int l);
-------------------------------------------------------------------------------
Description
   Opens a dialog box to retrieve a string from keyboard.  

Input
 TITLE = string to be displayed at the title bar
     l = Length of the string variable TXT ([C]).

Output
  IRTN = length (Bytes) of the string retrieved.
   TXT = the string retrieved (input is terminated by Enter).
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWINPUT "^";
int GWINPUT(int *ret, CHARACTER *ttl, CHARACTER *str)
#else
int GWINPUT(int *ret, char *ttl, char *str, int l1, int l)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWINPUT(int *ret, char *ttl, int l1, char *str, int l)
#else
int gwinput_(int *ret, char *ttl, char *str, int l1, int l)
#endif
#endif
{
#ifdef __WATCOMC__
	_copyBuff(nDOC, ttl->p, ttl->l);
	if(_command1(nDOC, GW_CMD, CMD_INPUT)) {
		int ln, l = str->l;
		if((ln = strlen(GW_pBuffer)) < l) {
			strncpy(str->p, GW_pBuffer, l);
			while(--l >= ln)
				str->p[l] = ' ';
#else
	_copyBuff(nDOC, ttl, l1);
	if(_command1(nDOC, GW_CMD, CMD_INPUT)) {
		int ln;
		if((ln = strlen(GW_pBuffer)) < l) {
			strncpy(str, GW_pBuffer, l);
			while(--l >= ln)
				str[l] = ' ';
#endif
			return (*ret = ln);
		}
	}
	return 0;
}

int GWinput(char *ttl, char *str, int l)
{
	return GW_input(nDOC, ttl, str, l);
}

int GW_input(int nDoc, char *ttl, char *str, int l)
{
	_setBuff(nDoc, ttl);
	if(_command1(nDoc, GW_CMD, CMD_INPUT)) {
		int ln;
		if((ln = strlen(GW_Buffer(nDoc))) < l) {
			strncpy(str, GW_Buffer(nDoc), l);
			return ln;
		}
	}
	return 0;
}


/*0
_CAO{bNXɂt@C̎擾
*******************************************************************************
[F] SUBROUTINE GWFILEDLG(IRTN, FN)
    INTEGER IRTN
    CHARACTER FN*(*)

[C] int GWfiledlg(char *FN, int l);
-------------------------------------------------------------------------------
()
    ut@C̎擾v_CAO{bNXJăt@C擾B_CA
    O{bNXŎw肵t@Ci`͏nɈˑj̒()
    ϐ FN ̒𒴂ꍇɂ͎sCFN ͕ωȂB
-------------------------------------------------------------------------------
(͕ϐ)
  FN = lƂėpt@C
   l = ϐ FN ̒ ([C])
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN > 0: 擾t@C̒
      < 0: -(_CAO{bNXŎw肵t@C̒ > l)
      = 0: ̎s
   FN = 擾t@C (ꍇ)
_______________________________________________________________________________
*/
/*E
Popup File Dialog
*******************************************************************************
[F] SUBROUTINE GWFILEDLG(IRTN, FN)
    INTEGER IRTN
    CHARACTER FN*(*)

[C] int GWfiledlg(char *FN, int l);
-------------------------------------------------------------------------------
Description
    Retrieves a file name using File Dialog (Windows).  If the length of the 
    specified file name, which depends on the implementation of the compiler 
    used, is longer than the length of the string variable FN or l ([C]), it 
    fails and the variable FN is unchanged.

Input
  FN = a filename used to initialize the File Name edit control.
   l = Length of the string buffer ([C]).

Output
  FN > 0: length of the file name retrieved.
     < 0: -(length of the file name specified in the dialog box > l).
     = 0: failed
 IRTN = 
   FN = Retrieved file name (when succeeded).
______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWFILEDLG "^";
int GWFILEDLG(int *ret, CHARACTER *fname)
#else
int GWFILEDLG(int *ret, char *fname, int l)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWFILEDLG(int *ret, char *fname, int l)
#else
int gwfiledlg_(int *ret, char *fname, int l)
#endif
#endif
{
#ifdef __WATCOMC__
	int ln, l = fname->l;
	_copyBuff(nDOC, fname->p, l);
	if(_command1(nDOC, GW_CMD, CMD_FILE_DIALOG) == IDOK) {
		if((ln = strlen(GW_pBuffer)) < l) {
			strncpy(fname->p, GW_pBuffer, l);
			while(--l >= ln)
				fname->p[l] = ' ';
#else
	int ln;
	_copyBuff(nDOC, fname, l);
	if(_command1(nDOC, GW_CMD, CMD_FILE_DIALOG) == IDOK) {
		if((ln = strlen(GW_pBuffer)) < l) {
			strncpy(fname, GW_pBuffer, l);
			while(--l >= ln)
				fname[l] = ' ';
#endif
			return (*ret = ln);
		} else if(ln > 0)
			return (*ret = -ln);
	}
	return (*ret = 0);
}

int GWfiledlg(char *fname, int l)
{
	return GW_filedlg(nDOC, fname, l);
}

int GW_filedlg(int nDoc, char *fname, int l)
{
	int ln;
	_setBuff(nDoc, fname);
	if(_command1(nDoc, GW_CMD, CMD_FILE_DIALOG) == IDOK) {
		if((ln = strlen(GW_Buffer(nDoc))) < l) {
			strncpy(fname, GW_Buffer(nDoc), l);
			return ln;
		} else if(ln > 0)
			return -ln;
	}
	return 0;
}


/*0
f[^̓ǂݍ
*******************************************************************************
[F] SUBROUTINE GWLOAD(IRTN, IC, FN)
    INTEGER IRTN
    CHARACTER FN*(*)

[C] int GWload(int IC, char *FN);
-------------------------------------------------------------------------------
()
    ۑt@C(*.gwd)ǂݍ݁C`悷Bt@C FN Ŏw肳ꂽt@C
    Ȃꍇ̓t@C擾̃_CAO{bNXJBp[^ IC
    ̒lɂ蓮삪قȂBkڂ𒲐ȂƂɂ́Cۑ(foCXɈˑ
    ) kڂŌEBhEɒǉ̂ŁCۑƈقȂœǂݍޏ
    Ȃǂɂ͒ӂKvB
-------------------------------------------------------------------------------
(͕ϐ)
    IC = 0: kڂ𒲐ȂŒǉBp^͕ȂB
       = 1: kڂ𒲐Ēǉ(p^͕Ȃ)
       = 2: kڂ𒲐ȂŒǉCp^𕜌
        : kڂ𒲐ĒǉCp^𕜌
    FN = ۑt@C(t@C͎st@CƓfBNgɒuCt
         pXŎw肵Ȃ΂ȂȂ)
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Load Data
*******************************************************************************
[F] SUBROUTINE GWLOAD(IRTN, IC, FN)
    INTEGER IRTN
    CHARACTER FN*(*)

[C] int GWload(int IC, char *FN);
-------------------------------------------------------------------------------
Description
    Loads the graphic objects from a file (*.gwd) specified with a file name 
    FN.  A File Dialog pops up if failed to load with the specified file name.
    The parameter IC controls size matchings for the saved objects and 
    restorations of internal parameters for a continuation of the saved job.

Input
    IC = 0: only draws the objects (no resize, no parameter restoration)
         1: draws the objects with resizes (no parameter restoration)
         2: draws the objects with parameter restorations (no resize)
 otherwise: draws the objects with resizes and parameter restorations

    FN = file name (the file must be in the same directory as the exe file for 
         the application unless specified as full path).

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWLOAD "^";
int GWLOAD(int *ret, int *ic, CHARACTER *fname)
#else
int GWLOAD(int *ret, int *ic, char *fname, int l)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWLOAD(int *ret, int *ic, char *fname, int l)
#else
int gwload_(int *ret, int *ic, char *fname, int l)
#endif
#endif
{
#ifdef __WATCOMC__
	return (*ret = GW_load(nDOC, *ic, _copyBuff(nDOC, fname->p, fname->l)));
#else
	return (*ret = GW_load(nDOC, *ic, _copyBuff(nDOC, fname, l)));
#endif
}

int GWload(int ic, char *fname)
{
	return GW_load(nDOC, ic, fname);
}

int GW_load(int nDoc, int ic, char *fname)
{
	FILE *fp;
	if(_setBuff(nDoc, fname) == 0) _setBuff(nDoc, "*.gwd");
	if((fp = fopen(GW_Buffer(nDoc), "r"))) {
		fclose(fp);
	} else {
		if(_command1(nDoc, GW_CMD, CMD_FILE_DIALOG) != IDOK)
			return 0;
	}
	return _command2(nDoc, GW_CMD, CMD_FILE_LOAD, ic);
}


/*0
f[^̕ۑ
*******************************************************************************
[F] SUBROUTINE GWSAVEAS(IRTN, MF, MV, IW, IH, FN)
    INTEGER IRTN, MF, MV, IW, IH
    CHARACTER FN*(*)

[C] int GWsaveas(int MF, int MV, int IW, int IH, char *FN);
-------------------------------------------------------------------------------
()
    }`f[^C̓p[^ MF Ŏw肵t@C`Ńt@CɕۑB
    t@Cw肷̓p[^ FN ̒ 0 ( FN == NULL [C]) ̏ꍇ
    ́Ct@C擾̃_CAO{bNXJBMF  0 ܂ C邢͑
    ̖Ȓlݒ肳ꂽꍇɂ́Ct@C̊gqɂt@C`
    Bt@C̊gqt@C`łȂꍇɂ GrWin 
    L̃t@C`iGWD t@C`j肳CKvȂΊgq '.gwd' t
    Br[(\)[hw肷̓p[^ MV ƁCۑt@C
    ƍ^̓p[^ IWCIH ̒lɂ\͈͂AXyNg䂪
    ̂ŒӁB^̓̓p[^̒l 0 ̏ꍇɂ̓ftHglg
    BIW ܂ IH ɕ̒lݒ肳ꂽꍇɂ͂ꂼ̌]B
    ̃[`͕ۑ[hiGWMODE QƁj on ̏ꍇɐɓ삷B
-------------------------------------------------------------------------------
(͕ϐ)
    MF = t@C` (gq, ƍ̒P)
       = 1: GWD t@C ('.gwd', Ȃ) 
       = 2: g^t@C ('.emf', 0.01 mm)
       = 3: rbg}bv ('.bmp', sNZ)
!      = 4: JPEG t@C ('.jpg', sNZ)
!      = 5: PNG t@C ('.png', sNZ)
!      = 6: EPS t@C ('.eps', Ȃ)
    MV = r[[h
         1: rbg}bv
         2: I
         3: tBbg
         4: S
         5: ݂̃r[|[g
    IW =  (Pʂ MF ̍QƁj
    IH = iPʂ MF ̍QƁj
    FN = t@C
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Save Data
*******************************************************************************
[F] SUBROUTINE GWSAVEAS(IRTN, MF, MV, IW, IH, FN)
    INTEGER IRTN, MF, MV, IW, IH
    CHARACTER FN*(*)

[C] int GWsaveas(int MF, int MV, int IW, int IH, char *FN);
-------------------------------------------------------------------------------
Description
    Saves the graphics data into a named file with a file format specified by 
    the parameter MF.   If the specified value MF is equal to or less than 0, 
    or another invalid value is specified, the file format is determined from 
    the specified file name if possible, or otherwise is assumed to be the GWD 
    format, the internal format for grwnd.exe, with the extension '.gwd' 
    appended.   A File Dialog pops up when the length of the file name 
    specified by FN is equal to zero (or FN == NULL [C]).  The result, the 
    aspect ratio and the saved area, etc., depends on the viewmode specified 
    by MV and the sizes IW and IH.   When a negative value is specified for IW 
    or IH the corresponding direction is reversed.    A default value is used 
    for an integral parameter if the value 0 is specified for it.  This routine
    works normally in case the storing mode is set on.
Input
    MF = file format (the file extention, the unit assumed for IW and IH)
       = 1: GWD format ('.gwd', n/a) 
       = 2: extended metafile format ('.emf', 0.01 mm)
       = 3: DIB (device independent bitmap) format ('.bmp', pixels)
!      = 4: JPEG format ('.jpg', pixels)
!      = 5: PNG format ('.png', pixels)
!      = 6: EPS format ('.eps', n/a)
    MV = view mode
         1: Bitmap
         2: Isotropic
         3: Fit
         4: Total
         5: the current view port
    IW = width (see above for the unit)
    IH = height (see above for the unit)
    FN = file name
Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWSAVEAS "^";
int GWSAVEAS(int *ret, int *f, int *m, int *w, int *h, CHARACTER *fname)
#else
int GWSAVEAS(int *ret, int *f, int *m, int *w, int *h, char *fname, int l)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWSAVEAS(int *ret, int *f, int *m, int *w, int *h, char *fname, int l)
#else
int gwsaveas_(int *ret, int *f, int *m, int *w, int *h, char *fname, int l)
#endif
#endif
{
#ifdef __WATCOMC__
	return (*ret = GW_saveas(nDOC, *f, *m, *w, *h, _copyBuff(nDOC, fname->p, fname->l)));
#else
	return (*ret = GW_saveas(nDOC, *f, *m, *w, *h, _copyBuff(nDOC, fname, l)));
#endif
}

int GWsaveas(int f, int m, int w, int h, char *fname)
{
	return GW_saveas(nDOC, f, m, w, h, fname);
}

int GW_saveas(int nDoc, int f, int m, int w, int h, char *fname)
{
	_setBuff(nDoc, fname);
	GW_Params(nDoc)->c.i.p0 = f;
	GW_Params(nDoc)->c.i.p1 = m;
	return _command(nDoc, GW_CMD, CMD_FILE_SAVE, w, h);
}

#if 1	// for backward compatibility
#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWSAVE "^";
int GWSAVE(int *ret, CHARACTER *fname)
#else
int GWSAVE(int *ret, char *fname, int l)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWSAVE(int *ret, char *fname, int l)
#else
int gwsave_(int *ret, char *fname, int l)
#endif
#endif
{
#ifdef __WATCOMC__
	return (*ret = GW_saveas(nDOC, 0, 0, 0, 0, _copyBuff(nDOC, fname->p, fname->l)));
#else
	return (*ret = GW_saveas(nDOC, 0, 0, 0, 0, _copyBuff(nDOC, fname, l)));
#endif
}

int GWsave(char *fname)
{
	return GW_saveas(nDOC, 0, 0, 0, 0, fname);
}
#endif


/*0

*******************************************************************************
[F] SUBROUTINE GWPRINT(IRTN, IW, MV)
    INTEGER IRTN, IW, MV

[C] int GWprint(int IW, int MV);
-------------------------------------------------------------------------------
()
    IW Ŏw肳ꂽEBhEBIW = 0 ̏ꍇ̓JgEEBhE
    BIW < 0 ̏ꍇɂ̓AvP[VJׂẴEBhE
    BMV ɂ͈̃r[(\)[hw肷BIW < 0 ̏ꍇɂ̓J
    gEEBhĚ݂̃r[(\)[hiGWVWMOD QƁj肳B
    [`͕ۑ[hiGWMODE QƁj on ̏ꍇɐɓ삷B
-------------------------------------------------------------------------------
(͕ϐ)
    IW = EBhẼEBhEԍB
    MV = r[[h
         1: rbg}bv
         2: I
         3: tBbg
         4: S
         5: ݂̃EBhES
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Print
*******************************************************************************
[F] SUBROUTINE GWPRINT(IRTN, IW, MV)
    INTEGER IRTN, IW, MV

[C] int GWprint(int IW, int MV);
-------------------------------------------------------------------------------
Description
    Prints out a window specified with the window number IW.  When IW = 0, the 
    current window is printed out.   When IW < 0 all windows opened by the 
    apprication are printed out.   The view mode for the printing can be 
    specified by MV.   When MV < 0, the current view mode (see GWMODE) of the 
    current window is assumed.   This routine works normally in case the 
    storing mode is set on.

Input
    IW = the window number to be printed
    MV = view mode
         1: Bitmap
         2: Isotropic
         3: Fit
         4: Total
         5: the current window

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWPRINT "^";
#endif
int GWPRINT(int *ret, int *n, int *m)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWPRINT(int *ret, int *n, int *m)
#else
int gwprint_(int *ret, int *n, int *m)
#endif
#endif
{
	return (*ret = GW_print(*n, *m));
}

int GWprint(int n, int m)
{
	return GW_print(n, m);
}

int GW_print(int nDoc, int nMode)
{
	int ret = 0;
	if(nDoc == 0) {
		return _command2(nDOC, GW_CMD, CMD_PRINT, nMode);
	} else if(nDoc > 0) {
		if(FileMaps[nDoc]) 
			return _command2(nDoc, GW_CMD, CMD_PRINT, nMode);
		else
			return 0;
	}
	for(nDoc = 1; nDoc < MAXDOCS; ++nDoc)
		if(FileMaps[nDoc]) {
			ret = _command2(nDoc, GW_CMD, CMD_PRINT, nMode);
			if(ret <= 0) return 0;
		}
	return ret;
}


/*0
IuWFNgEO[vԍ̐ݒ
*******************************************************************************
[F] SUBROUTINE GWSETOGN(IRTN, ISRC, IDST)
    INTEGER IRTN, ISRC, IDST

[C] int GWsetogn(int ISRC, int IDST);
-------------------------------------------------------------------------------
(IuWFNgEO[vԍɂ)
   IuWFNgEO[vԍ (OGN) Ƃ͊e`IuWFNg(}`vf)𕪗ނ
   ߂ɗpӂꂽIuWFNg̑̈ŁCOGN ̃IuWFNg͕`悪
   Cobt@iFBFtbVEobt@jɕۑBvZԂ̂
   镡GȐ}`̍\zȂǕ`ۗĂCOGN ̕𐳂ɕύX邱Ƃɂ
   `ۗ̕CɉāCȕ`sƂłBtbV
   `ƌĂԁB܂Cۑ[hiGWMODE QƁjȈꍇɂ́CIuWFNg
   `ɃɕۑiVACYjCOGN ͂ۑIuWFNg̑I
   Iȏ (GWERASE Q) Ȃǂ̂߂ɂQƂBftHg OGN  1 
   ZbgĂ(OGN = 0 ̓VXeŎgp)BȂCۑ[hiGWMODE 
   QƁjIt̏ꍇɂ́C`ɃIuWFNg͏̂ŁCOGN  FB 
   ۑIuWFNgɑ΂ĂLB|OGN|  32767 ȉłȂ΂ȂȂB
()
   ISRC != 0 ̏ꍇɂ OGN  ISRC ɓۑIuWFNg OGN  IDST ɕ
   XCOGN ̒l ISRC ɓۑIuWFNg̐ IRTN ɕԂB
   ƂCOGN 畉ɕύXƑΉIuWFNg͕ۗԂɖ߂ĉ
   ʂB΂ɁC琳ɕύXƕۗԂCtbV`
   悪sBOGN  0 ɕύXƂ̓VXeݒpIuWFNgƂāC
   ȌłȂȂBISRC = 0CIDST != 0 ̏ꍇɂ́Cȍ~ɕ`悳I
   uWFNg OGN  IDST Ŏw肳ꂽlɐݒ肳C݂̃IuWFNg̑
    IRTN ɕԂBISRC = IDST = 0 ̏ꍇɂ OGN ͕ύXꂸC݂ OGN 
    IRTN ɕԂB

   ISRC  IDST :                       : o͒l
  ------------+---------------------------+--------------------------
     +  !  0  : ی                      : ی삳ꂽIuWFNg
     +  =  +  : Ȃ                : ۑIuWFNg OGN  ISRC 
                                            ̂̑
     +  !  +  : ۑIuWFNgOGNύX : OGNύXꂽIuWFNg
     +  =  -  : ISRCB                : BꂽIuWFNg
     +  !  -  : ISRCIDSTɕύXCB  : BꂽIuWFNg
     -  !  0  : tbV`ɕی    : ی삳ꂽIuWFNg
     -  =  +  : tbV`            : tbV`悳ꂽIuWFNg
     -  !  +  : tbV`OGNύX : tbV`悳ꂽIuWFNg
     -  =  -  : Ȃ                : FB  OGN  -ISRC ɓIu
                                            WFNg̐
     -  !  -  : FBISRCIDSTɌ: ꂽIuWFNg
     0  =  0  : Ȃ                : ݂ OGN
     0  ! +/- : ݂OGNύX       : ۑIuWFNg
  
   [ L '='C'!'  ISRC  IDST ̐ΒlłȂ\B] 
-------------------------------------------------------------------------------
(͕ϐ)
  ISRC != 0: IuWFNg OGN (= ISRC)  IDST ɕύX
        = 0: ȍ~ OGN  IDST (!= 0) Ƃ
  IDST  = Zbg OGN
-------------------------------------------------------------------------------
(o͕ϐ)
   IRTN = OGN ̒l ISRC ɓIuWFNg̐ (ISRC != 0 ̏ꍇ)
        = ݂̃IuWFNg̑ (ISRC = 0, IDST != 0 ̏ꍇ)
        = ݂ OGN  (ISRC = IDST = 0 ̏ꍇ)
      < 0 s̏ꍇ
_______________________________________________________________________________
*/
/*E
Set Object-Group Number
*******************************************************************************
[F] SUBROUTINE GWSETOGN(IRTN, ISRC, IDST)
    INTEGER IRTN, ISRC, IDST

[C] int GWsetogn(int ISRC, int IDST);
-------------------------------------------------------------------------------
Description
   The object-group number (OGN) is an attribute of an object for grouping the 
   objects.  The objects having a negative OGN are stored in an internal flush 
   buffer (FB) corresponding to the value of the OGN, and are suspended or not 
   displayed in drawing until a flushing is made.  A flushing is made by 
   turning the negative OGN of them to a positive one.  When the storing mode 
   is set on (see GWMODE), objects drawn are stored or serialized in memory.   
   The OGN is referred, for example, in selective erasing (GWERASE) of those 
   serialized objects with the OGN.   On default the current OGN is set equal 
   to 1.  The OGN = 0 is used by the system.  When the storing mode is set off 
   (see GWMODE), drawn objects are not serialized and the features referring 
   OGN's for serialized objects are not available, in principle.   |OGN| must 
   be less than 32768.
   
   When ISRC != 0 the OGN's of the objects whose OGN's are equal to ISRC are 
   set equal to IDST, and the number of them is returned to IRTN.  When 
   ISRC = 0 and IDST != 0, the current OGN for the subsequent objects is set 
   equal to IDST, and the current number of the stored objects is returned.  
   When ISRC = IDST = 0, the current OGN is returned.  The storing mode must be 
   set on to use this routine.
  
   ISRC  IDST : action                    : return value
  ------------+---------------------------+--------------------------
     +  !  0  : protects ISRC             : # of stored objs that got protected
     +  =  +  : nothing                   : # of stored objs with OGN = ISRC
     +  !  +  : changes OGN of stored objs: # of stored objs with OGN = IDST
     +  =  -  : hides ISRC                : # of objs that got hidden
     +  !  -  : hides ISRC as -IDST       : # of objs that got hidden
     -  !  0  : flushes & protects ISRC   : # of objs that got protected
     -  =  +  : flushes ISRC              : # of objs that got flushed
     -  !  +  : flushes ISRC & changes OGN: # of objs that got flushed
     -  =  -  : nothing                   : # of objs in the FB with OGN = ISRC
     -  !  -  : merge ISRC to IDST in FB  : # of objs that got merged
     0  =  0  : nothing                   : the current OGN
     0  ! +/- : changes the current OGN   : total # of the stored objs
  
   [ The symbol '=' or '!' between src and dst stands for whether src and dst 
     are equal in their absolute values or not.] 

Input
  ISRC != 0: sets OGN's of the existing objects with OGN = ISRC equal to IDST
        = 0: sets the current OGN equal to IDST (!= 0)
  IDST  = the OGN to be set

Output
   IRTN = the number of objects whose OGN's are equal to ISRC (if ISRC != 0)
        = the current number of the objects (if ISRC = 0 and IDST != 0)
        = the current OGN  (if ISRC = IDST = 0)
      < 0 failed
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWSETOGN "^";
#endif
int GWSETOGN(int *ret, int *s, int *d)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWSETOGN(int *ret, int *s, int *d)
#else
int gwsetogn_(int *ret, int *s, int *d)
#endif
#endif
{
	return (*ret = _command(nDOC, GW_CMD, CMD_SETOGN, *s, *d));
}

int GWsetogn(int s, int d)
{
	return _command(nDOC, GW_CMD, CMD_SETOGN, s, d);
}


/*1,-x
AJ[
*******************************************************************************
[F] SUBROUTINE GWANCHOR(IRTN, N)
    INTEGER IRTN, N

[C] int GWanchor(int N);
-------------------------------------------------------------------------------
()
   AJ[̐ݒƏsBAJ[Ƃ̓IuWFNgEO[vԍ (OGN) 
   0 ̉ȂIuWFNgłCɁCGWFLUSH  GWERASE Ƒgݍ킹āC
   ܂łɕ`悵IuWFNg̕یɗpBftHgł́Cی삳ꂽIu
   WFNg͔wiƂčĕ`ɎgpBeAJ[̓IuWFNg̐擪
   牽Ԗڂ̃AJ[ɂAJ[ԍŎʂBۑ[hiGWMODE QƁj
    off ̏ꍇCAJ[̓IuWFNgƂĂ̈ӖCwi̕ۑ̂߂
   ɎgB
-------------------------------------------------------------------------------
(͕ϐ)
     N > 0: IuWFNg̍ŌɃAJ[BN ̒l݂̃AJ[ɓ
            ꍇɂ́CÕAJ[菜āCAJ[͕ωȂB
       < 0: IuWFNg̍Ō |N| ̃AJ[菜B
       = 0: ׂẴAJ[菜B
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN >  0: ݂̃AJ[
      == 0: AJ[̒ǉɎs
      <  0: -(菜Ƃ̂łȂAJ[)
_______________________________________________________________________________
*/
/*E
Anchor
*******************************************************************************
[F] SUBROUTINE GWANCHOR(IRTN, N)
    INTEGER IRTN, N

[C] int GWanchor(int N);
-------------------------------------------------------------------------------
Description
   Adds or removes anchors.  An anchor is an object that does nothing with the 
   object group number 0.  Anchors are used to protect earlier objects from 
   erasing with GWERASE or GWFRUSH.   On default, the anchor added with this 
   function becomes the background anchor, which is associated with a 
   background surface used in fast redrawings.   Each anchor is identified 
   with the anchor number, the sequential number of the anchor in the anchors 
   counted from the head of the objects.   When the storing mode is set off, 
   the anchor is not an object but is used only to store a background surface.

Input
    N >  0: adds an anchor at the tail of the objects.  If the value of N is 
            equal to the current number of the anchors, the last anchor is 
            removed before adding.
      <  0: removes |N| anchors from the tail
      =  0: removes all anchors

Output
 IRTN >  0: the anchor number
      == 0: failed to add an anchor
      <  0: -(number of the anchors that could not been removed)
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWANCHOR "^";
#endif
int GWANCHOR(int *ret, int *n)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWANCHOR(int *ret, int *n)
#else
int gwanchor_(int *ret, int *n)
#endif
#endif
{
	return (*ret = _command2(nDOC, GW_CMD, CMD_ANCHOR, *n));
}

int GWanchor(int n)
{
	return _command2(nDOC, GW_CMD, CMD_ANCHOR, n);
}


/*x
wi̐ݒ
*******************************************************************************
[F] SUBROUTINE GWSETBK(IRTN, N)
    INTEGER IRTN, N

[C] int GWsetbk(int N);
-------------------------------------------------------------------------------
()
    AJ[ԍ N ( > 0 ) ̃AJ[wiAJ[ɐݒ肷BN = 0 ̏ꍇɂ
    wi[h (AJ[͍폜Ȃ)BN < 0 w肵ꍇɂ́C
    ݂̔wiAJ[ԍAJ[̖₢킹sB
-------------------------------------------------------------------------------
(͕ϐ)
    N >  0: AJ[ԍ N ̃AJ[wiAJ[ɐݒ肷Bw肵ԍ
            AJ[݂Ȃꍇɂ͉ȂB
      =  0: wigpȂ
      = -1: wiAJ[ԍ̖₢킹
      < -1: AJ[̖₢킹
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN >= 0: ݂̔wĩAJ[ԍ (N >= -1) ܂̓AJ[̑ (N < -1)
      <  0: G[
_______________________________________________________________________________
*/
/*E
Set Background
*******************************************************************************
[F] SUBROUTINE GWSETBK(IRTN, N)
    INTEGER IRTN, N

[C] int GWsetbk(int N);
-------------------------------------------------------------------------------
Description
    Sets the anchor with the anchor number N (> 0) to be the background anchor.
    If N = 0, the background mode is turned off.  When N < 0 is specified, 
    inquires the current anchor number or the number of the anchors.  

Input
    N >  0: sets the anchor with the anchor number N to be the background 
            anchor, or does nothing if no anchor of the specified anchor number 
            exists.
      =  0: turns OFF the background mode
      = -1: inquires the current anchor number
      < -1: inquires the current total number of the anchors

Output
 IRTN >= 0: the current background anchor number (N >= -1) or 
            the current number of the anchors (N < -1)
      <  0: error
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWSETBK "^";
#endif
int GWSETBK(int *ret, int *m)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWSETBK(int *ret, int *m)
#else
int gwsetbk_(int *ret, int *m)
#endif
#endif
{
	return (*ret = _command2(nDOC, GW_CMD, CMD_BACKGROUND, *m));
}

int GWsetbk(int m)
{
	return _command2(nDOC, GW_CMD, CMD_BACKGROUND, m);
}

int GW_setbk(int nDoc, int m)
{
	return _command2(nDoc, GW_CMD, CMD_BACKGROUND, m);
}

/*-x
}`̏
*******************************************************************************
[F] SUBROUTINE GWERASE(IRTN, N, LRF)
    INTEGER IRTN, N, LRF

[C] int GWerase(int N, int LRF);
-------------------------------------------------------------------------------
()
   N > 0 ̏ꍇɂ́CIuWFNgEO[vԍ (GWSETOGN Q) ̐Βl N 
   ׂẴIuWFNg(}`vf)[BN = 0 ̏ꍇ̓J
   gEEBhÊׂẴIuWFNgC܂CN < 0 ̏ꍇɂ͍Ō
    abs(N) ȉ̃IuWFNgBLRF  0 łȂꍇɂ́C
   ꂽIuWFNgɑΉ}`ʏォɏ邪CLRF = 0 ̏
   ɂ͌Ăяoʂ͕ωCĕ`̍ۂɌʂfBȂC
   Ō̃IuWFNg珇ɍsCOGN  0 ̃IuWFNgɒBꍇɂ͂
   ŏIB̃[`͕ۑ[hiGWMODE QƁj on ̏ꍇɐɓ
   삷B
-------------------------------------------------------------------------------
(͕ϐ)
    N > 0: IuWFNg OGN ̐Βl
      = 0: JgEEBhȄ
      < 0: Ō abs(N) ̃IuWFNg̏
  LRF = ĕ`tO(0 ̂Ƃĕ`sȂ)
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ۂɏꂽIuWFNg̑
_______________________________________________________________________________
*/
/*E
Erase
*******************************************************************************
[F] SUBROUTINE GWERASE(IRTN, N, LRF)
    INTEGER IRTN, N, LRF

[C] int GWerase(int N, int LRF);
-------------------------------------------------------------------------------
Description
   Erases the objects with the abs(OGN) = N when N > 0.  When N = 0 the objects
   with non zero object group numbers are erased.  If a negative integer is 
   given for N, the last abs(N) objects are erased.  The argument LRF is a flag 
   for refreshing.   The current window is not refreshed immediately when 
   LRF = 0 is specified, otherwise the graphic objects as instances of the 
   objects deleted disappear from the current window.   The erasing is made from
   the tail of the objects, and is quitted if an object with OGN = 0 is reached.
   This routine works normally in case the storing mode is set on.

Input
    N > 0: erases the objects with the abs(OGN) = N
      = 0: erases the current window
      < 0: erases the last abs(N) objects
  LRF = flag for refreshing ( no refreshing when LRF = 0 )

Output
  IRTN = the number of the erased objects
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWERASE "^";
#endif
int GWERASE(int *ret, int *ogn, int *rdrw)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWERASE(int *ret, int *ogn, int *rdrw)
#else
int gwerase_(int *ret, int *ogn, int *rdrw)
#endif
#endif
{
	return (*ret = _command(nDOC, GW_CMD, CMD_ERASE, *ogn, *rdrw));
}

int GWerase(int ogn, int rdrw)
{
	return _command(nDOC, GW_CMD, CMD_ERASE, ogn, rdrw);
}

int GW_erase(int nDoc, int ogn, int rdrw)
{
	return _command(nDoc, GW_CMD, CMD_ERASE, ogn, rdrw);
}


/*-x
tbV`
*******************************************************************************
[F] SUBROUTINE GWFLUSH(IRTN, N)
    INTEGER IRTN, N

[C] int GWflush(int N);
-------------------------------------------------------------------------------
()
   N > 0 ̏ꍇ́COGN (GWSETOGN Q)  -N ɓׂẴIuWFNg(}`
   vf)  OGN ̕𐳂ɕύXătbV`sBN < 0 ̏ꍇɂ
   OGN ̐Βl N ɓIuWFNg OGN ׂ̕Ĕ]COGN 
   ȂIuWFNg菜BɂCΒlŕقȂIuWF
   Ng̕\̐؂ւsBN = 0 ̏ꍇ̓IuWFNgEO[vԍ
   ̃IuWFNg̕𔽓]CtbV`sBIRTN ɂ͕`悳ꂽ
   IuWFNg̑ԂB̃[`gpꍇ͕ۑ[hiGWMODE Q
   Ɓj on ɃZbgĂȂ΂ȂȂB
-------------------------------------------------------------------------------
(͕ϐ)
     N > 0: OGN = -N ̃IuWFNgtbV`
       < 0: iOGN = -Nj{tbV`iOGN = Nj
       = 0: `ۗĂׂẴIuWFNg̃tbV`
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = `悳ꂽIuWFNg̑
_______________________________________________________________________________
*/
/*E
Flushing
*******************************************************************************
[F] SUBROUTINE GWFLUSH(IRTN, N)
    INTEGER IRTN, N

[C] int GWflush(int N);
-------------------------------------------------------------------------------
Description
   Flushes suspended objects.   When N > 0 the objects with the OGN being equal
   to -N are flushed and the OGN's of them is inverted to be positive.   
   When N < 0 the objects with the OGN being equal to -N are erased, and the 
   objects with the OGN being equal to N are flushed with the sign inversions. 
   When N = 0 all suspended objects with negative OGN are flushed with the 
   sign inversions.  The number of the objects flushed is returned to IRTN.
   The storing mode must be set on to use this routine.

Input
     N > 0: flushes the objs with the OGN = -N
       < 0: erases the objs with the OGN = -N 
            and flushes the objs with the OGN = N
       = 0: flushes all suspended objects

Output
  IRTN = the number of the objects flushed
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWFLUSH "^";
#endif
int GWFLUSH(int *ret, int *ogn)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWFLUSH(int *ret, int *ogn)
#else
int gwflush_(int *ret, int *ogn)
#endif
#endif
{
	return (*ret = _command2(nDOC, GW_CMD, CMD_FLUSH, *ogn));
}

int GWflush(int ogn)
{
	return _command2(nDOC, GW_CMD, CMD_FLUSH, ogn);
}

int GW_flush(int nDoc, int ogn)
{
	return _command2(nDoc, GW_CMD, CMD_FLUSH, ogn);
}


/*0
ʂ̍ĕ`
*******************************************************************************
[F] SUBROUTINE GWREFRESH(IRTN)
    INTEGER IRTN

[C] int GWrefresh(void);
-------------------------------------------------------------------------------
()
   JgEEBhEĕ`悷Bj[o[  [r[] -> [ĕ`] 
   B̃[`͕ۑ[hiGWMODE QƁj on ̏ꍇɐɓ삷B
-------------------------------------------------------------------------------
(͕ϐ)
    Ȃ
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Refresh
*******************************************************************************
[F] SUBROUTINE GWREFRESH(IRTN)
    INTEGER IRTN

[C] int GWrefresh(void);
-------------------------------------------------------------------------------
Description
   Refreshs the current window ( = [View] -> [Redraw] at Menu Bar).  This 
   routine works normally in case the storing mode is set on.

Input
   None

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWREFRESH "^";
#endif
int GWREFRESH(int *ret)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWREFRESH(int *ret)
#else
int gwrefresh_(int *ret)
#endif
#endif
{
	return (*ret = _command1(nDOC, GW_CMD, CMD_REFRESH));
}

int GWrefresh(void)
{
	return _command1(nDOC, GW_CMD, CMD_REFRESH);
}

int GW_refresh(int nDoc)
{
	return _command1(nDoc, GW_CMD, CMD_REFRESH);
}


/*0
r[[h
*******************************************************************************
[F] SUBROUTINE GWVWMOD(IRTN, M)
    INTEGER IRTN, M

[C] int GWvwmod(int M);
-------------------------------------------------------------------------------
()
   JgEEBhẼr[(\)[h̐ݒ/₢킹sB EBhE
   JĂȂꍇɂ̓ftHg̃r[[h̐ݒ/₢킹sBf
   tHg̃r[[h̓EBhẼI[viGWopen QƁjɎQƂB
-------------------------------------------------------------------------------
(͕ϐ)
    M = 1:    rbg}bv
        2:    I
        3:    tBbg
        4:    S
        5:    gĩ݂r[|[gցFݒ莞j
       :    ₢킹
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = JgEEBhẼr[(\)[h(͕ϐ̍ڎQ, 0: s)
_______________________________________________________________________________
*/
/*E
View Mode
*******************************************************************************
[F] SUBROUTINE GWVWMOD(IRTN, M)
    INTEGER IRTN, M

[C] int GWvwmod(int M);
-------------------------------------------------------------------------------
Description
   Sets or inquires the view mode of the current window, if any, or the default 
   view mode, which is reffered in opening a windos (see GWopen).

Input
     M = 1:   Bitmap
         2:   Isotropic
         3:   Fit
         4:   Total
         5:   Zoom in (to the current view port, on setting)
 otherwise:   inquire the view mode

Output
  IRTN = the view mode of the current window (see above, 0: if failed)
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWVWMOD "^";
#endif
int GWVWMOD(int *ret, int *m)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWVWMOD(int *ret, int *m)
#else
int gwvwmod_(int *ret, int *m)
#endif
#endif
{
	return (*ret = GW_viewmode(nDOC, *m));
}

int GWvwmod(int m)
{
	return GW_viewmode(nDOC, m);
}


/*0
[hݒƖ₢킹
*******************************************************************************
[F] SUBROUTINE GWMODE(IRTN, MD, M)
    INTEGER IRTN, MD, M

[C] int GWmode(int MD, int M);
-------------------------------------------------------------------------------
()
   e탂[hiȉQƁj̐ݒ//₢킹sB[h̎ʂƐݒ胂[h
    MD  M Ŏw肷D

   1. ۑF ۑ[h on ̏ꍇɂ͐}`IuWFNg͕`Ƀɕۑ
      iVACYjCĕ`t@Cւ̕ۑCɍėpB
      ۑ[h off ̏ꍇC}`IuWFNg͕`ɍ폜Bۑ[h
      ̉ɂ胁[gpʂ}邪ĈƂɕ`悳ꂽIuWFN
      g̃t@Cւ̕ۑ͐̂ŒӁBftHgł onB

   2. obt@OF obt@OsƁC݂̉ʂƓ\́upv
      IɃrbg}bvƂėpӂCʂւ̍ĕ`悪B
      ̏kڂɂĂ͑ʂ̃[BftH[gł on B   

   3. Xe[^XEo[̕\F Xe[^XEo[Ƃ̓C(t[)EEBhE
      ŉ̃o[̂ƂŁCeԂ\B`ɍsꍇ̓X
      e[^XEo[\\Ȃق悢BftHgł onB

   4. mFF ܂܂ȏʂŁCx⒍ӂ𑣂_CAO{bNX\B
      ftHgł offB

   5. hXP[vF ɗpuihXP[vjɐݒ肷B
      ftHgł onB

   6. EBhEJ܂܏IF GWQUIT ̌ĂяoƂCEBhEJ
      ܂܏IBftHgł offB

   7. rbg}bv̖ߍ݁F gwd t@CɃrbg}bv𖄂ߍށB̃[h off ɂ΃rbg}bvEt@CoƂłBftHgł onB
-------------------------------------------------------------------------------
(͕ϐ)
   MD = 1 :  ۑ
        2 :  obt@O
        3 :  Xe[^Xo[̕\
        4 :  mF
        5 :  hXP[v
        6 :  EBhEJ܂܏I
        7 :  rbg}bv̖ߍ
        :  
    M = 0 :   (off) 
      > 0 :  ݒ (on) 
      < 0 :  ₢킹̂
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = 0 :   (off) Ă
        1 :  ݒ (on) Ă
       -1 :  G[
_______________________________________________________________________________
*/
/*E
Setting and Inquiring Modes
*******************************************************************************
[F] SUBROUTINE GWMODE(IRTN, MD, M)
    INTEGER IRTN, MD, M

[C] int GWmode(int MD, int M);
-------------------------------------------------------------------------------
Description
   Sets or inquires a mode (see below).   The input parameters MD and M are for 
   specifying a sort of mode and the mode to be set, respectively.  

   1. Storing:  When this mode is set on, objects drawn are stored (serialized) 
      in memory, and will be used in redrawing printing, and saving to a file, 
      etc.   With this mode set off, on the contrary, they are deleted and the 
      amount of memories used can be reduced, though features based on the 
      serialization such as redrawing, printing and saving are not available, 
      in principle.   The default status of this mode is set on.

   2. Buffering:  When status of this mode turned on an internal bitmap is 
      created as a copy of the current window, and subsequent drawings are 
      made on the bitmap.  The drawing on the bitmap is faster but is memory 
      consuming.  The default status of this mode is set on.

   3. Displaying status bar:  For fast drawings it is recommended to set this 
      mode off.  The default status of this mode is set on.

   4. Inquiring:  Shows dialog boxes in some aspects.  The default status of 
      this mode is set off.

   5. Landscape:  The landscape mode is used in printing.  The default status 
      of this mode is set on.

   6. Staying open on QUIT:  Leaves the main frame window open when GWQUIT 
      is called.  The default status of this mode is set off.

   7. Embedding BMPs:  Embedes the bitmaps in a gwd file (see GWsaveas) when 
      the gwd is specified as an output file format.  To extract bitmaps to 
      *.bmp files this mode must set off.  The default status of this mode is 
      set on.

Input
   MD = 1 :  storing mode
        2 :  buffering mode
        3 :  displaying status bar mode
        4 :  Inquiring
        5 :  Landscape
        6 :  Staying open on QUIT
        7 :  Embedding BMPs
   others :  not defined
    M = 0 :  sets off
      > 0 :  sets on
      < 0 :  inquires the current status

Output
 IRTN = 0 :  off
        1 :  on
       -1 :  error
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWMODE "^";
#endif
int GWMODE(int *ret, int *md, int *m)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWMODE(int *ret, int *md, int *m)
#else
int gwmode_(int *ret, int *md, int *m)
#endif
#endif
{
	return (*ret = GW_mode(nDOC, *md, *m));
}

int GWmode(int md, int m)
{
	return GW_mode(nDOC, md, m);
}

int GW_mode(int nDoc, int md, int m)
{
	return _command(nDoc, GW_CMD, CMD_MODE, md, m);
}
