/* Core.c
 *
 * Copyright (C) 1998-2002 by TAMARIBUCHI, Tsuguhiro
 *
 *   WWW: http://sip.sci.shizuoka.ac.jp/grwin
 *
 */

#include "gw.h"
#include <ctype.h>

/*0

*******************************************************************************
[F] SUBROUTINE GWINIT(IRTN)
    INTEGER IRTN

[C] int GWinit(void);
-------------------------------------------------------------------------------
()
    CȕsB̍ہCC(t[)EEBhEJĂ
    Ȃ΁Cgrwnd.exe IvVȂŎsCJBAvP[V2x
    ȏ̌ĂяosĂ邾ŎQ͂ȂB
     GWinitx(-1,-1,-1,-1,-1,-1,-1,-1,-1) ƓB
    GWopen ̌ĂяoɁCKvȂ玩IɌĂяôŒʏ͏ȗB
*******************************************************************************
[F] SUBROUTINE GWINITX(IRTN, IRB, IX, IY, IW, IH, MA, MM, MZ, ND)
    INTEGER IRTN, IRB, IX, IY, IW, IH, MA, MM, MZ, ND

[C] int GWinitx(int IRB, int IX, int IY, int IW, int IH, int MA, int MM, 
		int MZ, int ND);
-------------------------------------------------------------------------------
()
    CȕsCC(t[)EEBhEJĂȂ
    grwnd.exe Xg̕тɑΉIvVŎsCJBAvP[
    V2xȏ̌ĂяosĂ邾ŎQ͂ȂB̒l
    ̏ꍇɂ͑ΉR}hCEIvV͐ȂB
    GWopen ̌ĂяoɁCKvȂ GWinitx(-1,-1,-1,-1,-1,-1,-1,-1) I
    ĂяôŁCIvVwsꍇďȗB
-------------------------------------------------------------------------------
(͕ϐ)
    IRB = O*32 + L*16 + I*8 + R*4 + B*2 + T*1 
            + 65536*(o*32 + l*16 + i*8 + r*4 + b*2 + t*1)
          O = 1[0] IɃEBhE [Ȃ]
          L = 1[0] v^̃hXP[vipujE[h ON [OFF]
          I = 1[0] mF[h ON [OFF]
          R = 1[0] Xe[^Xo[\ ON [OFF]
          B = 1[0] obt@OE[h ON [OFF]
          T = 1[0] ۑ[h ON [OFF]
       [l, i,... ́Cꂼ L, I,... ̐ݒ荀ڂɑΉ}XNrbg
       i0 ܂ 1jŁC}XNrbg 1 ̐ݒ荀ڂ͖]
 IX, IY = t[̍̃XN[W (sNZl)
 IW, IH = t[̕ƍ (sNZl)
     MA = EBhE̔zu[hԍ (MA = 1..4)B GWarrange(MA) ƓB
     MM = t[̕\[hԍ (MM = 0..14)B GWshowfr(MM) ƓB
     MZ = t[̕\[hԍ (MZ = 1..4)B GWshowfr(MZ+10) ƓB
     ND = Ȃǂɉ肳𑜓xidpi lj
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Initialize
*******************************************************************************
[F] SUBROUTINE GWINIT(IRTN)
    INTEGER IRTN

[C] int GWinit(void);
-------------------------------------------------------------------------------
Description
    Initializes the GrWin Library, and open the main frame window by executing 
    grwnd.exe with no option if it has not yet been opened.  This routine is 
    equivalent to GWinitx(-1,-1,-1,-1,-1,-1,-1,-1,-1).
    Usually there is no need to call this routine because GWopen (or GWopenx) 
    calls this automatically if necessary.
*******************************************************************************
[F] SUBROUTINE GWINITX(IRTN, IRB, IX, IY, IW, IH, MA, MM, MZ, ND)
    INTEGER IRTN, IRB, IX, IY, IW, IH, MA, MM, MZ, ND

[C] int GWinitx(int IRB, int IX, int IY, int IW, int IH, int MA, int MM, 
		int MZ, int ND);
-------------------------------------------------------------------------------
Description
    Initializes the GrWin Library, and open the main frame window by executing 
    grwnd.exe with options corresponding to the arguments given.  If a negative 
    value is specified for an argument, no corresponding option is generated.
    Usually there is no need to call this routine because GWopen (or GWopenx) 
    calls GWinitx(-1,-1,-1,-1,-1,-1,-1,-1,-1) automatically if necessary, 
    unless you want to specify options.

Input
    IRB = O*32 + L*16 + I*8 + R*4 + B*2 + T*1 
            + 65536*(o*32 + l*16 + i*8 + r*4 + b*2 + t*1)
          O = 1[0] the staying open on QUIT mode is set ON [OFF].
          L = 1[0] the landscape printer mode is set ON [OFF].
          I = 1[0] the inquring mode is set ON [OFF].
          R = 1[0] the status bar is displayed [not displayed].
          B = 1[0] the buffering mode is set ON [OFF].
          T = 1[0] the storing mode is set ON [OFF].
      [ l, i,... are the mask bits for the above setting switches L, I,..., 
       respectively.  A setting switch with the corresponding mask bit set 1 
       is ignored. ]
 IX, IY = Screen coordinates (in pixels) of the top-left corner of the frame
 IW, IH = Width and height (in pixels) of the frame
     MA = Mode number (MA = 1..4) for Arrange Window. [GWarrange(MA)]
     MM = Mode number (MM = 0..14) for Frame's Show State. [GWshowfr(MM)]
     MZ = Mode number (MZ = 1..4) for the Z-Order of the frame. [GWshowfr(MZ+10)]
     ND = The default dpi value for printing, etc.

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWINIT "^";
#endif
int GWINIT(int *ret)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWINIT(int *ret)
#else
int gwinit_(int *ret)
#endif
#endif
{
	return (*ret = GW_init(-1,-1,-1,-1,-1,-1,-1,-1,-1));
}

int GWinit(void)
{
	return GW_init(-1,-1,-1,-1,-1,-1,-1,-1,-1);
}

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWINITX "^";
#endif
int GWINITX(int *ret, int *bzi, int *x, int *y, int *w, int *h, 
		int *a, int *m, int *z, int *d)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWINITX(int *ret, int *bzi, int *x, int *y, int *w, int *h, 
		int *a, int *m, int *z, int *d)
#else
int gwinitx_(int *ret, int *bzi, int *x, int *y, int *w, int *h, 
		int *a, int *m, int *z, int *d)
#endif
#endif
{
	return (*ret = GW_init(*bzi, *x, *y, *w, *h, *a, *m, *z, *d));
}

int GWinitx(int bzi, int x, int y, int w, int h, int a, int m, int z, int d)
{
	return GW_init(bzi, x, y, w, h, a, m, z, d);
}


/*1
EBhẼI[v
*******************************************************************************
[F] SUBROUTINE GWOPEN(IRTN, NW)
    INTEGER IRTN, NW

[C] int GWopen(int NW);
-------------------------------------------------------------------------------
()
    GWopenx  IW = 0, IH = 0, IFC = -1, IBC = -1, M = -1, FN = ''(NULL) 
   w肵̂ƓB

*******************************************************************************
[F] SUBROUTINE GWOPENX(IRTN, NW, IW, IH, IFC, IBC, M, FN)
    INTEGER IRTN, NW, IW, IH, IFC, IBC, M
    CHARACTER FN*(*)

[C] int GWopenx(int NW, int IW, int IH, int IFC, int IBC, int M, char *FN);
-------------------------------------------------------------------------------
()
   NW > 0 ̏ꍇɂ́Cw肳ꂽԍ NWAt@C FN ̃EBhEJB
   NW = 0 ̏ꍇ͎gĂȂEBhEԍgpB̍ہCgp̃
   C(t[)EEBhEȂ΁CGWINIT Ăяoďs
   Bł 'WC' (GWJOIN Q) ɐĂꍇɂ NW  FN ̎w
   BIW  IH ɂ͗p̕ƍ 0.1mm PʂŎw肷BIɂ́C
   w肳ꂽi邢͏ȗĺjƍCшȂǂɉ肳𑜓xi
   GWinitx QƁjƂɃobt@prbg}bvETCY肳BIFC  
   IBC ͑OiFƔwiF̏l_FԍŎw肷BǂC̒lݒ肳
   ꂽꍇɂ͏ȗlpB ȂCwiF IBC ̎wɂ Windows Wp
   bgƑ COLORREF lwłȂ(GWcolor Q)B M (0..10) ̓I[v
   ̃EBhE̕\ (GWshowwn Q)B
-------------------------------------------------------------------------------
(͕ϐ)
   NW = EBhEԍ (0,1,2,3,...)
   IW = p̕ (0 ̏ꍇAv^[̏ȗlgp)
   IH = p̍ (0 ̏ꍇAv^[̏ȗlgp)
  IFC = OiF̏l(_Fԍ: GWCOLOR Q)Bȗl 0  ()
  IBC = wiF̏l(_Fԍ: GWCOLOR Q)Bȗl 19 ()
    M = I[ṽEBhE̕\ (< 0 ̏ꍇ͏ȗl)
   FN = OtBNXEf[^ۑꍇ̃ftHg̃t@C
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = ۂɊJꂽEBhEԍ ( > 0 ), ŝƂ 0
_______________________________________________________________________________
*/
/*E
Open Window
*******************************************************************************
[F] SUBROUTINE GWOPEN(IRTN, NW)
    INTEGER IRTN, NW

[C] int GWopen(int NW);
-------------------------------------------------------------------------------
Description
   This routine is equivalent to GWopenx (see the next) with IW = 0, IH = 0, 
   IFC = -1, IBC = -1, M = -1 and FN = ''(NULL).   
*******************************************************************************
[F] SUBROUTINE GWOPENX(IRTN, NW, IW, IH, IFC, IBC, M, FN)
    INTEGER IRTN, NW, IW, IH, IFC, IBC, M
    CHARACTER FN*(*)

[C] int GWopenx(int NW, int IW, int IH, int IFC, int IBC, int M, char *FN);
-------------------------------------------------------------------------------
Description
   When NW > 0 a new window with the specified window number NW opens, and an 
   unused window number is used for the new window when NW = 0.  When the join 
   mode (see GWJOIN) has been set up successflly parameters NW and FN are 
   ignored.  In any case GWinitx(-1,-1,-1,-1,-1,-1,-1,-1) is called to open a 
   main frame window if necessary.  If the opening or the joining to an window 
   is succeeded the number of actually opened window, or 0 otherwise, is 
   returned to IRTN.  The argument FN is used to the default file name in 
   saving data.   The internal paper size in unit of 0.1 mm is given by the 
   width IW and the height IH assuming landscape (IW > IH).   Internally these 
   values are used with the resolution assumed in printing, etc. (see GWinitx) 
   to determin sizes of bitmaps for buffers, for example.   If the value is 
   equal to 0 for IW or IH, or '' for FN, default values are used.    IFC and 
   IBC are initial logical color values (LCV: See GWCOLOR) for the foreground 
   color and the background color, respectively.  Only one of the reserved 
   color values 0..20 or a palette-relative RGB values (See GWCOLOR) can be 
   specified for the initial background color IBC.   M is an initial window's 
   show state (0..10: see GWshowwn) for the window.   For IFC, IBC or M, if an 
   invalid value is specified, a default value is used.

Input
   NW > window number
      = 0: open a new window
   IW > paper width (in 0.1 mm)
      = 0: width of the current printer in pixels is used
   IH > paper height (in 0.1 mm)
      = 0: height of the current printer in pixels is used
  IFC = initial LCV of the foreground color (>= 0);   0 (black) on default
  IBC = initial LCV of the background color (>= 0);  19 (white) on default
    M = window's show state (0..10)
   FN = default file name in saving graphics data

Output
 IRTN = window number ( > 0 ), 0 if failed.
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWOPEN "^";
#endif
int GWOPEN(int *ret, int *nDoc)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWOPEN(int *ret, int *nDoc)
#else
int gwopen_(int *ret, int *nDoc)
#endif
#endif
{
	return (*ret = GWopenx(*nDoc,0,0,-1,-1,-1,NULL));
}

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWOPENX "^";
int GWOPENX(int *ret, int *nDoc, int *Width, int *Height, int *fc, int *bc, 
		int *Mode, CHARACTER *fname)
#else
int GWOPENX(int *ret, int *nDoc, int *Width, int *Height, int *fc, int *bc, 
		int *Mode, char *fname, int l)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWOPENX(int *ret, int *nDoc, int *Width, int *Height, int *fc, int *bc, 
		int *Mode, char *fname, int l)
#else
int gwopenx_(int *ret, int *nDoc, int *Width, int *Height, int *fc, int *bc, 
		int *Mode, char *fname, int l)
#endif
#endif
{
	char fn[MAX_PATH];
#ifdef __WATCOMC__
	int l = fname->l;
	strncpy(fn, fname->p, min(l, MAX_PATH-1));
#else
	strncpy(fn, fname, min(l, MAX_PATH-1));
#endif
	l = min(l, MAX_PATH-1);
	while((--l >= 0) && (fn[l] == ' ')) 
			fn[l] = '\0';
	if(l >= 0)
		return (*ret = GWopenx(*nDoc, *Width, *Height, *fc, *bc, *Mode, fn));
	else
		return (*ret = GWopenx(*nDoc, *Width, *Height, *fc, *bc, *Mode, NULL));
}

int GWopen(int nDoc)
{
	return GW_open(nDoc,0,0,-1,-1,-1,NULL);
}

int GWopenx(int nDoc, int Width, int Height, int fc, int bc, 
		int Mode, char *fname)
{
	return GW_open(nDoc, Width, Height, fc, bc, Mode, fname);
}


/*0
I
*******************************************************************************
[F] SUBROUTINE GWQUIT(IRTN)
    INTEGER IRTN

[C] int GWquit(void);
-------------------------------------------------------------------------------
()
   I_CAO\C҂ĂCAvP[VJׂĂ
   EBhEāAIsBɊJĂEBhEꍇɂ
   C(t[)EEBhEB GWquitx(1) ƓB

*******************************************************************************
[F] SUBROUTINE GWQUITX(IRTN, MQ)
    INTEGER IRTN, MQ

[C] int GWquitx(int MQ);
-------------------------------------------------------------------------------
()
   AvP[VJׂẴEBhEAIsB̒l
   ďI_CAO̐sB
-------------------------------------------------------------------------------
(͕ϐ)
   MQ = 0 :   I_CAOoɒɏIsB
        :   I_CAO\ĂC͂҂ďIsB
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Quit
*******************************************************************************
[F] SUBROUTINE GWQUIT(IRTN)
    INTEGER IRTN

[C] int GWquit(void);
-------------------------------------------------------------------------------
Description
   Pops up an ending dialog, and wait for a button clicked.  Then close all 
   window which is/are opened by the application, and close the main frame 
   window if there is no other application which has opened windows in it.  
   This routine is equivalent to GWquitx(1).
*******************************************************************************
[F] SUBROUTINE GWQUITX(IRTN, MQ)
    INTEGER IRTN, MQ

[C] int GWquitx(int MQ);
-------------------------------------------------------------------------------
Description
   Closes the window(s) opened by the application and the main frame window.  
   When the input parameter MQ is not equal to 0 an ending dialog appears. 

Input
   MQ  = 0 :   quit now
      != 0 :   popup an ending dialog, and then quit.

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWQUIT "^";
#endif
int GWQUIT(int *ret)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWQUIT(int *ret)
#else
int gwquit_(int *ret)
#endif
#endif
{
	return (*ret = GW_quit(1));
}

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWQUITX "^";
#endif
int GWQUITX(int *ret, int *MQ)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWQUITX(int *ret, int *MQ)
#else
int gwquitx_(int *ret, int *MQ)
#endif
#endif
{
	return (*ret = GW_quit((*MQ)?1:0));
}

int GWquit(void)
{
	return GW_quit(1);
}

int GWquitx(int MQ)
{
	return GW_quit(MQ?1:0);
}


/*0
EBhEȂŏI
*******************************************************************************
[F] SUBROUTINE GWLEAVE(IRTN)
    INTEGER IRTN

[C] int GWleave(void);
-------------------------------------------------------------------------------
()
   EBhEȂŁAIsB
-------------------------------------------------------------------------------
(͕ϐ)
   Ȃ

-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Leave
*******************************************************************************
[F] SUBROUTINE GWLEAVE(IRTN)
    INTEGER IRTN

[C] int GWleave(void);
-------------------------------------------------------------------------------
Description
  Leaves from the graphics window without closing the window. 

Input
  None

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWLEAVE "^";
#endif
int GWLEAVE(int *ret)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWLEAVE(int *ret)
#else
int gwleave_(int *ret)
#endif
#endif
{
	return (*ret = GW_quit(-1));
}

int GWleave(void)
{
	return GW_quit(-1);
}


/*0,2
WCiǉ`̊Jnj
*******************************************************************************
[F] SUBROUTINE GWJOIN(IRTN, NW, IN, IS, JND)
    INTEGER IRTN, NW, IN, IS
    CHARACTER JND*(*)

[C] int GWjoin(int NW, int IN, int IS, char *JND);
-------------------------------------------------------------------------------
()
   ̓p[^ (NW, IN) Ŏw肳ꂽEBhEɐڑĒǉ`s߂
   iWCjsB̓p[^ IN ŃCEEBhEiGrWndj
   CNW ŃEBhEԍiGWopen QƁjw肷B{[` GWinit[x] 
    GWopen[x] ɌĂяoȂ΂ȂȂB GWinit[x]  GWopen[x] 
   Ăяoꂽ_Ŗ{ݒ肪LƂȂCNW, IN ̂ǂ̓̓p[^ɂ
   Ă 0 w肳ꂽꍇɂ́CΉEBhEōŏɂ݂̂g
   C݂Ȃꍇ͐VɊJB'WC'̃EBhȄ͕ϐ JND 
   Ŏ󂯎邱ƂłB'WC'\ǂm邾̏ꍇ IS  0 
   ݒ肷΂悢B̏ꍇCo͕ϐ̐ݒ肾'WC'͍sȂ
   ŁC'WC'ꍇɂ IS  0 łȂlݒ肵Ė{[`x
   ĂяoKvB

   ӁFP̃EBhEɕ̃AvP[V'WC'ꍇ̌ʂɂ
   Ă͕ۏ؂ȂB
-------------------------------------------------------------------------------
(͕ϐ)
   NW = EBhEԍ (0,1,2,3,...)
   IN = CEEBhEiGrWndjԍ (0,1,2,3,...)
-------------------------------------------------------------------------------
(o͕ϐ)
  JND = 'WC'ɐꍇ́CCEEBhEԍCEBhEԍCA
        vP[VJ}ŋ؂Bsꍇ͋̕B
 IRTN = ۂɊJꂽEBhEԍ ( > 0 ), ŝƂ 0
_______________________________________________________________________________
*/
/*E
Join in a Window
*******************************************************************************
[F] SUBROUTINE GWJOIN(IRTN, NW, IN, IS, JND)
    INTEGER IRTN, NW, IN, IS
    CHARACTER JND*(*)

[C] int GWjoin(int NW, int IN, int IS, char *JND);
-------------------------------------------------------------------------------
Description
   Joins in an existent window, that is, begins drawing in the existent window 
   specified.   A main frame (GrWnd) window as the target is specified by the 
   input parameter IN, and a child window within the main frame window by NW.
   This routine must be called before any calls to GWopen[x] and GWinit[x] and 
   tries to change manners of working of them suited to the join mode.   For 
   each of the parameters NW and IN,  an corresponding existent window found 
   first is used when the specified value is set equal to 0.  When failed or a 
   negative value is spesified to an input paramter a corresponding new window 
   opens.  If succeeded the actually joined window number, or 0 if failed, is 
   returned to IRTN.  Information of the joining window can be retrieved by 
   the variable JND.  If the specified value for IS is 0, no joining is made 
   at all, but the output variables are set as if it was actually made.  
   Getting information with setting IS = 0 you can make joining by calling 
   again this routine with IS != 0.

   CAUTION: Result when more than one applications are joined togather in a 
   frame window is unknown.

Input
   NW = a window number
   IN = a main frame window (GrWnd) number

Output
  JND = a string composed of the main frame window number and the window number
        followed by the application name with commas as separators if succeeds.
        An empty string otherwise.
 IRTN = the joined window number ( > 0 ), 0 if failed.
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWJOIN "^";
int GWJOIN(int *ret, int *nDoc, int *nWnd, int *bDo, CHARACTER *str)
#else
int GWJOIN(int *ret, int *nDoc, int *nWnd, int *bDo, char *str, int l)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWJOIN(int *ret, int *nDoc, int *nWnd, int *bDo, char *str, int l)
#else
int gwjoin_(int *ret, int *nDoc, int *nWnd, int *bDo, char *str, int l)
#endif
#endif
{
#ifdef __WATCOMC__
	if(str->l > 10)
		return (*ret = GW_join(*nDoc,*nWnd,*bDo,str->p));
#else
	if(l > 10)
		return (*ret = GW_join(*nDoc,*nWnd,*bDo,str));
#endif
	else
		return (*ret = GW_join(*nDoc,*nWnd,*bDo,NULL));
}

int GWjoin(int nDoc, int nWnd, int bDo, char *str)
{
	return GW_join(nDoc,nWnd,bDo,str);
}


/*1
p[^̍ď
*******************************************************************************
[F] SUBROUTINE GWRESET(IRTN)
    INTEGER IRTN

[C] int GWreset(void);
-------------------------------------------------------------------------------
()
   ݂̃EBhE̊ep[^ftHglɖ߂B
-------------------------------------------------------------------------------
(͕ϐ)
   Ȃ

-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Reset Parameters
*******************************************************************************
[F] SUBROUTINE GWRESET(IRTN)
    INTEGER IRTN

[C] int GWreset(void);
-------------------------------------------------------------------------------
Description
   Resets the internal parameters for the current window.

Input
   None

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWRESET "^";
#endif
int GWRESET(int *ret)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWRESET(int *ret)
#else
int gwreset_(int *ret)
#endif
#endif
{
	return (*ret = _command1(nDOC, GW_GENDOTOOL, TOOL_RESET));
}

int GWreset(void)
{
	return _command1(nDOC, GW_GENDOTOOL, TOOL_RESET);
}

int GW_reset(int nDoc)
{
	return _command1(nDoc, GW_GENDOTOOL, TOOL_RESET);
}


/*0
EBhẼN[Y
*******************************************************************************
[F] SUBROUTINE GWCLOSE(IRTN, NW)
    INTEGER IRTN, NW

[C] int GWclose(int NW);
-------------------------------------------------------------------------------
()
   w肵OtBNXEEBhEB
-------------------------------------------------------------------------------
(͕ϐ)
   NW > 0: w肵ԍ̃EBhEN[Y
      = 0: JgEEBhEN[Y
      < 0: AvP[VJׂẴEBhE
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = JgEEBhEԍCJĂEBhE 0
_______________________________________________________________________________
*/
/*E
Close Window
*******************************************************************************
[F] SUBROUTINE GWCLOSE(IRTN, NW)
    INTEGER IRTN, NW

[C] int GWclose(int NW);
-------------------------------------------------------------------------------
Description
   Closes the window(s) depending on the value of NW.

Input
   NW > 0: window number
      = 0: the current window
      < 0: the all windows which are opened by the application

Output
 IRTN = the current window number, or 0 if there is no window opened by the 
        application
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWCLOSE "^";
#endif
int GWCLOSE(int *ret, int *nDoc)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWCLOSE(int *ret, int *nDoc)
#else
int gwclose_(int *ret, int *nDoc)
#endif
#endif
{
	*nDoc = GW_close(*nDoc);
	return (*ret = *nDoc);
}

int GWclose(int nDoc)
{
	return GW_close(nDoc);
}


/*0
[hWn̐ݒ
*******************************************************************************
[F] SUBROUTINE GWINDOW(IRTN, X1,Y1,X2,Y2)
    INTEGER IRTN
    REAL X1,Y1,X2,Y2

[C] int GWindow(float X1, float Y1, float X2, float Y2);
-------------------------------------------------------------------------------
()
   r[|[g̓_ƉE̓_̍W[hWŗ^邱Ƃɂ胏[
   hWnݒ肷BftHgł͗p̃TCY͍_ɁC 
       (X1, Y1, X2, Y2) = (0.0, 0.0, 640.0, 640.0/U2*V2)
   ɐݒ肳ĂD(U2,V2) ́DKi_Wnɂr[|[g̉E̓_
   ̍WBX1 = X2  Y1 != Y2 ̏ꍇɂ́C r[|[gӒ̓_̃[
   hW (X1, Y1)Cr[|[g̃[hWnł̍ | Y2 - Y1 | ́CA
   XyNgic̃XP[j 1:1 ̍Wnݒ肳BlɁCX1 != X2 
    Y1 = Y2 ̏ꍇɂ́Cɍ킹AXyNg䂪 1:1 ̍Wnݒ肳
   B X1 = X2  Y1 = Y2 ̏ꍇɂ́C[hWn͘_foCXWnƓ
   ɂȂB
-------------------------------------------------------------------------------
(͕ϐ)
   X1 = r[|[g X W([hWn)
   Y1 = r[|[g Y W([hWn)
   X2 = r[|[gE X W([hWn)
   Y2 = r[|[gE Y W([hWn)
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Set World Coordinate System
*******************************************************************************
[F] SUBROUTINE GWINDOW(IRTN, X1,Y1,X2,Y2)
    INTEGER IRTN
    REAL X1,Y1,X2,Y2

[C] int GWindow(float X1, float Y1, float X2, float Y2);
-------------------------------------------------------------------------------
Description
   Sets the world coordinate system (WCS) by specifying the bottom-left corner 
   (X1, Y1) and the top-right corner (X2, Y2) of the view port in WCS to be set.
   On default WCS is defined as identical as the logical coordinate system 
   where the size is equal to the paper size and the origin is at the bottom-
   left corner of the view port.  If X1 = X2 with Y1 != Y2 is specified, the 
   width in WCS of the view port is chosen so as to make isotropic window 
   with the aspect ratio 1:1 using the height |Y2 - Y1| in WCS.  In this case 
   the world coordinate of the bottom-center becomes (X1, Y1).  Similarly if 
   X1 != X2 with Y1 = Y2 is specified, an isotropic world coordinate system is 
   made using the width of the view port |X2 - X1| in WCS.  When X1 = X2 and 
   Y1 = Y2, WCS is chosen identical to the logical device coordinate system as 
   default.

Input
   X1 = the world x-coordinate of the bottom-left corner of the view port
   Y1 = the world y-coordinate of the bottom-left corner of the view port
   X2 = the world x-coordinate of the top-right corner of the view port
   Y2 = the world y-coordinate of the top-right corner of the view port

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWINDOW "^";
#endif
int GWINDOW(int *ret, float *x1, float *y1, float *x2, float *y2)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWINDOW(int *ret, float *x1, float *y1, float *x2, float *y2)
#else
int gwindow_(int *ret, float *x1, float *y1, float *x2, float *y2)
#endif
#endif
{
	return (*ret = GWindow(*x1, *y1, *x2, *y2));
}

int GWindow(float x1, float y1, float x2, float y2)
{
	if(x2 == x1 && y2 == y1) {
		int w, h;
		GWsize(1, &w, &h);
		GW_X1 = 0;
		GW_Y1 = 0;
		GW_X2 = (float)(w-1);
		GW_Y2 = (float)(h-1);
		GW_RX = 0;
		GW_RY = 0;
		GW_PM = 1;
	} else {
		if(x2 == x1 && y2 != y1) {
			float w2 = (y2 - y1)/(GW_V2-GW_V1)*(GW_U2-GW_U1)/2;
			GW_X1 = x1 - w2;
			GW_Y1 = y1;
			GW_X2 = x1 + w2;
			GW_Y2 = y2;
		} else if(x2 != x1 && y2 == y1) {
			float h2 = (x2 - x1)/(GW_U2-GW_U1)*(GW_V2-GW_V1)/2;
			GW_X1 = x1;
			GW_Y1 = y1 - h2;
			GW_X2 = x2;
			GW_Y2 = y1 + h2;
		} else {
			GW_X1 = x1;
			GW_Y1 = y1;
			GW_X2 = x2;
			GW_Y2 = y2;
		}
		GW_RX = GW_DU*(GW_U2-GW_U1)/(GW_X2-GW_X1);
		GW_RY = GW_DU*(GW_V2-GW_V1)/(GW_Y2-GW_Y1);
		GW_PM = 0;
	}
	_command1(nDOC, GW_CMD, CMD_SETWINDOW);
	return nDOC;
}


/*0
[hWn̎擾
*******************************************************************************
[F] SUBROUTINE GWGETWN(IRTN, X1,Y1,X2,Y2)
    INTEGER IRTN
    REAL X1,Y1,X2,Y2

[C] int GWgetwn(float *X1, float *Y1, float *X2, float *Y2);
-------------------------------------------------------------------------------
()
  ݂̃[hWn擾(GWINDOW Q)B
-------------------------------------------------------------------------------
(͕ϐ)
   Ȃ
-------------------------------------------------------------------------------
(o͕ϐ)
   X1 = r[|[g X W([hWn)
   Y1 = r[|[g Y W([hWn)
   X2 = r[|[gE X W([hWn)
   Y2 = r[|[gE Y W([hWn)
 IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Get World Coordinate System
*******************************************************************************
[F] SUBROUTINE GWGETWN(IRTN, X1,Y1,X2,Y2)
    INTEGER IRTN
    REAL X1,Y1,X2,Y2

[C] int GWgetwn(float *X1, float *Y1, float *X2, float *Y2);
-------------------------------------------------------------------------------
Description
   Gets the current world coordinates (see GWINDOW).

Input
  None

Output
   X1 = the world x-coordinate of the bottom-left corner of the view port
   Y1 = the world y-coordinate of the bottom-left corner of the view port
   X2 = the world x-coordinate of the top-right corner of the view port
   Y2 = the world y-coordinate of the top-right corner of the view port
 IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWGETWN "^";
#endif
int GWGETWN(int *ret, float *x1, float *y1, float *x2, float *y2)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWGETWN(int *ret, float *x1, float *y1, float *x2, float *y2)
#else
int gwgetwn_(int *ret, float *x1, float *y1, float *x2, float *y2)
#endif
#endif
{
	return (*ret = GWgetwn(x1, y1, x2, y2));
}

int GWgetwn(float *x1, float *y1, float *x2, float *y2)
{
	if(x1) *x1 = GW_X1;
	if(y1) *y1 = GW_Y1;
	if(x2) *x2 = GW_X2;
	if(y2) *y2 = GW_Y2;
	return nDOC;
}


/*0
r[|[g̐ݒ
*******************************************************************************
[F] SUBROUTINE GWVPORT(IRTN, U1,V1,U2,V2)
    INTEGER IRTN
    REAL U1,V1,U2,V2

[C] int GWvport(float U1, float V1, float U2, float V2);
-------------------------------------------------------------------------------
()
   Ki_WnŃr[|[gݒ肷BKi_WnƂ́Cp̃AX
   yNg(c)ۂ܂܁Cp̕(W)ƍ(H)̒Z 1 ɋKi
   Wn̂ƁBU1 = U2C܂́CV1 = V2 w肵ꍇɂ͗pŜɃr[
   |[gݒ肳B
-------------------------------------------------------------------------------
(͕ϐ)
   U1 = r[|[g X W (Ki_Wn)
   V1 = r[|[g Y W (Ki_Wn)
   U2 = r[|[gE X W (Ki_Wn)
   V2 = r[|[gE Y W (Ki_Wn)
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Set View Port
*******************************************************************************
[F] SUBROUTINE GWVPORT(IRTN, U1,V1,U2,V2)
    INTEGER IRTN
    REAL U1,V1,U2,V2

[C] int GWvport(float U1, float V1, float U2, float V2);
-------------------------------------------------------------------------------
Description
   Sets the view port by specifying the bottom-left (BL) corner and the top-
   right (TR) corner of the view port in the normalized logical coordinate 
   system (NLCS).  The normalized logical coordinate system is the coordinate 
   system where the shorter of the width and the height of the paper in 
   pixels is normalized to unity.  That is, the coordinates of the BL and the 
   TR corners of the paper are (0.0, 0.0) and (max(W/H, 1.0), max(H/W, 1.0)), 
   respectively, in the normalized logical coordinate system.  If the specified
   view port has null area, that is U1 = U2 or V1 = V2, the whole paper is 
   used as the view port.

Input
  U1 = the x-coordinate of the BL corner of the view port (NLCS)
  V1 = the y-coordinate of the BL corner of the view port (NLCS)
  U2 = the x-coordinate of the TR corner of the view port (NLCS)
  V2 = the y-coordinate of the TR corner of the view port (NLCS)

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWVPORT "^";
#endif
int GWVPORT(int *ret, float *u1, float *v1, float *u2, float *v2)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWVPORT(int *ret, float *u1, float *v1, float *u2, float *v2)
#else
int gwvport_(int *ret, float *u1, float *v1, float *u2, float *v2)
#endif
#endif
{
	return (*ret = GWvport(*u1, *v1, *u2, *v2));
}

int GWvport(float u1, float v1, float u2, float v2)
{
	if(!((u2-u1)*(v2-v1))) {
		u1 = 0;
		v1 = 0;
		if(GW_DW > GW_DH) {
			u2 = (FLOAT)GW_DW/(FLOAT)GW_DH;
			v2 = 1.0;
			GW_DU = GW_DH;	// GW_DU * NLDC = LC
		} else {
			u2 = 1.0;
			v2 = (FLOAT)GW_DH/(FLOAT)GW_DW;
			GW_DU = GW_DW;	// GW_DU * NLDC = LC
		}
	}
	GW_U1 = u1;
	GW_V1 = v1;
	GW_U2 = u2;
	GW_V2 = v2;
	if(GW_PM) {
		GW_RX = 0;
		GW_RY = 0;
	} else {
		GW_RX = GW_DU*(GW_U2-GW_U1)/(GW_X2-GW_X1);
		GW_RY = GW_DU*(GW_V2-GW_V1)/(GW_Y2-GW_Y1);
	}
	_command1(nDOC, GW_CMD, CMD_VIEWPORT);
	return nDOC;
}


/*0
r[|[g̐ݒ([hWn)
*******************************************************************************
[F] SUBROUTINE GWPORT(IRTN, X1,Y1,X2,Y2)
    INTEGER IRTN
    REAL X1,Y1,X2,Y2

[C] int GWport(float X1, float Y1, float X2, float Y2);
-------------------------------------------------------------------------------
()
   [hWnŃr[|[gݒ肷BX1 = X2C܂́CY1 = Y2 w肵
   ꍇɂ͗pŜɃr[|[gݒ肳B[hWnωȂ
   ɂ́C GWINDOW(IRTN, X1,Y1,X2,Y2) ĂяoKvB
-------------------------------------------------------------------------------
(͕ϐ)
   X1 = r[|[g X W ([hWn)
   Y1 = r[|[g Y W ([hWn)
   X2 = r[|[gE X W ([hWn)
   Y2 = r[|[gE Y W ([hWn)
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Set View Port (in the world coordinate)
*******************************************************************************
[F] SUBROUTINE GWPORT(IRTN, X1,Y1,X2,Y2)
    INTEGER IRTN
    REAL X1,Y1,X2,Y2

[C] int GWport(float X1, float Y1, float X2, float Y2);
-------------------------------------------------------------------------------
Description
   Sets the view port by specifying the bottom-left (BL) corner and the top-
   right (TR) corner of the view port in the world coordinate system (WCS).  
   If the specified view port has null area, that is X1 = X2 or Y1 = Y2, the 
   whole paper is used as the view port.  To preserve the world coordinate 
   system GWINDOW(IRTN, X1,Y1,X2,Y2) must follow.

Input
  X1 = the world x-coordinate of the BL corner of the view port
  Y1 = the world y-coordinate of the BL corner of the view port
  X2 = the world x-coordinate of the TR corner of the view port
  Y2 = the world y-coordinate of the TR corner of the view port

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWPORT "^";
#endif
int GWPORT(int *ret, float *x1, float *y1, float *x2, float *y2)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWPORT(int *ret, float *x1, float *y1, float *x2, float *y2)
#else
int gwport_(int *ret, float *x1, float *y1, float *x2, float *y2)
#endif
#endif
{
	return (*ret = GWport(*x1, *y1, *x2, *y2));
}

int GWport(float x1, float y1, float x2, float y2)
{
	float u1 = WCtoLPx(x1)/(float)GW_DU, 
		  u2 = WCtoLPx(x2)/(float)GW_DU, 
		  v1 = (GW_DH - WCtoLPy(y1))/(float)GW_DU, 
		  v2 = (GW_DH - WCtoLPy(y2))/(float)GW_DU;
	return GWvport(u1, v1, u2, v2);
}


/*0
r[|[g̎擾
*******************************************************************************
[F] SUBROUTINE GWGETVP(IRTN, U1,V1,U2,V2)
    INTEGER IRTN
    REAL U1,V1,U2,V2

[C] int GWgetvp(float *U1, float *V1, float *U2, float *V2);
-------------------------------------------------------------------------------
()
  ݂̃r[|[g擾(GWVPORT Q)B
-------------------------------------------------------------------------------
(͕ϐ)
   Ȃ
-------------------------------------------------------------------------------
(o͕ϐ)
   U1 = r[|[g X W (Ki_Wn)
   V1 = r[|[g Y W (Ki_Wn)
   U2 = r[|[gE X W (Ki_Wn)
   V2 = r[|[gE Y W (Ki_Wn)
 IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Get View Port
*******************************************************************************
[F] SUBROUTINE GWGETVP(IRTN, U1,V1,U2,V2)
    INTEGER IRTN
    REAL U1,V1,U2,V2

[C] int GWgetvp(float *U1, float *V1, float *U2, float *V2);
-------------------------------------------------------------------------------
Description
   Gets the current view port (see GWVPORT).

Input
  None

Output
   U1 = the x-coordinate of the BL corner of the view port (NLCS)
   V1 = the y-coordinate of the BL corner of the view port (NLCS)
   U2 = the x-coordinate of the TR corner of the view port (NLCS)
   V2 = the y-coordinate of the TR corner of the view port (NLCS)
 IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWGETVP "^";
#endif
int GWGETVP(int *ret, float *u1, float *v1, float *u2, float *v2)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWGETVP(int *ret, float *u1, float *v1, float *u2, float *v2)
#else
int gwgetvp_(int *ret, float *u1, float *v1, float *u2, float *v2)
#endif
#endif
{
	return (*ret = GWgetvp(u1, v1, u2, v2));
}

int GWgetvp(float *u1, float *v1, float *u2, float *v2)
{
	GW_asgn(u1, GW_U1);
	GW_asgn(v1, GW_V1);
	GW_asgn(u2, GW_U2);
	GW_asgn(v2, GW_V2);
	return nDOC;
}

int GW_getvp(int nDoc, int *u1, int *v1, int *u2, int *v2)
{
	int ret;
	if((ret = _command1(nDoc, GW_CMD, CMD_GETVP))) {
		GW_asgn(u1, GW_Params(nDoc)->c.i.p0);
		GW_asgn(v1, GW_Params(nDoc)->c.i.p1);
		GW_asgn(u2, GW_Params(nDoc)->c.i.p2);
		GW_asgn(v2, GW_Params(nDoc)->c.i.p3);
	}
	return ret;
}


/*0
r[|[g̕ۑ
*******************************************************************************
[F] SUBROUTINE GWSAVEVP(IRTN, IVP)
    INTEGER IRTN, IVP

[C] int GWsavevp(int IVP);
-------------------------------------------------------------------------------
()
  ݂̃r[|[gw肵r[|[gԍŕۑBۑꂽr[
  |[g GWselvp ŌĂяoƂłB
-------------------------------------------------------------------------------
(͕ϐ)
  IVP = r[|[gԍ ( > 0 )
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Save View Port Info
*******************************************************************************
[F] SUBROUTINE GWSAVEVP(IRTN, IVP)
    INTEGER IRTN, IVP

[C] int GWsavevp(int IVP);
-------------------------------------------------------------------------------
Description
   Sets the view port number to the current view port.  The view port number 
   set is used to recall the view port by calling GWselvp.

Input
 IVP = the view port number ( > 0 )

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWSAVEVP "^";
#endif
int GWSAVEVP(int *ret, int *vpn)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWSAVEVP(int *ret, int *vpn)
#else
int gwsavevp_(int *ret, int *vpn)
#endif
#endif
{
	return (*ret = GWsavevp(*vpn));
}

int GWsavevp(int vpn)
{
	return _command2(nDOC, GW_CMD, CMD_SAVEVP, vpn);
}


/*0
r[|[g̑I
*******************************************************************************
[F] SUBROUTINE GWSELVP(IRTN, IVP)
    INTEGER IRTN, IVP

[C] int GWselvp(int IVP);
-------------------------------------------------------------------------------
()
  r[|[gIBw肳ꂽr[|[gԍ IVP `̏ꍇ͉
  ȂB  ƁCr[|[gƑΉ郏[hWnB
  r[|[gԍ IVP = 0 ɂ̓ftHg̐ݒ肪ۑĂB
-------------------------------------------------------------------------------
(͕ϐ)
  IVP = r[|[gԍ
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Select View Port
*******************************************************************************
[F] SUBROUTINE GWSELVP(IRTN, IVP)
    INTEGER IRTN, IVP

[C] int GWselvp(int IVP);
-------------------------------------------------------------------------------
Description
   Selects the view port of the view port number IVP set by GWsavevp.  Nothing 
   is done if the view port number specified is not defined.  If succeeded the 
   view port is restored with the world coordinate system.  The default 
   view port is stored with VPN = 0.

Input
 IVP = the view port number

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWSELVP "^";
#endif
int GWSELVP(int *ret, int *vpn)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWSELVP(int *ret, int *vpn)
#else
int gwselvp_(int *ret, int *vpn)
#endif
#endif
{
	return (*ret = _command2(nDOC, GW_CMD, CMD_SELVP, *vpn));
}

int GWselvp(int vpn)
{
	return _command2(nDOC, GW_CMD, CMD_SELVP, vpn);
}


/*0
ŏ̃EBhE
*******************************************************************************
[F] SUBROUTINE GWFIRST(IRTN)
    INTEGER IRTN

[C] int GWfirst(void);
-------------------------------------------------------------------------------
()
   ̃AvP[VI[vŏ̃EBhE̔ԍ擾B

-------------------------------------------------------------------------------
(͕ϐ)
   Ȃ
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = ŏ̃EBhẼEBhEԍ, ŝƂ 0
_______________________________________________________________________________
*/
/*E
Get Window / First
*******************************************************************************
[F] SUBROUTINE GWFIRST(IRTN, NW)
    INTEGER IRTN, NW

[C] int GWfirst(void);
-------------------------------------------------------------------------------
Description
   Gets the window number of the first window opened by the application.

Input
   None

Output
 IRTN = the first window number (> 0), or 0 if failed.
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWFIRST "^";
#endif
int GWFIRST(int *ret)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWFIRST(int *ret)
#else
int gwfirst_(int *ret)
#endif
#endif
{
	return (*ret = GW_next(0));
}

int GWfirst(void)
{
	return GW_next(0);
}

/*0
̃EBhE
*******************************************************************************
[F] SUBROUTINE GWNEXT(IRTN, NW)
    INTEGER IRTN, NW

[C] int GWnext(int NW);
-------------------------------------------------------------------------------
()
   w肵EBhE̎ɃI[vEBhE̔ԍ擾B
   I[vĂ邷ׂẴEBhE̔ԍ擾ɂ́Aŏ GWfirst 
   ĂłA0 Ԃ܂ GWnext JԂĂׂ΂悢BC ̏ꍇɃEB
   hEԍ NW XVɂ
      NW = GWnext(NW);
   ƂāC֐̖߂l𖾎I NW ɑȂĂ͂ȂȂB
-------------------------------------------------------------------------------
(͕ϐ)
   EBhEԍ
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = ̃EBhẼEBhEԍCsƂ 0
_______________________________________________________________________________
*/
/*E
Get Window / Next
*******************************************************************************
[F] SUBROUTINE GWNEXT(IRTN, NW)
    INTEGER IRTN, NW

[C] int GWnext(int NW);
-------------------------------------------------------------------------------
Description
   Gets the window number of the next window to the specified window.   To get 
   all window numbers belonging to the application, call GWfirst first, and 
   then call GWnext's until 0 is returned.

Input
   NW = a window number

Output
 IRTN = the next window number (> 0), or 0 if failed.
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWNEXT "^";
#endif
int GWNEXT(int *ret, int *nw)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWNEXT(int *ret, int *nw)
#else
int gwnext_(int *ret, int *nw)
#endif
#endif
{
	return (*ret = GW_next(*nw));
}

int GWnext(int nw)
{
	return GW_next(nw);
}

int GW_next(int nw)
{
	if(nw < 0)
		return 0;
	while(++nw < MAXDOCS)
		if(FileMaps[nw]) return nw;
	return 0;
}


/*0
EBhEI
*******************************************************************************
[F] SUBROUTINE GWSELECT(IRTN, NW)
    INTEGER IRTN, NW

[C] int GWselect(int NW);
-------------------------------------------------------------------------------
()
   w肳ꂽEBhEԍ̃EBhEJgEEBhEɐݒ肷B
-------------------------------------------------------------------------------
(͕ϐ)
   NW = EBhEԍ (1,2,3,...)
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = JgEEBhEԍ
_______________________________________________________________________________
*/
/*E
Select Window
*******************************************************************************
[F] SUBROUTINE GWSELECT(IRTN, NW)
    INTEGER IRTN, NW

[C] int GWselect(int NW);
-------------------------------------------------------------------------------
Description
   Sets the specified window the current window.

Input
   NW = window number (1,2,3,...)

Output
 IRTN = the current window number
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWSELECT "^";
#endif
int GWSELECT(int *ret, int *nDoc)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWSELECT(int *ret, int *nDoc)
#else
int gwselect_(int *ret, int *nDoc)
#endif
#endif
{
	*nDoc = GW_selwin(*nDoc);
	return (*ret = *nDoc);
}

int GWselect(int nDoc)
{
	return GW_selwin(nDoc);
}

int GW_selwin(int nDoc)
{
	if((nDoc > 0) && (nDoc < MAXDOCS) && FileMaps[nDoc]) {
		GW_pParams = (WndParams*)FileMaps[nDoc];
		GW_pBuffer = GW_pParams->Work.Buffer;
		GW_pData   = GW_pParams->Work.Data;
		GW_pPoints = &(GW_pParams->Work.Points[0]);
		nDOC = nDoc;
		cDOC = (char)(nDOC + 0x20);
	}
	return nDOC;
}


/*0
EBhE̕\Ԃݒ
*******************************************************************************
[F] SUBROUTINE GWSHOWWN(IRTN, NW, IS)
    INTEGER IRTN, NW, IS

[C] int GWshowwn(int NW, int IS);
-------------------------------------------------------------------------------
()
   w肳ꂽEBhEԍ̃EBhE̕\Ԃݒ肷BJgEEBh
   E͕ύXȂBNW = 0 ̏ꍇ̓JgEEBhEw肳B
-------------------------------------------------------------------------------
(͕ϐ)
   NW = EBhEԍ (0,1,2,3,...)
   IS = 0: EBhE\ɂÃEBhEANeBuɂ܂B 
        1: EBhEő剻܂B 
        2: EBhEŏAZ ʂ̃gbvxEBhEANeBu
           ɂ܂B 
        3: EBhEANeBuɂA\܂BEBhEŏĂ
           ő剻Ă肷ƁÄʒuƃTCYɖ߂܂B 
        4: EBhEANeBuɂāÄ݂ʒuƃTCYŕ\܂B 
        5: EBhEANeBuɂāAő剻܂B 
        6: EBhEANeBuɂāAŏ܂B 
        7: EBhEŏ܂BANeBuȃEBhÉAANeBuȏ
           ێ܂BANeBuȃEBhÉAANeBuȂ܂܂łB 
        8: EBhȄ݂Ԃŕ\܂BANeBuȃEBhE̓ANeB
           uȏԂێ܂B 
        9: EBhE𒼑ÖʒuƃTCYŕ\܂BANeBuȃEBhE
           ANeBuȏԂێ܂B 
       10: EBhEANeBuɂāA\܂BEBhEŏ܂͍
           剻ĂƂ́AʒuƃTCYɖ߂܂B 

-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Set Window's Show State
*******************************************************************************
[F] SUBROUTINE GWSHOWWN(IRTN, NW, IS)
    INTEGER IRTN, NW, IS

[C] int GWshowwn(int NW, int IS);
-------------------------------------------------------------------------------
Description
   Sets the specified window's show state.    The current window is not changed.
   When NW = 0, the current window is specified.

Input
   NW = window number (0,1,2,3,...)
   IS = 0: Hides the window and activates another window. 
        1: Maximizes the specified window. 
        2: Minimizes the specified window and activates the next top-level 
           window in the Z order. 
        3: Activates and displays the window. If the window is minimized or 
           maximized, the system restores it to its original size and position. 
           An application should specify this flag when restoring a minimized 
           window. 
        4: Activates the window and displays it in its current size and 
           position.
        5: Activates the window and displays it as a maximized window. 
        6: Activates the window and displays it as a minimized window. 
        7: Displays the window as a minimized window. The active window remains 
           active. 
        8: Displays the window in its current state. The active window remains 
           active. 
        9: Displays a window in its most recent size and position. The active 
           window remains active. 
       10: Activates and displays a window. If the window is minimized or 
           maximized, the system restores it to its original size and position. 
           An application should specify this flag when displaying the window 
           for the first time. 

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWSHOWWN "^";
#endif
int GWSHOWWN(int *ret, int *nDoc, int *show)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWSHOWWN(int *ret, int *nDoc, int *show)
#else
int gwshowwn_(int *ret, int *nDoc, int *show)
#endif
#endif
{
	return (*ret = GWshowwn(*nDoc, *show));
}

int GWshowwn(int nDoc, int show)
{
	if(show < SHW_HIDE || show > SHW_SHOWNORMAL) 
		return _command1(nDoc, GW_SHOWWIN, -2);
	return _command1(nDoc, GW_SHOWWIN, show + SH_NSHOWMODE);
}


/*0
t[̕\Ԃݒ
*******************************************************************************
[F] SUBROUTINE GWSHOWFR(IRTN, IS)
    INTEGER IRTN, IS

[C] int GWshowfr(int IS);
-------------------------------------------------------------------------------
()
   t[(g)̕\Ԃݒ肷B
-------------------------------------------------------------------------------
(͕ϐ)
   IS = 0: t[\ɂÃt[ANeBuɂ܂(HIDE)
        1: t[ő剻܂(MAXIMIZE)
        2: t[ŏAZ ʂ̃gbvxt[ANeBu
           ɂ܂(MINIMIZE)
        3: t[ANeBuɂA\܂Bt[ŏĂ
           ő剻Ă肷ƁÄʒuƃTCYɖ߂܂(RESTORE)
        4: t[ANeBuɂāÄ݂ʒuƃTCYŕ\܂(SHOW)
        5: t[ANeBuɂāAő剻܂(SHOWMAXIMIZED)
        6: t[ANeBuɂāAŏ܂(SHOWMINIMIZED)
        7: t[ŏ܂BANeBuȃt[́AANeBuȏ
           ێ܂BANeBuȃt[́AANeBuȂ܂܂ł
           (SHOWMINNOACTIVE)
        8: t[݂̏Ԃŕ\܂BANeBuȃt[̓ANeB
           uȏԂێ܂(SHOWNA)
        9: t[𒼑ÖʒuƃTCYŕ\܂BANeBuȃt[
           ANeBuȏԂێ܂(SHOWNOACTIVATE)
       10: t[ANeBuɂāA\܂Bt[ŏ܂͍
           剻ĂƂ́AʒuƃTCYɖ߂܂(SHOWNORMAL)
       11: t[őOʂɒu(TOPMOST)
       12: t[őOʂ̎ɒu(NOTOPMOST)
       13: t[ԏɒu(TOP)
       14: t[ԉɒu(BOTTOM)

-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Set Frame's Show State
*******************************************************************************
[F] SUBROUTINE GWSHOWFR(IRTN, IS)
    INTEGER IRTN, IS

[C] int GWshowfr(int IS);
-------------------------------------------------------------------------------
Description
   Sets the frame's show state.
Input
   IS = 0: Hides the frame and activates another frame. 
        1: Maximizes the specified frame. 
        2: Minimizes the specified frame and activates the next top-level 
           frame in the Z order. 
        3: Activates and displays the frame. If the frame is minimized or 
           maximized, the system restores it to its original size and position. 
           An application should specify this flag when restoring a minimized 
           frame. 
        4: Activates the frame and displays it in its current size and 
           position.
        5: Activates the frame and displays it as a maximized frame. 
        6: Activates the frame and displays it as a minimized frame. 
        7: Displays the frame as a minimized frame. The active frame remains 
           active. 
        8: Displays the frame in its current state. The active frame remains 
           active. 
        9: Displays a frame in its most recent size and position. The active 
           frame remains active. 
       10: Activates and displays a frame. If the frame is minimized or 
           maximized, the system restores it to its original size and position. 
           An application should specify this flag when displaying the frame 
           for the first time. 
       11: Place the frame window at topmost
       12: Place the frame window behind all topmost windows
       13: Place the frame window at the top
       14: Place the frame window at the bottom

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWSHOWFR "^";
#endif
int GWSHOWFR(int *ret, int *show)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWSHOWFR(int *ret, int *show)
#else
int gwshowfr_(int *ret, int *show)
#endif
#endif
{
	return (*ret = GWshowfr(*show));
}

int GWshowfr(int show)
{
	if(show < SHW_HIDE || show > SHF_BOTTOM) 
		return _command0(GW_SHOWWIN, 0x20, SH_NSHOWMODE);
	return _command0(GW_SHOWWIN, 0x20, (char)show);
}


/*0
EBhE̔zu
*******************************************************************************
[F] SUBROUTINE GWARRANGE(IRTN, M)
    INTEGER IRTN, M

[C] int GWarrange(int M);
-------------------------------------------------------------------------------
()
   C(t[)EEBhẼNCAgEEBhEĔzuB
   j[Eo[[EBhE] w肷̂Ɠ (M < 5 ̏ꍇ)B
-------------------------------------------------------------------------------
(͕ϐ)
    M = 1: d˂ĕ\
        2: cɕׂĕ\
        3: ɕׂĕ\
        4: ACR̐
        5: JgEEBhEANeBuɂ
        6: JgEEBhEő剻
        7: JgEEBhẼTCYɖ߂
        8: JgEEBhEj
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Arrange Windows
*******************************************************************************
[F] SUBROUTINE GWARRANGE(IRTN, M)
    INTEGER IRTN, M

[C] int GWarrange(int M);
-------------------------------------------------------------------------------
Description
   Arranges the windows in the main window.   Same as [Window] -> [...] at the 
   Menu Bar for M < 5.

Input
    M = 1: Cascade
        2: Tile Horizontally
        3: Tile Vertically
        4: Arrange Icons
        5: Activate the current window
        6: Maximize the current window
        7: Restore the current window
        8: Destroy the current window

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWARRANGE "^";
#endif
int GWARRANGE(int *ret, int *m)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWARRANGE(int *ret, int *m)
#else
int gwarrange_(int *ret, int *m)
#endif
#endif
{
	return (*ret = GWarrange(*m));
}

int GWarrange(int m)
{
	return GW_arrange(nDOC, m);
}

int GW_arrange(int nDoc, int m)
{
	if((m < 1) || (m >= ARNG_N)) return 0;
	if(nDoc == 0)
		return _command0(GW_CMD, (char)(CMD_ARRANGE+0x20), (char)(m+0x20));
	return _command2(nDoc, GW_CMD, CMD_ARRANGE, m);
}


/*0
_foCXWnł̈ʒuW̎擾
*******************************************************************************
[F] SUBROUTINE GWLDCPOS(IRTN, X, Y, IU, IV)
    REAL X, Y
    INTEGER IRTN, IU, IV

[C] int GWldcpos(float X, float Y, int *IU, int *IV);
-------------------------------------------------------------------------------
()
    [hW (X, Y) _foCXW [IU, IV] ֕ϊB_foCX
    WńupvɌŒ肳ꂽWnŁCupv̍_ [0,0]CE
    [W-1,H-1] ƂWnB W  H ́upv̕ƍiv^̃sN
    ZPʁjB
-------------------------------------------------------------------------------
(͕ϐ)
    X = X W([hWn)
    Y = Y W([hWn)
-------------------------------------------------------------------------------
(o͕ϐ)
   IU = U W(_foCXWn)
   IV = V W(_foCXWn)
 IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Get Position in LDCS
*******************************************************************************
[F] SUBROUTINE GWLDCPOS(IRTN, X, Y, IU, IV)
    REAL X, Y
    INTEGER IRTN, IU, IV

[C] int GWldcpos(float X, float Y, int *IU, int *IV);
-------------------------------------------------------------------------------
Description
   Transforms world coordinates (X,Y) into logical device coordinate [IU,IV].
   The logical device coordinate system (LDC) is defined by specifying 
   the top-left corner of "the paper" as the origin [0,0], the u-axis to the 
   right and the v-axis to the bottom, in the unit of pixel for the current 
   printer.

Input
    X = the world x-coordinate
    Y = the world y-coordinate

Output
   IU = the logical device u-coordinate
   IV = the logical device v-coordinate
 IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWLDCPOS "^";
#endif
int GWLDCPOS(int *ret, float *x, float *y, int *u, int *v)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWLDCPOS(int *ret, float *x, float *y, int *u, int *v)
#else
int gwldcpos_(int *ret, float *x, float *y, int *u, int *v)
#endif
#endif
{
	*u = WCtoLPx(*x);
	*v = WCtoLPy(*y);
	return (*ret = nDOC);
}

int GWldcpos(float x, float y, int *u, int *v)
{
	if(u) *u = WCtoLPx(x);
	if(v) *v = WCtoLPy(y);
	return nDOC;
}


/*0
_foCXWnł̃TCY̎擾
*******************************************************************************
[F] SUBROUTINE GWLDCSIZ(IRTN, W, H, IU, IV)
    REAL X, Y
    INTEGER IRTN, IU, IV

[C] int GWldcsiz(float W, float H, int *IU, int *IV);
-------------------------------------------------------------------------------
()
    [hWnł̕ W ƍ H _foCXWn֕ϊB
-------------------------------------------------------------------------------
(͕ϐ)
    X = [hWnł̕
    Y = [hWnł̍
-------------------------------------------------------------------------------
(o͕ϐ)
   IU = _foCXWnł̕
   IV = _foCXWnł̍
 IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Get Sise in LDCS
*******************************************************************************
[F] SUBROUTINE GWLDCSIZ(IRTN, W, H, IU, IV)
    REAL X, Y
    INTEGER IRTN, IU, IV

[C] int GWldcsiz(float W, float H, int *IU, int *IV);
-------------------------------------------------------------------------------
Description
   The width W and the height H in the WCS are transformed into those in LDCS.

Input
    W = width in the WCS
    H = height in the WCS

Output
   IU = width in the LDCS
   IV = height in the LDCS
 IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWLDCSIZ "^";
#endif
int GWLDCSIZ(int *ret, float *x, float *y, int *u, int *v)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWLDCSIZ(int *ret, float *x, float *y, int *u, int *v)
#else
int gwldcsiz_(int *ret, float *x, float *y, int *u, int *v)
#endif
#endif
{
	*u = WCtoLPw(*x);
	*v = WCtoLPh(*y);
	return (*ret = nDOC);
}

int GWldcsiz(float x, float y, int *u, int *v)
{
	if(u) *u = WCtoLPw(x);
	if(v) *v = WCtoLPh(y);
	return nDOC;
}


/*0
sNZETCY̎擾
*******************************************************************************
[F] SUBROUTINE GWPXLSIZ(IRTN, W, H)
    REAL X, Y

[C] int GWpxlsiz(float *W, float *H);
-------------------------------------------------------------------------------
()
    gp̃fBXvC1sNZɑΉ郏[hWnł̕ W ƍ H 
    ̌ݒl擾Bl݂͌̕\EBhẼTCY\[h
    ˑB
-------------------------------------------------------------------------------
(͕ϐ)
    Ȃ
-------------------------------------------------------------------------------
(o͕ϐ)
    X = [hWnł̕
    Y = [hWnł̍
 IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Retrieve Pixel Sise in WCS
*******************************************************************************
[F] SUBROUTINE GWPXLSIZ(IRTN, W, H)
    REAL X, Y

[C] int GWpxlsiz(float *W, float *H);
-------------------------------------------------------------------------------
Description
   Retrieves the current values for the width W and the height H in the WCS of 
   a pixel on the working display.   These values depend on the current size of 
   the graphics window and the current display mode.

Input
    None

Output
    W = width of a pixel in the WCS
    H = height of a pixel in the WCS
 IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWPXLSIZ "^";
#endif
int GWPXLSIZ(int *ret, float *x, float *y)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWPXLSIZ(int *ret, float *x, float *y)
#else
int gwpxlsiz_(int *ret, float *x, float *y)
#endif
#endif
{
	*ret = _command1(nDOC, GW_WSIZE, WSZ_PIXEL);
	if(*ret > 0) {
		*x = GW_Params(nDOC)->c.f.x;
		*y = GW_Params(nDOC)->c.f.y;
		*ret = nDOC;
	}
	return *ret;
}

int GWpxlsiz(float *x, float *y)
{
	int ret = _command1(nDOC, GW_WSIZE, WSZ_PIXEL);
	if(ret > 0) {
		if(x) *x = GW_Params(nDOC)->c.f.x;
		if(y) *y = GW_Params(nDOC)->c.f.y;
		return nDOC;
	}
	return ret;
}
