/* Calcomp.c
 *
 * Copyright (C) 1998-2001 by TAMARIBUCHI, Tsuguhiro
 *
 *   WWW: http://sip.sci.shizuoka.ac.jp/grwin
 *
 */

#include "gw.h"


/*0
(Calcomp nR}h)
*******************************************************************************
[F] SUBROUTINE PLOTS(X, Y, LD)

[C] Ȃ
-------------------------------------------------------------------------------
()
   GrWin Cȕ̌COtBNXEEBhEI[vB

      mQln CALL GWOPEN(NW,0)
-------------------------------------------------------------------------------
(͕ϐ)
    X = y̏ʒu X W([hWn)
    Y = y̏ʒu Y W([hWn)
   LD = ݊̂߂̃_~[
-------------------------------------------------------------------------------
(o͕ϐ)
  Ȃ
_______________________________________________________________________________
*/
/*E
Initialize (Calcomp compatible)
*******************************************************************************
[F] SUBROUTINE PLOTS(X, Y, LD)

[C] None
-------------------------------------------------------------------------------
Description
   Initialize the GrWin library, and then open a window.

      Implement using GrWin intrinsics:
            CALL GWOPEN(NW,0)

Input
    X = x coordinate of the initial pen position (in world coordinate system)
    Y = y coordinate of the initial pen position (in world coordinate system)
   LD = dummy for compatibility

Output
  None
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux PLOTS "^";
#endif
int PLOTS(float *x, float *y, int *dmy)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall PLOTS(float *x, float *y, int *dmy)
#else
int plots_(float *x, float *y, int *dmy)
#endif
#endif
{
	int nDoc = 0, ret;
	dmy = NULL;
	if((ret = GWopen(nDoc)))
		GWmove2(*x, *y);
	return ret;
}


/*0
I(Calcomp nR}h)
*******************************************************************************
[F] SUBROUTINE PLOTE(MQ)

[C] Ȃ
-------------------------------------------------------------------------------
()
      JĂSẴEBhECGrWin CȕIsB

      mQln CALL GWQUIT
-------------------------------------------------------------------------------
(͕ϐ)
   MQ = 0 :   R\[EEBhEɏIvvg '>' \B
        1 :   I_CAO\B
        :   IvvgoɒɏIsB
-------------------------------------------------------------------------------
(o͕ϐ)
  Ȃ
_______________________________________________________________________________
*/
/*E
Quit (Calcomp compatible)
*******************************************************************************
[F] SUBROUTINE PLOTE(MQ)

[C] None
-------------------------------------------------------------------------------
Description
   Close all windows opened by the application, and do ending procedures.

      Implement using GrWin intrinsics:
            CALL GWQUIT

Input
   MQ = 0 :   Display a ending prompt '>' on the console window.
        1 :   Popup an ending dialog.
 otherwise:   without any prompting

Output
  None
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux PLOTE "^";
#endif
int PLOTE(int *mq)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall PLOTE(int *mq)
#else
int plote_(int *mq)
#endif
#endif
{
	return GWquitx(*mq);
}


/*1
ÿړ/̕`(Calcomp nR}h)
*******************************************************************************
[F] SUBROUTINE PLOT(X, Y, IP)
    REAL X, Y
    INTEGER IP

[C] Ȃ
-------------------------------------------------------------------------------
()
    [hWnŎw肳ꂽ_ (X, Y) ܂ŃyړB

    mQln CALL GWLINE2(X, Y)
             CALL GWMOVE2(X, Y)
-------------------------------------------------------------------------------
(͕ϐ)
    X = ړ̃yʒu X W([hWn)
    Y = ړ̃yʒu Y W([hWn)
   IP = }2: y܂܈ړB܂蒼`B
        }3: yグ܂܈ړB܂艽`ȂB
        999: Is(PLOTE Ɠ)B
      <   0: [hWn𕽍sړāCړ̓_VɍW_ɂB
-------------------------------------------------------------------------------
(o͕ϐ)
  Ȃ
_______________________________________________________________________________
*/
/*E
Draw Line To/Move Pen (Calcomp compatible)
*******************************************************************************
[F] SUBROUTINE PLOT(X, Y, IP)
    REAL X, Y
    INTEGER IP

[C] None
-------------------------------------------------------------------------------
Description
    Move the pen to the point specified by (X, Y).

      Implement using GrWin intrinsics:
            CALL GWLINE2(X, Y)
      or
            CALL GWMOVE2(X, Y)

Input
    X = x coordinate of the destination point (in world coordinate system)
    Y = y coordinate of the destination point (in world coordinate system)
   IP = +/-2: Move with the pen down (draw a line)
        +/-3: Move with the pen up (do not draw)
        999: End of plot (PLOTE)
      <   0: The origin of the world coordinate is moved to the destination point.

Output
  None
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux PLOT "^";
#endif
int PLOT(float *x, float *y, int *ip)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall PLOT(float *x, float *y, int *ip)
#else
int plot_(float *x, float *y, int *ip)
#endif
#endif
{
	int ret = 0;

	switch(*ip) {
	case 2:
	case -2:
		ret = GWline2(*x, *y);
		break;
	case 3:
	case -3:
		ret = GWmove2(*x, *y);
		break;
	case 999:
		return GWquit();
	}
	if((*ip) < 0) {
		GW_X1 -= *x;
		GW_X2 -= *x;
		GW_Y1 -= *y;
		GW_Y2 -= *y;
	}
	return ret;
}

/*0
[hWn̐ݒ(Calcomp nR}h)
*******************************************************************************
[F] SUBROUTINE WINDOW(XL, YT, XR, YB)
    REAL XL, YT, XR, YB

[C] Ȃ
-------------------------------------------------------------------------------
()
   ʂ̍ӂ x WCӂ y WCEӂ x WCӂ y W[h
   Wŗ^邱Ƃɂ胏[hWnݒ肷B GWINDOW Ƃ͈̕т̏
   Ⴄ̂ŒӁB

    mQln CALL GWINDOW(XL, YB, XR, YT)
-------------------------------------------------------------------------------
(͕ϐ)
    XL = ӂ x W([hWn)
    YT = ӂ y W([hWn)
    XR = Eӂ x W([hWn)
    YB = ӂ y W([hWn)
-------------------------------------------------------------------------------
(o͕ϐ)
  Ȃ
_______________________________________________________________________________
*/
/*E
Set World Coordinate System (Calcomp compatible)
*******************************************************************************
[F] SUBROUTINE WINDOW(XL, YT, XR, YB)
    REAL XL, YT, XR, YB

[C] None
-------------------------------------------------------------------------------
Description
   Set the world coordinate system by giving the left, top, right and bottom 
   coordinates of the view port in the required world coordinate system.
   It should be noted that the argument list is different from the corresponding 
   GrWin intrinsic GWINDOW.

      Implement using GrWin intrinsics:
            CALL GWINDOW(XL, YB, XR, YT)

Input
    XL = x coordinate of the left position of the view port
    YT = y coordinate of the top of the view port
    XR = x coordinate of the right position of the view port
    YB = y coordinate of the bottom of the view port

Output
  None
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux WINDOW "^";
#endif
int WINDOW(float *xl, float *yt, float *xr, float *yb)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall WINDOW(float *xl, float *yt, float *xr, float *yb)
#else
int window_(float *xl, float *yt, float *xr, float *yb)
#endif
#endif
{
	return GWindow(*xl, *yb, *xr, *yt);
}


/*1
y̐F(Calcomp nR}h)
*******************************************************************************
[F] SUBROUTINE NEWPEN(IPC)
    INTEGER IPC

[C] Ȃ
-------------------------------------------------------------------------------
()
    y̘_Fԍݒ肷B

    mQln GWSETPEN(IPC, -1, -1, -1)
-------------------------------------------------------------------------------
(͕ϐ)
  IPC = _Fԍ
         -1 ̏ꍇ͕ύXȂ
         ̑̏ꍇɂĂ GWCOLOR ̍QƁB
-------------------------------------------------------------------------------
(o͕ϐ)
  Ȃ
_______________________________________________________________________________
*/
/*E
New Pen (Calcomp compatible)
*******************************************************************************
[F] SUBROUTINE NEWPEN(IPC)
    INTEGER IPC

[C] None
-------------------------------------------------------------------------------
Description
    Set the logical color number of the pen.   

      Implement using GrWin intrinsics:
            GWSETPEN(IPC, -1, -1, -1)

Input
  IPC >= 0: Logical color number.
      = -1: unchanged
      < -1: Refer to GWCOLOR in this manual

Output
  None
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux NEWPEN "^";
#endif
int NEWPEN(int *c)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall NEWPEN(int *c)
#else
int newpen_(int *c)
#endif
#endif
{
	return GWsetpen(*c, -1, -1, -1);
}


/*1
̕\(Calcomp nR}h)
*******************************************************************************
[F] SUBROUTINE SYMBOL(X, Y, H, TXT, A, NC)
    REAL X, Y, H, A
    CHARACTER TXT*(*)
    INTEGER NC

[C] Ȃ
-------------------------------------------------------------------------------
()
    [hWnŎw肳ꂽ_ (X, Y) ɕ\B

    mQln CALL GWSETTXT(H, A, -1, -1, -1, ' ')
             CALL GWPUTTXT(X, Y, TXT)
-------------------------------------------------------------------------------
(͕ϐ)
    X = ŏ̍̓̕_ X W([hWn)
    Y = ŏ̍̓̕_ Y W([hWn)
    H = tHg̍([hWn)
         0 ̏ꍇ̓ftH[glg
         ̏ꍇ݂͌̒lg
  TXT = \镶
    A = tHǧXp(degCv)
   NC = ̒B 0 ܂͕̏ꍇ TXT ׂ̂Ă̕\B
-------------------------------------------------------------------------------
(o͕ϐ)
  Ȃ
_______________________________________________________________________________
*/
/*E
Draw Character String (Calcomp compatible)
*******************************************************************************
[F] SUBROUTINE SYMBOL(X, Y, H, TXT, A, NC)
    REAL X, Y, H, A
    CHARACTER TXT*(*)
    INTEGER NC

[C] None
-------------------------------------------------------------------------------
Description
    Draw a character string from the point (X, Y).

      Implement using GrWin intrinsics:
            CALL GWSETTXT(H, A, -1, -1, -1, ' ')
            CALL GWPUTTXT(X, Y, TXT)

Input
    X = the world x-coordinate of the bottom-left corner of the string
    Y = the world y-coordinate of the bottom-left corner of the string
    H > 0: height of the font
      = 0: use the default height for text fonts
      < 0: use the height of the current text font
  TXT = string to be drawn
    A = angle (in deg, counterclockwise)
   NC = length of the string in bytes.  If 0 or a negative number is specified 
        all characters in TXT are drawn.

Output
  None
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux SYMBOL "^";
int SYMBOL(float *x, float *y, float *height, CHARACTER *text, float *angle, int *nchar)
#else
int SYMBOL(float *x, float *y, float *height, char *text, float *angle, int *nchar, int l)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall SYMBOL(float *x, float *y, float *height, char *text, int l, float *angle, int *nchar)
#else
int symbol_(float *x, float *y, 
	float *height, char *text, float *angle, int *nchar, int l)
#endif
#endif
{
#ifdef __WATCOMC__
	int l = min(text->l,(int)MAXBUFFER-1);
	GWsettxt(*height, *angle/360, -1, -1, -1, NULL);
	strncpy(GW_pBuffer, text->p, l);
#else
	GWsettxt(*height, *angle/360, -1, -1, -1, NULL);
	l = min(l,(int)MAXBUFFER-1);
	strncpy(GW_pBuffer, text, l);
#endif
	if(*nchar > 0) {
		if(*nchar < l) 
			l = *nchar;
		else while(*nchar > l)
			GW_pBuffer[l++] = ' ';
	}
	GW_pBuffer[l] = '\0';
	return GWputtxt(*x, *y, GW_pBuffer);
}


/*2
l̕\(Calcomp nR}h)
*******************************************************************************
[F] SUBROUTINE NUMBER(X, Y, H, D, A, ND)
    REAL X, Y, H, D, A
    INTEGER ND

[C] Ȃ
-------------------------------------------------------------------------------
()
    [hWnŎw肳ꂽ_ (X, Y) ɐ\Bϊ@włB

    mQln WRITE(TXT, *) N
             CALL GWSETTXT(H, A, -1, -1, -1, ' ')
             CALL GWPUTTXT(X, Y, TXT)
-------------------------------------------------------------------------------
(͕ϐ)
    X = ŏ̍̓̕_ X W([hWn)
    Y = ŏ̍̓̕_ Y W([hWn)
    H = tHg̍([hWn)
         0 ̏ꍇ̓ftH[glg
         ̏ꍇ݂͌̒lg
    D = \鐔l
    A = tHǧXp(degCv)
   ND >  0: _̌
      =  0: Ə_\
      = -1: ̂ݕ\
      < -1: ̏ |ND| ̂ݕ\
-------------------------------------------------------------------------------
(o͕ϐ)
  Ȃ
_______________________________________________________________________________
*/
/*E
Draw Numeric Value (Calcomp compatible)
*******************************************************************************
[F] SUBROUTINE NUMBER(X, Y, H, D, A, ND)
    REAL X, Y, H, D, A
    INTEGER ND

[C] None
-------------------------------------------------------------------------------
Description
    Draw a numeric value as a string from the point (X, Y).   The parameter ND 
    specifies decimal places.

      Implement using GrWin intrinsics:
            WRITE(TXT, *) N
            CALL GWSETTXT(H, A, -1, -1, -1, ' ')
            CALL GWPUTTXT(X, Y, TXT)

Input
    X = x coordinate of the bottom-left corner of the string
    Y = y coordinate of the bottom-left corner of the string
    H > 0: height
      = 0: use default height for text strings
      < 0: use current height for text strings
    D = a REAL to be drawn
    A = angle (in deg, counterclockwise)
   ND >  0: decimal places
      =  0: no decimal place with a decimal point
      = -1: truncate into an integer
      < -1: upper |ND| digits in integer part

Output
  None
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux NUMBER "^";
#endif
int NUMBER(float *x, float *y, 
	float *height, float *d, float *angle, int *nd)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall NUMBER(float *x, float *y, 
	float *height, float *d, float *angle, int *nd)
#else
int number_(float *x, float *y, 
	float *height, float *d, float *angle, int *nd)
#endif
#endif
{
	GWsettxt(*height, *angle/360, -1, -1, -1, NULL);
	if(*nd > 0)
		sprintf(GW_pBuffer, "%.*f", *nd, *d);
	else if(*nd == 0) 
		sprintf(GW_pBuffer, "%d.", (int)*d);
	else if(*nd == -1) 
		sprintf(GW_pBuffer, "%d", (int)*d);
	else {
		int v = (int)*d, n, n10 = 1;
		for(n = *nd; n < 0; ++n) 
			n10 *= 10;
		while(abs(v) >= n10)
			v /= 10;
		sprintf(GW_pBuffer, "%d", v);
	}
	return GWputtxt(*x, *y, GW_pBuffer);
}


/*0
OtBNXʏ(Calcomp nR}h)
*******************************************************************************
[F] SUBROUTINE GCLS(IDMY)

[C] Ȃ
-------------------------------------------------------------------------------
()
   OtBNXʂB
-------------------------------------------------------------------------------
(͕ϐ)
   IDMY ͌݊̂߂̃_~[ϐB
-------------------------------------------------------------------------------
(o͕ϐ)
  Ȃ
_______________________________________________________________________________
*/
/*E
Erase Window (Calcomp compatible)
*******************************************************************************
[F] SUBROUTINE GCLS(IDMY)

[C] None
-------------------------------------------------------------------------------
Description
   Erase the current window.

Input
   IDMY = dummy for compatibility

Output
  None
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GCLS "^";
#endif
int GCLS(int *dmy)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GCLS(int *dmy)
#else
int gcls_(int *dmy)
#endif
#endif
{
	dmy = NULL;
	return GWclear(-1);
}
