/* SysDep.c
 *
 * Copyright (C) 1998-2003 by TAMARIBUCHI, Tsuguhiro
 *
 *   WWW: http://sip.sci.shizuoka.ac.jp/grwin
 *
 */

#include "gw.h"

#if !defined(__INTEL_COMPILER) && !defined(__WATCOMC__) && !defined(_MSC_VER) && !defined(__BORLANDC__) && !defined(__DMC__) && !defined(__LCC__)

int kbhit(void)
{
#ifdef __CYGWIN32__
	fd_set rfds;
	struct timeval tv;
	unsigned char c;
	struct termios tio;
	long c_lflag;

	tcgetattr(0, &tio);
	c_lflag = tio.c_lflag;
	tio.c_lflag &= ~(ECHO|ICANON);
	tcsetattr(0, TCSANOW, &tio);

	FD_ZERO(&rfds);
	FD_SET(0, &rfds);
	tv.tv_sec = 0;
	tv.tv_usec = 0;

	if(select(1, &rfds, NULL, NULL, &tv))
		read(0, &c, 0);
	else
		c = 0;

	tio.c_lflag = c_lflag;
	tcsetattr(0, TCSANOW, &tio);
	return (int)c;
#else
	return _kbhit();
#endif
}
#endif

#ifdef __CYGWIN32__
int getch (void)
{
	int c;
	struct termios tio;
	long c_lflag;

	tcgetattr(0, &tio);
	c_lflag = tio.c_lflag;
	tio.c_lflag &= ~(ECHO|ICANON);
	tcsetattr(0, TCSANOW, &tio);

	/* Must be in raw or cbreak mode for this to work correctly. */
	if (read (0, &c, 1) != 1)
		c = EOF;

	tio.c_lflag = c_lflag;
	tcsetattr(0, TCSANOW, &tio);
	return c & 0xff;
}

int getche (void)
{
  int c = getch ();

  if(isprint(c)) putchar(c);
  return c;
}
#endif

#ifdef __F2C__
float rand_(void)
{
	return (float)rand()/(float)RAND_MAX;
}
#endif

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux RAND "^";
#endif
float RAND(void)
{
	return (float)rand()/RAND_MAX;
}
#endif
