# Copyright (c) 2005
# 	Riverbank Computing Limited <info@riverbankcomputing.co.uk>
# 
# This file is part of PyQt.
# 
# This copy of PyQt is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2, or (at your option) any later
# version.
# 
# PyQt is supplied in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
# details.
# 
# You should have received a copy of the GNU General Public License along with
# PyQt; see the file LICENSE.  If not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
# This module is intended to be used by the configuration scripts of extension
# modules that %Import PyQt modules.


import sipconfig


# These are installation specific values created when PyQt was configured.
_pkg_config = {
    '_pyqt_qscintilla_defines':  '',
    '_pyqt_qscintilla_inc_dir':  '/scisoft/ESRF_sw/linux_i386_03//include',
    '_pyqt_qscintilla_lib_dir':  '/scisoft/ESRF_sw/linux_i386_03//lib',
    'pyqt_bin_dir':              '/scisoft/ESRF_sw/linux_i386_03/bin',
    'pyqt_mod_dir':              '/scisoft/ESRF_sw/linux_i386_03/lib/python2.4/site-packages',
    'pyqt_modules':              'qt qtcanvas qtnetwork qttable qtxml qtgl qtui qtsql qtext',
    'pyqt_qt_sip_flags':         '-x Qt_THREAD_SUPPORT -x Qt_STYLE_WINDOWSXP -x Qt_STYLE_INTERLACE -x Qt_STYLE_WINDOWSXP -x VendorID -t WS_X11 -t Qt_3_3_0',
    'pyqt_qtcanvas_sip_flags':   '-x Qt_THREAD_SUPPORT -x Qt_STYLE_WINDOWSXP -x Qt_STYLE_INTERLACE -x Qt_STYLE_WINDOWSXP -x VendorID -t WS_X11 -t Qt_3_3_0',
    'pyqt_qtext_sip_flags':      '-x Qt_THREAD_SUPPORT -x Qt_STYLE_WINDOWSXP -x Qt_STYLE_INTERLACE -x Qt_STYLE_WINDOWSXP -x VendorID -t WS_X11 -t Qt_3_3_0 -t QScintilla_1_5',
    'pyqt_qtgl_sip_flags':       '-x Qt_THREAD_SUPPORT -x Qt_STYLE_WINDOWSXP -x Qt_STYLE_INTERLACE -x Qt_STYLE_WINDOWSXP -x VendorID -t WS_X11 -t Qt_3_3_0',
    'pyqt_qtnetwork_sip_flags':  '-x Qt_THREAD_SUPPORT -x Qt_STYLE_WINDOWSXP -x Qt_STYLE_INTERLACE -x Qt_STYLE_WINDOWSXP -x VendorID -t WS_X11 -t Qt_3_3_0',
    'pyqt_qtsql_sip_flags':      '-x Qt_THREAD_SUPPORT -x Qt_STYLE_WINDOWSXP -x Qt_STYLE_INTERLACE -x Qt_STYLE_WINDOWSXP -x VendorID -t WS_X11 -t Qt_3_3_0',
    'pyqt_qttable_sip_flags':    '-x Qt_THREAD_SUPPORT -x Qt_STYLE_WINDOWSXP -x Qt_STYLE_INTERLACE -x Qt_STYLE_WINDOWSXP -x VendorID -t WS_X11 -t Qt_3_3_0',
    'pyqt_qtui_sip_flags':       '-x Qt_THREAD_SUPPORT -x Qt_STYLE_WINDOWSXP -x Qt_STYLE_INTERLACE -x Qt_STYLE_WINDOWSXP -x VendorID -t WS_X11 -t Qt_3_3_0',
    'pyqt_qtxml_sip_flags':      '-x Qt_THREAD_SUPPORT -x Qt_STYLE_WINDOWSXP -x Qt_STYLE_INTERLACE -x Qt_STYLE_WINDOWSXP -x VendorID -t WS_X11 -t Qt_3_3_0',
    'pyqt_sip_dir':              '/scisoft/ESRF_sw/linux_i386_03/share/sip',
    'pyqt_version':              0x030e01,
    'pyqt_version_str':          '3.14.1'
}



class Configuration(sipconfig.Configuration):
    """The class that represents PyQt configuration values.
    """
    def __init__(self, sub_cfg=None):
        """Initialise an instance of the class.

        sub_cfg is the list of sub-class configurations.  It should be None
        when called normally.
        """
        if sub_cfg:
            cfg = sub_cfg
        else:
            cfg = []

        cfg.append(_pkg_config)

        sipconfig.Configuration.__init__(self, cfg)


class QtModuleMakefile(sipconfig.SIPModuleMakefile):
    """The Makefile class for modules that %Import qt.
    """
    def __init__(self, *args, **kw):
        """Initialise an instance of a module Makefile.
        """
        kw["qt"] = 1
        apply(sipconfig.SIPModuleMakefile.__init__, (self, ) + args, kw)

    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            # Note that we don't use self.extra_lib_dirs because we don't want
            # it to be added to the rpath.
            self.LIBDIR.append(self.config.pyqt_mod_dir)
            self.extra_libs.append(self.module_as_lib("qt"))

        sipconfig.SIPModuleMakefile.finalise(self)


class QtAxContainerModuleMakefile(QtModuleMakefile):
    """The Makefile class for modules that %Import qtaxcontainer.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            self.extra_libs.append(self.module_as_lib("qtaxcontainer"))

        QtModuleMakefile.finalise(self)


class QtCanvasModuleMakefile(QtModuleMakefile):
    """The Makefile class for modules that %Import qtcanvas.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            self.extra_libs.append(self.module_as_lib("qtcanvas"))

        QtModuleMakefile.finalise(self)


class QtExtModuleMakefile(QtModuleMakefile):
    """The Makefile class for modules that %Import qtext.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            self.extra_libs.append(self.module_as_lib("qtext"))

        self.extra_defines.extend(self.config._pyqt_qscintilla_defines)
        self.extra_include_dirs.append(self.config._pyqt_qscintilla_inc_dir)
        self.extra_lib_dirs.append(self.config._pyqt_qscintilla_lib_dir)
        self.extra_libs.append("qscintilla")

        QtModuleMakefile.finalise(self)


class QtGLModuleMakefile(QtModuleMakefile):
    """The Makefile class for modules that %Import qtgl.
    """
    def __init__(self, *args, **kw):
        """Initialise an instance of a module Makefile.
        """
        kw["opengl"] = 1
        apply(QtModuleMakefile.__init__, (self, ) + args, kw)

    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            self.extra_libs.append(self.module_as_lib("qtgl"))

        QtModuleMakefile.finalise(self)


class QtNetworkModuleMakefile(QtModuleMakefile):
    """The Makefile class for modules that %Import qtnetwork.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            self.extra_libs.append(self.module_as_lib("qtnetwork"))

        QtModuleMakefile.finalise(self)


class QtTableModuleMakefile(QtModuleMakefile):
    """The Makefile class for modules that %Import qttable.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            self.extra_libs.append(self.module_as_lib("qttable"))

        QtModuleMakefile.finalise(self)


class QtSQLModuleMakefile(QtTableModuleMakefile):
    """The Makefile class for modules that %Import qtsql.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            self.extra_libs.append(self.module_as_lib("qtsql"))

        QtTableModuleMakefile.finalise(self)


class QtUIModuleMakefile(QtModuleMakefile):
    """The Makefile class for modules that %Import qtui.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            self.extra_libs.append(self.module_as_lib("qtui"))

        QtModuleMakefile.finalise(self)


class QtXMLModuleMakefile(QtModuleMakefile):
    """The Makefile class for modules that %Import qtxml.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            self.extra_libs.append(self.module_as_lib("qtxml"))

        QtModuleMakefile.finalise(self)
