# Copyright (c) 2000-2004 LOGILAB S.A. (Paris, FRANCE).
# http://www.logilab.fr/ -- mailto:contact@logilab.fr
#
# Copyright (c) 2004 DoCoMo Euro-Labs GmbH (Munich, Germany).
# http://www.docomolab-euro.com/ -- mailto:tarlano@docomolab-euro.com
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""unit tests for narval.reader and Recipe / Action handlers

:version: $Revision:$  
:author: Logilab

:copyright:
  2000-2004 LOGILAB S.A. (Paris, FRANCE)
  
  2004 DoCoMo Euro-Labs GmbH (Munich, Germany)
  
:contact:
  http://www.logilab.fr/ -- mailto:contact@logilab.fr
  
  http://www.docomolab-euro.com/ -- mailto:tarlano@docomolab-euro.com
"""

import unittest

import os
from copy import deepcopy
        
from logilab.common import testlib

from narval.actions import PyLogDB as pylogdb
from narval.elements.base import RDFStatementElement, RDFRuleElement


def extract_predicates(context_src):
    import re
    return [class_name for index, class_name 
            in enumerate(re.split('class\ (.*)\(', context_src))
            if index % 2]

def check_syntax(rdf_xml_string):
    test_file = file('test.xml','w')
    test_file.write(rdf_xml_string)
    test_file.close()
    return os.system('rapper -i rdfxml test.xml')

class Testing(testlib.TestCase):

    def test_creation(self):
        s = pylogdb.statement('a','b','c')
        self.assertEquals(type(RDFStatementElement()),
                          type(s))

    def test_as_xml(self):
        s = pylogdb.statement('jack', 'eats', 'fish')
        s_xml = '<rdf:Description rdf:about="jack">' \
                '    <ns0:eats xmlns:ns0="http://www.logilab.org/namespaces/Narval/1.2#">' \
                '       fish' \
                '    </ns0:eats>' \
                '  </rdf:Description>'
        self.assertEquals(s.as_rdf_xml().split(), s_xml.split())

    def test_statements(self):
        # FIXME - crado... 
        return_code = os.system('rapper')
        self.assertEquals(return_code, 256, 'You don\'t have Raptor RDF parser installed')
        statements = []
        stmt = pylogdb.statement('Sylvain', 'works_for', 'Logilab')
        statements.append(deepcopy(stmt))
        stmt.subject = 'Alexandre'
        statements.append(deepcopy(stmt))
        stmt.subject = 'Antony'
        stmt.object = 'Docomo'
        statements.append(deepcopy(stmt))
        rdf_xml_string = pylogdb.to_xml_rdf(statements)
        return_code = check_syntax(rdf_xml_string)
        self.assertEquals(return_code, 0, 'There is something wrong with your rdfxml')
        

    def test_from_kb(self):
        return_code = os.system('rapper')
        self.assertEquals(return_code, 256, 'You don\'t have Raptor RDF parser installed')
        path, encoding = pylogdb.kb_file()
        stream = open(path)
        context = {}
        from pylog import compile
        context_src = compile(stream.read())
        exec "from pylog import *" in context
        exec context_src in context
        predicate_seq = extract_predicates(context_src)
        statements = []
        for x in predicate_seq:
            for y in context[x](None,None)._exprs:
                print y[0].args[0], x, y[0].args[1]
                statements.append(pylogdb.statement(y[0].args[0], x, y[0].args[1]))
        rdf_xml_string = pylogdb.to_xml_rdf(statements)
        return_code = check_syntax(rdf_xml_string)
        self.assertEquals(return_code, 0, 'There is something wrong with your rdfxml')


    def test_final(self):
        input = 'todays meeting was created yesterday'
        statements = pylogdb.process(input)
        xml_out = pylogdb.to_xml_rdf(statements)
        xml_proof = ''
        self.assertEquals(xml_out, xml_proof)


if __name__ == '__main__':
            
    unittest.main()



